/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch;

import java.util.Random;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.graph.PawNode;
import us.ihmc.robotics.robotSide.QuadrantDependentList;
import us.ihmc.robotics.robotSide.RobotQuadrant;

public class PawStepPlanningRandomTools {
    public static PawNode createRandomFootstepNode(Random random) {
        return PawStepPlanningRandomTools.createRandomFootstepNode(random, 1.0);
    }

    public static PawNode createRandomFootstepNode(Random random, double minMaxXY) {
        return new PawNode(RobotQuadrant.generateRandomRobotQuadrant((Random)random), new QuadrantDependentList((Object)EuclidCoreRandomTools.nextPoint2D((Random)random, (double)minMaxXY), (Object)EuclidCoreRandomTools.nextPoint2D((Random)random, (double)minMaxXY), (Object)EuclidCoreRandomTools.nextPoint2D((Random)random, (double)minMaxXY), (Object)EuclidCoreRandomTools.nextPoint2D((Random)random, (double)minMaxXY)), RandomNumbers.nextDouble((Random)random, (double)Math.PI), 1.0, 0.5);
    }

    public static PawNode createRandomFootstepNode(Random random, double length, double width) {
        RobotQuadrant robotQuadrant = RobotQuadrant.generateRandomRobotQuadrant((Random)random);
        Point2D center = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
        Vector2D offsetFromCenter = new Vector2D(length, width);
        offsetFromCenter.scale(0.5);
        Point2D frontLeft = new Point2D((Tuple2DReadOnly)center);
        Point2D frontRight = new Point2D((Tuple2DReadOnly)center);
        Point2D hindLeft = new Point2D((Tuple2DReadOnly)center);
        Point2D hindRight = new Point2D((Tuple2DReadOnly)center);
        frontLeft.add((Tuple2DReadOnly)offsetFromCenter);
        frontRight.add(offsetFromCenter.getX(), -offsetFromCenter.getY());
        hindLeft.add(-offsetFromCenter.getX(), offsetFromCenter.getY());
        hindRight.add(-offsetFromCenter.getX(), -offsetFromCenter.getY());
        double yaw = PawNode.computeNominalYaw((double)frontLeft.getX(), (double)frontLeft.getY(), (double)frontRight.getX(), (double)frontRight.getY(), (double)hindLeft.getX(), (double)hindLeft.getY(), (double)hindRight.getX(), (double)hindRight.getY());
        return new PawNode(robotQuadrant, (Tuple2DReadOnly)frontLeft, (Tuple2DReadOnly)frontRight, (Tuple2DReadOnly)hindLeft, (Tuple2DReadOnly)hindRight, yaw, length, width);
    }
}

