/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.ContinuousIntegrationTools;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.javaFXToolkit.starter.ApplicationRunner;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.messager.SharedMemoryMessager;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.messager.javafx.SharedMemoryJavaFXMessager;
import us.ihmc.pathPlanning.DataSet;
import us.ihmc.pathPlanning.DataSetIOTools;
import us.ihmc.pathPlanning.DataSetName;
import us.ihmc.pathPlanning.PlannerInput;
import us.ihmc.quadrupedBasics.gait.QuadrupedTimedStep;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.BodyPathAndPawPlanner;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.PawStepPlan;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.PawStepPlannerGoal;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.PawStepPlannerStart;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.PawStepPlanningResult;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.communication.PawStepPlannerMessagerAPI;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.graph.PawNode;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.parameters.PawStepPlannerParametersBasics;
import us.ihmc.quadrupedFootstepPlanning.ui.PawStepPlannerUI;
import us.ihmc.quadrupedPlanning.QuadrupedSpeed;
import us.ihmc.quadrupedPlanning.QuadrupedXGaitSettings;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.graphics.Graphics3DObjectTools;
import us.ihmc.robotics.robotSide.QuadrantDependentList;
import us.ihmc.robotics.robotSide.RobotQuadrant;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;

public abstract class PawStepPlannerDataSetTest {
    private static final double defaultBestEffortTimeout = 1.0;
    protected static final double bambooTimeScaling = 4.0;
    private static final double defaultHorizonLength = 100.0;
    private static final QuadrantDependentList<AppearanceDefinition> colorDefinitions = new QuadrantDependentList((Object)YoAppearance.Red(), (Object)YoAppearance.Green(), (Object)YoAppearance.DarkRed(), (Object)YoAppearance.DarkGreen());
    protected static boolean VISUALIZE = false;
    protected static boolean DEBUG = false;
    protected static boolean VERBOSE = false;
    private PawStepPlannerUI ui = null;
    protected Messager messager = null;
    protected QuadrupedXGaitSettings xGaitSettings = null;
    protected PawStepPlannerParametersBasics plannerParameters = null;
    private BodyPathAndPawPlanner planner = null;

    protected abstract QuadrupedXGaitSettings getXGaitSettings();

    protected abstract PawStepPlannerParametersBasics getPlannerParameters();

    protected abstract BodyPathAndPawPlanner createPlanner();

    @BeforeEach
    public void setup() {
        VISUALIZE = VISUALIZE && !ContinuousIntegrationTools.isRunningOnContinuousIntegrationServer();
        this.messager = VISUALIZE ? new SharedMemoryJavaFXMessager(PawStepPlannerMessagerAPI.API) : new SharedMemoryMessager(PawStepPlannerMessagerAPI.API);
        this.planner = this.createPlanner();
        if (this.xGaitSettings == null) {
            this.xGaitSettings = this.getXGaitSettings();
        }
        if (this.plannerParameters == null) {
            this.plannerParameters = this.getPlannerParameters();
        }
        try {
            this.messager.startMessager();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start messager.");
        }
        this.messager.submitMessage(PawStepPlannerMessagerAPI.XGaitSettingsTopic, (Object)this.xGaitSettings);
        if (VISUALIZE) {
            this.createUI(this.messager);
        }
        ThreadTools.sleep((long)1000L);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.messager.closeMessager();
        if (this.ui != null) {
            this.ui.stop();
        }
        this.ui = null;
        this.messager = null;
        this.planner = null;
    }

    private void createUI(final Messager messager) {
        ApplicationRunner.runApplication((Application)new Application(){

            public void start(Stage stage) throws Exception {
                PawStepPlannerDataSetTest.this.ui = PawStepPlannerUI.createMessagerUI((Stage)stage, (JavaFXMessager)((SharedMemoryJavaFXMessager)messager));
                PawStepPlannerDataSetTest.this.ui.show();
            }

            public void stop() throws Exception {
                PawStepPlannerDataSetTest.this.ui.stop();
                Platform.exit();
            }
        });
        double maxWaitTime = 5.0;
        double totalTime = 0.0;
        long sleepDuration = 100L;
        while (this.ui == null) {
            if (totalTime > maxWaitTime) {
                throw new RuntimeException("Timed out waiting for the UI to start.");
            }
            ThreadTools.sleep((long)sleepDuration);
            totalTime += Conversions.millisecondsToSeconds((double)sleepDuration);
        }
    }

    @Test
    public void testDataSets() {
        List dataSets = DataSetIOTools.loadDataSets(dataSet -> {
            if (!dataSet.hasPlannerInput()) {
                return false;
            }
            return dataSet.getPlannerInput().getQuadrupedPlannerIsTestable();
        });
        this.runAssertionsOnAllDatasets(dataSets);
    }

    @Disabled
    @Test
    public void runInDevelopmentTests() {
        List dataSets = DataSetIOTools.loadDataSets(dataSet -> {
            if (!dataSet.hasPlannerInput()) {
                return false;
            }
            return dataSet.getPlannerInput().getQuadrupedPlannerIsInDevelopment();
        });
        this.runAssertionsOnAllDatasets(dataSets);
    }

    @Test
    public void testSimpleForwardPoint() {
        FramePose3D startPose = new FramePose3D();
        FramePose3D goalPose = new FramePose3D();
        goalPose.getPosition().set(1.5, 0.5, 0.0);
        goalPose.getOrientation().setYawPitchRoll(-0.7853981633974483, 0.0, 0.0);
        PawStepPlannerStart start = new PawStepPlannerStart();
        PawStepPlannerGoal goal = new PawStepPlannerGoal();
        start.setStartPose((FramePose3DReadOnly)startPose);
        goal.setGoalPose((FramePose3DReadOnly)goalPose);
        this.planner.setPlanarRegionsList(null);
        this.planner.setStart(start);
        this.planner.setGoal(goal);
        this.planner.setTimeout(20.0);
        this.planner.setBestEffortTimeout(1.0);
        this.xGaitSettings.setEndPhaseShift(180.0);
        this.xGaitSettings.setQuadrupedSpeed(QuadrupedSpeed.MEDIUM);
        this.xGaitSettings.getTrotMediumTimings().setMaxSpeed(0.6);
        this.xGaitSettings.getTrotMediumTimings().setEndDoubleSupportDuration(0.15);
        this.xGaitSettings.getTrotMediumTimings().setStepDuration(0.3);
        this.xGaitSettings.setStanceLength(1.1);
        this.xGaitSettings.setStanceWidth(0.2);
        this.messager.submitMessage(PawStepPlannerMessagerAPI.XGaitSettingsTopic, (Object)this.xGaitSettings);
        this.messager.submitMessage(PawStepPlannerMessagerAPI.PlanarRegionDataTopic, null);
        this.messager.submitMessage(PawStepPlannerMessagerAPI.StartPositionTopic, (Object)new Point3D((Tuple3DReadOnly)startPose.getPosition()));
        this.messager.submitMessage(PawStepPlannerMessagerAPI.GoalPositionTopic, (Object)new Point3D((Tuple3DReadOnly)goalPose.getPosition()));
        this.messager.submitMessage(PawStepPlannerMessagerAPI.StartOrientationTopic, (Object)new Quaternion((QuaternionReadOnly)startPose.getOrientation()));
        this.messager.submitMessage(PawStepPlannerMessagerAPI.GoalOrientationTopic, (Object)new Quaternion((QuaternionReadOnly)goalPose.getOrientation()));
        this.messager.submitMessage(PawStepPlannerMessagerAPI.PlannerHorizonLengthTopic, (Object)100.0);
        PawStepPlanningResult pathResult = this.planner.planPath();
        Assert.assertTrue((String)("Path plan is invalid. Got path result " + pathResult), (boolean)pathResult.validForExecution());
        PawStepPlanningResult planResult = this.planner.plan();
        Assert.assertTrue((String)("Footstep plan is invalid. Got path result " + planResult), (boolean)planResult.validForExecution());
        this.messager.submitMessage(PawStepPlannerMessagerAPI.FootstepPlanTopic, (Object)this.planner.getPlan());
        String errorMessage = PawStepPlannerDataSetTest.assertPlanIsValid("", this.planner.getPlan(), (Point3DReadOnly)goalPose.getPosition(), goalPose.getYaw());
        Assert.assertTrue((String)errorMessage, (boolean)errorMessage.isEmpty());
        if (VISUALIZE) {
            ThreadTools.sleepForever();
        }
    }

    private void runAssertionsOnAllDatasets(List<DataSet> allDatasets) {
        if (VERBOSE || DEBUG) {
            LogTools.info((String)("Unit test files found: " + allDatasets.size()));
        }
        if (allDatasets.isEmpty()) {
            Assert.fail((String)"Did not find any datasets to test.");
        }
        int numberOfFailingTests = 0;
        ArrayList<String> failingDatasets = new ArrayList<String>();
        ArrayList<String> failingMessages = new ArrayList<String>();
        int numbberOfTestedSets = 0;
        for (int i = 0; i < allDatasets.size(); ++i) {
            DataSet dataset = allDatasets.get(i);
            if (DEBUG || VERBOSE) {
                LogTools.info((String)("Testing file: " + dataset.getName()));
            }
            ++numbberOfTestedSets;
            String errorMessagesForCurrentFile = this.runAssertions(dataset);
            if (!errorMessagesForCurrentFile.isEmpty()) {
                ++numberOfFailingTests;
                failingDatasets.add(dataset.getName());
                failingMessages.add(errorMessagesForCurrentFile);
            }
            if (DEBUG || VERBOSE) {
                String result = errorMessagesForCurrentFile.isEmpty() ? "passed" : "failed";
                LogTools.info((String)(dataset.getName() + " " + result));
            }
            ThreadTools.sleep((long)500L);
        }
        String message = "Number of failing datasets: " + numberOfFailingTests + " out of " + numbberOfTestedSets;
        message = message + "\n Datasets failing: ";
        for (int i = 0; i < failingDatasets.size(); ++i) {
            message = message + "\n" + (String)failingDatasets.get(i) + " : " + (String)failingMessages.get(i);
        }
        if (VISUALIZE) {
            LogTools.info((String)message);
            ThreadTools.sleepForever();
        } else {
            Assert.assertEquals((String)message, (long)0L, (long)numberOfFailingTests);
        }
    }

    protected String runAssertions(DataSetName dataSetName) {
        DataSet dataSet = DataSetIOTools.loadDataSet((DataSetName)dataSetName);
        return this.runAssertions(dataSet);
    }

    protected String runAssertions(DataSet dataset) {
        ThreadTools.sleep((long)1000L);
        this.packPlanningRequest(dataset);
        String errorMessage = this.findPlanAndAssertGoodResult(dataset);
        return errorMessage;
    }

    protected void packPlanningRequest(DataSet dataset) {
        PlannerInput plannerInput = dataset.getPlannerInput();
        FramePose3D startPose = new FramePose3D();
        FramePose3D goalPose = new FramePose3D();
        startPose.getPosition().set((Tuple3DReadOnly)plannerInput.getQuadrupedStartPosition());
        goalPose.getPosition().set((Tuple3DReadOnly)plannerInput.getQuadrupedGoalPosition());
        if (plannerInput.getHasQuadrupedStartYaw()) {
            startPose.getOrientation().set((QuaternionReadOnly)new Quaternion(plannerInput.getQuadrupedStartYaw(), 0.0, 0.0));
        }
        if (plannerInput.getHasQuadrupedGoalYaw()) {
            goalPose.getOrientation().set((QuaternionReadOnly)new Quaternion(plannerInput.getQuadrupedGoalYaw(), 0.0, 0.0));
        }
        double timeMultiplier = ContinuousIntegrationTools.isRunningOnContinuousIntegrationServer() ? 4.0 : 1.0;
        double timeout = timeMultiplier * plannerInput.getQuadrupedTimeout();
        PawStepPlannerStart start = new PawStepPlannerStart();
        PawStepPlannerGoal goal = new PawStepPlannerGoal();
        start.setStartPose((FramePose3DReadOnly)startPose);
        goal.setGoalPose((FramePose3DReadOnly)goalPose);
        this.planner.setPlanarRegionsList(dataset.getPlanarRegionsList());
        this.planner.setStart(start);
        this.planner.setGoal(goal);
        this.planner.setTimeout(timeout);
        this.planner.setBestEffortTimeout(1.0);
        this.planner.setPlanningHorizonLength(100.0);
        this.messager.submitMessage(PawStepPlannerMessagerAPI.XGaitSettingsTopic, (Object)this.xGaitSettings);
        this.messager.submitMessage(PawStepPlannerMessagerAPI.PlannerParametersTopic, (Object)this.plannerParameters);
        this.messager.submitMessage(PawStepPlannerMessagerAPI.PlanarRegionDataTopic, (Object)dataset.getPlanarRegionsList());
        this.messager.submitMessage(PawStepPlannerMessagerAPI.StartPositionTopic, (Object)new Point3D((Tuple3DReadOnly)startPose.getPosition()));
        this.messager.submitMessage(PawStepPlannerMessagerAPI.GoalPositionTopic, (Object)new Point3D((Tuple3DReadOnly)goalPose.getPosition()));
        this.messager.submitMessage(PawStepPlannerMessagerAPI.StartOrientationTopic, (Object)new Quaternion((QuaternionReadOnly)startPose.getOrientation()));
        this.messager.submitMessage(PawStepPlannerMessagerAPI.GoalOrientationTopic, (Object)new Quaternion((QuaternionReadOnly)goalPose.getOrientation()));
        this.messager.submitMessage(PawStepPlannerMessagerAPI.PlannerHorizonLengthTopic, (Object)100.0);
        if (DEBUG) {
            LogTools.info((String)"Set planner parameters.");
        }
    }

    private String findPlanAndAssertGoodResult(DataSet dataset) {
        String datasetName = dataset.getName();
        PawStepPlanningResult pathResult = this.planner.planPath();
        if (!pathResult.validForExecution()) {
            return "Path plan for " + datasetName + " is invalid. Got path result " + pathResult;
        }
        PawStepPlanningResult planResult = this.planner.plan();
        if (!planResult.validForExecution()) {
            return "Footstep plan for " + datasetName + " is invalid. Got plan result " + planResult;
        }
        this.messager.submitMessage(PawStepPlannerMessagerAPI.FootstepPlanTopic, (Object)this.planner.getPlan());
        PlannerInput plannerInput = dataset.getPlannerInput();
        String errorMessage = PawStepPlannerDataSetTest.assertPlanIsValid(datasetName, this.planner.getPlan(), (Point3DReadOnly)plannerInput.getQuadrupedGoalPosition(), plannerInput.getQuadrupedGoalYaw());
        ThreadTools.sleep((long)1000L);
        return errorMessage;
    }

    private static String assertPlanIsValid(String datasetName, PawStepPlan plannedSteps, Point3DReadOnly goalPosition, double goalYaw) {
        double yawError;
        QuadrantDependentList<Point3DBasics> finalSteps = PawStepPlannerDataSetTest.getFinalStepPositions(plannedSteps);
        Point3D centerPoint = new Point3D();
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            centerPoint.add((Tuple3DReadOnly)finalSteps.get((Enum)robotQuadrant));
        }
        double nominalYaw = PawNode.computeNominalYaw((double)((Point3DBasics)finalSteps.get((Enum)RobotQuadrant.FRONT_LEFT)).getX(), (double)((Point3DBasics)finalSteps.get((Enum)RobotQuadrant.FRONT_LEFT)).getY(), (double)((Point3DBasics)finalSteps.get((Enum)RobotQuadrant.FRONT_RIGHT)).getX(), (double)((Point3DBasics)finalSteps.get((Enum)RobotQuadrant.FRONT_RIGHT)).getY(), (double)((Point3DBasics)finalSteps.get((Enum)RobotQuadrant.HIND_LEFT)).getX(), (double)((Point3DBasics)finalSteps.get((Enum)RobotQuadrant.HIND_LEFT)).getY(), (double)((Point3DBasics)finalSteps.get((Enum)RobotQuadrant.HIND_RIGHT)).getX(), (double)((Point3DBasics)finalSteps.get((Enum)RobotQuadrant.HIND_RIGHT)).getY());
        centerPoint.scale(0.25);
        Object errorMessage = "";
        if (goalPosition.distanceXY((Point3DReadOnly)centerPoint) > 3.0 * PawNode.gridSizeXY) {
            errorMessage = datasetName + " did not reach goal position. Made it to " + centerPoint + ", trying to get to " + goalPosition;
        }
        if (!Double.isNaN(goalYaw) && (yawError = AngleTools.computeAngleDifferenceMinusPiToPi((double)goalYaw, (double)nominalYaw)) > PawNode.gridSizeYaw) {
            errorMessage = datasetName + " did not reach goal yaw. Made it to " + nominalYaw + ", trying to get to " + goalYaw;
        }
        errorMessage = (String)errorMessage + PawStepPlannerDataSetTest.checkStepOrder(datasetName, plannedSteps);
        if ((VISUALIZE || DEBUG) && !((String)errorMessage).isEmpty()) {
            LogTools.error((String)errorMessage);
        }
        return errorMessage;
    }

    private static QuadrantDependentList<Point3DBasics> getFinalStepPositions(PawStepPlan plannedSteps) {
        QuadrantDependentList finalSteps = new QuadrantDependentList();
        for (int i = plannedSteps.getNumberOfSteps() - 1; i >= 0; --i) {
            QuadrupedTimedStep step = plannedSteps.getPawStep(i);
            if (finalSteps.containsKey((Object)step.getRobotQuadrant())) continue;
            finalSteps.put((Enum)step.getRobotQuadrant(), (Object)new Point3D((Tuple3DReadOnly)step.getGoalPosition()));
        }
        return finalSteps;
    }

    private static String checkStepOrder(String dataseName, PawStepPlan plannedSteps) {
        Object errorMessage = "";
        RobotQuadrant previousMovingQuadrant = plannedSteps.getPawStep(0).getRobotQuadrant();
        for (int i = 1; i < plannedSteps.getNumberOfSteps(); ++i) {
            RobotQuadrant movingQuadrant = plannedSteps.getPawStep(i).getRobotQuadrant();
            if (previousMovingQuadrant.getNextRegularGaitSwingQuadrant() != movingQuadrant) {
                errorMessage = (String)errorMessage + dataseName + " step " + i + " in the plan is out of order.\n";
            }
            previousMovingQuadrant = movingQuadrant;
        }
        return errorMessage;
    }

    private void visualizePlan(PawStepPlan plan, PlanarRegionsList planarRegionsList, Point3DReadOnly start, Point3DReadOnly goal) {
        if (!VISUALIZE || ContinuousIntegrationTools.isRunningOnContinuousIntegrationServer()) {
            return;
        }
        SimulationConstructionSet scs = new SimulationConstructionSet();
        Graphics3DObject graphics3DObject = new Graphics3DObject();
        if (planarRegionsList != null) {
            Graphics3DObjectTools.addPlanarRegionsList((Graphics3DObject)graphics3DObject, (PlanarRegionsList)planarRegionsList, (AppearanceDefinition[])new AppearanceDefinition[]{YoAppearance.White(), YoAppearance.Grey(), YoAppearance.DarkGray()});
        }
        scs.setGroundVisible(false);
        graphics3DObject.identity();
        graphics3DObject.translate((Tuple3DReadOnly)start);
        graphics3DObject.translate(0.0, 0.0, 0.05);
        graphics3DObject.addCone(0.3, 0.05, YoAppearance.Blue());
        graphics3DObject.identity();
        graphics3DObject.translate((Tuple3DReadOnly)goal);
        graphics3DObject.translate(0.0, 0.0, 0.05);
        graphics3DObject.addCone(0.3, 0.05, YoAppearance.Black());
        if (plan != null) {
            for (int i = 0; i < plan.getNumberOfSteps(); ++i) {
                Point3DReadOnly point = plan.getPawStep(i).getGoalPosition();
                AppearanceDefinition appearanceDefinition = (AppearanceDefinition)colorDefinitions.get((Enum)plan.getPawStep(i).getRobotQuadrant());
                graphics3DObject.identity();
                graphics3DObject.translate((Tuple3DReadOnly)point);
                graphics3DObject.addSphere(0.1, appearanceDefinition);
            }
        }
        scs.addStaticLinkGraphics(graphics3DObject);
        scs.setCameraFix(0.0, 0.0, 0.0);
        scs.setCameraPosition(-0.001, 0.0, 15.0);
        scs.startOnAThread();
        ThreadTools.sleepForever();
    }
}

