/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pathPlanning;

import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.DefaultVisibilityGraphParameters;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersReadOnly;
import us.ihmc.quadrupedFootstepPlanning.pathPlanning.VisibilityGraphPawPathPlanner;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.PawStepPlannerGoal;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.PawStepPlannerTargetType;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.yoVariables.registry.YoRegistry;

public class VisibilityGraphPawPathPlannerTest {
    @Test
    public void testStartingOffPlanarRegion() {
        YoRegistry testRegistry = new YoRegistry("testRegistry");
        VisibilityGraphPawPathPlanner planner = new VisibilityGraphPawPathPlanner((VisibilityGraphsParametersReadOnly)new DefaultVisibilityGraphParameters(), testRegistry);
        ConvexPolygon2D planarRegionPolygon = new ConvexPolygon2D();
        planarRegionPolygon.addVertex(-5.0, 5.0);
        planarRegionPolygon.addVertex(-5.0, -5.0);
        planarRegionPolygon.addVertex(5.0, -5.0);
        planarRegionPolygon.addVertex(5.0, 5.0);
        planarRegionPolygon.update();
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), (Vertex2DSupplier)planarRegionPolygon);
        planarRegion.setRegionId(25);
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(new PlanarRegion[]{planarRegion});
        PawStepPlannerGoal goal = new PawStepPlannerGoal();
        goal.setGoalType(PawStepPlannerTargetType.POSE_BETWEEN_FEET);
        goal.setGoalPose((FramePose3DReadOnly)new FramePose3D());
        FramePose3D startPose = new FramePose3D();
        startPose.getPosition().set(-4.0, 0.0, 0.0);
        planner.setPlanarRegionsList(planarRegionsList);
        planner.setInitialBodyPose((FramePose3DReadOnly)startPose);
        planner.setGoal(goal);
        planner.setTimeout(10.0);
        startPose = new FramePose3D();
        startPose.getPosition().set(-5.4, 0.0, 0.0);
        planner.setPlanarRegionsList(planarRegionsList);
        planner.setInitialBodyPose((FramePose3DReadOnly)startPose);
        planner.setGoal(goal);
        planner.setTimeout(10.0);
        Assert.assertTrue((boolean)planner.planWaypoints().validForExecution());
    }
}

