/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.stepCost;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.stepCost.EllipseTools;
import us.ihmc.robotics.Assert;

public class EllipseToolsTest {
    @Test
    public void computeMagnitudeOnEllipseInDirection() {
        Random random = new Random(1738L);
        for (int i = 0; i < 1000; ++i) {
            double maxX = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)100.0);
            double maxY = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)100.0);
            double xDirection = RandomNumbers.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double yDirection = RandomNumbers.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double xIntersection = maxX * maxY / Math.sqrt(MathTools.square((double)(maxX * yDirection)) + MathTools.square((double)(maxY * xDirection))) * xDirection;
            double yIntersection = maxX * maxY / Math.sqrt(MathTools.square((double)(maxX * yDirection)) + MathTools.square((double)(maxY * xDirection))) * yDirection;
            double magnitude = EuclidCoreTools.norm((double)xIntersection, (double)yIntersection);
            Assert.assertEquals((double)magnitude, (double)EllipseTools.computeMagnitudeOnEllipseInDirection((double)maxX, (double)maxY, (double)xDirection, (double)yDirection), (double)1.0E-5);
        }
    }

    @Test
    public void testProjectPointOntoEllipse() {
        Random random = new Random(1738L);
        for (int i = 0; i < 1000; ++i) {
            double maxX = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)100.0);
            double maxY = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)100.0);
            Point2D pointToProject = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            double projectedXPosition = maxX * maxY / Math.sqrt(MathTools.square((double)(maxX * pointToProject.getY())) + MathTools.square((double)(maxY * pointToProject.getX()))) * pointToProject.getX();
            double projectedYPosition = maxX * maxY / Math.sqrt(MathTools.square((double)(maxX * pointToProject.getY())) + MathTools.square((double)(maxY * pointToProject.getX()))) * pointToProject.getY();
            Point2D projectedPointExpected = new Point2D(projectedXPosition, projectedYPosition);
            Point2D projectedPoint = new Point2D();
            EllipseTools.projectPointOntoEllipse((double)maxX, (double)maxY, (Point2DReadOnly)pointToProject, (Point2DBasics)projectedPoint);
            EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)projectedPointExpected, (Point2DReadOnly)projectedPoint, (double)1.0E-5);
        }
    }

    @Test
    public void testDistanceToEllipse() {
        Random random = new Random(1738L);
        for (int i = 0; i < 1000; ++i) {
            double maxX = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)100.0);
            double maxY = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)100.0);
            Point2D point = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            double projectedXPosition = maxX * maxY / Math.sqrt(MathTools.square((double)(maxX * point.getY())) + MathTools.square((double)(maxY * point.getX()))) * point.getX();
            double projectedYPosition = maxX * maxY / Math.sqrt(MathTools.square((double)(maxX * point.getY())) + MathTools.square((double)(maxY * point.getX()))) * point.getY();
            Point2D projectedPoint = new Point2D(projectedXPosition, projectedYPosition);
            double distanceSign = EllipseTools.isPointInsideEllipse((double)maxX, (double)maxY, (Point2DReadOnly)point) ? -1.0 : 1.0;
            double expectedDistance = distanceSign * projectedPoint.distance((Point2DReadOnly)point);
            double distance = EllipseTools.getDistanceFromPointToEllipse((double)maxX, (double)maxY, (Point2DReadOnly)point);
            Assert.assertEquals((String)("iteration " + i), (double)expectedDistance, (double)distance, (double)1.0E-6);
        }
    }

    @Test
    public void testIsPointInsideEllipse() {
        Random random = new Random(1738L);
        for (int i = 0; i < 1000; ++i) {
            Point2D point;
            double maxY;
            double maxX = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)100.0);
            double distanceToEllipse = EllipseTools.getDistanceFromPointToEllipse((double)maxX, (double)(maxY = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)100.0)), (Point2DReadOnly)(point = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0)));
            boolean pointIsInsideExpected = distanceToEllipse < 0.0;
            Assert.assertEquals((String)("iteration " + i), (Object)pointIsInsideExpected, (Object)EllipseTools.isPointInsideEllipse((double)maxX, (double)maxY, (Point2DReadOnly)point));
        }
    }
}

