/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.pawSnapping;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commonWalkingControlModules.polygonWiggling.PolygonWiggler;
import us.ihmc.commonWalkingControlModules.polygonWiggling.WiggleParameters;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DBasics;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.pathPlanning.DataSet;
import us.ihmc.pathPlanning.DataSetIOTools;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.graph.PawNode;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.parameters.DefaultPawStepPlannerParameters;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.parameters.PawStepPlannerParametersReadOnly;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.pawSnapping.PawNodePlanarRegionSnapAndWiggler;
import us.ihmc.quadrupedFootstepPlanning.pawPlanning.graphSearch.pawSnapping.PawNodeSnapData;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.robotSide.RobotQuadrant;

class PawNodePlanarRegionSnapAndWigglerTest {
    private static final int iters = 5000;

    PawNodePlanarRegionSnapAndWigglerTest() {
    }

    @Test
    void testIssue20190603_WigglerViolateDeltaInsideRegionOnly() {
        DataSet dataSet = DataSetIOTools.loadDataSet((String)"20190603_224047_PlanarRegionWigglerViolateDeltaInside");
        PlanarRegion troublesomeRegion = dataSet.getPlanarRegionsList().getPlanarRegionsAsList().stream().filter(region -> region.isPointInside((Point3DReadOnly)new Point3D(-0.12, -0.51, -0.49), 0.01)).findFirst().get();
        ConvexPolygon2D planeToWiggleInto = troublesomeRegion.getConvexHull();
        double deltaInside = 0.06;
        double maxXY = 0.1;
        for (int vertexIndex = 0; vertexIndex < planeToWiggleInto.getNumberOfVertices(); ++vertexIndex) {
            for (double alpha = 0.0; alpha <= 1.0; alpha += 0.05) {
                ConvexPolygon2D polygonToWiggle = new ConvexPolygon2D();
                Point2D pointOnEdge = new Point2D();
                pointOnEdge.interpolate((Tuple2DReadOnly)planeToWiggleInto.getVertex(vertexIndex), (Tuple2DReadOnly)planeToWiggleInto.getNextVertex(vertexIndex), alpha);
                LineSegment2D edge = new LineSegment2D();
                planeToWiggleInto.getEdge(vertexIndex, (LineSegment2DBasics)edge);
                Vector2DBasics normal = edge.direction(true);
                normal = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)normal);
                normal.scale(0.005);
                polygonToWiggle.addVertex((Point2DReadOnly)pointOnEdge);
                polygonToWiggle.update();
                WiggleParameters parameters = new WiggleParameters();
                parameters.deltaInside = deltaInside;
                parameters.maxX = maxXY;
                parameters.maxY = maxXY;
                parameters.minX = -maxXY;
                parameters.minY = -maxXY;
                parameters.maxYaw = 0.0;
                parameters.minYaw = -0.0;
                ConvexPolygon2D wigglePolygon = PolygonWiggler.wigglePolygon((ConvexPolygon2D)polygonToWiggle, (ConvexPolygon2DReadOnly)planeToWiggleInto, (WiggleParameters)parameters);
                double distanceInside = planeToWiggleInto.signedDistance(wigglePolygon.getCentroid());
                Assert.assertTrue((String)("desired = -0.025 actual = " + distanceInside), (distanceInside < -0.025 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    void testIssue20190603_WigglerViolateDeltaInsideSinglePoint() {
        DataSet dataSet = DataSetIOTools.loadDataSet((String)"20190603_224047_PlanarRegionWigglerViolateDeltaInside");
        PlanarRegion troublesomeRegion = dataSet.getPlanarRegionsList().getPlanarRegionsAsList().stream().filter(region -> region.isPointInside((Point3DReadOnly)new Point3D(-0.12, -0.51, -0.49), 0.01)).findFirst().get();
        ConvexPolygon2D planeToWiggleInto = troublesomeRegion.getConvexHull();
        ConvexPolygon2D polygonToWiggle = new ConvexPolygon2D();
        Point2D pointOnEdge = new Point2D(0.1621632681, -0.006395009);
        polygonToWiggle.addVertex((Point2DReadOnly)pointOnEdge);
        polygonToWiggle.update();
        WiggleParameters parameters = new WiggleParameters();
        parameters.deltaInside = 0.06;
        parameters.maxX = 0.05;
        parameters.maxY = 0.05;
        parameters.minX = -0.05;
        parameters.minY = -0.05;
        parameters.maxYaw = 0.0;
        parameters.minYaw = -0.0;
        ConvexPolygon2D wigglePolygon = PolygonWiggler.wigglePolygon((ConvexPolygon2D)polygonToWiggle, (ConvexPolygon2DReadOnly)planeToWiggleInto, (WiggleParameters)parameters);
        Assert.assertTrue((planeToWiggleInto.signedDistance(wigglePolygon.getCentroid()) < -0.025 ? 1 : 0) != 0);
    }

    @Test
    void testIssue20190603_WigglerViolateDeltaInside() {
        DataSet dataSet = DataSetIOTools.loadDataSet((String)"20190603_224047_PlanarRegionWigglerViolateDeltaInside");
        Point3D suspiciousPoint = new Point3D(-0.12, -0.51, -0.49);
        Random random = new Random(1738L);
        PawNodePlanarRegionSnapAndWigglerTest.testPoint(random, (Point3DReadOnly)suspiciousPoint, dataSet, 5000);
    }

    private static void testABunchOfPoints(DataSet dataSet, int numberOfPoints) {
        PlanarRegionsList planarRegionsList = dataSet.getPlanarRegionsList();
        Random random = new Random(1738L);
        int pointsTested = 0;
        while (pointsTested < numberOfPoints) {
            int regionNumberToCheck = RandomNumbers.nextInt((Random)random, (int)0, (int)(planarRegionsList.getNumberOfPlanarRegions() - 1));
            PlanarRegion planarRegion = planarRegionsList.getPlanarRegion(regionNumberToCheck);
            if (planarRegion.getNormal().angle((Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0)) < Math.toRadians(45.0)) continue;
            int convexPolygonToCheck = RandomNumbers.nextInt((Random)random, (int)0, (int)(planarRegion.getNumberOfConvexPolygons() - 1));
            Point2DReadOnly randomPointInPolygon = PawNodePlanarRegionSnapAndWigglerTest.getRandomInteriorPointOfPolygon(random, (ConvexPolygon2DReadOnly)planarRegion.getConvexPolygon(convexPolygonToCheck));
            Point3D randomPointInWorld = new Point3D((Tuple2DReadOnly)randomPointInPolygon);
            planarRegion.transformFromLocalToWorld((Transformable)randomPointInWorld);
            PawNodePlanarRegionSnapAndWigglerTest.testPoint(random, (Point3DReadOnly)randomPointInWorld, dataSet, 1);
            ++pointsTested;
        }
    }

    private static void testPoint(Random random, Point3DReadOnly containingPointOfSuspicion, DataSet dataSet, int iters) {
        Point2D pointToCheck;
        Point3D gridPointInLocal;
        double gridY;
        double gridX;
        int yIndex;
        int xIndex;
        boolean useConvexHull = true;
        double distanceInside = 0.06;
        boolean careAboutGridCell = false;
        final double maxWiggle = 0.05;
        DefaultPawStepPlannerParameters plannerParameters = new DefaultPawStepPlannerParameters(){

            public double getMaximumXYWiggleDistance() {
                return maxWiggle;
            }
        };
        PawNodePlanarRegionSnapAndWiggler snapAndWiggler = new PawNodePlanarRegionSnapAndWiggler((PawStepPlannerParametersReadOnly)plannerParameters, () -> distanceInside, () -> useConvexHull, careAboutGridCell);
        PlanarRegion troublesomeRegion = dataSet.getPlanarRegionsList().getPlanarRegionsAsList().stream().filter(region -> region.isPointInside(containingPointOfSuspicion, 0.01)).findFirst().get();
        snapAndWiggler.setPlanarRegions(dataSet.getPlanarRegionsList());
        ConvexPolygon2D planeToWiggleInto = troublesomeRegion.getConvexHull();
        for (int vertexIndex = 0; vertexIndex < planeToWiggleInto.getNumberOfVertices(); ++vertexIndex) {
            for (double alpha = 0.0; alpha <= 1.0; alpha += 0.05) {
                Point2D pointOnEdgeInLocal = new Point2D();
                pointOnEdgeInLocal.interpolate((Tuple2DReadOnly)planeToWiggleInto.getVertex(vertexIndex), (Tuple2DReadOnly)planeToWiggleInto.getNextVertex(vertexIndex), alpha);
                Point3D pointOnEdgeInWorld = new Point3D((Tuple2DReadOnly)pointOnEdgeInLocal);
                troublesomeRegion.transformFromLocalToWorld((Transformable)pointOnEdgeInWorld);
                String premessage = "Vertex index = " + vertexIndex + "\nAlpha = " + alpha + "\n";
                Assert.assertTrue((String)(premessage + "Pre-wiggle is out of the region.\n Point in local\n" + pointOnEdgeInLocal), (boolean)troublesomeRegion.isPointInside((Point2DReadOnly)pointOnEdgeInLocal, 1.0E-8));
                Assert.assertTrue((String)(premessage + "Pre-wiggle is out of the region with the world check.\n Point in world\n" + pointOnEdgeInWorld), (boolean)troublesomeRegion.isPointInWorld2DInside((Point3DReadOnly)pointOnEdgeInWorld, 1.0E-8));
                xIndex = PawNode.snapToGrid((double)pointOnEdgeInWorld.getX());
                yIndex = PawNode.snapToGrid((double)pointOnEdgeInWorld.getY());
                gridX = PawNode.gridSizeXY * (double)xIndex;
                gridY = PawNode.gridSizeXY * (double)yIndex;
                gridPointInLocal = new Point3D(gridX, gridY, 0.0);
                troublesomeRegion.transformFromWorldToLocal((Transformable)gridPointInLocal);
                if (!troublesomeRegion.isPointInWorld2DInside((Point3DReadOnly)new Point3D(gridX, gridY, 0.0), 1.0E-8)) continue;
                PawNodeSnapData snapData = snapAndWiggler.snapPawNode(RobotQuadrant.FRONT_LEFT, xIndex, yIndex, 0.0);
                Point3D snappedPointInWorld = new Point3D(gridX, gridY, 0.0);
                snapData.getSnapTransform().transform((Point3DBasics)snappedPointInWorld);
                Point3DReadOnly alternatelySnappedPointInWorld = PawNodePlanarRegionSnapAndWigglerTest.runDifferentCheck(new Point2D((Tuple3DReadOnly)gridPointInLocal), troublesomeRegion, distanceInside, maxWiggle);
                EuclidCoreTestTools.assertPoint3DGeometricallyEquals((String)(premessage + "Checking the way it was wiggled\n"), (Point3DReadOnly)alternatelySnappedPointInWorld, (Point3DReadOnly)snappedPointInWorld, (double)1.0E-5);
                Point3D snappedPointInLocal = new Point3D((Tuple3DReadOnly)snappedPointInWorld);
                Point3D alternatelySnappedPointInLocal = new Point3D((Tuple3DReadOnly)alternatelySnappedPointInWorld);
                troublesomeRegion.transformFromWorldToLocal((Transformable)snappedPointInLocal);
                troublesomeRegion.transformFromWorldToLocal((Transformable)alternatelySnappedPointInLocal);
                pointToCheck = new Point2D((Tuple3DReadOnly)snappedPointInLocal);
                Point2D alternatelyPointToCheck = new Point2D((Tuple3DReadOnly)alternatelySnappedPointInLocal);
                Assert.assertTrue((String)(premessage + "We wiggled out of the region with the world check.\n Point in world\n" + alternatelySnappedPointInWorld), (boolean)troublesomeRegion.isPointInWorld2DInside(alternatelySnappedPointInWorld));
                Assert.assertTrue((String)(premessage + "We wiggled out of the region with the world check.\n Point in world\n" + snappedPointInWorld), (boolean)troublesomeRegion.isPointInWorld2DInside((Point3DReadOnly)snappedPointInWorld));
                Assert.assertTrue((String)(premessage + "We wiggled out of the region!"), (boolean)troublesomeRegion.isPointInside((Point2DReadOnly)alternatelyPointToCheck));
                Assert.assertTrue((String)(premessage + "We wiggled out of the region!"), (boolean)troublesomeRegion.isPointInside((Point2DReadOnly)pointToCheck));
                double achievedDistance = planeToWiggleInto.signedDistance((Point2DReadOnly)pointToCheck);
                double alternateltyAchievedDistance = planeToWiggleInto.signedDistance((Point2DReadOnly)alternatelyPointToCheck);
                Assert.assertTrue((String)(premessage + "Point\n" + alternatelyPointToCheck + "\nis not far enough inside region\n" + planeToWiggleInto + "\ndistance inside: " + alternateltyAchievedDistance), (alternateltyAchievedDistance < -0.025 ? 1 : 0) != 0);
                Assert.assertTrue((String)(premessage + "Point\n" + pointToCheck + "\nis not far enough inside region\n" + planeToWiggleInto + "\ndistance inside: " + achievedDistance), (achievedDistance < -0.025 ? 1 : 0) != 0);
            }
        }
        for (int iter = 0; iter < iters; ++iter) {
            Point2DReadOnly pointInLocalToWiggle = PawNodePlanarRegionSnapAndWigglerTest.getRandomInteriorPointOfPolygon(random, (ConvexPolygon2DReadOnly)planeToWiggleInto);
            Point3D pointInWorldToWiggle = new Point3D((Tuple2DReadOnly)pointInLocalToWiggle);
            troublesomeRegion.transformFromLocalToWorld((Transformable)pointInWorldToWiggle);
            Point3D pointInLocalAgain = new Point3D((Tuple3DReadOnly)pointInWorldToWiggle);
            troublesomeRegion.transformFromWorldToLocal((Transformable)pointInLocalAgain);
            String premessage = "Iter = " + iter + "\n";
            Assert.assertTrue((String)(premessage + "Pre-wiggle is out of the region.\n Point in local\n" + pointInLocalToWiggle), (boolean)troublesomeRegion.isPointInside(pointInLocalToWiggle, 1.0E-8));
            Assert.assertTrue((String)(premessage + "Pre-wiggle is out of the region with the world check.\n Point in world\n" + pointInWorldToWiggle), (boolean)troublesomeRegion.isPointInWorld2DInside((Point3DReadOnly)pointInWorldToWiggle, 1.0E-8));
            RobotQuadrant robotQuadrant = RobotQuadrant.FRONT_LEFT;
            xIndex = PawNode.snapToGrid((double)pointInWorldToWiggle.getX());
            yIndex = PawNode.snapToGrid((double)pointInWorldToWiggle.getY());
            gridX = PawNode.gridSizeXY * (double)xIndex;
            gridY = PawNode.gridSizeXY * (double)yIndex;
            gridPointInLocal = new Point3D(gridX, gridY, 0.0);
            troublesomeRegion.transformFromWorldToLocal((Transformable)gridPointInLocal);
            double yaw = 0.0;
            if (!troublesomeRegion.isPointInWorld2DInside((Point3DReadOnly)new Point3D(gridX, gridY, 0.0), 1.0E-8)) continue;
            PawNodeSnapData snapData = snapAndWiggler.snapPawNode(robotQuadrant, xIndex, yIndex, yaw);
            Point3D snappedPointInWorld = new Point3D(gridX, gridY, 0.0);
            snapData.getSnapTransform().transform((Point3DBasics)snappedPointInWorld);
            Point3D snappedPointInLocal = new Point3D((Tuple3DReadOnly)snappedPointInWorld);
            troublesomeRegion.transformFromWorldToLocal((Transformable)snappedPointInLocal);
            pointToCheck = new Point2D((Tuple3DReadOnly)snappedPointInLocal);
            Assert.assertTrue((String)(premessage + "We wiggled out of the region with the world check.\n Point in world\n" + snappedPointInWorld), (boolean)troublesomeRegion.isPointInWorld2DInside((Point3DReadOnly)snappedPointInWorld));
            Assert.assertTrue((String)(premessage + "We wiggled out of the region!"), (boolean)troublesomeRegion.isPointInside((Point2DReadOnly)pointToCheck));
            double achievedDistance = planeToWiggleInto.signedDistance((Point2DReadOnly)pointToCheck);
            Assert.assertTrue((String)(premessage + "Point\n" + pointToCheck + "\nis not far enough inside region\n" + planeToWiggleInto + "\ndistance inside: " + achievedDistance), (achievedDistance < -0.025 ? 1 : 0) != 0);
        }
    }

    private static Point3DReadOnly runDifferentCheck(Point2D pointInLocalToWiggle, PlanarRegion regionToWiggleInto, double distanceInside, double maxWiggle) {
        ConvexPolygon2D polygonToWiggle = new ConvexPolygon2D();
        polygonToWiggle.addVertex((Point2DReadOnly)pointInLocalToWiggle);
        polygonToWiggle.update();
        WiggleParameters parameters = new WiggleParameters();
        parameters.deltaInside = distanceInside;
        parameters.maxX = maxWiggle;
        parameters.maxY = maxWiggle;
        parameters.minX = -maxWiggle;
        parameters.minY = -maxWiggle;
        parameters.maxYaw = 0.0;
        parameters.minYaw = -0.0;
        ConvexPolygon2D wigglePolygon = PolygonWiggler.wigglePolygon((ConvexPolygon2D)polygonToWiggle, (ConvexPolygon2DReadOnly)regionToWiggleInto.getConvexHull(), (WiggleParameters)parameters);
        Point3D centroidInWorld = new Point3D((Tuple2DReadOnly)wigglePolygon.getCentroid());
        regionToWiggleInto.transformFromLocalToWorld((Transformable)centroidInWorld);
        return centroidInWorld;
    }

    private static Point2DReadOnly getRandomInteriorPointOfPolygon(Random randomSeed, ConvexPolygon2DReadOnly polygon) {
        TDoubleArrayList vertexWeights = new TDoubleArrayList();
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            vertexWeights.add(RandomNumbers.nextDouble((Random)randomSeed, (double)0.0, (double)1.0));
        }
        double sum = vertexWeights.sum();
        for (int i = 0; i < vertexWeights.size(); ++i) {
            vertexWeights.set(i, vertexWeights.get(i) / sum);
        }
        Point2D interiorPoint = new Point2D();
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            interiorPoint.scaleAdd(vertexWeights.get(i), (Tuple2DReadOnly)polygon.getVertex(i), (Tuple2DReadOnly)interiorPoint);
        }
        return interiorPoint;
    }
}

