/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.idl;

import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.idl.IDLSequence;

public class IDLTools {
    public static boolean equals(StringBuilder a, StringBuilder b) {
        if (a.length() == b.length()) {
            for (int i = 0; i < a.length(); ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean epsilonEquals(double a, double b, double epsilon) {
        return EuclidCoreTools.epsilonEquals((double)a, (double)b, (double)epsilon);
    }

    public static boolean epsilonEqualsBoolean(boolean a, boolean b, double epsilon) {
        return a == b;
    }

    public static boolean epsilonEqualsPrimitive(double a, double b, double epsilon) {
        return EuclidCoreTools.epsilonEquals((double)a, (double)b, (double)epsilon);
    }

    public static boolean epsilonEqualsEnum(Enum a, Enum b, double epsilon) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return EuclidCoreTools.epsilonEquals((double)a.ordinal(), (double)b.ordinal(), (double)epsilon);
    }

    public static boolean epsilonEqualsStringBuilder(StringBuilder a, StringBuilder b, double epsilon) {
        return IDLTools.equals(a, b);
    }

    public static boolean epsilonEqualsStringBuilderSequence(IDLSequence.StringBuilderHolder a, IDLSequence.StringBuilderHolder b, double epsilon) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (IDLTools.epsilonEqualsStringBuilder((StringBuilder)a.get(i), (StringBuilder)b.get(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean epsilonEqualsBooleanSequence(IDLSequence.Boolean a, IDLSequence.Boolean b, double epsilon) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (IDLTools.epsilonEqualsBoolean(a.getBoolean(i), b.getBoolean(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean epsilonEqualsPrimitiveSequence(DoubleProvider providerA, DoubleProvider providerB, IDLSequence a, IDLSequence b, double epsilon) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (IDLTools.epsilonEquals(providerA.get(i), providerB.get(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean epsilonEqualsEnumSequence(IDLSequence.Enum a, IDLSequence.Enum b, double epsilon) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (IDLTools.epsilonEqualsEnum(a.get(i), b.get(i), epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean epsilonEqualsByteSequence(IDLSequence.Byte a, IDLSequence.Byte b, double epsilon) {
        return IDLTools.epsilonEqualsPrimitiveSequence(a::get, b::get, a, b, epsilon);
    }

    public static boolean epsilonEqualsCharSequence(IDLSequence.Char a, IDLSequence.Char b, double epsilon) {
        return IDLTools.epsilonEqualsPrimitiveSequence(arg_0 -> ((IDLSequence.Char)a).get(arg_0), arg_0 -> ((IDLSequence.Char)b).get(arg_0), a, b, epsilon);
    }

    public static boolean epsilonEqualsShortSequence(IDLSequence.Short a, IDLSequence.Short b, double epsilon) {
        return IDLTools.epsilonEqualsPrimitiveSequence(arg_0 -> ((IDLSequence.Short)a).get(arg_0), arg_0 -> ((IDLSequence.Short)b).get(arg_0), a, b, epsilon);
    }

    public static boolean epsilonEqualsIntegerSequence(IDLSequence.Integer a, IDLSequence.Integer b, double epsilon) {
        return IDLTools.epsilonEqualsPrimitiveSequence(arg_0 -> ((IDLSequence.Integer)a).get(arg_0), arg_0 -> ((IDLSequence.Integer)b).get(arg_0), a, b, epsilon);
    }

    public static boolean epsilonEqualsLongSequence(IDLSequence.Long a, IDLSequence.Long b, double epsilon) {
        return IDLTools.epsilonEqualsPrimitiveSequence(arg_0 -> ((IDLSequence.Long)a).get(arg_0), arg_0 -> ((IDLSequence.Long)b).get(arg_0), a, b, epsilon);
    }

    public static boolean epsilonEqualsFloatSequence(IDLSequence.Float a, IDLSequence.Float b, double epsilon) {
        return IDLTools.epsilonEqualsPrimitiveSequence(arg_0 -> ((IDLSequence.Float)a).get(arg_0), arg_0 -> ((IDLSequence.Float)b).get(arg_0), a, b, epsilon);
    }

    public static boolean epsilonEqualsDoubleSequence(IDLSequence.Double a, IDLSequence.Double b, double epsilon) {
        return IDLTools.epsilonEqualsPrimitiveSequence(arg_0 -> ((IDLSequence.Double)a).get(arg_0), arg_0 -> ((IDLSequence.Double)b).get(arg_0), a, b, epsilon);
    }

    private static interface DoubleProvider {
        public double get(int var1);
    }
}

