/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.common;

public class SequenceNumber {
    private int high;
    private long low;

    public int getHigh() {
        return this.high;
    }

    public void setHigh(int high) {
        this.high = high;
    }

    public long getLow() {
        return this.low;
    }

    public void setLow(long low) {
        this.low = low;
    }

    public void set(int high, long low) {
        this.high = high;
        this.low = low;
    }

    public boolean lessThan(SequenceNumber other) {
        if (this.high > other.high) {
            return false;
        }
        if (this.high < other.high) {
            return true;
        }
        return this.low < other.low;
    }

    public void set(long sequenceNumber) {
        this.high = (int)(sequenceNumber >> 32);
        this.low = sequenceNumber & 0xFFFFFFFFFFFFFFFFL;
    }

    public long get() {
        return this.getAsLong();
    }

    private long getAsLong() {
        if (this.high == -1) {
            return -1L;
        }
        return ((long)this.high << 32) + this.low;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.high;
        result = 31 * result + (int)(this.low ^ this.low >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceNumber other = (SequenceNumber)obj;
        if (this.high != other.high) {
            return false;
        }
        return this.low == other.low;
    }

    public void set(SequenceNumber other) {
        this.low = other.low;
        this.high = other.high;
    }
}

