/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.attributes;

import com.eprosima.xmlschemas.fastrtps_profiles.DurationType;
import jakarta.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import us.ihmc.pubsub.common.Time;

public class DDSConversionTools {
    public static DurationType timeToDurationType(Time time) {
        DurationType dt = new DurationType();
        JAXBElement nanosec = new JAXBElement(new QName("http://www.eprosima.com/XMLSchemas/fastRTPS_Profiles", "nanosec"), String.class, (Object)Long.toString(time.getNanoseconds()));
        JAXBElement sec = new JAXBElement(new QName("http://www.eprosima.com/XMLSchemas/fastRTPS_Profiles", "sec"), String.class, (Object)Integer.toString(time.getSeconds()));
        dt.getSecOrNanosec().add(nanosec);
        dt.getSecOrNanosec().add(sec);
        return dt;
    }

    public static Time durationTypeToTime(DurationType duration) {
        if (duration == null) {
            return null;
        }
        Time time = new Time();
        for (JAXBElement e : duration.getSecOrNanosec()) {
            switch (e.getName().getLocalPart()) {
                case "nanosec": {
                    time.setNanoseconds(Long.parseLong(e.getValue().toString()));
                    break;
                }
                case "sec": {
                    time.setSeconds(Integer.parseInt(e.getValue().toString()));
                }
            }
        }
        return time;
    }

    public static Time createTime(double timeInSeconds) {
        Time time = new Time();
        int seconds = (int)timeInSeconds;
        double remainder = timeInSeconds - (double)seconds;
        time.setSeconds((int)timeInSeconds);
        time.setNanoseconds((long)(remainder * 1.0E9));
        return time;
    }
}

