/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.impl.fastRTPS;

import com.eprosima.xmlschemas.fastrtps_profiles.Dds;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantProfile;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSNativeLibrary;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSParticipant;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSPublisher;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSJNI;
import us.ihmc.tools.nativelibraries.NativeLibraryDescription;
import us.ihmc.tools.nativelibraries.NativeLibraryLoader;

public class FastRTPSDomain
implements Domain {
    public static final String FAST_DDS_DISCOVERY_CONFIGURABLE_PREFIX = "44.53.%02X.5f.45.50.52.4f.53.49.4d.41";
    public static final String FAST_DDS_XML_NAMESPACE = "http://www.eprosima.com/XMLSchemas/fastRTPS_Profiles";
    public static final String FAST_DDS_METATRAFFIC_UNICAST_LOCATOR_LIST = "metatrafficUnicastLocatorList";
    public static final String FAST_DDS_TRANSPORT = "transport_descriptors";
    public static final String FAST_DDS_PARTICIPANT = "participant";
    public static final String FAST_DDS_PUBLISHER = "publisher";
    public static final String FAST_DDS_SUBSCRIBER = "subscriber";
    public static final String FAST_DDS_NANOSEC = "nanosec";
    public static final String FAST_DDS_SEC = "sec";
    public static final int DEFAULT_DISCOVERY_SERVER_PORT = 11811;
    private final ArrayList<FastRTPSParticipant> participants = new ArrayList();
    private final ArrayList<Participant> allParticipantsForStatistics = new ArrayList();
    private static boolean useSystemFastRTPS = false;
    private static FastRTPSDomain instance = null;

    public static synchronized FastRTPSDomain getInstance(boolean useSystemFastRTPS) {
        if (instance == null) {
            FastRTPSDomain.useSystemFastRTPS = useSystemFastRTPS;
            instance = new FastRTPSDomain(useSystemFastRTPS);
        }
        if (FastRTPSDomain.useSystemFastRTPS != useSystemFastRTPS) {
            if (useSystemFastRTPS) {
                throw new RuntimeException("Loading FastRTPS using the system FastRTPS library, but the builtin FastRTPS library is already loaded.");
            }
            throw new RuntimeException("Loading FastRTPS using the builtin FastRTPS library, but the system FastRTPS library is already loaded.");
        }
        return instance;
    }

    public static synchronized Domain accessInstance() {
        return instance;
    }

    private FastRTPSDomain(boolean useSystemFastRTPS) {
        try {
            if (useSystemFastRTPS) {
                System.loadLibrary("FastRTPSWrapper");
            } else {
                NativeLibraryLoader.loadLibrary((NativeLibraryDescription)new FastRTPSNativeLibrary());
                FastRTPSJNI.LogLevel_setLogLevel(0);
            }
        }
        catch (UnsatisfiedLinkError e) {
            if (SystemUtils.IS_OS_WINDOWS) {
                throw new UnsatisfiedLinkError("Cannot load library, make sure to install Microsoft Visual C++ 2022 Redistributable (x64) (https://aka.ms/vs/17/release/vc_redist.x64.exe). " + e.getMessage());
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Participant createParticipant(ParticipantProfile att, ParticipantListener participantListener) throws IOException {
        FastRTPSParticipant participant = new FastRTPSParticipant(att, participantListener);
        this.participants.add(participant);
        ArrayList<Participant> arrayList = this.allParticipantsForStatistics;
        synchronized (arrayList) {
            this.allParticipantsForStatistics.add(participant);
        }
        return participant;
    }

    @Override
    public synchronized Publisher createPublisherImpl(Participant participant, PublisherAttributes att, PublisherListener listener) throws IOException, IllegalArgumentException {
        FastRTPSPublisher publisher = null;
        for (FastRTPSParticipant fastRTPSParticipant : this.participants) {
            if (fastRTPSParticipant != participant) continue;
            publisher = fastRTPSParticipant.createPublisher(att, listener);
            break;
        }
        if (publisher == null) {
            throw new IllegalArgumentException("Participant is not part of this domain.");
        }
        ThreadTools.sleep((long)1L);
        return publisher;
    }

    @Override
    public synchronized Subscriber createSubscriberImpl(Participant participant, SubscriberAttributes attrs, SubscriberListener listener) throws IOException, IllegalArgumentException {
        Subscriber subscriber = null;
        for (FastRTPSParticipant fastRTPSParticipant : this.participants) {
            if (fastRTPSParticipant != participant) continue;
            subscriber = fastRTPSParticipant.createSubscriber(attrs, listener);
            break;
        }
        if (subscriber == null) {
            throw new IllegalArgumentException("Participant is not part of this domain.");
        }
        ThreadTools.sleep((long)1L);
        return subscriber;
    }

    @Override
    public synchronized boolean removeParticipant(Participant participant) {
        for (int i = 0; i < this.participants.size(); ++i) {
            if (this.participants.get(i) != participant) continue;
            this.participants.get(i).delete();
            this.participants.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removePublisher(Publisher publisher) {
        for (int i = 0; i < this.participants.size(); ++i) {
            if (!this.participants.get(i).getGuid().getGuidPrefix().equals(publisher.getGuid().getGuidPrefix())) continue;
            return this.participants.get(i).removePublisher(publisher);
        }
        return false;
    }

    @Override
    public synchronized boolean removeSubscriber(Subscriber subscriber) {
        for (int i = 0; i < this.participants.size(); ++i) {
            if (!this.participants.get(i).getGuid().getGuidPrefix().equals(subscriber.getGuid().getGuidPrefix())) continue;
            return this.participants.get(i).removeSubscriber(subscriber);
        }
        return false;
    }

    @Override
    public synchronized TopicDataType<?> getRegisteredType(Participant participant, String typeName) {
        for (int i = 0; i < this.participants.size(); ++i) {
            if (this.participants.get(i) != participant) continue;
            return this.participants.get(i).getRegisteredType(typeName);
        }
        return null;
    }

    @Override
    public synchronized void registerType(Participant participant, TopicDataType<?> topicDataType) throws IllegalArgumentException {
        for (int i = 0; i < this.participants.size(); ++i) {
            if (this.participants.get(i) != participant) continue;
            this.participants.get(i).registerType(topicDataType);
            return;
        }
        throw new IllegalArgumentException("Participant is not part of this domain.");
    }

    @Override
    public synchronized void unregisterType(Participant participant, String typeName) throws IOException {
        for (int i = 0; i < this.participants.size(); ++i) {
            if (this.participants.get(i) != participant) continue;
            this.participants.get(i).unregisterType(typeName);
            return;
        }
        throw new IllegalArgumentException("Participant is not part of this domain.");
    }

    @Override
    public synchronized void stopAll() {
        for (int i = this.participants.size() - 1; i >= 0; --i) {
            this.removeParticipant(this.participants.get(i));
        }
    }

    @Override
    public void setLogLevel(LogLevel level) {
        us.ihmc.rtps.impl.fastRTPS.LogLevel.setLogLevel(level.getLevel());
    }

    public static String marshallProfile(Dds dds) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Dds.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.marshal((Object)dds, (Writer)writer);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            throw new IOException("Could not marshal XML", e);
        }
        return writer.toString();
    }

    @Override
    public List<Participant> getAllParticipantsForStatistics() {
        return this.allParticipantsForStatistics;
    }
}

