/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.attributes;

import com.eprosima.xmlschemas.fastrtps_profiles.DurabilityQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.DurabilityQosPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.HistoryQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.HistoryQosPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.LifespanQosPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.OwnershipQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.PartitionQosPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.TopicElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.DDSConversionTools;
import us.ihmc.pubsub.common.Time;

public abstract class CommonAttributes<T extends CommonAttributes<T>> {
    private TopicDataType<?> topicDataType;
    protected final TopicElementType topicElementType = new TopicElementType();
    protected final HistoryQosPolicyType historyQosPolicyType = new HistoryQosPolicyType();
    protected final DurabilityQosPolicyType durabilityQosPolicyType = new DurabilityQosPolicyType();
    protected final ReliabilityQosPolicyType reliabilityQosPolicyType = new ReliabilityQosPolicyType();

    public CommonAttributes() {
        this.historyDepth(10L);
        this.historyQosPolicyKind(HistoryQosKindPolicyType.KEEP_LAST);
        this.durabilityKind(DurabilityQosKindPolicyType.VOLATILE);
        this.reliabilityKind(ReliabilityQosKindPolicyType.RELIABLE);
        this.topicElementType.setHistoryQos(this.historyQosPolicyType);
    }

    private T self() {
        return (T)this;
    }

    public T topicDataType(TopicDataType<?> topicDataType) {
        this.topicDataType = topicDataType;
        this.topicElementType.setDataType(topicDataType.getName());
        return this.self();
    }

    public TopicDataType<?> getTopicDataType() {
        return this.topicDataType;
    }

    public T topicName(String name) {
        this.topicElementType.setName(name);
        return this.self();
    }

    public String getTopicName() {
        return this.topicElementType.getName();
    }

    public T historyDepth(long depth) {
        this.historyQosPolicyType.setDepth(Long.valueOf(depth));
        return this.self();
    }

    public long getHistoryDepth() {
        return this.historyQosPolicyType.getDepth();
    }

    public T historyQosPolicyKind(HistoryQosKindPolicyType kind) {
        this.historyQosPolicyType.setKind(kind);
        return this.self();
    }

    public HistoryQosKindPolicyType getHistoryQosPolicyKind() {
        return this.historyQosPolicyType.getKind();
    }

    public T durabilityKind(DurabilityQosKindPolicyType kind) {
        this.durabilityQosPolicyType.setKind(kind);
        return this.self();
    }

    public DurabilityQosKindPolicyType getDurabilityKind() {
        return this.durabilityQosPolicyType.getKind();
    }

    public T reliabilityKind(ReliabilityQosKindPolicyType kind) {
        this.reliabilityQosPolicyType.setKind(kind);
        return this.self();
    }

    public ReliabilityQosKindPolicyType getReliabilityKind() {
        return this.reliabilityQosPolicyType.getKind();
    }

    public T maxBlockingTime(Time time) {
        this.reliabilityQosPolicyType.setMaxBlockingTime(DDSConversionTools.timeToDurationType(time));
        return this.self();
    }

    public Time getMaxBlockingTime() {
        return DDSConversionTools.durationTypeToTime(this.reliabilityQosPolicyType.getMaxBlockingTime());
    }

    protected abstract void setPartitionQosPolicyType(PartitionQosPolicyType var1);

    protected abstract PartitionQosPolicyType getPartitionQosPolicyType();

    public T partitions(List<String> partitions) {
        if (partitions != null && !partitions.isEmpty()) {
            PartitionQosPolicyType partitionQosPolicyType = new PartitionQosPolicyType();
            PartitionQosPolicyType.Names names = new PartitionQosPolicyType.Names();
            names.getName().addAll(partitions);
            partitionQosPolicyType.setNames(names);
            this.setPartitionQosPolicyType(partitionQosPolicyType);
        }
        return this.self();
    }

    public List<String> getPartitions() {
        if (this.getPartitionQosPolicyType() == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.getPartitionQosPolicyType().getNames().getName());
    }

    public T ownershipPolicyKind(OwnershipQosKindPolicyType kind) {
        LogTools.warn((String)"OwnershipQosPolicy not supported");
        return this.self();
    }

    public OwnershipQosKindPolicyType getOwnerShipPolicyKind() {
        return null;
    }

    protected abstract void setLifespanQosPolicyType(LifespanQosPolicyType var1);

    protected abstract LifespanQosPolicyType getLifespanQosPolicyType();

    public T lifespan(Time lifespan) {
        LifespanQosPolicyType lifespanQosPolicyType = new LifespanQosPolicyType();
        lifespanQosPolicyType.setDuration(DDSConversionTools.timeToDurationType(lifespan));
        this.setLifespanQosPolicyType(lifespanQosPolicyType);
        return this.self();
    }

    public Time getLifespan() {
        if (this.getLifespanQosPolicyType() != null) {
            return DDSConversionTools.durationTypeToTime(this.getLifespanQosPolicyType().getDuration());
        }
        return null;
    }
}

