/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.attributes;

import com.eprosima.xmlschemas.fastrtps_profiles.BuiltinAttributesType;
import com.eprosima.xmlschemas.fastrtps_profiles.DiscoveryProtocolType;
import com.eprosima.xmlschemas.fastrtps_profiles.DiscoveryServersListType;
import com.eprosima.xmlschemas.fastrtps_profiles.DiscoverySettingsType;
import com.eprosima.xmlschemas.fastrtps_profiles.EDPType;
import com.eprosima.xmlschemas.fastrtps_profiles.LocatorListType;
import com.eprosima.xmlschemas.fastrtps_profiles.ParticipantProfileType;
import com.eprosima.xmlschemas.fastrtps_profiles.ProfilesType;
import com.eprosima.xmlschemas.fastrtps_profiles.RemoteServerAttributesType;
import com.eprosima.xmlschemas.fastrtps_profiles.TransportDescriptorListType;
import com.eprosima.xmlschemas.fastrtps_profiles.TransportDescriptorType;
import com.eprosima.xmlschemas.fastrtps_profiles.Udpv4LocatorType;
import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import us.ihmc.pubsub.attributes.DDSConversionTools;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSDomain;

public class ParticipantProfile {
    private final ParticipantProfileType profileType = new ParticipantProfileType();
    private final TransportDescriptorListType transportDescriptors = new TransportDescriptorListType();

    public ParticipantProfile() {
        BuiltinAttributesType builtin = new BuiltinAttributesType();
        DiscoverySettingsType discoverySettingsType = new DiscoverySettingsType();
        this.profileType.setRtps(new ParticipantProfileType.Rtps());
        this.profileType.getRtps().setBuiltin(builtin);
        builtin.setDiscoveryConfig(discoverySettingsType);
        this.discoveryLeaseDuration(Time.Infinite);
    }

    public static ParticipantProfile create() {
        return new ParticipantProfile();
    }

    public ParticipantProfileType getProfile() {
        return this.profileType;
    }

    public ParticipantProfile domainId(int id) {
        this.profileType.setDomainId(id);
        return this;
    }

    public int getDomainId() {
        return this.getProfile().getDomainId();
    }

    public ParticipantProfile name(String name) {
        this.profileType.getRtps().setName(name);
        return this;
    }

    public String getName() {
        return this.profileType.getRtps().getName();
    }

    public ParticipantProfile discoveryLeaseDuration(Time discoveryLeaseDuration) {
        this.profileType.getRtps().getBuiltin().getDiscoveryConfig().setLeaseDuration(DDSConversionTools.timeToDurationType(discoveryLeaseDuration));
        return this;
    }

    public ParticipantProfile discoveryServer(String discoveryServerAddress, int discoveryServerId) {
        return this.discoveryServer(discoveryServerAddress, discoveryServerId, 11811);
    }

    public ParticipantProfile discoveryServer(String discoveryServerAddress, int discoveryServerId, int discoveryServerPort) {
        if (discoveryServerId < 0 || discoveryServerId > 255) {
            throw new RuntimeException("Invalid discovery server ID");
        }
        if (discoveryServerPort < 0 || discoveryServerPort > 65535) {
            throw new RuntimeException("Invalid discovery server port");
        }
        DiscoverySettingsType discoverySettingsType = this.profileType.getRtps().getBuiltin().getDiscoveryConfig();
        discoverySettingsType.setDiscoveryProtocol(DiscoveryProtocolType.CLIENT);
        LocatorListType locatorListType = new LocatorListType();
        LocatorListType.Locator locatorType = new LocatorListType.Locator();
        Udpv4LocatorType udpv4LocatorType = new Udpv4LocatorType();
        udpv4LocatorType.setAddress(discoveryServerAddress);
        udpv4LocatorType.setPort(discoveryServerPort);
        locatorType.getUdpv4().add(udpv4LocatorType);
        locatorListType.getLocator().add(locatorType);
        RemoteServerAttributesType remoteServerAttributes = new RemoteServerAttributesType();
        remoteServerAttributes.getContent().add((JAXBElement<LocatorListType>)new JAXBElement(new QName("http://www.eprosima.com/XMLSchemas/fastRTPS_Profiles", "metatrafficUnicastLocatorList"), LocatorListType.class, (Object)locatorListType));
        remoteServerAttributes.setPrefix(String.format("44.53.%02X.5f.45.50.52.4f.53.49.4d.41", discoveryServerId));
        DiscoveryServersListType discoveryServerList = this.profileType.getRtps().getBuiltin().getDiscoveryConfig().getDiscoveryServersList();
        discoveryServerList.getRemoteServer().add(remoteServerAttributes);
        discoverySettingsType.setDiscoveryServersList(discoveryServerList);
        return this;
    }

    public ParticipantProfile bindToAddressRestrictions(boolean addSharedMemoryTransport, List<InetAddress> bindToAddressRestrictions) {
        this.useBuiltinTransports(false);
        if (addSharedMemoryTransport) {
            this.addSharedMemoryTransport();
        }
        if (bindToAddressRestrictions != null && !bindToAddressRestrictions.isEmpty()) {
            String transportName = UUID.randomUUID().toString();
            TransportDescriptorType transportDescriptor = new TransportDescriptorType();
            transportDescriptor.setTransportId(transportName);
            transportDescriptor.setType("UDPv4");
            TransportDescriptorType.InterfaceWhiteList addressWhitelist = new TransportDescriptorType.InterfaceWhiteList();
            for (InetAddress addr : bindToAddressRestrictions) {
                JAXBElement addressElement = new JAXBElement(new QName("http://www.eprosima.com/XMLSchemas/fastRTPS_Profiles", "address"), String.class, (Object)addr.getHostAddress());
                addressWhitelist.getAddressOrInterface().add(addressElement);
            }
            transportDescriptor.setInterfaceWhiteList(addressWhitelist);
            this.addTransport(transportDescriptor);
        }
        return this;
    }

    public ParticipantProfile addTransport(TransportDescriptorType transport) {
        this.transportDescriptors.getTransportDescriptor().add(transport);
        if (this.profileType.getRtps().getUserTransports() == null) {
            this.profileType.getRtps().setUserTransports(new ParticipantProfileType.Rtps.UserTransports());
        }
        this.profileType.getRtps().getUserTransports().getTransportId().add(transport.getTransportId());
        return this;
    }

    public ParticipantProfile addSharedMemoryTransport() {
        String transportName = UUID.randomUUID().toString();
        TransportDescriptorType transportDescriptor = new TransportDescriptorType();
        transportDescriptor.setTransportId(transportName);
        transportDescriptor.setType("SHM");
        this.addTransport(transportDescriptor);
        return this;
    }

    public ParticipantProfile useBuiltinTransports(boolean useBuiltinTransports) {
        this.profileType.getRtps().setUseBuiltinTransports(useBuiltinTransports);
        return this;
    }

    public boolean isUseBuiltinTransports() {
        return this.profileType.getRtps().isUseBuiltinTransports();
    }

    public ParticipantProfile useOnlySharedMemoryTransport() {
        this.useBuiltinTransports(false);
        this.addSharedMemoryTransport();
        return this;
    }

    public boolean isUseStaticDiscovery() {
        return this.profileType.getRtps().getBuiltin().getDiscoveryConfig().getEDP() == EDPType.STATIC;
    }

    public ParticipantProfile useStaticDiscovery(boolean useStaticDiscovery) {
        this.profileType.getRtps().getBuiltin().getDiscoveryConfig().setEDP(useStaticDiscovery ? EDPType.STATIC : EDPType.SIMPLE);
        return this;
    }

    public String marshall(String profileName) throws IOException {
        this.profileType.setProfileName(profileName);
        ProfilesType profilesType = new ProfilesType();
        profilesType.getDomainparticipantFactoryOrParticipantOrDataWriter().add(this.transportDescriptors);
        profilesType.getDomainparticipantFactoryOrParticipantOrDataWriter().add(this.profileType);
        String profileXML = FastRTPSDomain.marshalProfile(profilesType);
        return profileXML;
    }
}

