/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.impl.fastRTPS;

import com.eprosima.xmlschemas.fastrtps_profiles.TopicKindType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.Guid;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSParticipantDiscoveryInfo;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSPublisher;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSSubscriber;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.participant.PublisherEndpointDiscoveryListener;
import us.ihmc.pubsub.participant.SubscriberEndpointDiscoveryListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;
import us.ihmc.rtps.impl.fastRTPS.NativeParticipantImpl;
import us.ihmc.rtps.impl.fastRTPS.NativeParticipantListener;

class FastRTPSParticipant
implements Participant {
    private final NativeParticipantImpl impl;
    private final ArrayList<TopicDataType<?>> types = new ArrayList();
    private final ArrayList<FastRTPSPublisher> publishers = new ArrayList();
    private final ArrayList<FastRTPSSubscriber> subscribers = new ArrayList();
    private final ParticipantAttributes attributes;
    private final ParticipantListener participantListener;
    private final Guid guid = new Guid();
    private final NativeParticipantListenerImpl nativeListener = new NativeParticipantListenerImpl();
    private PublisherEndpointDiscoveryListener publisherDiscoveryListener = null;
    private SubscriberEndpointDiscoveryListener subscriberDiscoveryListener = null;

    FastRTPSParticipant(ParticipantAttributes attrs, ParticipantListener participantListener) throws IOException, IllegalArgumentException {
        String profileName = UUID.randomUUID().toString();
        String profileXML = attrs.marshall(profileName);
        this.participantListener = participantListener;
        this.impl = new NativeParticipantImpl(profileName, profileXML, profileXML.length(), this.nativeListener);
        this.attributes = attrs;
        this.getGuid(this.guid);
    }

    synchronized void delete() {
        int i;
        for (i = 0; i < this.publishers.size(); ++i) {
            this.publishers.get(i).delete();
        }
        for (i = 0; i < this.subscribers.size(); ++i) {
            this.subscribers.get(i).delete();
        }
        this.impl.delete();
        this.nativeListener.delete();
    }

    private void getGuid(Guid guid) {
        guid.fromPrimitives(this.impl.getGuidHigh(), this.impl.getGuidLow());
    }

    @Override
    public Guid getGuid() {
        return this.guid;
    }

    @Override
    public ParticipantAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public synchronized int get_no_publisher(String target_topic) {
        int count = 0;
        for (int i = 0; i < this.publishers.size(); ++i) {
            if (!this.publishers.get(i).getAttributes().getTopicName().equals(target_topic)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public synchronized int get_no_subscribers(String target_topic) {
        int count = 0;
        for (int i = 0; i < this.subscribers.size(); ++i) {
            if (!this.subscribers.get(i).getAttributes().getTopicName().equals(target_topic)) continue;
            ++count;
        }
        return count;
    }

    synchronized void registerType(TopicDataType<?> topicDataType) throws IllegalArgumentException {
        if (topicDataType.getTypeSize() <= 0) {
            throw new IllegalArgumentException("Registered type must have maximum byte size > 0");
        }
        if (topicDataType.getName().isEmpty()) {
            throw new IllegalArgumentException("Registered type must have a name");
        }
        for (int i = 0; i < this.types.size(); ++i) {
            if (!this.types.get(i).getName().equals(topicDataType.getName())) continue;
            throw new IllegalArgumentException("Type with the same name already exists: " + topicDataType.getName());
        }
        this.impl.registerType(topicDataType.getName(), topicDataType.getTypeSize(), topicDataType.isGetKeyDefined());
        this.types.add(topicDataType);
    }

    synchronized TopicDataType<?> getRegisteredType(String name) {
        for (int i = 0; i < this.types.size(); ++i) {
            if (!this.types.get(i).getName().equals(name)) continue;
            return this.types.get(i);
        }
        return null;
    }

    synchronized FastRTPSPublisher createPublisher(PublisherAttributes attrs, PublisherListener listener) throws IOException, IllegalArgumentException {
        TopicDataType<?> topicDataType = this.getRegisteredType(attrs.getTopicDataType().getName());
        if (topicDataType == null) {
            throw new IllegalArgumentException("Type: " + attrs.getTopicDataType() + " is not registered");
        }
        if (attrs.getTopicKind() == TopicKindType.WITH_KEY && !topicDataType.isGetKeyDefined()) {
            throw new IllegalArgumentException("Keyed topic needs getKey function");
        }
        if (this.attributes.isUseStaticDiscovery() && attrs.getUserDefinedId() <= 0) {
            throw new IllegalArgumentException("Static EDP requires user defined EDP");
        }
        FastRTPSPublisher publisher = new FastRTPSPublisher(topicDataType, attrs, listener, this.impl);
        this.publishers.add(publisher);
        return publisher;
    }

    synchronized Subscriber createSubscriber(SubscriberAttributes attrs, SubscriberListener listener) throws IOException {
        TopicDataType<?> topicDataType = this.getRegisteredType(attrs.getTopicDataType().getName());
        if (topicDataType == null) {
            throw new IllegalArgumentException("Type: " + attrs.getTopicDataType() + " is not registered");
        }
        if (attrs.getTopicKind() == TopicKindType.WITH_KEY && !topicDataType.isGetKeyDefined()) {
            throw new IllegalArgumentException("Keyed topic needs getKey function");
        }
        if (this.attributes.isUseStaticDiscovery() && attrs.getUserDefinedId() <= 0) {
            throw new IllegalArgumentException("Static EDP requires user defined EDP");
        }
        FastRTPSSubscriber subscriber = new FastRTPSSubscriber(topicDataType, attrs, listener, this.impl);
        this.subscribers.add(subscriber);
        return subscriber;
    }

    synchronized boolean removePublisher(Publisher publisher) {
        for (int i = 0; i < this.publishers.size(); ++i) {
            if (this.publishers.get(i) != publisher) continue;
            this.publishers.get(i).delete();
            this.publishers.remove(i);
            return true;
        }
        return false;
    }

    synchronized boolean removeSubscriber(Subscriber subscriber) {
        for (int i = 0; i < this.subscribers.size(); ++i) {
            if (this.subscribers.get(i) != subscriber) continue;
            this.subscribers.get(i).delete();
            this.subscribers.remove(i);
            return true;
        }
        return false;
    }

    synchronized void unregisterType(String typeName) throws IOException {
        int i;
        TopicDataType<?> type = null;
        for (i = 0; i < this.types.size(); ++i) {
            if (!this.types.get(i).getName().equals(typeName)) continue;
            type = this.types.get(i);
        }
        if (type == null) {
            throw new IllegalArgumentException(typeName + " is not registered with participant");
        }
        for (i = 0; i < this.publishers.size(); ++i) {
            if (!this.publishers.get(i).getTopicDataType().equals(type)) continue;
            throw new IOException("TopicDataType in use by publisher " + this.publishers.get(i).getAttributes().getTopicName());
        }
        for (i = 0; i < this.subscribers.size(); ++i) {
            if (!this.subscribers.get(i).getTopicDataType().equals(type)) continue;
            throw new IOException("TopicDataType in use by subscriber " + this.subscribers.get(i).getAttributes().getTopicName());
        }
        this.publishers.remove(type);
    }

    @Override
    public void registerEndpointDiscoveryListeners(PublisherEndpointDiscoveryListener publisherEndpointDiscoveryListener, SubscriberEndpointDiscoveryListener subscriberEndpointDiscoveryListener) throws IOException {
        this.publisherDiscoveryListener = publisherEndpointDiscoveryListener;
        this.subscriberDiscoveryListener = subscriberEndpointDiscoveryListener;
    }

    @Override
    public synchronized boolean isAvailable() {
        return this.impl != null;
    }

    private class NativeParticipantListenerImpl
    extends NativeParticipantListener {
        private final FastRTPSParticipantDiscoveryInfo discoveryInfo = new FastRTPSParticipantDiscoveryInfo();

        private NativeParticipantListenerImpl() {
        }

        @Override
        public void onParticipantDiscovery(long infoPtr, long guidHigh, long guidLow, int discoveryStatus) {
            try {
                if (FastRTPSParticipant.this.participantListener != null) {
                    System.out.println("infoPtr = " + infoPtr + ", guidHigh = " + guidHigh + ", guidLow = " + guidLow + ", status = " + discoveryStatus);
                    this.discoveryInfo.updateInfo(discoveryStatus, this, infoPtr, guidHigh, guidLow);
                    FastRTPSParticipant.this.participantListener.onParticipantDiscovery(FastRTPSParticipant.this, this.discoveryInfo);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

