/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.impl.fastRTPS;

import com.eprosima.xmlschemas.fastrtps_profiles.TopicKindType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.common.Guid;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.rtps.impl.fastRTPS.NativeParticipantImpl;
import us.ihmc.rtps.impl.fastRTPS.NativePublisherImpl;
import us.ihmc.rtps.impl.fastRTPS.NativePublisherListener;

class FastRTPSPublisher
implements Publisher {
    private final Object destructorLock = new Object();
    private NativePublisherImpl impl;
    private final PublisherAttributes attributes;
    private final TopicDataType<Object> topicDataType;
    private final PublisherListener listener;
    private final SerializedPayload payload;
    private final Guid guid = new Guid();
    private final ByteBuffer keyBuffer = ByteBuffer.allocateDirect(16);
    private final NativePublisherListenerImpl nativeListenerImpl = new NativePublisherListenerImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FastRTPSPublisher(TopicDataType<?> topicDataTypeIn, PublisherAttributes attributes, PublisherListener listener, NativeParticipantImpl participant) throws IOException, IllegalArgumentException {
        Object object = this.destructorLock;
        synchronized (object) {
            this.attributes = attributes;
            this.topicDataType = topicDataTypeIn.newInstance();
            this.listener = listener;
            this.payload = new SerializedPayload(this.topicDataType.getTypeSize());
            String profileName = UUID.randomUUID().toString();
            String profileXML = attributes.marshall(profileName);
            this.impl = new NativePublisherImpl(participant, this.nativeListenerImpl);
            if (!this.impl.createPublisher(profileName, profileXML, profileXML.length())) {
                throw new IOException("Cannot create publisher");
            }
            this.guid.fromPrimitives(this.impl.getGuidHigh(), this.impl.getGuidLow());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object data) throws IOException {
        Object object = this.destructorLock;
        synchronized (object) {
            if (this.impl == null) {
                throw new IOException("This publisher has been removed from the domain");
            }
            this.serializeMessage(data);
            this.impl.write(this.payload.getData(), this.payload.getLength(), this.payload.getEncapsulation(), this.keyBuffer, this.keyBuffer.position());
        }
    }

    private void serializeMessage(Object data) throws IOException {
        if (this.attributes.getTopicKind() == TopicKindType.WITH_KEY) {
            this.keyBuffer.clear();
            this.topicDataType.getKey(data, this.keyBuffer);
        }
        this.payload.getData().clear();
        this.topicDataType.serialize(data, this.payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(Object data) throws IOException {
        Object object = this.destructorLock;
        synchronized (object) {
            if (this.impl == null) {
                throw new IOException("This publisher has been removed from the domain");
            }
            this.serializeMessage(data);
            this.impl.dispose(this.payload.getData(), this.payload.getLength(), this.payload.getEncapsulation(), this.keyBuffer, this.keyBuffer.position());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(Object data) throws IOException {
        Object object = this.destructorLock;
        synchronized (object) {
            if (this.impl == null) {
                throw new IOException("This publisher has been removed from the domain");
            }
            this.serializeMessage(data);
            this.impl.unregister(this.payload.getData(), this.payload.getLength(), this.payload.getEncapsulation(), this.keyBuffer, this.keyBuffer.position());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose_and_unregister(Object data) throws IOException {
        Object object = this.destructorLock;
        synchronized (object) {
            if (this.impl == null) {
                throw new IOException("This publisher has been removed from the domain");
            }
            this.serializeMessage(data);
            this.impl.dispose_and_unregister(this.payload.getData(), this.payload.getLength(), this.payload.getEncapsulation(), this.keyBuffer, this.keyBuffer.position());
        }
    }

    @Override
    public Guid getGuid() {
        return this.guid;
    }

    @Override
    public PublisherAttributes getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() {
        Object object = this.destructorLock;
        synchronized (object) {
            this.impl.delete();
            this.nativeListenerImpl.delete();
            this.impl = null;
        }
    }

    public void finalize() {
        this.delete();
    }

    @Override
    public int removeAllChange() throws IOException {
        Object object = this.destructorLock;
        synchronized (object) {
            if (this.impl == null) {
                throw new IOException("This publisher has been removed from the domain");
            }
            int removed = this.impl.removeAllChange();
            if (removed >= 0) {
                return removed;
            }
            throw new IOException("Cannot remove all changes");
        }
    }

    public TopicDataType<?> getTopicDataType() {
        return this.topicDataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable() {
        Object object = this.destructorLock;
        synchronized (object) {
            return this.impl != null;
        }
    }

    private class NativePublisherListenerImpl
    extends NativePublisherListener {
        private final MatchingInfo matchingInfo = new MatchingInfo();

        private NativePublisherListenerImpl() {
        }

        @Override
        public void onWriterMatched(int matchingStatus, long guidHigh, long guidLow) {
            try {
                if (FastRTPSPublisher.this.listener != null) {
                    this.matchingInfo.getGuid().fromPrimitives(guidHigh, guidLow);
                    this.matchingInfo.setStatus(MatchingInfo.MatchingStatus.values[matchingStatus]);
                    FastRTPSPublisher.this.listener.onPublicationMatched(FastRTPSPublisher.this, this.matchingInfo);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

