/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rtps.impl.fastRTPS;

import java.net.Inet4Address;
import java.net.InetAddress;
import us.ihmc.pubsub.attributes.Locator;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.common.Time;
import us.ihmc.rtps.impl.fastRTPS.BuiltinAttributes;
import us.ihmc.rtps.impl.fastRTPS.DiscoverySettings;
import us.ihmc.rtps.impl.fastRTPS.FastRTPSCommonFunctions;
import us.ihmc.rtps.impl.fastRTPS.Locator_t;
import us.ihmc.rtps.impl.fastRTPS.RTPSParticipantAttributes;
import us.ihmc.rtps.impl.fastRTPS.Time_t;

public class FastRTPSParticipantAttributes
extends ParticipantAttributes {
    private final RTPSParticipantAttributes rtps = new RTPSParticipantAttributes();
    private final BuiltinAttributes builtin = this.rtps.getBuiltin();
    private final DiscoverySettings discoveryConfig = this.builtin.getDiscovery_config();
    private final Time_t time = new Time_t();

    FastRTPSParticipantAttributes() {
    }

    public RTPSParticipantAttributes rtps() {
        return this.rtps;
    }

    @Override
    public void setName(String name) {
        this.rtps().setName(name);
    }

    @Override
    public void setDomainId(int domain) {
        this.builtin.setDomainId(domain);
    }

    @Override
    public void setLeaseDuration(Time time) {
        this.time.setSeconds(time.getSeconds());
        this.time.setNanosec(time.getNanoseconds());
        this.discoveryConfig.setLeaseDuration(this.time);
    }

    @Override
    public void bindToAddress(InetAddress ... addresses) {
        for (InetAddress address : addresses) {
            Locator locator = new Locator();
            Locator_t locatorN = new Locator_t();
            if (!(address instanceof Inet4Address)) {
                throw new RuntimeException("Only IPv4 addresses are tested and supported");
            }
            locator.setKind(Locator.Kind.LOCATOR_KIND_UDPv4);
            locator.setIPv4Adress(address);
            FastRTPSCommonFunctions.convertToCPPLocator(locator, locatorN);
            this.rtps.getDefaultUnicastLocatorList().push_back(locatorN);
        }
    }

    public void delete() {
        this.rtps().delete();
        this.time.delete();
    }

    public void finalize() {
        this.delete();
    }
}

