/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rtps.impl.fastRTPS;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.pubsub.attributes.DurabilityKind;
import us.ihmc.pubsub.attributes.Locator;
import us.ihmc.pubsub.attributes.OwnerShipPolicyKind;
import us.ihmc.pubsub.attributes.PublishModeKind;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.pubsub.attributes.TopicAttributes;
import us.ihmc.rtps.impl.fastRTPS.DurabilityQosPolicyKind_t;
import us.ihmc.rtps.impl.fastRTPS.FastRTPS;
import us.ihmc.rtps.impl.fastRTPS.LocatorList_t;
import us.ihmc.rtps.impl.fastRTPS.Locator_t;
import us.ihmc.rtps.impl.fastRTPS.OwnershipQosPolicyKind;
import us.ihmc.rtps.impl.fastRTPS.PublishModeQosPolicyKind_t;
import us.ihmc.rtps.impl.fastRTPS.ReliabilityKind_t;
import us.ihmc.rtps.impl.fastRTPS.ReliabilityQosPolicyKind;
import us.ihmc.rtps.impl.fastRTPS.TopicKind_t;

class FastRTPSCommonFunctions {
    public static final int LOCATOR_KIND_RESERVED = 0;
    public static final int LOCATOR_KIND_UDPv4 = 1;
    public static final int LOCATOR_KIND_UDPv6 = 2;

    FastRTPSCommonFunctions() {
    }

    public static LocatorList_t convertToCPPLocatorList(List<Locator> in, LocatorList_t out) {
        out.clear();
        for (int i = 0; i < in.size(); ++i) {
            Locator_t cLocator = new Locator_t();
            FastRTPSCommonFunctions.convertToCPPLocator(in.get(i), cLocator);
            out.push_back(cLocator);
            cLocator.delete();
        }
        return out;
    }

    public static void convertToJavaLocatorList(LocatorList_t in, ArrayList<Locator> out) {
        int i = 0;
        while ((long)i < in.size()) {
            Locator javaLocator = new Locator();
            FastRTPSCommonFunctions.convertToJavaLocator(FastRTPS.getLocator(in, i), javaLocator);
            out.add(javaLocator);
            ++i;
        }
    }

    public static void convertToJavaLocator(Locator_t in, Locator out) {
        switch (in.getKind()) {
            case 1: {
                out.setKind(Locator.Kind.LOCATOR_KIND_UDPv4);
                break;
            }
            case 2: {
                out.setKind(Locator.Kind.LOCATOR_KIND_UDPv6);
                break;
            }
            default: {
                out.setKind(Locator.Kind.LOCATOR_KIND_RESERVED);
                return;
            }
        }
        for (int i = 0; i < 16; ++i) {
            out.setOctet(i, (byte)FastRTPS.getLocatorOctet(i, in));
        }
        out.setPort((int)in.getPort());
    }

    public static void convertToCPPLocator(Locator in, Locator_t out) {
        switch (in.getKind()) {
            case LOCATOR_KIND_UDPv4: {
                out.setKind(1);
                break;
            }
            case LOCATOR_KIND_UDPv6: {
                out.setKind(2);
                break;
            }
            default: {
                out.setKind(0);
                return;
            }
        }
        for (int i = 0; i < 16; ++i) {
            FastRTPS.setLocatorOctet(out, i, in.getOctet(i));
        }
        out.setPort(in.getPort());
    }

    public static TopicAttributes.TopicKind toJavaTopicKind(TopicKind_t topicKind) {
        if (topicKind == TopicKind_t.WITH_KEY) {
            return TopicAttributes.TopicKind.WITH_KEY;
        }
        return TopicAttributes.TopicKind.NO_KEY;
    }

    public static TopicKind_t toCPPTopicKind_t(TopicAttributes.TopicKind topicKind) {
        if (topicKind == TopicAttributes.TopicKind.WITH_KEY) {
            return TopicKind_t.WITH_KEY;
        }
        return TopicKind_t.NO_KEY;
    }

    public static ReliabilityQosPolicyKind toCppReliabilityQosPolicyKind(ReliabilityKind reliabilityKind) {
        switch (reliabilityKind) {
            case BEST_EFFORT: {
                return ReliabilityQosPolicyKind.BEST_EFFORT_RELIABILITY_QOS;
            }
            case RELIABLE: {
                return ReliabilityQosPolicyKind.RELIABLE_RELIABILITY_QOS;
            }
        }
        return null;
    }

    public static ReliabilityKind toJavaReliabilityKind(ReliabilityQosPolicyKind reliabilityKind_t) {
        if (reliabilityKind_t == ReliabilityQosPolicyKind.BEST_EFFORT_RELIABILITY_QOS) {
            return ReliabilityKind.BEST_EFFORT;
        }
        return ReliabilityKind.RELIABLE;
    }

    public static ReliabilityKind_t toCppReliabilityKind(ReliabilityKind reliabilityKind) {
        switch (reliabilityKind) {
            case BEST_EFFORT: {
                return ReliabilityKind_t.BEST_EFFORT;
            }
            case RELIABLE: {
                return ReliabilityKind_t.RELIABLE;
            }
        }
        return null;
    }

    public static ReliabilityKind toJavaReliabilityKind(ReliabilityKind_t reliabilityKind_t) {
        if (reliabilityKind_t == ReliabilityKind_t.BEST_EFFORT) {
            return ReliabilityKind.BEST_EFFORT;
        }
        return ReliabilityKind.RELIABLE;
    }

    public static DurabilityKind toJavaDurabilityKind(DurabilityQosPolicyKind_t kind) {
        if (kind == DurabilityQosPolicyKind_t.PERSISTENT_DURABILITY_QOS) {
            return DurabilityKind.PERSISTENT_DURABILITY_QOS;
        }
        if (kind == DurabilityQosPolicyKind_t.TRANSIENT_DURABILITY_QOS) {
            return DurabilityKind.TRANSIENT_DURABILITY_QOS;
        }
        if (kind == DurabilityQosPolicyKind_t.TRANSIENT_LOCAL_DURABILITY_QOS) {
            return DurabilityKind.TRANSIENT_LOCAL_DURABILITY_QOS;
        }
        if (kind == DurabilityQosPolicyKind_t.VOLATILE_DURABILITY_QOS) {
            return DurabilityKind.VOLATILE_DURABILITY_QOS;
        }
        return null;
    }

    public static DurabilityQosPolicyKind_t toCppDurabilityKind(DurabilityKind kind) {
        if (kind == DurabilityKind.PERSISTENT_DURABILITY_QOS) {
            return DurabilityQosPolicyKind_t.PERSISTENT_DURABILITY_QOS;
        }
        if (kind == DurabilityKind.TRANSIENT_DURABILITY_QOS) {
            return DurabilityQosPolicyKind_t.TRANSIENT_DURABILITY_QOS;
        }
        if (kind == DurabilityKind.TRANSIENT_LOCAL_DURABILITY_QOS) {
            return DurabilityQosPolicyKind_t.TRANSIENT_LOCAL_DURABILITY_QOS;
        }
        if (kind == DurabilityKind.VOLATILE_DURABILITY_QOS) {
            return DurabilityQosPolicyKind_t.VOLATILE_DURABILITY_QOS;
        }
        return null;
    }

    public static OwnerShipPolicyKind toJavaOwnershipQosPolicyKind(OwnershipQosPolicyKind kind) {
        if (kind == OwnershipQosPolicyKind.EXCLUSIVE_OWNERSHIP_QOS) {
            return OwnerShipPolicyKind.EXCLUSIVE_OWNERSHIP_QOS;
        }
        return OwnerShipPolicyKind.SHARED_OWNERSHIP_QOS;
    }

    public static OwnershipQosPolicyKind toCppOwnershipQosPolicyKind(OwnerShipPolicyKind kind) {
        if (kind == OwnerShipPolicyKind.EXCLUSIVE_OWNERSHIP_QOS) {
            return OwnershipQosPolicyKind.EXCLUSIVE_OWNERSHIP_QOS;
        }
        return OwnershipQosPolicyKind.SHARED_OWNERSHIP_QOS;
    }

    public static PublishModeQosPolicyKind_t toCppPublishModeKind(PublishModeKind kind) {
        if (kind == PublishModeKind.ASYNCHRONOUS_PUBLISH_MODE) {
            return PublishModeQosPolicyKind_t.ASYNCHRONOUS_PUBLISH_MODE;
        }
        return PublishModeQosPolicyKind_t.SYNCHRONOUS_PUBLISH_MODE;
    }

    public static PublishModeKind toJavaPublishModeKind(PublishModeQosPolicyKind_t kind) {
        if (kind == PublishModeQosPolicyKind_t.ASYNCHRONOUS_PUBLISH_MODE) {
            return PublishModeKind.ASYNCHRONOUS_PUBLISH_MODE;
        }
        return PublishModeKind.SYNCHRONOUS_PUBLISH_MODE;
    }
}

