/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.impl.intraprocess;

import us.ihmc.pubsub.attributes.DurabilityKind;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessPublisherAttributes;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessReaderQosHolder;

class IntraProcessSubscriberAttributes
extends SubscriberAttributes {
    private final IntraProcessReaderQosHolder qos = new IntraProcessReaderQosHolder();

    IntraProcessSubscriberAttributes() {
    }

    @Override
    public IntraProcessReaderQosHolder getQos() {
        return this.qos;
    }

    @Override
    public <T> T getTimes() {
        return null;
    }

    boolean publisherMatches(IntraProcessPublisherAttributes publisher) {
        if (!this.getTopic().getTopicName().equals(publisher.getTopic().getTopicName())) {
            return false;
        }
        if (!this.getTopic().getTopicDataType().equals(publisher.getTopic().getTopicDataType())) {
            return false;
        }
        if (this.getQos().getOwnershipPolicyKind() != publisher.getQos().getOwnershipPolicyKind()) {
            return false;
        }
        if (publisher.getQos().getReliabilityKind() == ReliabilityKind.BEST_EFFORT && this.getQos().getReliabilityKind() == ReliabilityKind.RELIABLE) {
            return false;
        }
        if (publisher.getQos().getDurabilityKind() == DurabilityKind.TRANSIENT_LOCAL_DURABILITY_QOS && this.getQos().getDurabilityKind() == DurabilityKind.VOLATILE_DURABILITY_QOS) {
            return false;
        }
        if (this.getQos().getPartitions().isEmpty() && publisher.getQos().getPartitions().isEmpty()) {
            return true;
        }
        for (String partition : this.getQos().getPartitions()) {
            for (String subPartition : publisher.getQos().getPartitions()) {
                if (!partition.equals(subPartition)) continue;
                return true;
            }
        }
        return false;
    }
}

