/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.common;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class Guid {
    private final GuidPrefix guidPrefix = new GuidPrefix();
    private final Entity entity = new Entity();
    private final ByteBuffer conversionBuffer = ByteBuffer.allocate(16);

    public Guid() {
        this.conversionBuffer.order(ByteOrder.nativeOrder());
    }

    public GuidPrefix getGuidPrefix() {
        return this.guidPrefix;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void fromPrimitives(long high, long low) {
        this.conversionBuffer.clear();
        this.conversionBuffer.putLong(high);
        this.conversionBuffer.putLong(low);
        this.conversionBuffer.flip();
        this.conversionBuffer.get(this.guidPrefix.value, 0, 12);
        this.conversionBuffer.get(this.entity.value, 0, 4);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GUID Prefix: ");
        sb.append(this.guidPrefix.toString());
        sb.append(" Entity ID: ");
        sb.append(this.entity.toString());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.entity.hashCode();
        result = 31 * result + this.guidPrefix.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Guid other = (Guid)obj;
        if (!this.entity.equals(other.entity)) {
            return false;
        }
        return this.guidPrefix.equals(other.guidPrefix);
    }

    public void set(Guid guid) {
        System.arraycopy(guid.guidPrefix.value, 0, this.guidPrefix.value, 0, this.guidPrefix.value.length);
        System.arraycopy(guid.entity.value, 0, this.entity.value, 0, this.entity.value.length);
    }

    public class Entity {
        public static final int size = 4;
        private byte[] value = new byte[4];

        public byte[] getValue() {
            return this.value;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        private Entity() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(8);
            for (byte b : this.value) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entity other = (Entity)obj;
            return Arrays.equals(this.value, other.value);
        }
    }

    public class GuidPrefix {
        public static final int size = 12;
        private byte[] value = new byte[12];

        public byte[] getValue() {
            return this.value;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        private GuidPrefix() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(24);
            for (byte b : this.value) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GuidPrefix other = (GuidPrefix)obj;
            return Arrays.equals(this.value, other.value);
        }
    }
}

