/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.idl.serializers.extra;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang3.NotImplementedException;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.idl.serializers.extra.UnsupportedFeatureException;
import us.ihmc.pubsub.TopicDataType;

class JacksonInterchangeSerializer
implements InterchangeSerializer {
    private final boolean supportsArrays;
    private final ObjectNode node;

    JacksonInterchangeSerializer(ObjectNode node, boolean supportsArrays) {
        this.node = node;
        this.supportsArrays = supportsArrays;
    }

    public short read_type_1(String name) {
        return (short)this.node.path(name).asInt();
    }

    public void write_type_1(String name, short val) {
        this.node.put(name, val);
    }

    public int read_type_2(String name) {
        return this.node.path(name).asInt();
    }

    public void write_type_2(String name, int val) {
        this.node.put(name, val);
    }

    public float read_type_5(String name) {
        return (float)this.node.path(name).asDouble();
    }

    public void write_type_5(String name, float val) {
        this.node.put(name, val);
    }

    public double read_type_6(String name) {
        return this.node.path(name).asDouble();
    }

    public void write_type_6(String name, double val) {
        this.node.put(name, val);
    }

    public boolean read_type_7(String name) {
        return this.node.path(name).asBoolean();
    }

    public void write_type_7(String name, boolean val) {
        this.node.put(name, val);
    }

    public char read_type_8(String name) {
        String text = this.node.path(name).asText();
        return this.str2char(text);
    }

    private final char str2char(String text) {
        if (text != null && text.length() > 0) {
            return text.charAt(0);
        }
        return '\u0000';
    }

    public void write_type_8(String name, char val) {
        this.node.put(name, String.valueOf(val));
    }

    public byte read_type_9(String name) {
        return (byte)this.node.path(name).asInt();
    }

    public void write_type_9(String name, byte val) {
        this.node.put(name, (int)val);
    }

    public <T> void read_type_a(String name, TopicDataType<T> type, T data) {
        type.deserialize((InterchangeSerializer)new JacksonInterchangeSerializer(this.node.with(name), this.supportsArrays), data);
    }

    public <T> void write_type_a(String name, TopicDataType<T> type, T data) {
        type.serialize(data, (InterchangeSerializer)new JacksonInterchangeSerializer(this.node.putObject(name), this.supportsArrays));
    }

    public Enum<?> read_type_c(String name, Class<? extends Enum<?>> enumType) {
        String val = this.node.path(name).asText();
        return JacksonInterchangeSerializer.str2enum(enumType.getEnumConstants(), val);
    }

    private static Enum<?> str2enum(Enum<?>[] enumConstants, String val) {
        for (Enum<?> enumVal : enumConstants) {
            if (!enumVal.name().equals(val)) continue;
            return enumVal;
        }
        return null;
    }

    public void write_type_c(String name, Enum<?> val) {
        if (val == null) {
            this.node.putNull(name);
        } else {
            this.node.put(name, val.name());
        }
    }

    public void read_type_d(String name, StringBuilder res) {
        res.setLength(0);
        res.append(this.node.path(name).asText());
    }

    public void write_type_d(String name, StringBuilder str) {
        this.node.put(name, str.toString());
    }

    private void checkArraySupport() {
        if (!this.supportsArrays) {
            throw new UnsupportedFeatureException("This serializer does not support arrays and sequences");
        }
    }

    public void read_type_e(String name, IDLSequence seq) {
        this.checkArraySupport();
        seq.resetQuick();
        JsonNode child = this.node.path(name);
        if (child.isArray()) {
            for (JsonNode val : child) {
                if (seq instanceof IDLSequence.Boolean) {
                    ((IDLSequence.Boolean)seq).add(val.asBoolean());
                    continue;
                }
                if (seq instanceof IDLSequence.Byte) {
                    ((IDLSequence.Byte)seq).add((byte)val.asInt());
                    continue;
                }
                if (seq instanceof IDLSequence.Char) {
                    ((IDLSequence.Char)seq).add(this.str2char(val.asText()));
                    continue;
                }
                if (seq instanceof IDLSequence.Short) {
                    ((IDLSequence.Short)seq).add((short)val.asInt());
                    continue;
                }
                if (seq instanceof IDLSequence.Integer) {
                    ((IDLSequence.Integer)seq).add(val.asInt());
                    continue;
                }
                if (seq instanceof IDLSequence.Long) {
                    ((IDLSequence.Long)seq).add(val.asLong());
                    continue;
                }
                if (seq instanceof IDLSequence.Float) {
                    ((IDLSequence.Float)seq).add((float)val.asDouble());
                    continue;
                }
                if (seq instanceof IDLSequence.Double) {
                    ((IDLSequence.Double)seq).add(val.asDouble());
                    continue;
                }
                if (seq instanceof IDLSequence.StringBuilderHolder) {
                    ((IDLSequence.StringBuilderHolder)seq).add(val.asText());
                    continue;
                }
                if (seq instanceof IDLSequence.Enum) {
                    ((IDLSequence.Enum)seq).add(JacksonInterchangeSerializer.str2enum(((IDLSequence.Enum)seq).getEnumConstants(), val.asText()));
                    continue;
                }
                if (seq instanceof IDLSequence.Object) {
                    TopicDataType type = ((IDLSequence.Object)seq).getTopicDataType();
                    Object childStruct = ((IDLSequence.Object)seq).add();
                    if (!val.isObject()) continue;
                    type.deserialize((InterchangeSerializer)new JacksonInterchangeSerializer((ObjectNode)val, this.supportsArrays), childStruct);
                    continue;
                }
                throw new RuntimeException("Unknown sequence object");
            }
        } else {
            return;
        }
    }

    public void write_type_e(String name, IDLSequence seq) {
        this.checkArraySupport();
        ArrayNode child = this.node.putArray(name);
        for (int i = 0; i < seq.size(); ++i) {
            if (seq instanceof IDLSequence.Boolean) {
                child.add(((IDLSequence.Boolean)seq).getBoolean(i));
                continue;
            }
            if (seq instanceof IDLSequence.Byte) {
                child.add((short)((IDLSequence.Byte)seq).get(i));
                continue;
            }
            if (seq instanceof IDLSequence.Char) {
                child.add(String.valueOf(((IDLSequence.Char)seq).get(i)));
                continue;
            }
            if (seq instanceof IDLSequence.Short) {
                child.add(((IDLSequence.Short)seq).get(i));
                continue;
            }
            if (seq instanceof IDLSequence.Integer) {
                child.add(((IDLSequence.Integer)seq).get(i));
                continue;
            }
            if (seq instanceof IDLSequence.Long) {
                child.add(((IDLSequence.Long)seq).get(i));
                continue;
            }
            if (seq instanceof IDLSequence.Float) {
                child.add(((IDLSequence.Float)seq).get(i));
                continue;
            }
            if (seq instanceof IDLSequence.Double) {
                child.add(((IDLSequence.Double)seq).get(i));
                continue;
            }
            if (seq instanceof IDLSequence.StringBuilderHolder) {
                child.add(((StringBuilder)((IDLSequence.StringBuilderHolder)seq).get(i)).toString());
                continue;
            }
            if (seq instanceof IDLSequence.Enum) {
                child.add(((IDLSequence.Enum)seq).get(i).name());
                continue;
            }
            if (seq instanceof IDLSequence.Object) {
                TopicDataType type = ((IDLSequence.Object)seq).getTopicDataType();
                Object childStruct = ((IDLSequence.Object)seq).get(i);
                type.serialize(childStruct, (InterchangeSerializer)new JacksonInterchangeSerializer(child.addObject(), this.supportsArrays));
                continue;
            }
            throw new RuntimeException("Unknown sequence object");
        }
    }

    public void read_type_f(String name, boolean[] arr) {
        this.checkArraySupport();
        JsonNode child = this.node.path(name);
        this.read_array(arr, child);
    }

    private void read_array(boolean[] arr, JsonNode child) {
        for (int i = 0; i < arr.length; ++i) {
            JsonNode element = child.get(i);
            arr[i] = element != null ? element.asBoolean() : false;
        }
    }

    public void read_type_f(String name, byte[] arr) {
        this.checkArraySupport();
        JsonNode child = this.node.path(name);
        this.read_array(arr, child);
    }

    private void read_array(byte[] arr, JsonNode child) {
        for (int i = 0; i < arr.length; ++i) {
            JsonNode element = child.get(i);
            arr[i] = element != null ? (byte)element.asInt() : (byte)0;
        }
    }

    public void read_type_f(String name, char[] arr) {
        this.checkArraySupport();
        JsonNode child = this.node.path(name);
        this.read_array(arr, child);
    }

    private void read_array(char[] arr, JsonNode child) {
        for (int i = 0; i < arr.length; ++i) {
            JsonNode element = child.get(i);
            arr[i] = element != null ? this.str2char(element.asText()) : (char)'\u0000';
        }
    }

    public void read_type_f(String name, short[] arr) {
        this.checkArraySupport();
        JsonNode child = this.node.path(name);
        this.read_array(arr, child);
    }

    private void read_array(short[] arr, JsonNode child) {
        for (int i = 0; i < arr.length; ++i) {
            JsonNode element = child.get(i);
            arr[i] = element != null ? (short)element.asInt() : (short)0;
        }
    }

    public void read_type_f(String name, int[] arr) {
        this.checkArraySupport();
        JsonNode child = this.node.path(name);
        this.read_array(arr, child);
    }

    private void read_array(int[] arr, JsonNode child) {
        for (int i = 0; i < arr.length; ++i) {
            JsonNode element = child.get(i);
            arr[i] = element != null ? element.asInt() : 0;
        }
    }

    public void read_type_f(String name, long[] arr) {
        this.checkArraySupport();
        JsonNode child = this.node.path(name);
        this.read_array(arr, child);
    }

    private void read_array(long[] arr, JsonNode child) {
        for (int i = 0; i < arr.length; ++i) {
            JsonNode element = child.get(i);
            arr[i] = element != null ? element.asLong() : 0L;
        }
    }

    public void read_type_f(String name, float[] arr) {
        this.checkArraySupport();
        JsonNode child = this.node.path(name);
        this.read_array(arr, child);
    }

    private void read_array(float[] arr, JsonNode child) {
        for (int i = 0; i < arr.length; ++i) {
            JsonNode element = child.get(i);
            arr[i] = element != null ? (float)element.asDouble() : 0.0f;
        }
    }

    public void read_type_f(String name, double[] arr) {
        this.checkArraySupport();
        JsonNode child = this.node.path(name);
        this.read_array(arr, child);
    }

    private void read_array(double[] arr, JsonNode child) {
        for (int i = 0; i < arr.length; ++i) {
            JsonNode element = child.get(i);
            arr[i] = element != null ? element.asDouble() : 0.0;
        }
    }

    public <T> void read_type_f(String name, T[] arr) {
        this.checkArraySupport();
        JsonNode child = this.node.path(name);
        this.read_array(arr, child, null);
    }

    public <T> void read_type_f(String name, TopicDataType<T> dataType, Object[] arr) {
        this.checkArraySupport();
        JsonNode child = this.node.path(name);
        this.read_array(arr, child, dataType);
    }

    private <T> void read_array(T[] arr, JsonNode child, TopicDataType dataType) {
        if (child == null) {
            return;
        }
        Class<?> arrayType = arr.getClass().getComponentType();
        if (arrayType.isArray()) {
            for (int i = 0; i < arr.length; ++i) {
                JsonNode element = child.get(i);
                if (arr[i] instanceof boolean[]) {
                    this.read_array((boolean[])arr[i], element);
                    continue;
                }
                if (arr[i] instanceof byte[]) {
                    this.read_array((byte[])arr[i], element);
                    continue;
                }
                if (arr[i] instanceof char[]) {
                    this.read_array((char[])arr[i], element);
                    continue;
                }
                if (arr[i] instanceof short[]) {
                    this.read_array((short[])arr[i], element);
                    continue;
                }
                if (arr[i] instanceof int[]) {
                    this.read_array((int[])arr[i], element);
                    continue;
                }
                if (arr[i] instanceof long[]) {
                    this.read_array((long[])arr[i], element);
                    continue;
                }
                if (arr[i] instanceof float[]) {
                    this.read_array((float[])arr[i], element);
                    continue;
                }
                if (arr[i] instanceof double[]) {
                    this.read_array((double[])arr[i], element);
                    continue;
                }
                this.read_array((Object[])arr[i], element, dataType);
            }
        } else if (arrayType.isEnum()) {
            Enum[] enumConstants = (Enum[])arr.getClass().getComponentType().getEnumConstants();
            for (int i = 0; i < arr.length; ++i) {
                JsonNode element = child.get(i);
                arr[i] = element != null ? JacksonInterchangeSerializer.str2enum(enumConstants, element.asText()) : null;
            }
        } else if (StringBuilder.class.isAssignableFrom(arrayType)) {
            for (int i = 0; i < arr.length; ++i) {
                JsonNode element = child.get(i);
                if (element == null) continue;
                ((StringBuilder)arr[i]).setLength(0);
                ((StringBuilder)arr[i]).append(element.asText());
            }
        } else if (dataType != null) {
            for (int i = 0; i < arr.length; ++i) {
                JsonNode element = child.get(i);
                if (element == null || !element.isObject()) continue;
                dataType.deserialize((InterchangeSerializer)new JacksonInterchangeSerializer((ObjectNode)element, this.supportsArrays), arr[i]);
            }
        } else {
            throw new NotImplementedException("Unexpected array type " + String.valueOf(arrayType) + ". Aborting.");
        }
    }

    public void write_type_f(String name, boolean[] arr) {
        this.checkArraySupport();
        ArrayNode child = this.node.putArray(name);
        this.write_array(arr, child);
    }

    private void write_array(boolean[] arr, ArrayNode child) {
        for (int i = 0; i < arr.length; ++i) {
            child.add(arr[i]);
        }
    }

    public void write_type_f(String name, byte[] arr) {
        this.checkArraySupport();
        ArrayNode child = this.node.putArray(name);
        this.write_array(arr, child);
    }

    private void write_array(byte[] arr, ArrayNode child) {
        for (int i = 0; i < arr.length; ++i) {
            child.add((short)arr[i]);
        }
    }

    public void write_type_f(String name, char[] arr) {
        this.checkArraySupport();
        ArrayNode child = this.node.putArray(name);
        this.write_array(arr, child);
    }

    private void write_array(char[] arr, ArrayNode child) {
        for (int i = 0; i < arr.length; ++i) {
            child.add(String.valueOf(arr[i]));
        }
    }

    public void write_type_f(String name, short[] arr) {
        this.checkArraySupport();
        ArrayNode child = this.node.putArray(name);
        this.write_array(arr, child);
    }

    private void write_array(short[] arr, ArrayNode child) {
        for (int i = 0; i < arr.length; ++i) {
            child.add(arr[i]);
        }
    }

    public void write_type_f(String name, int[] arr) {
        this.checkArraySupport();
        ArrayNode child = this.node.putArray(name);
        this.write_array(arr, child);
    }

    private void write_array(int[] arr, ArrayNode child) {
        for (int i = 0; i < arr.length; ++i) {
            child.add(arr[i]);
        }
    }

    public void write_type_f(String name, long[] arr) {
        this.checkArraySupport();
        ArrayNode child = this.node.putArray(name);
        this.write_array(arr, child);
    }

    private void write_array(long[] arr, ArrayNode child) {
        for (int i = 0; i < arr.length; ++i) {
            child.add(arr[i]);
        }
    }

    public void write_type_f(String name, float[] arr) {
        this.checkArraySupport();
        ArrayNode child = this.node.putArray(name);
        this.write_array(arr, child);
    }

    private void write_array(float[] arr, ArrayNode child) {
        for (int i = 0; i < arr.length; ++i) {
            child.add(arr[i]);
        }
    }

    public void write_type_f(String name, double[] arr) {
        this.checkArraySupport();
        ArrayNode child = this.node.putArray(name);
        this.write_array(arr, child);
    }

    private void write_array(double[] arr, ArrayNode child) {
        for (int i = 0; i < arr.length; ++i) {
            child.add(arr[i]);
        }
    }

    private <T> void write_array(ArrayNode child, T[] arr, TopicDataType dataType) {
        Class<?> arrayType = arr.getClass().getComponentType();
        if (arrayType.isArray()) {
            for (int i = 0; i < arr.length; ++i) {
                ArrayNode element = child.addArray();
                if (arr[i] instanceof boolean[]) {
                    this.write_array((boolean[])arr[i], element);
                    continue;
                }
                if (arr[i] instanceof byte[]) {
                    this.write_array((byte[])arr[i], element);
                    continue;
                }
                if (arr[i] instanceof char[]) {
                    this.write_array((char[])arr[i], element);
                    continue;
                }
                if (arr[i] instanceof short[]) {
                    this.write_array((short[])arr[i], element);
                    continue;
                }
                if (arr[i] instanceof int[]) {
                    this.write_array((int[])arr[i], element);
                    continue;
                }
                if (arr[i] instanceof long[]) {
                    this.write_array((long[])arr[i], element);
                    continue;
                }
                if (arr[i] instanceof float[]) {
                    this.write_array((float[])arr[i], element);
                    continue;
                }
                if (arr[i] instanceof double[]) {
                    this.write_array((double[])arr[i], element);
                    continue;
                }
                this.write_array(element, (Object[])arr[i], dataType);
            }
        } else if (arrayType.isEnum()) {
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] == null) {
                    child.add("null");
                    continue;
                }
                child.add(((Enum)arr[i]).name());
            }
        } else if (StringBuilder.class.isAssignableFrom(arrayType)) {
            for (int i = 0; i < arr.length; ++i) {
                child.add(((StringBuilder)arr[i]).toString());
            }
        } else if (dataType != null) {
            for (int i = 0; i < arr.length; ++i) {
                ObjectNode element = child.addObject();
                dataType.serialize(arr[i], (InterchangeSerializer)new JacksonInterchangeSerializer(element, this.supportsArrays));
            }
        } else {
            throw new NotImplementedException("Unexpected array type " + String.valueOf(arrayType) + ". Aborting.");
        }
    }

    public <T> void write_type_f(String name, T[] arr) {
        this.checkArraySupport();
        ArrayNode child = this.node.putArray(name);
        this.write_array(child, arr, null);
    }

    public <T> void write_type_f(String name, TopicDataType<T> dataType, Object[] arr) {
        this.checkArraySupport();
        ArrayNode child = this.node.putArray(name);
        this.write_array(child, arr, dataType);
    }

    public long read_type_11(String name) {
        return this.node.path(name).asLong();
    }

    public void write_type_11(String name, long val) {
        this.node.put(name, val);
    }

    public char read_type_14(String name) {
        return this.read_type_8(name);
    }

    public void write_type_14(String name, char val) {
        this.write_type_8(name, val);
    }

    public void read_type_15(String name, StringBuilder res) {
        this.read_type_d(name, res);
    }

    public void write_type_15(String name, StringBuilder str) {
        this.write_type_d(name, str);
    }
}

