/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.idl.serializers.extra;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.io.IOException;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.idl.serializers.extra.AbstractSerializer;
import us.ihmc.idl.serializers.extra.JacksonInterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;

public class XMLSerializer<T>
extends AbstractSerializer<T> {
    private static ObjectMapper createXMLObjectMapper() {
        JacksonXmlModule module = new JacksonXmlModule();
        module.setDefaultUseWrapper(false);
        XmlMapper objectMapper = new XmlMapper(module);
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        return objectMapper;
    }

    public XMLSerializer(TopicDataType<T> topicDataType) {
        super(topicDataType, XMLSerializer.createXMLObjectMapper());
    }

    @Override
    protected Object serialize(T data) throws IOException {
        Wrapper wrapper = new Wrapper();
        wrapper.name = this.topicDataType.getName();
        wrapper.payload = this.mapper.createObjectNode();
        this.topicDataType.serialize(data, (InterchangeSerializer)new JacksonInterchangeSerializer(wrapper.payload, false));
        return wrapper;
    }

    @Override
    protected T deserialize(JsonNode root) throws IOException {
        String name = root.get("name").asText();
        JsonNode element = root.get("TopicData");
        if (this.topicDataType.getName().equals(name) && element != null && element.isObject()) {
            JacksonInterchangeSerializer serializer = new JacksonInterchangeSerializer((ObjectNode)element, false);
            Object data = this.topicDataType.createData();
            this.topicDataType.deserialize((InterchangeSerializer)serializer, data);
            return (T)data;
        }
        return null;
    }

    @JacksonXmlRootElement(localName="TopicDataType")
    private static class Wrapper {
        @JacksonXmlProperty(localName="name", isAttribute=true)
        private String name;
        @JacksonXmlProperty(localName="TopicData", isAttribute=false)
        private ObjectNode payload;

        private Wrapper() {
        }
    }
}

