/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.idl.serializers.extra;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.idl.generated.chat.ChatMessage;
import us.ihmc.idl.generated.chat.ChatMessagePubSubType;
import us.ihmc.idl.generated.test.IDLElementTest;
import us.ihmc.idl.generated.test.IDLElementTestPubSubType;
import us.ihmc.idl.serializers.extra.JSONSerializerTest;
import us.ihmc.idl.serializers.extra.XMLSerializer;
import us.ihmc.pubsub.TopicDataType;

public class XMLSerializerTest {
    @Test
    public void testException() throws IOException {
        Assertions.assertThrows(IOException.class, () -> {
            IDLElementTestPubSubType dataType = new IDLElementTestPubSubType();
            XMLSerializer serializer = new XMLSerializer((TopicDataType)dataType);
            IDLElementTest testElement = JSONSerializerTest.createPopulatedIDLElementTest();
            serializer.serializeToString((Object)testElement);
        });
    }

    @Test
    public void test() throws IOException {
        ChatMessagePubSubType dataType = new ChatMessagePubSubType();
        XMLSerializer serializer = new XMLSerializer((TopicDataType)dataType);
        ChatMessage msg = new ChatMessage();
        msg.getSender().append("Java");
        msg.getMsg().append("Hello World");
        String xml = serializer.serializeToString((Object)msg);
        ChatMessage res = (ChatMessage)serializer.deserialize(xml);
        Assertions.assertEquals((Object)msg, (Object)res);
    }
}

