/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.idl.generator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskAction;
import us.ihmc.idl.generator.IDLGenerator;

public class IDLGeneratorTask
extends DefaultTask {
    public FileCollection idlFiles;
    public FileCollection includeDirs;
    public String packagePrefix = "";
    public String version = "";
    public File targetDirectory;

    @TaskAction
    public void compile() throws IOException {
        String packagePrefix;
        if (this.idlFiles == null) {
            throw new IOException("No IDL files to compile.");
        }
        ArrayList<File> idlList = new ArrayList<File>();
        for (Object idl : this.idlFiles) {
            if (!((File)idl).exists()) {
                throw new IOException("Cannot find " + String.valueOf(idl));
            }
            idlList.add((File)idl);
        }
        ArrayList<File> includeList = new ArrayList<File>();
        if (this.includeDirs != null) {
            for (File include : this.includeDirs) {
                includeList.add(include);
            }
        }
        if ((packagePrefix = this.packagePrefix) == null) {
            packagePrefix = "";
        }
        if (this.targetDirectory == null) {
            throw new IOException("Target directory not set.");
        }
        if (!this.targetDirectory.exists()) {
            throw new IOException("Target directory " + String.valueOf(this.targetDirectory) + " does not exist.");
        }
        if (!this.targetDirectory.isDirectory()) {
            throw new IOException("Target directory " + String.valueOf(this.targetDirectory) + " is not a directory.");
        }
        for (File idl : idlList) {
            IDLGenerator.execute(idl, packagePrefix, this.targetDirectory, includeList, this.version);
        }
    }
}

