/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.idl.generator;

import com.eprosima.idl.context.Context;
import com.eprosima.idl.generator.manager.TemplateGroup;
import com.eprosima.idl.generator.manager.TemplateManager;
import com.eprosima.idl.parser.grammar.IDLLexer;
import com.eprosima.idl.parser.grammar.IDLParser;
import com.eprosima.idl.parser.tree.AnnotationDeclaration;
import com.eprosima.idl.parser.tree.AnnotationMember;
import com.eprosima.idl.parser.typecode.PrimitiveTypeCode;
import com.eprosima.idl.parser.typecode.TypeCode;
import com.eprosima.idl.util.Util;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.anarres.cpp.CppReader;
import org.anarres.cpp.Feature;
import org.anarres.cpp.Preprocessor;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import us.ihmc.idl.generator.IDLContext;
import us.ihmc.idl.generator.PreprocessorFilter;
import us.ihmc.idl.generator.TypesGenerator;

public class IDLGenerator {
    public static void main(String[] args) throws IOException {
        ArrayList<File> defaultIncludePath = new ArrayList<File>();
        defaultIncludePath.add(new File("."));
        if (args.length == 3) {
            IDLGenerator.execute(new File(args[0]), args[1], new File(args[2]), defaultIncludePath);
        } else {
            FileDialog dialog = new FileDialog((Frame)null, "Select idl file", 0);
            dialog.setFile("*.idl");
            dialog.setVisible(true);
            if (dialog.getFile() == null) {
                dialog.dispose();
                return;
            }
            File file = new File(dialog.getDirectory(), dialog.getFile());
            String res = JOptionPane.showInputDialog("Desired package path");
            if (res == null) {
                JOptionPane.showMessageDialog(null, "No package path given");
                dialog.dispose();
                return;
            }
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setCurrentDirectory(new File("."));
            if (fileChooser.showOpenDialog(null) != 0) {
                dialog.dispose();
                return;
            }
            IDLGenerator.execute(file, res, fileChooser.getSelectedFile(), defaultIncludePath);
            dialog.dispose();
        }
    }

    private static Reader createPreProcessedInputStream(File idlFile, List<File> includePathIn) throws IOException {
        PreprocessorFilter preprocessor = new PreprocessorFilter();
        preprocessor.addFeature(Feature.KEEPALLCOMMENTS);
        preprocessor.addFeature(Feature.KEEPCOMMENTS);
        preprocessor.addFeature(Feature.LINEMARKERS);
        preprocessor.addFeature(Feature.INCLUDENEXT);
        ArrayList<String> includePath = new ArrayList<String>();
        includePath.add(idlFile.getParent());
        for (File include : includePathIn) {
            includePath.add(include.getAbsolutePath());
        }
        preprocessor.setSystemIncludePath(includePath);
        preprocessor.setQuoteIncludePath(includePath);
        preprocessor.addInput(idlFile);
        CppReader reader = new CppReader((Preprocessor)preprocessor);
        return new BufferedReader((Reader)reader);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void execute(File idlFile, String packageName, File targetDirectory, List<File> includePath) throws IOException {
        String idlFilename = idlFile.getAbsolutePath();
        try {
            Field field = TemplateManager.class.getDeclaredField("m_loaderDirectories");
            field.setAccessible(true);
            field.set(null, "us/ihmc/idl/templates");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("API changed, fixme", e);
        }
        String onlyFileName = Util.getIDLFileNameOnly((String)idlFilename);
        IDLContext context = new IDLContext(onlyFileName, idlFilename, new ArrayList<String>());
        context.setPackage(packageName);
        TypeCode.javapackage = context.isIsPackageEmpty() ? "" : context.getPackage() + ".";
        AnnotationDeclaration defaultAnnotation = context.createAnnotationDeclaration("defaultValue", null);
        defaultAnnotation.addMember(new AnnotationMember("value", (TypeCode)new PrimitiveTypeCode(13), ""));
        AnnotationDeclaration keyann = context.createAnnotationDeclaration("Key", null);
        keyann.addMember(new AnnotationMember("value", (TypeCode)new PrimitiveTypeCode(7), "true"));
        AnnotationDeclaration topicann = context.createAnnotationDeclaration("Topic", null);
        topicann.addMember(new AnnotationMember("value", (TypeCode)new PrimitiveTypeCode(7), "true"));
        AnnotationDeclaration abstractann = context.createAnnotationDeclaration("Abstract", null);
        abstractann.addMember(new AnnotationMember("type", (TypeCode)new PrimitiveTypeCode(13), "java.lang.Object"));
        abstractann.addMember(new AnnotationMember("impl", (TypeCode)new PrimitiveTypeCode(13), ""));
        AnnotationDeclaration typecode = context.createAnnotationDeclaration("TypeCode", null);
        typecode.addMember(new AnnotationMember("type", (TypeCode)new PrimitiveTypeCode(7), "INVALID_TYPE_CODE"));
        TemplateManager tmanager = new TemplateManager("FastCdrCommon:Common");
        TemplateGroup maintemplates = tmanager.createTemplateGroup("main");
        maintemplates.setAttribute("ctx", (Object)context);
        if (!idlFile.exists()) throw new IOException("The File " + idlFilename + " was not found.");
        Reader reader = IDLGenerator.createPreProcessedInputStream(idlFile, includePath);
        ANTLRInputStream input = new ANTLRInputStream(reader);
        IDLLexer lexer = new IDLLexer((CharStream)input);
        lexer.setContext((Context)context);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        IDLParser parser = new IDLParser((TokenStream)tokens);
        parser.specification((Context)context, tmanager, maintemplates);
        File packageDir = new File(targetDirectory, context.getPackageDir());
        if (!packageDir.isDirectory() && !packageDir.mkdirs()) throw new IOException("Cannot create output dir " + packageDir);
        TypesGenerator gen = new TypesGenerator(tmanager, true);
        if (gen.generate(context, packageDir.getPath() + "/", context.getPackage(), null)) return;
        throw new IOException("Cannot create Java files");
    }

    public static void printTokenStream(CommonTokenStream tokens) {
        tokens.fill();
        for (int index = 0; index < tokens.size(); ++index) {
            IDLGenerator.printToken(tokens, index, tokens.get(index));
        }
    }

    private static void printToken(CommonTokenStream tokens, int index, Token token) {
        if (token.getType() != 103) {
            Object out = "";
            out = (String)out + " Index: " + token.getTokenIndex();
            out = (String)out + " Start: " + token.getStartIndex();
            out = (String)out + " Stop: " + token.getStopIndex();
            out = (String)out + " Channel: " + token.getChannel();
            out = (String)out + " Type: " + token.getType();
            out = (String)out + " " + token.getText().replaceAll("\\s", "");
            System.out.println((String)out);
        }
    }
}

