/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.tools;

import java.util.ArrayList;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;
import us.ihmc.pubsub.tools.MessageCallback;

public class SubscriberListenerImpl<T>
implements SubscriberListener {
    private final T data;
    private final SampleInfo info = new SampleInfo();
    private ArrayList<MessageCallback<T>> callbacks;

    public SubscriberListenerImpl(T data, ArrayList<MessageCallback<T>> callbacks) {
        this.data = data;
        this.callbacks = callbacks;
    }

    public void onNewDataMessage(Subscriber subscriber) {
        if (subscriber.takeNextData(this.data, this.info)) {
            for (MessageCallback<T> callback : this.callbacks) {
                callback.callback(this.data, this.info);
            }
        }
    }

    public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
        System.out.println("New publisher matched");
        System.out.println("Status: " + String.valueOf(info.getStatus()));
        System.out.println("Guid: " + info.getGuid().toString());
    }
}

