/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.test;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.idl.generated.nested.NestedElement;
import us.ihmc.idl.generated.test.Color;
import us.ihmc.idl.generated.test.IDLElementTest;

public class MessageEqualsTest {
    @Test
    public void testEmptyMessagesEqual() {
        IDLElementTest a = new IDLElementTest();
        IDLElementTest b = new IDLElementTest();
        Assertions.assertTrue((boolean)a.equals((Object)b), (String)"not equal");
        Assertions.assertTrue((boolean)a.epsilonEquals(b, 0.0), (String)"not equal");
    }

    @Test
    public void testMessagesNotEqual1() {
        IDLElementTest a = new IDLElementTest();
        IDLElementTest b = new IDLElementTest();
        a.setBooleanTest(true);
        b.setBooleanTest(false);
        Assertions.assertFalse((boolean)a.equals((Object)b), (String)"is equal");
        Assertions.assertFalse((boolean)a.epsilonEquals(b, 0.0), (String)"is equal");
    }

    @Test
    public void testFullMessagesEqual() {
        IDLElementTest a = new IDLElementTest();
        IDLElementTest b = new IDLElementTest();
        this.createFullMessage(a);
        this.createFullMessage(b);
        Assertions.assertTrue((boolean)a.equals((Object)b), (String)"not equal");
        Assertions.assertTrue((boolean)a.epsilonEquals(b, 0.0), (String)"not equal");
    }

    @Test
    public void testMessagesNotEqual2() {
        IDLElementTest a = new IDLElementTest();
        IDLElementTest b = new IDLElementTest();
        this.createFullMessage(a);
        this.createFullMessage(b);
        a.getEnumSeqTest().remove();
        a.getEnumSeqTest().add((Enum)Color.green);
        Assertions.assertFalse((boolean)a.equals((Object)b), (String)"is equal");
        Assertions.assertFalse((boolean)a.epsilonEquals(b, 0.0), (String)"is equal");
    }

    @Test
    public void testMessagesNotEqual3() {
        IDLElementTest a = new IDLElementTest();
        IDLElementTest b = new IDLElementTest();
        this.createFullMessage(a);
        this.createFullMessage(b);
        a.getNestedArray()[1][2].setLongTest(1);
        b.getNestedArray()[1][2].setLongTest(2);
        Assertions.assertFalse((boolean)a.equals((Object)b), (String)"is equal");
        Assertions.assertFalse((boolean)a.epsilonEquals(b, 0.5), (String)"is equal");
    }

    @Test
    public void testMessagesEqual3() {
        IDLElementTest a = new IDLElementTest();
        IDLElementTest b = new IDLElementTest();
        this.createFullMessage(a);
        this.createFullMessage(b);
        a.getNestedArray()[1][2].setLongTest(1);
        b.getNestedArray()[1][2].setLongTest(2);
        Assertions.assertFalse((boolean)a.equals((Object)b), (String)"not equal");
        Assertions.assertTrue((boolean)a.epsilonEquals(b, 1.0), (String)"not equal");
    }

    @Test
    public void testCopyConstructor() {
        IDLElementTest a = new IDLElementTest();
        this.createFullMessage(a);
        IDLElementTest b = new IDLElementTest(a);
        Assertions.assertTrue((boolean)a.equals((Object)b), (String)"not equal");
        Assertions.assertTrue((boolean)a.epsilonEquals(b, 0.0), (String)"not equal");
    }

    private void createFullMessage(IDLElementTest a) {
        int i;
        a.setCharTest('a');
        a.setWcharTest('b');
        a.setOctetTest((byte)-1);
        a.setShortTest((short)-2);
        a.setUshortTest(3);
        a.setLongTest(-4);
        a.setUlongTest(5L);
        a.setLonglongTest(-6L);
        a.setUlonglongTest(7L);
        a.setFloatTest(8.0f);
        a.setDoubleTest(9.1);
        a.setBooleanTest(true);
        a.setColorTest(Color.red);
        a.getNestedElementTest().setStringTest("hi");
        a.getNestedElementTest().setLongTest(5);
        a.setStringTest("hi");
        for (i = 0; i < a.getLongArray().length; ++i) {
            a.getLongArray()[i] = i;
        }
        for (i = 0; i < a.getNestedArray().length; ++i) {
            for (int j = 0; j < a.getNestedArray()[i].length; ++j) {
                a.getNestedArray()[i][j].setStringTest("foo");
                a.getNestedArray()[i][j].setLongTest(j * i);
            }
        }
        for (i = 0; i < a.getStringArray().length; ++i) {
            a.getStringArray()[i] = new StringBuilder("hello");
        }
        for (i = 0; i < a.getEnumArray().length; ++i) {
            a.getEnumArray()[i] = Color.blue;
        }
        a.getCharSeqTest().add('d');
        a.getWcharSeqTest().add('e');
        a.getOctetSeqTest().add((byte)2);
        a.getShortSeqTest().add((short)5);
        a.getUshortSeqTest().add(7);
        a.getLongSeqTest().add(-8);
        a.getUlongSeqTest().add(9L);
        a.getLonglongSeqtest().add(-10L);
        a.getUlonglongSeqTest().add(11L);
        a.getFloatSeqTest().add(12.0f);
        a.getDoubleSeqTest().add(-13.0);
        a.getBooleanSeqTest().add(true);
        a.getNestedSeqTest().add();
        ((NestedElement)((Object)a.getNestedSeqTest().get(0))).setStringTest("help");
        a.getEnumSeqTest().add((Enum)Color.blue);
        a.getEnumSeqTest().add((Enum)Color.red);
        a.getStringSeqTest().add("yoyo");
    }
}

