/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.test;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.idl.generated.chat.ChatMessage;
import us.ihmc.idl.generated.chat.ChatMessagePubSubType;
import us.ihmc.pubsub.common.SerializedPayload;

public class ChatMessageTest {
    @Test
    public void testHelloWorld() throws IOException {
        byte[] javaHelloWorld = new byte[]{0, 1, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 74, 97, 118, 97, 0, 0, 0, 0, 12, 0, 0, 0, 72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100, 0};
        String senderIn = "Java";
        String msgIn = "Hello World";
        ChatMessage msg = new ChatMessage();
        msg.getSender().append(senderIn);
        msg.getMsg().append(msgIn);
        ChatMessagePubSubType type = new ChatMessagePubSubType();
        SerializedPayload payload = new SerializedPayload(type.getTypeSize());
        type.serialize(msg, payload);
        byte[] data = new byte[payload.getData().limit()];
        payload.getData().get(data);
        for (int i = 0; i < data.length; ++i) {
            System.out.printf("0x%02X\n", data[i]);
        }
        Assertions.assertArrayEquals((byte[])javaHelloWorld, (byte[])data);
        ChatMessage invertedMsg = new ChatMessage();
        SerializedPayload invertedPayload = new SerializedPayload(type.getTypeSize());
        invertedPayload.getData().put(javaHelloWorld);
        invertedPayload.getData().flip();
        type.deserialize(invertedPayload, invertedMsg);
        Assertions.assertEquals((Object)invertedMsg.getSender().toString(), (Object)senderIn);
        Assertions.assertEquals((Object)invertedMsg.getMsg().toString(), (Object)msgIn);
    }
}

