/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.test;

import com.eprosima.xmlschemas.fastrtps_profiles.DurabilityQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.HistoryQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosKindPolicyType;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.allocations.AllocationProfiler;
import us.ihmc.commons.allocations.AllocationRecord;
import us.ihmc.idl.generated.test.StatusMessage;
import us.ihmc.idl.generated.test.StatusMessagePubSubType;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantProfile;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSDomain;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantDiscoveryInfo;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

public class PublishSubscribeUInt64AllocationTest {
    public static final int NUMBER_OF_MESSAGES_TO_SEND = 30;

    @Tag(value="allocation")
    @Test
    public void testPublishSubscribeUInt32AllocationsFastRTPS() throws IOException {
        this.runAllocationTest();
    }

    @Disabled
    @Tag(value="allocation")
    @Test
    public void testPublishSubscribeUInt32AllocationsIntraprocess() throws IOException {
        this.runAllocationTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAllocationTest() throws IOException {
        AllocationProfiler allocationProfiler = new AllocationProfiler();
        FastRTPSDomain domain = DomainFactory.getDomain();
        try {
            domain.setLogLevel(LogLevel.INFO);
            ParticipantProfile attributes = ParticipantProfile.create().domainId(218).useOnlyIntraProcessDelivery().discoveryLeaseDuration(Time.Infinite).name("StatusTest");
            Participant participant = domain.createParticipant(attributes, (ParticipantListener)new ParticipantListenerImpl());
            StatusMessagePubSubType dataType = new StatusMessagePubSubType();
            domain.registerType(participant, (TopicDataType)dataType);
            PublisherAttributes genericPublisherAttributes = (PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)PublisherAttributes.create().topicDataType((TopicDataType)dataType)).topicName("Status")).reliabilityKind(ReliabilityQosKindPolicyType.RELIABLE)).partitions(Collections.singletonList("us/ihmc"))).durabilityKind(DurabilityQosKindPolicyType.TRANSIENT_LOCAL)).historyQosPolicyKind(HistoryQosKindPolicyType.KEEP_LAST)).historyDepth(50L);
            StatusMessagePubSubType dataType2 = new StatusMessagePubSubType();
            SubscriberAttributes subscriberAttributes = (SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)SubscriberAttributes.create().topicDataType((TopicDataType)dataType2)).topicName("Status")).reliabilityKind(ReliabilityQosKindPolicyType.RELIABLE)).partitions(Collections.singletonList("us/ihmc"))).durabilityKind(DurabilityQosKindPolicyType.VOLATILE)).historyQosPolicyKind(HistoryQosKindPolicyType.KEEP_ALL);
            SubscriberListenerImpl subscriberListener = new SubscriberListenerImpl();
            Subscriber subscriber = domain.createSubscriber(participant, subscriberAttributes, (SubscriberListener)subscriberListener);
            Publisher publisher = domain.createPublisher(participant, genericPublisherAttributes, (PublisherListener)new PublisherListenerImpl());
            StatusMessage msg = new StatusMessage();
            msg.setPause(false);
            msg.setSequenceId(0L);
            this.publishNMessages(publisher, msg, 1);
            allocationProfiler.startRecordingAllocations();
            this.publishNMessages(publisher, msg, 30);
            allocationProfiler.stopRecordingAllocations();
            for (StatusMessage message : subscriberListener.receivedMessages) {
                if (message == null) continue;
                PrintTools.info((Object)this, (String)("Message received: " + message.toString()));
            }
            List allocations = allocationProfiler.pollAllocations();
            Object message = "";
            for (AllocationRecord allocation : allocations) {
                message = (String)message + allocation.toString() + "\n";
            }
            System.out.println((String)message);
            Assertions.assertTrue((allocations.size() == 0 ? 1 : 0) != 0, (String)("allocated " + allocations.size() + ": \n" + (String)message));
        }
        finally {
            domain.stopAll();
        }
    }

    private void publishNMessages(Publisher publisher, StatusMessage msg, int numberOfMessagesToSend) throws IOException {
        for (int i = 0; i < numberOfMessagesToSend; ++i) {
            try {
                msg.setPause(i % 2 == 0);
                msg.setSequenceId(i);
                publisher.write((Object)msg);
                Thread.sleep(1000L);
                ++i;
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class ParticipantListenerImpl
    implements ParticipantListener {
        private ParticipantListenerImpl() {
        }

        public void onParticipantDiscovery(Participant participant, ParticipantDiscoveryInfo info) {
            LogTools.debug((String)"New participant discovered");
            LogTools.debug((String)("Status: " + String.valueOf(info.getStatus())));
            LogTools.debug((String)("Guid: " + info.getGuid().toString()));
            LogTools.debug((String)("Name: " + info.getName()));
        }
    }

    private class SubscriberListenerImpl
    implements SubscriberListener {
        private final SampleInfo info = new SampleInfo();
        public final StatusMessage[] receivedMessages = new StatusMessage[30];
        public int i;

        private SubscriberListenerImpl() {
            for (int i = 0; i < 30; ++i) {
                this.receivedMessages[i] = new StatusMessage();
            }
            this.i = 0;
        }

        public void onNewDataMessage(Subscriber subscriber) {
            if (subscriber.takeNextData((Object)this.receivedMessages[this.i++], this.info)) {
                // empty if block
            }
        }

        public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
            LogTools.debug((String)"New publisher matched");
            LogTools.debug((String)("Status: " + String.valueOf(info.getStatus())));
            LogTools.debug((String)("Guid: " + info.getGuid().toString()));
        }
    }

    private class PublisherListenerImpl
    implements PublisherListener {
        private PublisherListenerImpl() {
        }

        public void onPublicationMatched(Publisher publisher, MatchingInfo info) {
            LogTools.debug((String)"New subscriber matched");
            LogTools.debug((String)("Status: " + String.valueOf(info.getStatus())));
            LogTools.debug((String)("Guid: " + info.getGuid().toString()));
        }
    }
}

