/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.test;

import com.eprosima.xmlschemas.fastrtps_profiles.DurabilityQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.HistoryQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosKindPolicyType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.idl.generated.chat.ChatMessage;
import us.ihmc.idl.generated.chat.ChatMessagePubSubType;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantProfile;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSDomain;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

public class MultipleParticipantsInSameProcessTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMulitpleParticipantsInSameProcess() throws IOException, InterruptedException {
        AtomicInteger counter = new AtomicInteger();
        FastRTPSDomain domain = DomainFactory.getDomain();
        try {
            ChatMessagePubSubType topicDataType = new ChatMessagePubSubType();
            PublisherAttributes genericPublisherAttributes = (PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)PublisherAttributes.create().topicDataType((TopicDataType)topicDataType)).topicName("Status")).reliabilityKind(ReliabilityQosKindPolicyType.RELIABLE)).partitions(Collections.singletonList("us/ihmc"))).durabilityKind(DurabilityQosKindPolicyType.TRANSIENT_LOCAL)).historyQosPolicyKind(HistoryQosKindPolicyType.KEEP_LAST)).historyDepth(10L);
            SubscriberAttributes subscriberAttributes = (SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)SubscriberAttributes.create().topicDataType((TopicDataType)topicDataType)).topicName("Status")).reliabilityKind(ReliabilityQosKindPolicyType.RELIABLE)).partitions(Collections.singletonList("us/ihmc"))).durabilityKind(DurabilityQosKindPolicyType.TRANSIENT_LOCAL)).historyQosPolicyKind(HistoryQosKindPolicyType.KEEP_ALL);
            ArrayList<Participant> participants = new ArrayList<Participant>();
            for (int i = 1; i <= 100; ++i) {
                ParticipantProfile participantProfile = ParticipantProfile.create().domainId(217).useOnlyIntraProcessDelivery().discoveryLeaseDuration(Time.Infinite).name("StatusTest" + i);
                Participant participant = domain.createParticipant(participantProfile);
                participants.add(participant);
            }
            LogTools.info((String)"Created {} participants", (Object)participants.size());
            ArrayList<Publisher> publishers = new ArrayList<Publisher>();
            for (Participant participant : participants) {
                publishers.add(domain.createPublisher(participant, genericPublisherAttributes, null));
            }
            LogTools.info((String)"Created {} publishers", (Object)publishers.size());
            Subscriber subscriber = domain.createSubscriber((Participant)participants.get(0), subscriberAttributes, (SubscriberListener)new SubscriberListenerImpl(counter));
            Thread thread = new Thread(() -> {
                AtomicInteger msgCounter = new AtomicInteger();
                for (Publisher publisher : publishers) {
                    try {
                        ChatMessage msg = new ChatMessage();
                        msg.setMsg(String.valueOf(msgCounter.getAndIncrement()));
                        publisher.write((Object)msg);
                        Thread.sleep(20L);
                    }
                    catch (IOException | InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
            thread.start();
            thread.join();
            Assertions.assertEquals((int)100, (int)counter.get());
        }
        finally {
            domain.stopAll();
        }
    }

    private class SubscriberListenerImpl
    implements SubscriberListener {
        AtomicInteger counter;

        public SubscriberListenerImpl(AtomicInteger counter) {
            this.counter = counter;
        }

        public void onNewDataMessage(Subscriber subscriber) {
            ChatMessage chatMessage = (ChatMessage)((Object)subscriber.takeNextData());
            Assertions.assertEquals((int)Integer.parseInt(chatMessage.getMsgAsString()), (int)this.counter.getAndIncrement());
        }

        public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
        }
    }
}

