/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.examples;

import com.eprosima.xmlschemas.fastrtps_profiles.DurabilityQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.HistoryQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.PublishModeQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosKindPolicyType;
import java.io.IOException;
import java.util.Collections;
import us.ihmc.idl.generated.chat.ChatMessage;
import us.ihmc.idl.generated.chat.ChatMessagePubSubType;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantProfile;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSDomain;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantDiscoveryInfo;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;

public class PublisherExample {
    public PublisherExample() throws IOException {
        FastRTPSDomain domain = DomainFactory.getDomain();
        domain.setLogLevel(LogLevel.INFO);
        ParticipantProfile attributes2 = ParticipantProfile.create().domainId(1).useOnlyIntraProcessDelivery().name("PublisherExample2").discoveryLeaseDuration(Time.Infinite);
        System.out.println(attributes2.marshall("test"));
        Participant participant = domain.createParticipant(attributes2, (ParticipantListener)new ParticipantListenerImpl());
        ChatMessagePubSubType dataType = new ChatMessagePubSubType();
        domain.registerType(participant, (TopicDataType)dataType);
        PublisherAttributes attrs = ((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)PublisherAttributes.create().topicName("chatter")).topicDataType((TopicDataType)dataType)).publishModeKind(PublishModeQosKindPolicyType.ASYNCHRONOUS).reliabilityKind(ReliabilityQosKindPolicyType.RELIABLE)).durabilityKind(DurabilityQosKindPolicyType.TRANSIENT_LOCAL)).historyQosPolicyKind(HistoryQosKindPolicyType.KEEP_LAST)).historyDepth(50L)).partitions(Collections.singletonList("us/ihmc"))).lifespan(new Time(14, 0L))).heartBeatPeriod(new Time(0, 100000000L));
        System.out.println("creating publisher");
        Publisher publisher = domain.createPublisher(participant, attrs, (PublisherListener)new PublisherListenerImpl());
        ChatMessage msg = new ChatMessage();
        msg.setSender("Java");
        int i = 0;
        while (true) {
            try {
                while (true) {
                    msg.setMsg("Hello World " + i++);
                    publisher.write((Object)msg);
                    System.out.println("Publishing: " + msg.getMsgAsString());
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) throws IOException {
        new PublisherExample();
    }

    private class ParticipantListenerImpl
    implements ParticipantListener {
        private ParticipantListenerImpl() {
        }

        public void onParticipantDiscovery(Participant participant, ParticipantDiscoveryInfo info) {
            System.out.println("New participant discovered");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
            System.out.println("Name: " + info.getName());
        }
    }

    private class PublisherListenerImpl
    implements PublisherListener {
        private PublisherListenerImpl() {
        }

        public void onPublicationMatched(Publisher publisher, MatchingInfo info) {
            System.out.println("New subscriber matched");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
        }
    }
}

