/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.test;

import com.eprosima.xmlschemas.fastrtps_profiles.DurabilityQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.HistoryQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosKindPolicyType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.idl.generated.test.BigMessage;
import us.ihmc.idl.generated.test.BigMessagePubSubType;
import us.ihmc.idl.generated.test.IDLSubmessage;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantProfile;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantDiscoveryInfo;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

@Deprecated
public class IntraprocessLargeCopyTest {
    @Test
    @Disabled
    public void testRepeatedLargeCopiesInFastRTPSCallbacks() throws IOException, InterruptedException {
        Random random = new Random(981239012380L);
        DomainFactory.PubSubImplementation impl = DomainFactory.PubSubImplementation.FAST_RTPS;
        this.performCopyTest(random, impl);
    }

    @Test
    @Disabled
    public void testRepeatedLargeCopiesInIntraprocessCallbacks() throws IOException, InterruptedException {
        Random random = new Random(981239012380L);
        DomainFactory.PubSubImplementation impl = DomainFactory.PubSubImplementation.INTRAPROCESS;
        this.performCopyTest(random, impl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCopyTest(Random random, DomainFactory.PubSubImplementation impl) throws InterruptedException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream systemErr = System.err;
        Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)impl);
        try {
            System.setErr(new PrintStream(byteArrayOutputStream));
            this.createSubscriber(domain);
            ArrayList<Thread> threads = new ArrayList<Thread>();
            for (int i = 0; i < 5; ++i) {
                Thread publisherThread = new Thread(() -> {
                    try {
                        Publisher publisher = this.createPublisher(domain);
                        this.publishABunch(publisher, random);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }, "PublisherThread");
                publisherThread.start();
                threads.add(publisherThread);
            }
            threads.stream().forEach(thread -> {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            });
            ThreadTools.sleep((long)5000L);
            System.err.flush();
            System.setErr(systemErr);
            System.err.println(byteArrayOutputStream.toString());
            Assertions.assertFalse((boolean)byteArrayOutputStream.toString().contains("IndexOutOfBoundsException"), (String)"Standard error contains java.lang.IndexOutOfBoundsException");
        }
        finally {
            domain.stopAll();
        }
    }

    private ParticipantProfile createParticipantAttributes(String name) throws UnknownHostException {
        return ParticipantProfile.create().domainId(215).discoveryLeaseDuration(Time.Infinite).name(name).useOnlySharedMemoryTransport();
    }

    private Publisher createPublisher(Domain domain) throws IOException {
        domain.setLogLevel(LogLevel.ERROR);
        ParticipantProfile attributes = this.createParticipantAttributes("StatusTest");
        Participant participant = domain.createParticipant(attributes, (ParticipantListener)new ParticipantListenerImpl());
        BigMessagePubSubType dataType = new BigMessagePubSubType();
        domain.registerType(participant, (TopicDataType)dataType);
        PublisherAttributes genericPublisherAttributes = (PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)PublisherAttributes.create().topicDataType((TopicDataType)dataType)).topicName("Status")).reliabilityKind(ReliabilityQosKindPolicyType.RELIABLE)).partitions(Collections.singletonList("us/ihmc"))).durabilityKind(DurabilityQosKindPolicyType.VOLATILE)).historyQosPolicyKind(HistoryQosKindPolicyType.KEEP_LAST)).historyDepth(10L);
        return domain.createPublisher(participant, genericPublisherAttributes, (PublisherListener)new PublisherListenerImpl());
    }

    private void createSubscriber(Domain domain) throws IOException {
        domain.setLogLevel(LogLevel.ERROR);
        ParticipantProfile attributes = this.createParticipantAttributes("StatusTest");
        Participant participant = domain.createParticipant(attributes, (ParticipantListener)new ParticipantListenerImpl());
        BigMessagePubSubType dataType = new BigMessagePubSubType();
        domain.registerType(participant, (TopicDataType)dataType);
        BigMessagePubSubType dataType2 = new BigMessagePubSubType();
        SubscriberAttributes subscriberAttributes = (SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)SubscriberAttributes.create().topicDataType((TopicDataType)dataType2)).topicName("Status")).reliabilityKind(ReliabilityQosKindPolicyType.RELIABLE)).partitions(Collections.singletonList("us/ihmc"))).durabilityKind(DurabilityQosKindPolicyType.VOLATILE)).historyQosPolicyKind(HistoryQosKindPolicyType.KEEP_ALL);
        domain.createSubscriber(participant, subscriberAttributes, (SubscriberListener)new SubscriberListenerImpl());
    }

    private void publishABunch(Publisher publisher, Random random) throws IOException {
        for (int i = 0; i < 20; ++i) {
            BigMessage msg = new BigMessage();
            IDLSubmessage idlSubmessage = new IDLSubmessage();
            int randomSize = random.nextInt(100000);
            for (int j = 0; j < randomSize; ++j) {
                idlSubmessage.setHello(i + j);
                ((IDLSubmessage)((Object)msg.getLargeSequence().add())).set(idlSubmessage);
            }
            publisher.write((Object)msg);
        }
    }

    private class ParticipantListenerImpl
    implements ParticipantListener {
        private ParticipantListenerImpl() {
        }

        public void onParticipantDiscovery(Participant participant, ParticipantDiscoveryInfo info) {
            System.out.println("New participant discovered");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
            System.out.println("Name: " + info.getName());
        }
    }

    private class PublisherListenerImpl
    implements PublisherListener {
        private PublisherListenerImpl() {
        }

        public void onPublicationMatched(Publisher publisher, MatchingInfo info) {
            System.out.println("New subscriber matched");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
        }
    }

    private class SubscriberListenerImpl
    implements SubscriberListener {
        private final BigMessage data = new BigMessage();
        private final SampleInfo info = new SampleInfo();
        int i = 0;

        private SubscriberListenerImpl() {
        }

        public void onNewDataMessage(Subscriber subscriber) {
            if (subscriber.takeNextData((Object)this.data, this.info)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                BigMessage copied = new BigMessage();
                copied.set(this.data);
                System.out.println("Received: " + this.i++ + " Copied size: " + copied.getLargeSequence().size());
            }
        }

        public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
            System.out.println("New publisher matched");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
        }
    }
}

