/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.tools;

import com.eprosima.xmlschemas.fastrtps_profiles.DurabilityQosKindType;
import com.eprosima.xmlschemas.fastrtps_profiles.HistoryQosKindType;
import com.eprosima.xmlschemas.fastrtps_profiles.PublishModeQosKindType;
import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosKindType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Supplier;
import us.ihmc.communication.packets.Packet;
import us.ihmc.idl.generated.test.IDLElementTestPubSubType;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.tools.MessageCallback;
import us.ihmc.pubsub.tools.ParticipantListenerImpl;
import us.ihmc.pubsub.tools.PublishSubscribeTools;
import us.ihmc.pubsub.tools.PublisherListenerImpl;
import us.ihmc.pubsub.tools.SubscriberListenerImpl;

public class PubSubTester<P extends Packet> {
    public Domain domain;
    public Subscriber subscriber;
    public Publisher publisher;
    public ArrayList<MessageCallback<P>> callbacks = new ArrayList();

    public PubSubTester(Supplier<P> msgTypeSupplier) throws IOException {
        this(DomainFactory.PubSubImplementation.FAST_RTPS, msgTypeSupplier);
    }

    public PubSubTester(DomainFactory.PubSubImplementation pubSubImplementation, Supplier<P> msgTypeSupplier) throws IOException {
        this.domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)pubSubImplementation);
        this.domain.setLogLevel(LogLevel.INFO);
        ParticipantAttributes attributes = ParticipantAttributes.create().domainId(PublishSubscribeTools.systemDomain()).discoveryLeaseDuration(Time.Infinite).name("PubSubTester");
        Participant participant = this.domain.createParticipant(attributes, (ParticipantListener)new ParticipantListenerImpl());
        IDLElementTestPubSubType dataType = new IDLElementTestPubSubType();
        this.domain.registerType(participant, (TopicDataType)dataType);
        PublisherAttributes genericPublisherAttributes = ((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)PublisherAttributes.create().topicDataType((TopicDataType)dataType)).topicName("pubsubtest")).reliabilityKind(ReliabilityQosKindType.RELIABLE)).durabilityKind(DurabilityQosKindType.VOLATILE)).historyQosPolicyKind(HistoryQosKindType.KEEP_LAST)).historyDepth(1)).publishModeKind(PublishModeQosKindType.ASYNCHRONOUS);
        Packet data = (Packet)msgTypeSupplier.get();
        TopicDataType topicDataType = (TopicDataType)data.getPubSubTypePacket().get();
        SubscriberAttributes subscriberAttributes = (SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)SubscriberAttributes.create().topicDataType(topicDataType)).topicName("pubsubtest")).reliabilityKind(ReliabilityQosKindType.RELIABLE)).durabilityKind(DurabilityQosKindType.VOLATILE)).historyQosPolicyKind(HistoryQosKindType.KEEP_ALL);
        this.subscriber = this.domain.createSubscriber(participant, subscriberAttributes, new SubscriberListenerImpl<Packet>(data, this.callbacks));
        this.publisher = this.domain.createPublisher(participant, genericPublisherAttributes, (PublisherListener)new PublisherListenerImpl());
    }
}

