/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs.postProcessing;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.pathPlanning.bodyPathPlanner.BodyPathPlannerTools;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.DefaultVisibilityGraphParameters;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.postProcessing.PathOrientationCalculator;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.AngleTools;

public class PathOrientationCalculatorTest {
    @Test
    public void testStraightForward() {
        int i;
        Quaternion zeroOrientation;
        DefaultVisibilityGraphParameters visibilityGraphsParametersBasics = new DefaultVisibilityGraphParameters();
        PathOrientationCalculator pathOrientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)visibilityGraphsParametersBasics);
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        points.add(new Point3D());
        points.add(new Point3D(0.5, 0.0, 0.0));
        Quaternion startOrientation = zeroOrientation = new Quaternion();
        Quaternion goalOrientation = zeroOrientation;
        List poses = pathOrientationCalculator.computePosesFromPath(points, null, (Orientation3DReadOnly)startOrientation, (Orientation3DReadOnly)goalOrientation);
        Assert.assertEquals((long)2L, (long)poses.size());
        for (i = 0; i < poses.size(); ++i) {
            Assert.assertTrue((zeroOrientation.distance((Orientation3DReadOnly)((Pose3DReadOnly)poses.get(i)).getOrientation()) < 1.0E-5 ? 1 : 0) != 0);
        }
        points.add(new Point3D(1.0, 0.0, 0.0));
        poses = pathOrientationCalculator.computePosesFromPath(points, null, (Orientation3DReadOnly)startOrientation, (Orientation3DReadOnly)goalOrientation);
        Assert.assertEquals((long)3L, (long)poses.size());
        for (i = 0; i < poses.size(); ++i) {
            Assert.assertTrue((zeroOrientation.distance((Orientation3DReadOnly)((Pose3DReadOnly)poses.get(i)).getOrientation()) < 1.0E-5 ? 1 : 0) != 0);
        }
        points.clear();
        points.add(new Point3D());
        points.add(new Point3D(3.0, 0.0, 0.0));
        points.add(new Point3D(6.0, 0.0, 0.0));
        poses = pathOrientationCalculator.computePosesFromPath(points, null, (Orientation3DReadOnly)startOrientation, (Orientation3DReadOnly)goalOrientation);
        Assert.assertEquals((long)3L, (long)poses.size());
        for (i = 0; i < poses.size(); ++i) {
            Assert.assertTrue((zeroOrientation.distance((Orientation3DReadOnly)((Pose3DReadOnly)poses.get(i)).getOrientation()) < 1.0E-5 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testStraightForwardWithHeightChange() {
        int i;
        Quaternion zeroOrientation;
        DefaultVisibilityGraphParameters visibilityGraphsParametersBasics = new DefaultVisibilityGraphParameters();
        PathOrientationCalculator pathOrientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)visibilityGraphsParametersBasics);
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        points.add(new Point3D());
        points.add(new Point3D(0.5, 0.0, 0.5));
        Quaternion startOrientation = zeroOrientation = new Quaternion();
        Quaternion goalOrientation = zeroOrientation;
        List poses = pathOrientationCalculator.computePosesFromPath(points, null, (Orientation3DReadOnly)startOrientation, (Orientation3DReadOnly)goalOrientation);
        Assert.assertEquals((long)2L, (long)poses.size());
        for (i = 0; i < poses.size(); ++i) {
            Assert.assertTrue((zeroOrientation.distance((Orientation3DReadOnly)((Pose3DReadOnly)poses.get(i)).getOrientation()) < 1.0E-5 ? 1 : 0) != 0);
        }
        points.add(new Point3D(1.0, 0.0, 0.5));
        poses = pathOrientationCalculator.computePosesFromPath(points, null, (Orientation3DReadOnly)startOrientation, (Orientation3DReadOnly)goalOrientation);
        Assert.assertEquals((long)3L, (long)poses.size());
        for (i = 0; i < poses.size(); ++i) {
            Assert.assertTrue((zeroOrientation.distance((Orientation3DReadOnly)((Pose3DReadOnly)poses.get(i)).getOrientation()) < 1.0E-5 ? 1 : 0) != 0);
        }
        points.clear();
        points.add(new Point3D());
        points.add(new Point3D(3.0, 0.0, 0.5));
        points.add(new Point3D(6.0, 0.0, 0.5));
        poses = pathOrientationCalculator.computePosesFromPath(points, null, (Orientation3DReadOnly)startOrientation, (Orientation3DReadOnly)goalOrientation);
        Assert.assertEquals((long)3L, (long)poses.size());
        for (i = 0; i < poses.size(); ++i) {
            Assert.assertTrue((zeroOrientation.distance((Orientation3DReadOnly)((Pose3DReadOnly)poses.get(i)).getOrientation()) < 1.0E-5 ? 1 : 0) != 0);
        }
        points.clear();
        points.add(new Point3D());
        points.add(new Point3D(2.9, 0.0, 0.0));
        points.add(new Point3D(3.0, 0.0, 0.5));
        points.add(new Point3D(6.0, 0.0, 0.5));
        poses = pathOrientationCalculator.computePosesFromPath(points, null, (Orientation3DReadOnly)startOrientation, (Orientation3DReadOnly)goalOrientation);
        Assert.assertEquals((long)4L, (long)poses.size());
        for (i = 0; i < poses.size(); ++i) {
            Assert.assertTrue((zeroOrientation.distance((Orientation3DReadOnly)((Pose3DReadOnly)poses.get(i)).getOrientation()) < 1.0E-5 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testStepUpPlatform() {
        int i;
        DefaultVisibilityGraphParameters visibilityGraphsParametersBasics = new DefaultVisibilityGraphParameters();
        PathOrientationCalculator pathOrientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)visibilityGraphsParametersBasics);
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        points.add(new Point3D(6.774, 0.046, -1.0));
        points.add(new Point3D(6.412, 0.046, -1.0));
        points.add(new Point3D(6.05, 0.046, -1.0));
        points.add(new Point3D(5.98, 0.046, -0.8));
        points.add(new Point3D(5.515, 0.046, -0.8));
        points.add(new Point3D(5.283, 0.046, -0.8));
        points.add(new Point3D(5.05, 0.046, -0.8));
        points.add(new Point3D(4.98, 0.046, -0.6));
        points.add(new Point3D(4.515, 0.046, -0.6));
        Quaternion zeroOrientation = new Quaternion();
        zeroOrientation.setYawPitchRoll(Math.PI, 0.0, 0.0);
        Quaternion startOrientation = zeroOrientation;
        Quaternion goalOrientation = zeroOrientation;
        List poses = pathOrientationCalculator.computePosesFromPath(points, null, (Orientation3DReadOnly)startOrientation, (Orientation3DReadOnly)goalOrientation);
        Assert.assertEquals((long)9L, (long)poses.size());
        Assert.assertTrue((((Pose3DReadOnly)poses.get(0)).getOrientation().distance((Orientation3DReadOnly)zeroOrientation) < 1.0E-5 ? 1 : 0) != 0);
        Assert.assertTrue((((Pose3DReadOnly)poses.get(poses.size() - 1)).getOrientation().distance((Orientation3DReadOnly)zeroOrientation) < 1.0E-5 ? 1 : 0) != 0);
        for (i = 0; i < poses.size(); ++i) {
            double actualYaw = ((Pose3DReadOnly)poses.get(i)).getOrientation().getYaw();
            double desiredYaw = zeroOrientation.getYaw();
            String errorMessage = "pose" + i + " had yaw " + actualYaw + ", but should have been " + desiredYaw;
            Assert.assertTrue((String)errorMessage, (Math.abs(AngleTools.computeAngleDifferenceMinusPiToPi((double)actualYaw, (double)desiredYaw)) < 1.0E-5 ? 1 : 0) != 0);
        }
        points.clear();
        points.add(new Point3D(6.774, 0.046, -1.0));
        points.add(new Point3D(6.412, 0.106, -1.0));
        points.add(new Point3D(6.05, 0.167, -1.0));
        points.add(new Point3D(5.98, 0.096, -0.8));
        points.add(new Point3D(5.515, 0.131, -0.8));
        points.add(new Point3D(5.283, 0.149, -0.8));
        points.add(new Point3D(5.05, 0.167, -0.8));
        points.add(new Point3D(4.98, 0.096, -0.6));
        points.add(new Point3D(4.515, 0.131, -0.6));
        poses = pathOrientationCalculator.computePosesFromPath(points, null, (Orientation3DReadOnly)startOrientation, (Orientation3DReadOnly)goalOrientation);
        Assert.assertEquals((long)11L, (long)poses.size());
        Assert.assertTrue((((Pose3DReadOnly)poses.get(0)).getOrientation().distance((Orientation3DReadOnly)zeroOrientation) < 1.0E-5 ? 1 : 0) != 0);
        Assert.assertTrue((((Pose3DReadOnly)poses.get(poses.size() - 1)).getOrientation().distance((Orientation3DReadOnly)zeroOrientation) < 1.0E-5 ? 1 : 0) != 0);
        for (i = 1; i < poses.size() - 1; ++i) {
            double previousHeading = BodyPathPlannerTools.calculateHeading((Point3DReadOnly)((Pose3DReadOnly)poses.get(i - 1)).getPosition(), (Point3DReadOnly)((Pose3DReadOnly)poses.get(i)).getPosition());
            if (i == 1) {
                previousHeading = zeroOrientation.getYaw();
            }
            double nextHeading = BodyPathPlannerTools.calculateHeading((Point3DReadOnly)((Pose3DReadOnly)poses.get(i)).getPosition(), (Point3DReadOnly)((Pose3DReadOnly)poses.get(i + 1)).getPosition());
            double desiredOrientation = AngleTools.interpolateAngle((double)previousHeading, (double)nextHeading, (double)0.5);
            double actualYaw = ((Pose3DReadOnly)poses.get(i)).getOrientation().getYaw();
            String errorMessage = "pose" + i + " had yaw " + actualYaw + ", but should have been " + desiredOrientation;
            Assert.assertTrue((String)errorMessage, (Math.abs(AngleTools.computeAngleDifferenceMinusPiToPi((double)actualYaw, (double)desiredOrientation)) < 1.0E-5 ? 1 : 0) != 0);
        }
    }
}

