/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs;

import java.awt.Color;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import us.ihmc.commons.ContinuousIntegrationTools;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.GraphicsUpdatable;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPolygon;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.pathPlanning.visibilityGraphs.NavigableRegionsManager;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.DefaultVisibilityGraphParameters;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionTools;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.geometry.PlanarRegionsListGenerator;
import us.ihmc.robotics.geometry.SpiralBasedAlgorithm;
import us.ihmc.robotics.graphics.Graphics3DObjectTools;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.util.simulationTesting.SimulationTestingParameters;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class VisibilityGraphsOcclusionTest {
    private static final DefaultVisibilityGraphParameters VISIBILITY_GRAPH_PARAMETERS = new DefaultVisibilityGraphParameters(){

        public int getPlanarRegionMinSize() {
            return 0;
        }
    };
    private static final boolean VERBOSE = false;
    private static final SimulationTestingParameters simulationTestingParameters = SimulationTestingParameters.createFromSystemProperties();
    private boolean visualize = false;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int rays = 5000;
    private static final double rayLengthSquared = MathTools.square((double)5.0);
    private static final int maxPolygonsToVisualize = 10;
    private static final int maxPolygonsVertices = 100;
    private static final double defaultMaxAllowedSolveTime = 3.0;
    private static final int bodyPathVisualizationResolution = 500;
    private static final double defaultMarchingSpeedInMetersPerTick = 0.5;
    private static final double maximumFlyingDistance = 0.05;
    private static final int maxNumberOfIterations = 40;

    @BeforeEach
    public void setup() {
        this.visualize = this.visualize && !ContinuousIntegrationTools.isRunningOnContinuousIntegrationServer();
    }

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testFlatGround(TestInfo testInfo) {
        Point3D startPose = new Point3D();
        Point3D goalPose = new Point3D();
        PlanarRegionsList regions = this.createFlatGround(startPose, goalPose);
        this.runTest(testInfo, startPose, goalPose, regions, OcclusionMethod.OCCLUSION, 3.0, 3.0);
    }

    @Test
    public void testFlatGroundWithWall(TestInfo testInfo) {
        Point3D startPose = new Point3D(-4.805, 0.001, 0.0);
        Point3D goalPose = new Point3D(4.805, 0.001, 0.0);
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.addRectangle(10.0, 5.0);
        generator.translate(0.0, 0.0, 1.0);
        generator.rotate(1.5707963267948966, Axis3D.Y);
        generator.rotate(1.5707963267948966, Axis3D.Z);
        generator.addRectangle(3.0, 2.0);
        PlanarRegionsList regions = generator.getPlanarRegionsList();
        this.runTest(testInfo, startPose, goalPose, regions, OcclusionMethod.OCCLUSION, 3.0);
    }

    @Test
    public void testSimpleOcclusions(TestInfo testInfo) {
        Point3D startPose = new Point3D();
        Point3D goalPose = new Point3D();
        PlanarRegionsList regions = this.createSimpleOcclusionField(startPose, goalPose);
        this.runTest(testInfo, startPose, goalPose, regions, OcclusionMethod.OCCLUSION_PLUS_GROUND, 3.0);
    }

    @Test
    public void testMazeWithOcclusions(TestInfo testInfo) {
        Point3D startPose = new Point3D();
        Point3D goalPose = new Point3D();
        PlanarRegionsList regions = this.createMazeOcclusionField(startPose, goalPose);
        this.runTest(testInfo, startPose, goalPose, regions, OcclusionMethod.OCCLUSION_PLUS_GROUND, 3.0);
    }

    @Test
    public void testCrazyBridgeEnvironment(TestInfo testInfo) {
        Point3D startPose = new Point3D(0.4, 0.5, 0.001);
        Point3D goalPose = new Point3D(8.5, -3.5, 0.01);
        PlanarRegionsList regions = VisibilityGraphsOcclusionTest.createBodyPathPlannerTestEnvironment();
        this.runTest(testInfo, startPose, goalPose, regions, OcclusionMethod.NO_OCCLUSION, 3.0, 0.2);
    }

    private void runTest(TestInfo testInfo, Point3D start, Point3D goal, PlanarRegionsList regions, OcclusionMethod occlusionMethod, double maxAllowedSolveTime) {
        this.runTest(testInfo, start, goal, regions, occlusionMethod, maxAllowedSolveTime, 0.5);
    }

    private void runTest(TestInfo testInfo, Point3D start, Point3D goal, PlanarRegionsList regions, OcclusionMethod occlusionMethod, double maxAllowedSolveTime, double marchingSpeedInMetersPerTick) {
        YoRegistry registry = new YoRegistry(((Method)testInfo.getTestMethod().get()).getName());
        YoGraphicsListRegistry graphicsListRegistry = new YoGraphicsListRegistry();
        NavigableRegionsManager vizGraphs = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)VISIBILITY_GRAPH_PARAMETERS);
        SimulationConstructionSet scs = null;
        YoFramePoint3D currentPosition = new YoFramePoint3D("CurrentPosition", worldFrame, registry);
        currentPosition.set((Tuple3DReadOnly)start);
        YoFramePoint3D observerPoint = null;
        ArrayList<YoFramePoint3D> rayIntersectionVisualizations = null;
        ArrayList<YoFrameConvexPolygon2D> visiblePolygons = null;
        ArrayList<YoFramePoseUsingYawPitchRoll> visiblePolygonPoses = null;
        ArrayList<YoGraphicPolygon> polygonVisualizations = null;
        BagOfBalls bodyPathViz = null;
        BagOfBalls bodyPathWaypointsViz = null;
        YoBoolean plannerFailed = new YoBoolean("PlannerFailed", registry);
        YoDouble solveTime = new YoDouble("SolveTime", registry);
        if (this.visualize) {
            int i;
            YoFramePoint3D yoStart = new YoFramePoint3D("start", worldFrame, registry);
            yoStart.set((Tuple3DReadOnly)start);
            YoFramePoint3D yoGoal = new YoFramePoint3D("goal", worldFrame, registry);
            yoGoal.set((Tuple3DReadOnly)start);
            visiblePolygons = new ArrayList<YoFrameConvexPolygon2D>();
            visiblePolygonPoses = new ArrayList<YoFramePoseUsingYawPitchRoll>();
            polygonVisualizations = new ArrayList<YoGraphicPolygon>();
            for (i = 0; i < 10; ++i) {
                YoFrameConvexPolygon2D polygon = new YoFrameConvexPolygon2D("Polygon" + i, worldFrame, 100, registry);
                YoFramePoseUsingYawPitchRoll pose = new YoFramePoseUsingYawPitchRoll("PolygonPose" + i, worldFrame, registry);
                pose.setToNaN();
                visiblePolygons.add(polygon);
                visiblePolygonPoses.add(pose);
                YoGraphicPolygon visualization = new YoGraphicPolygon("Polygon" + i, polygon, pose.getPosition(), pose.getYawPitchRoll(), 1.0, 0.02, (AppearanceDefinition)new YoAppearanceRGBColor(Color.BLUE, 0.8));
                polygonVisualizations.add(visualization);
                graphicsListRegistry.registerYoGraphic("viz", (YoGraphic)visualization);
                graphicsListRegistry.registerGraphicsUpdatableToUpdateInAPlaybackListener((GraphicsUpdatable)visualization);
            }
            if (occlusionMethod != OcclusionMethod.NO_OCCLUSION) {
                rayIntersectionVisualizations = new ArrayList<YoFramePoint3D>();
                for (i = 0; i < 5000; ++i) {
                    YoFramePoint3D point = new YoFramePoint3D("RayIntersection" + i, ReferenceFrame.getWorldFrame(), registry);
                    point.setToNaN();
                    YoGraphicPosition visualization = new YoGraphicPosition("RayIntersection" + i, point, 0.0025, YoAppearance.Blue());
                    rayIntersectionVisualizations.add(point);
                    graphicsListRegistry.registerYoGraphic("viz", (YoGraphic)visualization);
                }
            }
            observerPoint = new YoFramePoint3D("Observer", worldFrame, registry);
            observerPoint.setToNaN();
            YoGraphicPosition observerVisualization = new YoGraphicPosition("Observer", observerPoint, 0.05, YoAppearance.Red());
            graphicsListRegistry.registerYoGraphic("viz", (YoGraphic)observerVisualization);
            YoGraphicPosition currentPositionVisualization = new YoGraphicPosition("CurrentPosition", currentPosition, 0.05, YoAppearance.Blue());
            graphicsListRegistry.registerYoGraphic("viz", (YoGraphic)currentPositionVisualization);
            bodyPathViz = new BagOfBalls(500, 0.01, "bodyPath", registry, graphicsListRegistry);
            bodyPathWaypointsViz = new BagOfBalls(100, 0.025, YoAppearance.Yellow(), registry, graphicsListRegistry);
            scs = VisibilityGraphsOcclusionTest.setupSCS(((Method)testInfo.getTestMethod().get()).getName(), registry, regions, start, goal);
            scs.addYoGraphicsListRegistry(graphicsListRegistry);
            scs.setInPoint();
            scs.startOnAThread();
        }
        double maxSolveTime = 0.0;
        PlanarRegionsList visiblePlanarRegions = switch (occlusionMethod) {
            case OcclusionMethod.OCCLUSION -> new PlanarRegionsList();
            case OcclusionMethod.OCCLUSION_PLUS_GROUND -> new PlanarRegionsList(new PlanarRegion[]{regions.getPlanarRegion(0)});
            case OcclusionMethod.NO_OCCLUSION -> regions;
            default -> throw new RuntimeException("Unhandled occlusion method: " + occlusionMethod);
        };
        int iteration = -1;
        while (!currentPosition.epsilonEquals((EuclidGeometry)goal, 0.001)) {
            List bodyPath;
            block27: {
                if (++iteration > 40) {
                    PrintTools.info((String)"Too many iterations too reach goal.");
                    break;
                }
                Point3D observer = new Point3D((Tuple3DReadOnly)currentPosition);
                observer.addZ(0.05);
                if (occlusionMethod != OcclusionMethod.NO_OCCLUSION) {
                    visiblePlanarRegions = this.createVisibleRegions(regions, observer, visiblePlanarRegions, rayIntersectionVisualizations);
                }
                if (this.visualize) {
                    observerPoint.set((Tuple3DReadOnly)observer);
                    for (int polygonIdx = 0; polygonIdx < 10; ++polygonIdx) {
                        ((YoFramePoseUsingYawPitchRoll)visiblePolygonPoses.get(polygonIdx)).setToNaN();
                    }
                    int polygons = Math.min(10, visiblePlanarRegions.getNumberOfPlanarRegions());
                    RigidBodyTransform transformToWorld = new RigidBodyTransform();
                    FramePose3D pose = new FramePose3D();
                    for (int polygonIdx = 0; polygonIdx < polygons; ++polygonIdx) {
                        PlanarRegion planarRegion = visiblePlanarRegions.getPlanarRegion(polygonIdx);
                        if (planarRegion.getConvexHull().getNumberOfVertices() > ((YoFrameConvexPolygon2D)visiblePolygons.get(polygonIdx)).getMaxNumberOfVertices()) {
                            throw new RuntimeException("Increase max number of vertices for visualization.");
                        }
                        planarRegion.getTransformToWorld(transformToWorld);
                        pose.set((RigidBodyTransformReadOnly)transformToWorld);
                        ((YoFramePoseUsingYawPitchRoll)visiblePolygonPoses.get(polygonIdx)).set((FramePose3DReadOnly)pose);
                        ((YoFrameConvexPolygon2D)visiblePolygons.get(polygonIdx)).set((Vertex2DSupplier)planarRegion.getConvexHull());
                    }
                }
                vizGraphs.setPlanarRegions(visiblePlanarRegions.getPlanarRegionsAsList());
                bodyPath = null;
                try {
                    long startTime = System.currentTimeMillis();
                    bodyPath = vizGraphs.calculateBodyPath((Point3DReadOnly)currentPosition, (Point3DReadOnly)goal);
                    double seconds = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                    solveTime.set(seconds);
                    if (seconds > maxSolveTime) {
                        maxSolveTime = seconds;
                    }
                    if (bodyPath != null) break block27;
                    PrintTools.info((String)"Planner failed: body path is null.");
                    plannerFailed.set(true);
                }
                catch (Exception e) {
                    PrintTools.info((String)"Planner threw exception:");
                    e.printStackTrace();
                    plannerFailed.set(true);
                    break;
                }
            }
            if (((Point3DReadOnly)bodyPath.get(bodyPath.size() - 1)).distanceXY((Point3DReadOnly)goal) > 0.001 || !MathTools.epsilonEquals((double)((Point3DReadOnly)bodyPath.get(bodyPath.size() - 1)).getZ(), (double)goal.getZ(), (double)0.1)) {
                if (this.visualize) {
                    scs.setTime((double)iteration);
                    scs.tickAndUpdate();
                }
                PrintTools.info((String)("Failed, not going to the goal: " + goal + ", end of plan: " + bodyPath.get(bodyPath.size() - 1)));
                plannerFailed.set(true);
            }
            if (((Point3DReadOnly)bodyPath.get(0)).distanceXY((Point3DReadOnly)currentPosition) > 0.001 || !MathTools.epsilonEquals((double)((Point3DReadOnly)bodyPath.get(0)).getZ(), (double)currentPosition.getZ(), (double)0.1)) {
                if (this.visualize) {
                    scs.setTime((double)iteration);
                    scs.tickAndUpdate();
                }
                PrintTools.info((String)("Failed, not starting from current position: " + new Point3D((Tuple3DReadOnly)currentPosition) + ", beginning of plan: " + bodyPath.get(0)));
                plannerFailed.set(true);
            }
            if (currentPosition.distance((Point3DReadOnly)goal) < 0.05 && bodyPath.size() > 2) {
                PrintTools.info((String)("Start is next to goal, should be a straight line but had: " + bodyPath.size() + " waypoints."));
                plannerFailed.set(true);
            }
            if (plannerFailed.getBooleanValue()) break;
            if (this.visualize) {
                VisibilityGraphsOcclusionTest.visualizeBodyPath(bodyPath, bodyPathViz);
                bodyPathWaypointsViz.hideAll();
                bodyPath.forEach(arg_0 -> ((BagOfBalls)bodyPathWaypointsViz).setBall(arg_0));
                scs.setTime((double)iteration);
                scs.tickAndUpdate();
            }
            currentPosition.set((Tuple3DReadOnly)bodyPath.get(0));
            currentPosition.set((Tuple3DReadOnly)VisibilityGraphsOcclusionTest.travelAlongBodyPath(marchingSpeedInMetersPerTick, (Point3DReadOnly)currentPosition, bodyPath));
            if (regions.findPlanarRegionsContainingPoint((Point3DReadOnly)currentPosition, 0.05) != null || regions.findPlanarRegionsContainingPointByProjectionOntoXYPlane(currentPosition.getX(), currentPosition.getY()) == null) continue;
            PrintTools.info((String)"Planner failed: path results in a flying robot.");
            plannerFailed.set(true);
            break;
        }
        PrintTools.info((String)("Maximum solve time was " + maxSolveTime + "s."));
        if (this.visualize) {
            scs.setOutPoint();
            scs.cropBuffer();
            scs.setPlaybackRealTimeRate(0.001);
            scs.play();
            ThreadTools.sleepForever();
        } else {
            Assert.assertTrue((String)("Planner took too long: " + maxSolveTime + "s, should be less than " + maxAllowedSolveTime + " s."), (maxSolveTime < maxAllowedSolveTime ? 1 : 0) != 0);
            Assert.assertFalse((String)("Planner failed at iteration: " + iteration), (boolean)plannerFailed.getBooleanValue());
        }
    }

    private static void visualizeBodyPath(List<Point3DReadOnly> bodyPath, BagOfBalls vizToUpdate) {
        int numberOfBalls = vizToUpdate.getNumberOfBalls();
        double bodyPathLength = 0.0;
        for (int i = 0; i < bodyPath.size() - 1; ++i) {
            bodyPathLength += bodyPath.get(i).distance(bodyPath.get(i + 1));
        }
        double distanceToTravel = bodyPathLength / ((double)numberOfBalls - 1.0);
        Point3D position = new Point3D((Tuple3DReadOnly)bodyPath.get(0));
        vizToUpdate.setBall((Point3DReadOnly)position);
        for (int i = 0; i < numberOfBalls - 1; ++i) {
            position = VisibilityGraphsOcclusionTest.travelAlongBodyPath(distanceToTravel, (Point3DReadOnly)position, bodyPath);
            vizToUpdate.setBall((Point3DReadOnly)position, i);
        }
    }

    private static Point3D travelAlongBodyPath(double distanceToTravel, Point3DReadOnly startingPosition, List<Point3DReadOnly> bodyPath) {
        Point3D newPosition = new Point3D();
        for (int i = 0; i < bodyPath.size() - 1; ++i) {
            LineSegment3D segment = new LineSegment3D(bodyPath.get(i), bodyPath.get(i + 1));
            if (!(segment.distance(startingPosition) < 1.0E-4)) continue;
            Vector3DBasics segmentDirection = segment.getDirection(true);
            newPosition.scaleAdd(distanceToTravel, (Tuple3DReadOnly)segmentDirection, (Tuple3DReadOnly)startingPosition);
            if (segment.distance((Point3DReadOnly)newPosition) < 1.0E-4) {
                return newPosition;
            }
            distanceToTravel -= startingPosition.distance((Point3DReadOnly)segment.getSecondEndpoint());
            startingPosition = new Point3D((Tuple3DReadOnly)segment.getSecondEndpoint());
        }
        return new Point3D((Tuple3DReadOnly)startingPosition);
    }

    private static SimulationConstructionSet setupSCS(String testName, YoRegistry testRegistry, PlanarRegionsList regions, Point3D start, Point3D goal) {
        Robot robot = new Robot(VisibilityGraphsOcclusionTest.class.getSimpleName());
        robot.addYoRegistry(testRegistry);
        SimulationConstructionSet scs = new SimulationConstructionSet(robot, (SimulationConstructionSetParameters)simulationTestingParameters);
        Graphics3DObject graphics3DObject = new Graphics3DObject();
        graphics3DObject.addCoordinateSystem(0.8);
        if (regions != null) {
            Graphics3DObjectTools.addPlanarRegionsList((Graphics3DObject)graphics3DObject, (PlanarRegionsList)regions, (AppearanceDefinition[])new AppearanceDefinition[]{YoAppearance.White(), YoAppearance.Grey(), YoAppearance.DarkGray()});
            scs.setGroundVisible(false);
        }
        graphics3DObject.identity();
        graphics3DObject.translate((Tuple3DReadOnly)start);
        graphics3DObject.translate(0.0, 0.0, 0.05);
        graphics3DObject.addCone(0.3, 0.05, YoAppearance.Green());
        graphics3DObject.identity();
        graphics3DObject.translate((Tuple3DReadOnly)goal);
        graphics3DObject.translate(0.0, 0.0, 0.05);
        graphics3DObject.addCone(0.3, 0.05, YoAppearance.Red());
        scs.addStaticLinkGraphics(graphics3DObject);
        scs.setCameraPosition(-7.0, -1.0, 25.0);
        scs.setCameraFix(0.0, 0.0, 0.0);
        return scs;
    }

    private PlanarRegionsList createVisibleRegions(PlanarRegionsList regions, Point3D observer, PlanarRegionsList knownRegions, List<YoFramePoint3D> rayPointsToPack) {
        Point3D[] pointsOnSphere = SpiralBasedAlgorithm.generatePointsOnSphere((Point3DReadOnly)observer, (double)1.0, (int)5000);
        ArrayList<ConvexPolygon2D> visiblePolygons = new ArrayList<ConvexPolygon2D>();
        for (int i = 0; i < regions.getNumberOfPlanarRegions(); ++i) {
            visiblePolygons.add(new ConvexPolygon2D());
        }
        RigidBodyTransform transform = new RigidBodyTransform();
        for (int rayIndex = 0; rayIndex < 5000; ++rayIndex) {
            Point3D pointOnSphere = pointsOnSphere[rayIndex];
            Vector3D rayDirection = new Vector3D();
            rayDirection.sub((Tuple3DReadOnly)pointOnSphere, (Tuple3DReadOnly)observer);
            ImmutablePair intersectionPair = PlanarRegionTools.intersectRegionsWithRay((PlanarRegionsList)regions, (Point3DReadOnly)observer, (Vector3D)rayDirection);
            if (intersectionPair == null || ((Point3D)intersectionPair.getLeft()).distanceSquared((Point3DReadOnly)observer) > rayLengthSquared) {
                if (rayPointsToPack == null) continue;
                rayPointsToPack.get(rayIndex).setToNaN();
                continue;
            }
            Point3D intersection = (Point3D)intersectionPair.getLeft();
            if (rayPointsToPack != null) {
                rayPointsToPack.get(rayIndex).set((Tuple3DReadOnly)intersection);
            }
            for (int regionIdx = 0; regionIdx < regions.getNumberOfPlanarRegions(); ++regionIdx) {
                PlanarRegion region = regions.getPlanarRegion(regionIdx);
                if (!PlanarRegionTools.isPointOnRegion((PlanarRegion)region, (Point3D)intersection, (double)0.01)) continue;
                region.getTransformToWorld(transform);
                Point3D pointOnPlane = new Point3D((Tuple3DReadOnly)intersection);
                pointOnPlane.applyInverseTransform((Transform)transform);
                Point2D newVertex = new Point2D();
                newVertex.set((Tuple3DReadOnly)pointOnPlane);
                ((ConvexPolygon2D)visiblePolygons.get(regionIdx)).addVertex((Point2DReadOnly)newVertex);
            }
        }
        PlanarRegionsList visible = new PlanarRegionsList();
        for (int i = 0; i < visiblePolygons.size(); ++i) {
            ConvexPolygon2D polygon = (ConvexPolygon2D)visiblePolygons.get(i);
            polygon.update();
            if (polygon.getNumberOfVertices() < 2) continue;
            PlanarRegion originalRegion = regions.getPlanarRegion(i);
            originalRegion.getTransformToWorld(transform);
            PlanarRegion newRegion = new PlanarRegion((RigidBodyTransformReadOnly)transform, (Vertex2DSupplier)polygon);
            visible.addPlanarRegion(newRegion);
        }
        return this.combine(knownRegions, visible);
    }

    private PlanarRegionsList combine(PlanarRegionsList regionsA, PlanarRegionsList regionsB) {
        PlanarRegionsList ret = new PlanarRegionsList();
        boolean[] added = new boolean[regionsB.getNumberOfPlanarRegions()];
        for (int regionBIdx = 0; regionBIdx < regionsB.getNumberOfPlanarRegions(); ++regionBIdx) {
            added[regionBIdx] = false;
        }
        for (PlanarRegion regionA : regionsA.getPlanarRegionsAsList()) {
            RigidBodyTransform transformA = new RigidBodyTransform();
            regionA.getTransformToWorld(transformA);
            boolean foundMatchingRegion = false;
            for (int regionBIdx = 0; regionBIdx < regionsB.getNumberOfPlanarRegions(); ++regionBIdx) {
                PlanarRegion regionB = regionsB.getPlanarRegion(regionBIdx);
                RigidBodyTransform transformB = new RigidBodyTransform();
                regionB.getTransformToWorld(transformB);
                if (!transformA.epsilonEquals((EuclidGeometry)transformB, 0.01)) continue;
                ConvexPolygon2D newHull = new ConvexPolygon2D((Vertex2DSupplier)regionA.getConvexHull(), (Vertex2DSupplier)regionB.getConvexHull());
                ret.addPlanarRegion(new PlanarRegion((RigidBodyTransformReadOnly)transformA, (Vertex2DSupplier)newHull));
                foundMatchingRegion = true;
                added[regionBIdx] = true;
            }
            if (foundMatchingRegion) continue;
            ret.addPlanarRegion(new PlanarRegion((RigidBodyTransformReadOnly)transformA, (Vertex2DSupplier)new ConvexPolygon2D((Vertex2DSupplier)regionA.getConvexHull())));
        }
        for (int regionBIdx = 0; regionBIdx < regionsB.getNumberOfPlanarRegions(); ++regionBIdx) {
            if (added[regionBIdx]) continue;
            ret.addPlanarRegion(regionsB.getPlanarRegion(regionBIdx));
        }
        return ret;
    }

    private PlanarRegionsList createFlatGround(Point3D startPoseToPack, Point3D goalPoseToPack) {
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.addRectangle(50.0, 5.0);
        startPoseToPack.set(-18.005, -2.001, 0.0);
        goalPoseToPack.set(18.005, 2.001, 0.0);
        return generator.getPlanarRegionsList();
    }

    private PlanarRegionsList createSimpleOcclusionField(Point3D startPoseToPack, Point3D goalPoseToPack) {
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.addRectangle(6.0, 6.0);
        generator.translate(-1.0, -1.0, 0.5);
        generator.rotate(-1.5707963267948966, Axis3D.Y);
        generator.addRectangle(1.0, 4.0);
        generator.identity();
        generator.translate(1.0, 1.0, 0.5);
        generator.rotate(-1.5707963267948966, Axis3D.Y);
        generator.addRectangle(1.0, 4.0);
        startPoseToPack.set(-2.0, -2.0, 0.0);
        goalPoseToPack.set(2.0, 2.0, 0.0);
        return generator.getPlanarRegionsList();
    }

    private PlanarRegionsList createMazeOcclusionField(Point3D startPoseToPack, Point3D goalPoseToPack) {
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.rotate(Math.toRadians(10.0), Axis3D.X);
        generator.addRectangle(6.0, 12.0);
        generator.identity();
        generator.rotate(Math.toRadians(10.0), Axis3D.X);
        generator.translate(-1.0, -2.0, 0.5);
        generator.rotate(-1.5707963267948966, Axis3D.Y);
        generator.addRectangle(1.0, 8.0);
        generator.identity();
        generator.rotate(Math.toRadians(10.0), Axis3D.X);
        generator.translate(1.0, 0.0, 0.5);
        generator.rotate(-1.5707963267948966, Axis3D.Y);
        generator.addRectangle(1.0, 8.0);
        generator.identity();
        generator.rotate(Math.toRadians(10.0), Axis3D.X);
        generator.translate(0.0, -4.0, 0.5);
        generator.rotate(-1.5707963267948966, Axis3D.X);
        generator.addRectangle(2.0, 1.0);
        generator.identity();
        generator.rotate(Math.toRadians(10.0), Axis3D.X);
        generator.translate(0.0, 4.0, 0.5);
        generator.rotate(-1.5707963267948966, Axis3D.X);
        generator.addRectangle(2.0, 1.0);
        startPoseToPack.set(-2.0, -5.0, 0.0);
        RotationMatrixTools.applyRollRotation((double)Math.toRadians(10.0), (Tuple3DReadOnly)startPoseToPack, (Tuple3DBasics)startPoseToPack);
        goalPoseToPack.set(0.0, -5.0, 0.0);
        RotationMatrixTools.applyRollRotation((double)Math.toRadians(10.0), (Tuple3DReadOnly)goalPoseToPack, (Tuple3DBasics)goalPoseToPack);
        return generator.getPlanarRegionsList();
    }

    public static PlanarRegionsList createBodyPathPlannerTestEnvironment() {
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        double extrusionDistance = -0.05;
        generator.translate(1.0, 0.5, 0.0);
        generator.addRectangle(2.0 + extrusionDistance, 1.0 + extrusionDistance);
        generator.identity();
        generator.translate(2.5, -3.5, 0.0);
        generator.addRectangle(1.0 + extrusionDistance, 13.0 + extrusionDistance);
        generator.identity();
        double wallSeparation = 0.4;
        double wallWidth = 0.5;
        double wallHeight = 1.0;
        generator.translate(4.5, 2.5, 0.0);
        generator.addRectangle(3.0 + extrusionDistance, 1.0 + extrusionDistance);
        generator.rotate(1.5707963267948966, Axis3D.Y);
        generator.translate(-0.5 * wallHeight, 0.5 * (wallSeparation + wallWidth), 0.0);
        generator.addRectangle(wallHeight, wallWidth);
        generator.translate(0.0, -1.0 * (wallSeparation + wallWidth), 0.0);
        generator.addRectangle(wallHeight, wallWidth);
        generator.identity();
        generator.translate(3.5, 0.5, 0.5);
        generator.rotate(-0.7853981633974483, Axis3D.Y);
        generator.addRectangle(Math.sqrt(2.0), 1.0);
        generator.identity();
        generator.translate(4.5, 0.5, 1.0);
        generator.addRectangle(1.0 + extrusionDistance, 1.0 + extrusionDistance);
        generator.identity();
        generator.translate(5.5, 0.5, 0.5);
        generator.rotate(0.7853981633974483, Axis3D.Y);
        generator.addRectangle(Math.sqrt(2.0), 1.0);
        generator.identity();
        double stepDownHeight = 0.4;
        generator.translate(3.5, -1.5, 0.0);
        generator.addRectangle(1.0 + extrusionDistance, 1.0 + extrusionDistance);
        generator.translate(1.0, 0.0, -stepDownHeight);
        generator.addRectangle(1.0 + extrusionDistance, 1.0 + extrusionDistance);
        generator.translate(1.0, 0.0, stepDownHeight);
        generator.addRectangle(1.0 + extrusionDistance, 1.0 + extrusionDistance);
        generator.identity();
        double stepUpHeight = 0.4;
        generator.translate(3.5, -3.5, 0.0);
        generator.addRectangle(1.0 + extrusionDistance, 1.0 + extrusionDistance);
        generator.translate(1.0, 0.0, stepUpHeight);
        generator.addRectangle(1.0 + extrusionDistance, 1.0 + extrusionDistance);
        generator.translate(1.0, 0.0, -stepUpHeight);
        generator.addRectangle(1.0 + extrusionDistance, 1.0 + extrusionDistance);
        generator.identity();
        double barrierHeight = 1.5;
        double barrierWidth = 0.8;
        generator.translate(4.5, -5.5, 0.0);
        generator.addRectangle(3.0 + extrusionDistance, 1.0 + extrusionDistance);
        generator.translate(0.0, 0.0, 0.5 * barrierHeight);
        generator.rotate(1.5707963267948966, Axis3D.Y);
        generator.addRectangle(barrierHeight, barrierWidth);
        generator.identity();
        generator.translate(3.5, -7.5, 0.0);
        generator.addRectangle(1.0 + extrusionDistance, 1.0 + extrusionDistance);
        generator.translate(2.0, 0.0, 0.0);
        generator.addRectangle(1.0 + extrusionDistance, 1.0 + extrusionDistance);
        generator.identity();
        generator.translate(6.5, -3.5, 0.01);
        generator.addRectangle(1.0 + extrusionDistance, 13.0 + extrusionDistance);
        generator.identity();
        generator.translate(8.0, -3.5, 0.01);
        generator.addRectangle(2.0 + extrusionDistance, 1.0 + extrusionDistance);
        generator.identity();
        PlanarRegionsList obstacleCourse = generator.getPlanarRegionsList();
        generator.translate(4.5, -9.5, 2.5);
        generator.addRectangle(1.5, 0.8);
        generator.identity();
        wallSeparation = 0.9;
        wallWidth = 0.2;
        wallHeight = 1.0;
        generator.translate(3.0, -9.5, 0.0);
        generator.rotate(1.5707963267948966, Axis3D.Y);
        generator.translate(-0.5 * wallHeight, 0.5 * (wallSeparation + wallWidth), 0.0);
        generator.addRectangle(wallHeight, wallWidth);
        generator.translate(0.0, -1.0 * (wallSeparation + wallWidth), 0.0);
        generator.addRectangle(wallHeight, wallWidth);
        generator.identity();
        PlanarRegionsList cinderBlockField = VisibilityGraphsOcclusionTest.generateCinderBlockField(3.0, -9.5, 0.25, 0.2, 11, 4, 0.0);
        for (int i = 0; i < cinderBlockField.getNumberOfPlanarRegions(); ++i) {
            obstacleCourse.addPlanarRegion(cinderBlockField.getPlanarRegion(i));
        }
        return obstacleCourse;
    }

    public static PlanarRegionsList generateCinderBlockField(double startX, double startY, double cinderBlockSize, double cinderBlockHeight, int courseWidthXInNumberOfBlocks, int courseLengthYInNumberOfBlocks, double heightVariation) {
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        double courseWidth = (double)courseLengthYInNumberOfBlocks * cinderBlockSize;
        generator.translate(startX, startY, 0.001);
        generator.addRectangle(0.6, courseWidth);
        generator.translate(0.5, 0.0, 0.0);
        generator.translate(0.0, -0.5 * (double)(courseLengthYInNumberOfBlocks - 1) * cinderBlockSize, 0.0);
        Random random = new Random(1231239L);
        for (int x = 0; x < courseWidthXInNumberOfBlocks; ++x) {
            for (int y = 0; y < courseLengthYInNumberOfBlocks; ++y) {
                int angleType = Math.abs(random.nextInt() % 3);
                int axisType = Math.abs(random.nextInt() % 2);
                VisibilityGraphsOcclusionTest.generateSingleCiderBlock(generator, cinderBlockSize, cinderBlockHeight, angleType, axisType);
                generator.translate(0.0, cinderBlockSize, 0.0);
            }
            if (x / 2 % 2 == 0) {
                generator.translate(0.0, 0.0, heightVariation);
            } else {
                generator.translate(0.0, 0.0, -heightVariation);
            }
            generator.translate(cinderBlockSize, -cinderBlockSize * (double)courseLengthYInNumberOfBlocks, 0.0);
        }
        generator.identity();
        generator.translate(0.6 + (double)courseWidthXInNumberOfBlocks * cinderBlockSize, 0.0, 0.001);
        generator.addRectangle(0.6, courseWidth);
        return generator.getPlanarRegionsList();
    }

    public static void generateSingleCiderBlock(PlanarRegionsListGenerator generator, double cinderBlockSize, double cinderBlockHeight, int angleType, int axisType) {
        double angle = 0.0;
        switch (angleType) {
            case 0: {
                angle = 0.0;
                break;
            }
            case 1: {
                angle = Math.toRadians(15.0);
                break;
            }
            case 2: {
                angle = -Math.toRadians(15.0);
            }
        }
        Axis3D axis = null;
        switch (axisType) {
            case 0: {
                axis = Axis3D.X;
                break;
            }
            case 1: {
                axis = Axis3D.Y;
            }
        }
        generator.rotate(angle, axis);
        generator.addCubeReferencedAtBottomMiddle(cinderBlockSize, cinderBlockSize, cinderBlockHeight);
        generator.rotate(-angle, axis);
    }

    private static enum OcclusionMethod {
        OCCLUSION,
        OCCLUSION_PLUS_GROUND,
        NO_OCCLUSION;

    }
}

