/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.ContinuousIntegrationTools;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.thread.Notification;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.Ellipsoid3D;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.log.LogTools;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.pathPlanning.DataSet;
import us.ihmc.pathPlanning.DataSetIOTools;
import us.ihmc.pathPlanning.DataSetName;
import us.ihmc.pathPlanning.PlannerInput;
import us.ihmc.pathPlanning.visibilityGraphs.NavigableRegionsManager;
import us.ihmc.pathPlanning.visibilityGraphs.OcclusionHandlingPathPlanner;
import us.ihmc.pathPlanning.visibilityGraphs.VisibilityGraphsTestVisualizerApplication;
import us.ihmc.pathPlanning.visibilityGraphs.interfaces.NavigableRegionFilter;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.DefaultVisibilityGraphParameters;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.postProcessing.BodyPathPostProcessor;
import us.ihmc.pathPlanning.visibilityGraphs.postProcessing.ObstacleAvoidanceProcessor;
import us.ihmc.pathPlanning.visibilityGraphs.postProcessing.PathOrientationCalculator;
import us.ihmc.pathPlanning.visibilityGraphs.ui.messager.UIVisibilityGraphsTopics;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullDecomposition;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullFactoryParameters;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionFilter;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionPolygonizer;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionSegmentationRawData;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PolygonizerParameters;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionTools;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.geometry.SpiralBasedAlgorithm;

public class VisibilityGraphsFrameworkTest {
    private static final double START_GOAL_EPSILON = 0.1;
    private static boolean VISUALIZE = Boolean.parseBoolean(System.getProperty("visualize"));
    private static boolean ENABLE_TIMERS = true;
    private static boolean DYNAMIC_WAIT_FOR_CLICK = false;
    private static boolean fullyExpandVisibilityGraph = false;
    private static int maxPointsInRegion = 25000;
    private static final double walkerTotalTime = 300.0;
    private static final List<DataSetName> fastDatasets = Arrays.asList(DataSetName._20190514_163532_QuadrupedShortPlatformEnvironment, DataSetName._20190514_163532_QuadrupedPlatformEnvironment, DataSetName._20171114_135559_PartialShallowMaze, DataSetName._20171115_171243_SimplePlaneAndWall, DataSetName._20171215_201810_RampSteppingStones_Sim);
    private static boolean DEBUG = true;
    private static VisibilityGraphsTestVisualizerApplication visualizerApplication = null;
    private static JavaFXMessager messager = null;
    private static final double walkerOffsetHeight = 0.75;
    private static final Vector3D walkerRadii = new Vector3D(0.25, 0.25, 0.5);
    protected static double walkerMarchingSpeed = 0.25;
    private static final double lidarObserverHeight = 1.25;
    private static final int rays = 7500;
    private static final double rayLengthSquared = MathTools.square((double)5.0);
    private final ConcaveHullFactoryParameters concaveHullFactoryParameters = new ConcaveHullFactoryParameters();
    private final PolygonizerParameters polygonizerParameters = new PolygonizerParameters();
    private static Notification nextStepDynamicNotification = new Notification();

    private static VisibilityGraphsParametersReadOnly createTestParameters() {
        DefaultVisibilityGraphParameters parameters = new DefaultVisibilityGraphParameters();
        return parameters;
    }

    @BeforeEach
    public void setup() {
        VISUALIZE = VISUALIZE && !ContinuousIntegrationTools.isRunningOnContinuousIntegrationServer();
        boolean bl = DEBUG = VISUALIZE || DEBUG && !ContinuousIntegrationTools.isRunningOnContinuousIntegrationServer();
        if (VISUALIZE) {
            visualizerApplication = new VisibilityGraphsTestVisualizerApplication();
            visualizerApplication.startOnAThread();
            messager = visualizerApplication.getMessager();
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (VISUALIZE) {
            visualizerApplication.stop();
            visualizerApplication = null;
            messager = null;
        }
    }

    @Test
    public void testDatasetsWithoutOcclusion() {
        if (VISUALIZE) {
            messager.submitMessage(UIVisibilityGraphsTopics.EnableWalkerAnimation, (Object)true);
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerOffsetHeight, (Object)0.75);
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerSize, (Object)walkerRadii);
        }
        boolean testWithOcclusions = false;
        Predicate<DataSet> dataSetFilter = dataSet -> {
            if (!dataSet.hasPlannerInput()) {
                return false;
            }
            if (testWithOcclusions && dataSet.getPlannerInput().getVisGraphCanRunWithOcclusion()) {
                return false;
            }
            return dataSet.getPlannerInput().getVisGraphIsTestable();
        };
        List dataSets = DataSetIOTools.loadDataSets(dataSetFilter);
        this.runAssertionsOnAllDatasets(dataSets, dataset -> this.runAssertionsWithoutOcclusion((DataSet)dataset));
    }

    @Test
    @Tag(value="fast")
    public void testFewDataSetsNoOcclussionsSimulateDynamicReplanning() {
        if (VISUALIZE) {
            messager.submitMessage(UIVisibilityGraphsTopics.EnableWalkerAnimation, (Object)true);
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerOffsetHeight, (Object)0.75);
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerSize, (Object)walkerRadii);
            messager.submitMessage(UIVisibilityGraphsTopics.ShowInterRegionVisibilityMap, (Object)true);
        }
        boolean testWithOcclusions = false;
        Predicate<DataSet> dataSetFilter = dataSet -> {
            if (!dataSet.hasPlannerInput()) {
                return false;
            }
            if (testWithOcclusions && dataSet.getPlannerInput().getVisGraphCanRunWithOcclusion()) {
                return false;
            }
            if (!dataSet.getPlannerInput().getVisGraphIsTestable()) {
                return false;
            }
            for (DataSetName namesToTest : fastDatasets) {
                if (!dataSet.getName().equals(namesToTest.name().substring(1))) continue;
                return true;
            }
            return false;
        };
        List dataSets = DataSetIOTools.loadDataSets(dataSetFilter);
        this.runAssertionsOnAllDatasets(dataSets, dataset -> this.runAssertionsSimulateDynamicReplanning((DataSet)dataset, walkerMarchingSpeed, 10000L, false));
    }

    @Test
    @Tag(value="path-planning-slow")
    public void testDatasetsNoOcclusionSimulateDynamicReplanning() {
        if (VISUALIZE) {
            messager.submitMessage(UIVisibilityGraphsTopics.EnableWalkerAnimation, (Object)true);
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerOffsetHeight, (Object)0.75);
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerSize, (Object)walkerRadii);
            messager.submitMessage(UIVisibilityGraphsTopics.ShowInterRegionVisibilityMap, (Object)true);
        }
        boolean testWithOcclusions = false;
        Predicate<DataSet> dataSetFilter = dataSet -> {
            if (!dataSet.hasPlannerInput()) {
                return false;
            }
            if (testWithOcclusions && dataSet.getPlannerInput().getVisGraphCanRunWithOcclusion()) {
                return false;
            }
            if (!dataSet.getPlannerInput().getVisGraphIsTestable()) {
                return false;
            }
            for (DataSetName nameToIgnore : fastDatasets) {
                if (!dataSet.getName().equals(nameToIgnore.name().substring(1))) continue;
                return false;
            }
            return true;
        };
        List allDatasets = DataSetIOTools.loadDataSets(dataSetFilter);
        this.runAssertionsOnAllDatasets(allDatasets, dataset -> this.runAssertionsSimulateDynamicReplanning((DataSet)dataset, walkerMarchingSpeed, 10000L, false));
    }

    @Disabled(value="Occlusion planning needs to be implemented better.")
    @Test
    public void testDatasetsSimulateOcclusionAndDynamicReplanning() {
        if (VISUALIZE) {
            messager.submitMessage(UIVisibilityGraphsTopics.EnableWalkerAnimation, (Object)true);
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerOffsetHeight, (Object)0.75);
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerSize, (Object)walkerRadii);
        }
        boolean testWithOcclusions = true;
        Predicate<DataSet> dataSetFilter = dataSet -> {
            if (!dataSet.hasPlannerInput()) {
                return false;
            }
            if (testWithOcclusions && dataSet.getPlannerInput().getVisGraphCanRunWithOcclusion()) {
                return false;
            }
            return dataSet.getPlannerInput().getVisGraphIsTestable();
        };
        List allDatasets = DataSetIOTools.loadDataSets(dataSetFilter);
        this.runAssertionsOnAllDatasets(allDatasets, dataset -> this.runAssertionsSimulateDynamicReplanning((DataSet)dataset, walkerMarchingSpeed, 1000000000L, true));
    }

    @Test
    public void testSimulateOcclusionAndDynamicReplanningOnTrickyCorridor() {
        if (VISUALIZE) {
            messager.submitMessage(UIVisibilityGraphsTopics.EnableWalkerAnimation, (Object)true);
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerOffsetHeight, (Object)0.75);
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerSize, (Object)walkerRadii);
        }
        boolean testWithOcclusions = true;
        ENABLE_TIMERS = false;
        DYNAMIC_WAIT_FOR_CLICK = false;
        maxPointsInRegion = Integer.MAX_VALUE;
        walkerMarchingSpeed = 0.7;
        ArrayList<DataSet> allDatasets = new ArrayList<DataSet>();
        allDatasets.add(DataSetIOTools.loadDataSet((DataSetName)DataSetName._20191008_153543_TrickCorridor));
        this.runAssertionsOnAllDatasets(allDatasets, dataset -> this.runAssertionsSimulateDynamicReplanning((DataSet)dataset, walkerMarchingSpeed, 1000000000L, true));
    }

    @Disabled(value="Not working yet. Need to cancel out the bordering home/free/escape/frontier nodes.")
    @Test
    public void testSimulateOcclusionAndDynamicReplanningOnTrickyCorridorWCutFloor() {
        if (VISUALIZE) {
            messager.submitMessage(UIVisibilityGraphsTopics.EnableWalkerAnimation, (Object)true);
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerOffsetHeight, (Object)0.75);
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerSize, (Object)walkerRadii);
        }
        boolean testWithOcclusions = true;
        ENABLE_TIMERS = true;
        DYNAMIC_WAIT_FOR_CLICK = false;
        maxPointsInRegion = Integer.MAX_VALUE;
        walkerMarchingSpeed = 0.7;
        ArrayList<DataSet> allDatasets = new ArrayList<DataSet>();
        allDatasets.add(DataSetIOTools.loadDataSet((DataSetName)DataSetName._20191107_110432_TrickCorridorWCutFloor));
        this.runAssertionsOnAllDatasets(allDatasets, dataset -> this.runAssertionsSimulateDynamicReplanning((DataSet)dataset, walkerMarchingSpeed, 1000000000L, true));
    }

    private void runAssertionsOnAllDatasets(List<DataSet> allDatasets, Function<DataSet, String> dataSetTester) {
        if (DEBUG) {
            LogTools.info((String)("Unit test files found: " + allDatasets.size()));
            for (int i = 0; i < allDatasets.size(); ++i) {
                System.out.println("\t" + allDatasets.get(i).getName());
            }
        }
        AtomicReference previousDatasetRequested = null;
        AtomicReference reloadDatasetRequested = null;
        AtomicReference nextDatasetRequested = null;
        AtomicReference requestedDatasetPathReference = null;
        if (VISUALIZE) {
            List allDatasetNames = allDatasets.stream().map(DataSet::getName).collect(Collectors.toList());
            messager.submitMessage(UIVisibilityGraphsTopics.AllDatasetPaths, allDatasetNames);
            nextDatasetRequested = messager.createInput(UIVisibilityGraphsTopics.NextDatasetRequest, (Object)false);
            reloadDatasetRequested = messager.createInput(UIVisibilityGraphsTopics.ReloadDatasetRequest, (Object)false);
            previousDatasetRequested = messager.createInput(UIVisibilityGraphsTopics.PreviousDatasetRequest, (Object)false);
            requestedDatasetPathReference = messager.createInput(UIVisibilityGraphsTopics.CurrentDatasetPath, null);
            messager.addTopicListener(UIVisibilityGraphsTopics.NextStepDynamic, obj -> nextStepDynamicNotification.set());
        }
        int numberOfFailingDatasets = 0;
        Object errorMessages = "";
        int currentDatasetIndex = 0;
        if (allDatasets.isEmpty()) {
            Assert.fail((String)"Did not find any datasets to test.");
        }
        Object dataset = allDatasets.get(currentDatasetIndex);
        while (dataset != null) {
            String errorMessagesForCurrentFile;
            if (VISUALIZE) {
                messager.submitMessage(UIVisibilityGraphsTopics.GlobalReset, (Object)true);
                messager.submitMessage(UIVisibilityGraphsTopics.CurrentDatasetPath, (Object)dataset.getName());
            }
            if (DEBUG) {
                LogTools.info((String)("Processing file: " + dataset.getName()));
            }
            if (!(errorMessagesForCurrentFile = dataSetTester.apply((DataSet)dataset)).isEmpty()) {
                ++numberOfFailingDatasets;
            }
            errorMessages = (String)errorMessages + errorMessagesForCurrentFile;
            if (DEBUG) {
                LogTools.info((String)("Finished processing file: " + dataset.getName()));
            }
            if (VISUALIZE) {
                messager.submitMessage(UIVisibilityGraphsTopics.NextDatasetRequest, (Object)false);
                messager.submitMessage(UIVisibilityGraphsTopics.ReloadDatasetRequest, (Object)false);
                messager.submitMessage(UIVisibilityGraphsTopics.PreviousDatasetRequest, (Object)false);
                while (!((Boolean)nextDatasetRequested.get()).booleanValue() && !((Boolean)reloadDatasetRequested.get()).booleanValue() && !((Boolean)previousDatasetRequested.get()).booleanValue() && dataset.getName().equals(requestedDatasetPathReference.get())) {
                    if (!messager.isMessagerOpen()) {
                        return;
                    }
                    ThreadTools.sleep((long)200L);
                }
                if (((Boolean)reloadDatasetRequested.get()).booleanValue()) continue;
                if (((Boolean)nextDatasetRequested.get()).booleanValue() && currentDatasetIndex < allDatasets.size() - 1) {
                    dataset = allDatasets.get(++currentDatasetIndex);
                } else if (((Boolean)previousDatasetRequested.get()).booleanValue() && currentDatasetIndex > 0) {
                    dataset = allDatasets.get(--currentDatasetIndex);
                } else if (requestedDatasetPathReference.get() != null) {
                    String path = (String)requestedDatasetPathReference.get();
                    DataSet requestedDataset = allDatasets.stream().filter(d -> d.getName().equals(path)).findFirst().orElse(null);
                    if (requestedDataset == null) {
                        LogTools.error((String)("Could not find the requested dataset with name: " + path));
                    } else {
                        currentDatasetIndex = allDatasets.indexOf(requestedDataset);
                        dataset = requestedDataset;
                    }
                } else {
                    dataset = null;
                }
            } else {
                dataset = ++currentDatasetIndex < allDatasets.size() ? allDatasets.get(currentDatasetIndex) : null;
            }
            ThreadTools.sleep((long)100L);
        }
        Assert.assertTrue((String)("Number of failing datasets: " + numberOfFailingDatasets + " out of " + allDatasets.size() + ". Errors:" + (String)errorMessages), (boolean)((String)errorMessages).isEmpty());
    }

    private void runAssertionsOnDataset(Function<DataSet, String> dataSetTester, DataSetName datasetname) {
        List allDataSets = DataSetIOTools.loadDataSets();
        DataSet dataSetToTest = DataSetIOTools.loadDataSet((DataSetName)datasetname);
        if (VISUALIZE) {
            List allDatasetNames = allDataSets.stream().map(DataSet::getName).collect(Collectors.toList());
            messager.submitMessage(UIVisibilityGraphsTopics.AllDatasetPaths, allDatasetNames);
        }
        if (VISUALIZE) {
            messager.submitMessage(UIVisibilityGraphsTopics.GlobalReset, (Object)true);
            messager.submitMessage(UIVisibilityGraphsTopics.CurrentDatasetPath, (Object)dataSetToTest.getName());
        }
        if (DEBUG) {
            LogTools.info((String)("Processing file: " + dataSetToTest.getName()));
        }
        String errorMessages = dataSetTester.apply(dataSetToTest);
        LogTools.info((String)"Finished testing.");
        ThreadTools.sleepForever();
    }

    private String runAssertionsWithoutOcclusion(DataSet dataset) {
        String datasetName = dataset.getName();
        PlanarRegionsList planarRegionsList = dataset.getPlanarRegionsList();
        PlannerInput plannerInput = dataset.getPlannerInput();
        Point3D start = plannerInput.getStartPosition();
        Point3D goal = plannerInput.getGoalPosition();
        if (VISUALIZE) {
            visualizerApplication.submitPlanarRegionsListToVisualizer(planarRegionsList);
            visualizerApplication.submitStartToVisualizer(start);
            visualizerApplication.submitGoalToVisualizer(goal);
        }
        String errorMessages = this.calculateAndTestVizGraphsBodyPath(datasetName, start, goal, planarRegionsList);
        return VisibilityGraphsFrameworkTest.addPrefixToErrorMessages(datasetName, errorMessages);
    }

    private String runAssertionsWithOcclusions(DataSet dataset) {
        String datasetName = dataset.getName();
        PlanarRegionsList planarRegionsList = dataset.getPlanarRegionsList();
        HashMap<PlanarRegion, List<Point3D>> pointsInRegions = new HashMap<PlanarRegion, List<Point3D>>();
        for (PlanarRegion planarRegion : planarRegionsList.getPlanarRegionsAsList()) {
            pointsInRegions.put(planarRegion, new ArrayList());
        }
        PlannerInput plannerInput = dataset.getPlannerInput();
        Point3D start = plannerInput.getStartPosition();
        Point3D goal = plannerInput.getGoalPosition();
        Point3D observer = new Point3D();
        observer.set(start);
        observer.addZ(1.25);
        Pair<PlanarRegionsList, List<Point3D>> result = this.createVisibleRegions(planarRegionsList, pointsInRegions, observer);
        PlanarRegionsList visibleRegions = (PlanarRegionsList)result.getKey();
        if (VISUALIZE) {
            visualizerApplication.submitPlanarRegionsListToVisualizer(visibleRegions);
            visualizerApplication.submitShadowPlanarRegionsListToVisualizer(planarRegionsList);
            visualizerApplication.submitStartToVisualizer(start);
            visualizerApplication.submitGoalToVisualizer(goal);
        }
        String errorMessages = this.calculateAndTestVizGraphsBodyPath(datasetName, start, goal, visibleRegions);
        return VisibilityGraphsFrameworkTest.addPrefixToErrorMessages(datasetName, errorMessages);
    }

    private String runAssertionsSimulateDynamicReplanning(DataSet dataset, double walkerSpeed, long maxSolveTimeInMilliseconds, boolean simulateOcclusions) {
        String datasetName = dataset.getName();
        PlanarRegionsList planarRegionsList = dataset.getPlanarRegionsList();
        HashMap<PlanarRegion, List<Point3D>> pointsInRegions = new HashMap<PlanarRegion, List<Point3D>>();
        for (PlanarRegion planarRegion : planarRegionsList.getPlanarRegionsAsList()) {
            pointsInRegions.put(planarRegion, new ArrayList());
        }
        PlannerInput plannerInput = dataset.getPlannerInput();
        Point3D start = plannerInput.getStartPosition();
        Point3D goal = plannerInput.getGoalPosition();
        AtomicReference stopWalkerRequest = null;
        if (VISUALIZE) {
            stopWalkerRequest = messager.createInput(UIVisibilityGraphsTopics.StopWalker, (Object)false);
            if (!simulateOcclusions) {
                visualizerApplication.submitPlanarRegionsListToVisualizer(planarRegionsList);
            }
            visualizerApplication.submitStartToVisualizer(start);
            visualizerApplication.submitGoalToVisualizer(goal);
        }
        Object errorMessages = "";
        ArrayList<Pose3DReadOnly> latestBodyPath = new ArrayList<Pose3DReadOnly>();
        Point3D walkerPosition = new Point3D((Tuple3DReadOnly)start);
        long totalStartTime = System.currentTimeMillis();
        while (!walkerPosition.geometricallyEquals((EuclidGeometry)goal, 0.01)) {
            PlanarRegionsList visibleRegions = planarRegionsList;
            if (simulateOcclusions) {
                Point3D observer = new Point3D();
                observer.set(walkerPosition);
                observer.addZ(1.25);
                Pair<PlanarRegionsList, List<Point3D>> result = this.createVisibleRegions(planarRegionsList, pointsInRegions, observer);
                visibleRegions = (PlanarRegionsList)result.getKey();
            }
            if (VISUALIZE && simulateOcclusions) {
                visualizerApplication.submitPlanarRegionsListToVisualizer(visibleRegions);
            }
            long startTime = System.currentTimeMillis();
            errorMessages = (String)errorMessages + this.calculateAndTestVizGraphsBodyPath(datasetName, walkerPosition, goal, visibleRegions, latestBodyPath, simulateOcclusions);
            long endTime = System.currentTimeMillis();
            if (ENABLE_TIMERS) {
                if (endTime - startTime > maxSolveTimeInMilliseconds) {
                    errorMessages = (String)errorMessages + this.fail(datasetName, "Took too long to compute a new body path.");
                }
                if ((double)(endTime - totalStartTime) > Conversions.secondsToMilliseconds((double)300.0)) {
                    errorMessages = (String)errorMessages + this.fail(datasetName, "Took too long to make it through the body path. Made it to " + walkerPosition + ", while the goal was " + goal);
                }
            }
            if (!((String)errorMessages).isEmpty()) {
                return VisibilityGraphsFrameworkTest.addPrefixToErrorMessages(datasetName, (String)errorMessages);
            }
            if (VISUALIZE) {
                messager.submitMessage(UIVisibilityGraphsTopics.EnableWalkerAnimation, (Object)(!simulateOcclusions ? 1 : 0));
                messager.submitMessage(UIVisibilityGraphsTopics.WalkerPosition, (Object)walkerPosition);
            }
            if (stopWalkerRequest != null && ((Boolean)stopWalkerRequest.get()).booleanValue()) {
                messager.submitMessage(UIVisibilityGraphsTopics.StopWalker, (Object)false);
                break;
            }
            walkerPosition.set((Tuple3DReadOnly)VisibilityGraphsFrameworkTest.travelAlongBodyPath(walkerSpeed, latestBodyPath));
            if (!VISUALIZE) continue;
            if (!messager.isMessagerOpen()) {
                return VisibilityGraphsFrameworkTest.addPrefixToErrorMessages(datasetName, (String)errorMessages);
            }
            if (!DYNAMIC_WAIT_FOR_CLICK) continue;
            while (!nextStepDynamicNotification.poll()) {
                Thread.yield();
            }
        }
        return VisibilityGraphsFrameworkTest.addPrefixToErrorMessages(datasetName, (String)errorMessages);
    }

    private static Point3DReadOnly travelAlongBodyPath(double distanceToTravel, List<Pose3DReadOnly> bodyPath) {
        double totalDesiredDistance = distanceToTravel;
        Point3D initialPosition = new Point3D((Tuple3DReadOnly)bodyPath.get(0).getPosition());
        Point3D positionWithShift = new Point3D();
        for (int i = 0; i < bodyPath.size() - 1; ++i) {
            LineSegment3D segment = new LineSegment3D(bodyPath.get(i).getPosition(), bodyPath.get(i + 1).getPosition());
            if (segment.length() < 0.005 || !(VisibilityGraphsFrameworkTest.xyDistance((LineSegment3DReadOnly)segment, (Point3DReadOnly)initialPosition) < 0.01)) continue;
            Vector3DBasics segmentDirection = segment.getDirection(true);
            positionWithShift.scaleAdd(distanceToTravel, (Tuple3DReadOnly)segmentDirection, (Tuple3DReadOnly)initialPosition);
            double distanceFromStart = bodyPath.get(0).getPosition().distanceXY((Point3DReadOnly)positionWithShift);
            if (VisibilityGraphsFrameworkTest.xyDistance((LineSegment3DReadOnly)segment, (Point3DReadOnly)positionWithShift) < 0.01 && distanceFromStart >= totalDesiredDistance) {
                initialPosition = new Point3D((Tuple3DReadOnly)positionWithShift);
                break;
            }
            distanceToTravel = Math.max(distanceToTravel - initialPosition.distanceXY((Point3DReadOnly)segment.getSecondEndpoint()), 0.1);
            initialPosition = new Point3D((Tuple3DReadOnly)segment.getSecondEndpoint());
        }
        if (initialPosition.getZ() > 2.0) {
            return initialPosition;
        }
        return initialPosition;
    }

    private static double xyDistance(LineSegment3DReadOnly segment, Point3DReadOnly point) {
        Point3DReadOnly lineSegmentStart = segment.getFirstEndpoint();
        Point3DReadOnly lineSegmentEnd = segment.getSecondEndpoint();
        return EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((double)point.getX(), (double)point.getY(), (double)lineSegmentStart.getX(), (double)lineSegmentStart.getY(), (double)lineSegmentEnd.getX(), (double)lineSegmentEnd.getY());
    }

    private String calculateAndTestVizGraphsBodyPath(String datasetName, Point3D start, Point3D goal, PlanarRegionsList planarRegionsList) {
        return this.calculateAndTestVizGraphsBodyPath(datasetName, start, goal, planarRegionsList, null);
    }

    private String calculateAndTestVizGraphsBodyPath(String datasetName, Point3D start, Point3D goal, PlanarRegionsList planarRegionsList, List<Pose3DReadOnly> bodyPathToPack) {
        return this.calculateAndTestVizGraphsBodyPath(datasetName, start, goal, planarRegionsList, bodyPathToPack, false);
    }

    private String calculateAndTestVizGraphsBodyPath(String datasetName, Point3D start, Point3D goal, PlanarRegionsList planarRegionsList, List<Pose3DReadOnly> bodyPathToPack, boolean simulateOcclusions) {
        Object errorMessages;
        VisibilityGraphsParametersReadOnly parameters = VisibilityGraphsFrameworkTest.createTestParameters();
        NavigableRegionsManager manager = new NavigableRegionsManager(parameters, null, (BodyPathPostProcessor)new ObstacleAvoidanceProcessor(parameters));
        OcclusionHandlingPathPlanner occlusionHandlingPathPlanner = new OcclusionHandlingPathPlanner(manager);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator(parameters);
        manager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = null;
        List pathPoints = null;
        try {
            pathPoints = simulateOcclusions ? occlusionHandlingPathPlanner.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal, fullyExpandVisibilityGraph) : manager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal, fullyExpandVisibilityGraph);
            path = orientationCalculator.computePosesFromPath(pathPoints, manager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        }
        catch (Exception e) {
            e.printStackTrace();
            ThreadTools.sleep((long)100L);
        }
        if (VISUALIZE) {
            if (path != null) {
                messager.submitMessage(UIVisibilityGraphsTopics.BodyPathData, (Object)pathPoints);
            }
            visualizerApplication.submitVisibilityGraphSolutionToVisualizer(manager.getVisibilityMapSolution());
            visualizerApplication.submitVisibilityGraphToVisualizer(manager.getVisibilityGraph());
        }
        if (!((String)(errorMessages = this.basicBodyPathSanityChecks(datasetName, (Point3DReadOnly)start, (Point3DReadOnly)goal, path, !simulateOcclusions))).isEmpty()) {
            return errorMessages;
        }
        if (bodyPathToPack != null) {
            bodyPathToPack.clear();
            bodyPathToPack.addAll(path);
        }
        int currentSegmentIndex = 0;
        Point3DReadOnly pathStart = ((Pose3DReadOnly)path.get(0)).getPosition();
        Point3DReadOnly pathEnd = ((Pose3DReadOnly)path.get(path.size() - 1)).getPosition();
        Point3D walkerCurrentPosition = new Point3D((Tuple3DReadOnly)pathStart);
        ArrayList<Point3D> collisions = new ArrayList<Point3D>();
        Ellipsoid3D walkerShape = new Ellipsoid3D();
        walkerShape.getRadii().set((Tuple3DReadOnly)walkerRadii);
        Point3D walkerBody3D = new Point3D((Tuple3DReadOnly)walkerCurrentPosition);
        walkerBody3D.addZ(0.75);
        walkerShape.getPosition().set((Tuple3DReadOnly)walkerBody3D);
        errorMessages = (String)errorMessages + this.walkerCollisionChecks(datasetName, walkerShape, planarRegionsList, collisions, parameters, true);
        while (!walkerCurrentPosition.geometricallyEquals((EuclidGeometry)pathEnd, 0.01)) {
            walkerBody3D = new Point3D((Tuple3DReadOnly)walkerCurrentPosition);
            walkerBody3D.addZ(0.75);
            walkerShape.getPosition().set((Tuple3DReadOnly)walkerBody3D);
            errorMessages = (String)errorMessages + this.walkerCollisionChecks(datasetName, walkerShape, planarRegionsList, collisions, parameters, !simulateOcclusions);
            Point3DReadOnly segmentStart = ((Pose3DReadOnly)path.get(currentSegmentIndex)).getPosition();
            Point3DReadOnly segmentEnd = ((Pose3DReadOnly)path.get(currentSegmentIndex + 1)).getPosition();
            Vector3D segmentDirection = new Vector3D();
            segmentDirection.sub((Tuple3DReadOnly)segmentEnd, (Tuple3DReadOnly)segmentStart);
            segmentDirection.normalize();
            if (segmentDirection.containsNaN() || segmentDirection.length() < 0.01) {
                ++currentSegmentIndex;
                continue;
            }
            walkerCurrentPosition.scaleAdd(walkerMarchingSpeed, (Tuple3DReadOnly)segmentDirection, (Tuple3DReadOnly)walkerCurrentPosition);
            if (!(segmentStart.distance(segmentEnd) < segmentStart.distance((Point3DReadOnly)walkerCurrentPosition))) continue;
            walkerCurrentPosition.set((Tuple3DReadOnly)segmentEnd);
            ++currentSegmentIndex;
        }
        if (VISUALIZE) {
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerCollisionLocations, collisions);
        }
        return errorMessages;
    }

    private String walkerCollisionChecks(String datasetName, Ellipsoid3D walkerShapeWorld, PlanarRegionsList planarRegionsList, List<Point3D> collisionsToPack, VisibilityGraphsParametersReadOnly visibilityGraphsParameters, boolean checkForShapeCollision) {
        Object errorMessages = "";
        walkerShapeWorld = new Ellipsoid3D((Ellipsoid3DReadOnly)walkerShapeWorld);
        NavigableRegionFilter navigableFilter = visibilityGraphsParameters.getNavigableRegionFilter();
        PlanarRegionFilter planarRegionFilter = visibilityGraphsParameters.getPlanarRegionFilter();
        List regionsToCheck = planarRegionsList.getPlanarRegionsAsList().stream().filter(query -> navigableFilter.isPlanarRegionNavigable(query, planarRegionsList.getPlanarRegionsAsList())).collect(Collectors.toList());
        regionsToCheck = regionsToCheck.stream().filter(arg_0 -> ((PlanarRegionFilter)planarRegionFilter).isPlanarRegionRelevant(arg_0)).collect(Collectors.toList());
        block0: for (PlanarRegion planarRegion : regionsToCheck) {
            Point3D walkerPosition3D = new Point3D((Tuple3DReadOnly)walkerShapeWorld.getPosition());
            Plane3D plane = planarRegion.getPlane();
            Point3DBasics closestPoint = plane.orthogonalProjectionCopy((Point3DReadOnly)walkerPosition3D);
            if (!walkerShapeWorld.isPointInside((Point3DReadOnly)closestPoint)) continue;
            Ellipsoid3D walkerShapeLocal = new Ellipsoid3D((Ellipsoid3DReadOnly)walkerShapeWorld);
            planarRegion.transformFromWorldToLocal((Transformable)walkerShapeLocal);
            walkerPosition3D.set((Tuple3DReadOnly)walkerShapeLocal.getPosition());
            Point2D walkerPosition2D = new Point2D((Tuple3DReadOnly)walkerPosition3D);
            if (planarRegion.getNumberOfConvexPolygons() == 0) {
                ArrayList concaveHullVertices = new ArrayList(planarRegion.getConcaveHull());
                double depthThreshold = 0.05;
                ArrayList convexPolygons = new ArrayList();
                ConcaveHullDecomposition.recursiveApproximateDecomposition(concaveHullVertices, (double)depthThreshold, convexPolygons);
            }
            for (int i = 0; i < planarRegion.getNumberOfConvexPolygons(); ++i) {
                ConvexPolygon2D convexPolygon = planarRegion.getConvexPolygon(i);
                Point2DBasics closestPoint2D = convexPolygon.orthogonalProjectionCopy((Point2DReadOnly)walkerPosition2D);
                if (closestPoint2D == null) {
                    if (convexPolygon.isPointInside((Point2DReadOnly)walkerPosition2D)) {
                        collisionsToPack.add(walkerPosition3D);
                        errorMessages = (String)errorMessages + this.fail(datasetName, "Body path is going through a region.");
                        continue block0;
                    }
                    throw new RuntimeException("Not sure what went wrong to here.");
                }
                closestPoint = new Point3D((Tuple2DReadOnly)closestPoint2D);
                if (!walkerShapeLocal.isPointInside((Point3DReadOnly)closestPoint) || !checkForShapeCollision) continue;
                Point2DBasics intersectionLocal = closestPoint2D;
                Point3D intersectionWorld = new Point3D((Tuple2DReadOnly)intersectionLocal);
                planarRegion.transformFromLocalToWorld((Transformable)intersectionWorld);
                errorMessages = (String)errorMessages + this.fail(datasetName, "Walker is going through a region at: " + intersectionWorld);
                collisionsToPack.add(intersectionWorld);
            }
        }
        return errorMessages;
    }

    private String basicBodyPathSanityChecks(String datasetName, Point3DReadOnly start, Point3DReadOnly goal, List<? extends Pose3DReadOnly> path, boolean checkEnds) {
        Object errorMessages = "";
        if (!((String)(errorMessages = (String)errorMessages + this.assertTrue(datasetName, "Path is null!", path != null))).isEmpty()) {
            return errorMessages;
        }
        if (!((String)(errorMessages = (String)errorMessages + this.assertTrue(datasetName, "Path does not contain any waypoints", path.size() > 0))).isEmpty()) {
            return errorMessages;
        }
        Point3DReadOnly pathEnd = path.get(path.size() - 1).getPosition();
        Point3DReadOnly pathStart = path.get(0).getPosition();
        Point2D pathEnd2D = new Point2D((Tuple3DReadOnly)pathEnd);
        Point2D pathStart2D = new Point2D((Tuple3DReadOnly)pathStart);
        Point2D goal2D = new Point2D((Tuple3DReadOnly)goal);
        Point2D start2D = new Point2D((Tuple3DReadOnly)start);
        if (checkEnds) {
            errorMessages = (String)errorMessages + this.assertTrue(datasetName, "Body path does not end at desired goal position: desired = " + goal + ", actual = " + pathEnd, pathEnd2D.geometricallyEquals((EuclidGeometry)goal2D, 0.1));
        }
        errorMessages = (String)errorMessages + this.assertTrue(datasetName, "Body path does not start from desired start position: desired = " + start + ", actual = " + pathStart, pathStart2D.geometricallyEquals((EuclidGeometry)start2D, 0.1));
        return errorMessages;
    }

    private Pair<PlanarRegionsList, List<Point3D>> createVisibleRegions(PlanarRegionsList regions, HashMap<PlanarRegion, List<Point3D>> pointsInRegions, Point3D observer) {
        ArrayList<Point3D> rayImpactLocations = new ArrayList<Point3D>();
        Point3D[] pointsOnSphere = SpiralBasedAlgorithm.generatePointsOnSphere((Point3DReadOnly)observer, (double)1.0, (int)7500);
        List filteredRegions = PlanarRegionTools.filterPlanarRegionsWithBoundingCircle((Point2DReadOnly)new Point2D((Tuple3DReadOnly)observer), (double)Math.sqrt(rayLengthSquared), (List)regions.getPlanarRegionsAsList());
        for (int rayIndex = 0; rayIndex < 7500; ++rayIndex) {
            Point3D point3D = pointsOnSphere[rayIndex];
            Vector3D rayDirection = new Vector3D();
            rayDirection.sub((Tuple3DReadOnly)point3D, (Tuple3DReadOnly)observer);
            ImmutablePair intersectionPair = PlanarRegionTools.intersectRegionsWithRay((List)filteredRegions, (Point3DReadOnly)observer, (Vector3D)rayDirection);
            if (intersectionPair == null || ((Point3D)intersectionPair.getLeft()).distanceSquared((Point3DReadOnly)observer) > rayLengthSquared) continue;
            Point3D intersection = (Point3D)intersectionPair.getLeft();
            PlanarRegion region = (PlanarRegion)intersectionPair.getRight();
            rayImpactLocations.add(intersection);
            Point3D pointOnPlane = new Point3D((Tuple3DReadOnly)intersection);
            region.transformFromWorldToLocal((Transformable)pointOnPlane);
            pointsInRegions.get(region).add(intersection);
        }
        for (PlanarRegion planarRegion : pointsInRegions.keySet()) {
            List<Point3D> pointsInRegion = pointsInRegions.get(planarRegion);
            while (pointsInRegion.size() > maxPointsInRegion) {
                pointsInRegion.remove(0);
            }
        }
        ArrayList<PlanarRegionSegmentationRawData> segmentationRawData = new ArrayList<PlanarRegionSegmentationRawData>();
        for (PlanarRegion originalRegion : pointsInRegions.keySet()) {
            List<Point3D> points = pointsInRegions.get(originalRegion);
            Point3D center = new Point3D();
            originalRegion.getBoundingBox3dInWorld().getCenterPoint((Point3DBasics)center);
            PlanarRegionSegmentationRawData rawData = new PlanarRegionSegmentationRawData(originalRegion.getRegionId(), (Vector3DReadOnly)originalRegion.getNormal(), (Point3DReadOnly)center, points);
            segmentationRawData.add(rawData);
        }
        PlanarRegionsList planarRegionsList = PlanarRegionPolygonizer.createPlanarRegionsList(segmentationRawData, (ConcaveHullFactoryParameters)this.concaveHullFactoryParameters, (PolygonizerParameters)this.polygonizerParameters);
        return new Pair((Object)planarRegionsList, rayImpactLocations);
    }

    private static String addPrefixToErrorMessages(String datasetName, String errorMessages) {
        if (!errorMessages.isEmpty()) {
            return "\n" + datasetName + errorMessages;
        }
        return "";
    }

    private String fail(String datasetName, String message) {
        return this.assertTrue(datasetName, message, false);
    }

    private String assertTrue(String datasetName, String message, boolean condition) {
        if ((VISUALIZE || DEBUG) && !condition) {
            LogTools.error((String)(datasetName + ": " + message));
        }
        return !condition ? "\n" + message : "";
    }

    public static void main(String[] args) throws Exception {
        VisibilityGraphsFrameworkTest test = new VisibilityGraphsFrameworkTest();
        DataSetName dataSetName = DataSetName._20171215_214730_CinderBlockField;
        VISUALIZE = true;
        test.setup();
        if (VISUALIZE) {
            messager.submitMessage(UIVisibilityGraphsTopics.EnableWalkerAnimation, (Object)false);
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerOffsetHeight, (Object)0.75);
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerSize, (Object)walkerRadii);
        }
        test.runAssertionsOnDataset(test::runAssertionsWithoutOcclusion, dataSetName);
        test.tearDown();
    }
}

