/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.ContinuousIntegrationTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.Ellipsoid3D;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.log.LogTools;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.pathPlanning.visibilityGraphs.NavigableRegionsManager;
import us.ihmc.pathPlanning.visibilityGraphs.VisibilityGraphsTestVisualizerApplication;
import us.ihmc.pathPlanning.visibilityGraphs.interfaces.NavigableRegionFilter;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.DefaultVisibilityGraphParameters;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.postProcessing.PathOrientationCalculator;
import us.ihmc.pathPlanning.visibilityGraphs.ui.messager.UIVisibilityGraphsTopics;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullDecomposition;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionFilter;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.geometry.PlanarRegionsListGenerator;

public class VisibilityGraphOcclusionTest {
    private boolean visualize = false;
    private PlanarRegionsList occludedEnvironmentWithAGoalPlane;
    private PlanarRegionsList occludedEnvironmentWithoutAGoalPlane;
    private PlanarRegionsList smallWallWithNoGround;
    private PlanarRegionsList tinyWallWithNoGround;
    private PlanarRegionsList largeWallWithNoGround;
    private VisibilityGraphsParametersReadOnly visibilityGraphsParameters;
    private static boolean DEBUG = true;
    private static VisibilityGraphsTestVisualizerApplication visualizerApplication = null;
    private static JavaFXMessager messager = null;
    private static final double walkerOffsetHeight = 0.75;
    private static final Vector3D walkerRadii = new Vector3D(0.25, 0.25, 0.5);
    private static final double walkerMarchingSpeed = 0.2;

    @BeforeEach
    public void setup() {
        DEBUG = this.visualize || DEBUG && !ContinuousIntegrationTools.isRunningOnContinuousIntegrationServer();
        this.visualize = this.visualize && !ContinuousIntegrationTools.isRunningOnContinuousIntegrationServer();
        this.occludedEnvironmentWithAGoalPlane = VisibilityGraphOcclusionTest.simpleOccludedEnvironment(true);
        this.occludedEnvironmentWithoutAGoalPlane = VisibilityGraphOcclusionTest.simpleOccludedEnvironment(false);
        this.smallWallWithNoGround = VisibilityGraphOcclusionTest.smallWallWithNoGoalGroundEnvironment();
        this.tinyWallWithNoGround = VisibilityGraphOcclusionTest.tinyWallWithNoGoalGroundEnvironment();
        this.largeWallWithNoGround = VisibilityGraphOcclusionTest.largeWallWithNoGoalGroundEnvironment();
        this.visibilityGraphsParameters = new DefaultVisibilityGraphParameters();
        if (this.visualize) {
            visualizerApplication = new VisibilityGraphsTestVisualizerApplication();
            visualizerApplication.startOnAThread();
            messager = visualizerApplication.getMessager();
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.occludedEnvironmentWithAGoalPlane = null;
        this.occludedEnvironmentWithoutAGoalPlane = null;
        this.smallWallWithNoGround = null;
        this.tinyWallWithNoGround = null;
        this.largeWallWithNoGround = null;
        this.visibilityGraphsParameters = null;
        if (this.visualize) {
            visualizerApplication.stop();
            visualizerApplication = null;
            messager = null;
        }
    }

    @Test
    public void testVisibilityGraphWithOcclusion() {
        Point3D goal = new Point3D(2.0, -1.0, 0.0);
        this.runTest(this.occludedEnvironmentWithAGoalPlane, goal);
    }

    @Test
    public void testVisibilityGraphWithOcclusionAndNoGoalPlane() {
        Point3D goal = new Point3D(2.0, -1.0, 0.0);
        this.runTest(this.occludedEnvironmentWithoutAGoalPlane, goal);
    }

    @Test
    public void testSmallWallWithNoGoalPlane() {
        Point3D goal = new Point3D(3.0, 0.0, 0.0);
        this.runTest(this.smallWallWithNoGround, goal);
    }

    @Test
    public void testTinyWallWithNoGoalPlane() {
        Point3D goal = new Point3D(3.0, 0.0, 0.0);
        this.runTest(this.tinyWallWithNoGround, goal);
    }

    @Test
    public void testLargeWallWithNoGoalPlane() {
        Point3D goal = new Point3D(3.0, 0.0, 0.0);
        this.runTest(this.largeWallWithNoGround, goal);
    }

    private void runTest(PlanarRegionsList planarRegionsList, Point3D goal) {
        Point3D start = new Point3D();
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager(planarRegionsList.getPlanarRegionsAsList());
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)new DefaultVisibilityGraphParameters());
        List pathPoints = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List path = orientationCalculator.computePosesFromPath(pathPoints, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (this.visualize) {
            visualizerApplication.submitPlanarRegionsListToVisualizer(planarRegionsList);
            visualizerApplication.submitGoalToVisualizer(goal);
            visualizerApplication.submitStartToVisualizer(start);
            visualizerApplication.submitNavigableRegionsToVisualizer(navigableRegionsManager.getNavigableRegionsList());
            messager.submitMessage(UIVisibilityGraphsTopics.BodyPathData, (Object)pathPoints);
            visualizerApplication.submitVisibilityGraphSolutionToVisualizer(navigableRegionsManager.getVisibilityMapSolution());
        }
        String errorMessages = this.testBodyPath(planarRegionsList, path);
        if (this.visualize) {
            ThreadTools.sleepForever();
        }
        Assert.assertTrue((String)("Errors: " + errorMessages), (boolean)errorMessages.isEmpty());
        LogTools.info((String)"Finished testing.");
    }

    private String testBodyPath(PlanarRegionsList planarRegionsList, List<? extends Pose3DReadOnly> path) {
        int currentSegmentIndex = 0;
        Point3DReadOnly pathStart = path.get(0).getPosition();
        Point3DReadOnly pathEnd = path.get(path.size() - 1).getPosition();
        Point3D walkerCurrentPosition = new Point3D((Tuple3DReadOnly)pathStart);
        ArrayList<Point3D> collisions = new ArrayList<Point3D>();
        Ellipsoid3D walkerShape = new Ellipsoid3D();
        walkerShape.getRadii().set((Tuple3DReadOnly)walkerRadii);
        Point3D walkerBody3D = new Point3D((Tuple3DReadOnly)walkerCurrentPosition);
        walkerBody3D.addZ(0.75);
        walkerShape.getPosition().set((Tuple3DReadOnly)walkerBody3D);
        Object errorMessages = this.walkerCollisionChecks((Ellipsoid3DReadOnly)walkerShape, planarRegionsList, collisions);
        while (!walkerCurrentPosition.geometricallyEquals((EuclidGeometry)pathEnd, 0.01)) {
            walkerBody3D = new Point3D((Tuple3DReadOnly)walkerCurrentPosition);
            walkerBody3D.addZ(0.75);
            walkerShape.getPosition().set((Tuple3DReadOnly)walkerBody3D);
            errorMessages = (String)errorMessages + this.walkerCollisionChecks((Ellipsoid3DReadOnly)walkerShape, planarRegionsList, collisions);
            Point3DReadOnly segmentStart = path.get(currentSegmentIndex).getPosition();
            Point3DReadOnly segmentEnd = path.get(currentSegmentIndex + 1).getPosition();
            Vector3D segmentDirection = new Vector3D();
            segmentDirection.sub((Tuple3DReadOnly)segmentEnd, (Tuple3DReadOnly)segmentStart);
            segmentDirection.normalize();
            if (segmentDirection.containsNaN() || segmentDirection.length() < 0.01) {
                ++currentSegmentIndex;
                continue;
            }
            walkerCurrentPosition.scaleAdd(0.2, (Tuple3DReadOnly)segmentDirection, (Tuple3DReadOnly)walkerCurrentPosition);
            if (!(segmentStart.distance(segmentEnd) < segmentStart.distance((Point3DReadOnly)walkerCurrentPosition))) continue;
            walkerCurrentPosition.set((Tuple3DReadOnly)segmentEnd);
            ++currentSegmentIndex;
        }
        if (this.visualize) {
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerCollisionLocations, collisions);
        }
        return errorMessages;
    }

    private String walkerCollisionChecks(Ellipsoid3DReadOnly walkerShapeWorld, PlanarRegionsList planarRegionsList, List<Point3D> collisionsToPack) {
        Object errorMessages = "";
        NavigableRegionFilter navigableFilter = this.visibilityGraphsParameters.getNavigableRegionFilter();
        PlanarRegionFilter planarRegionFilter = this.visibilityGraphsParameters.getPlanarRegionFilter();
        List regionsToCheck = planarRegionsList.getPlanarRegionsAsList().stream().filter(query -> navigableFilter.isPlanarRegionNavigable(query, planarRegionsList.getPlanarRegionsAsList())).collect(Collectors.toList());
        regionsToCheck = regionsToCheck.stream().filter(arg_0 -> ((PlanarRegionFilter)planarRegionFilter).isPlanarRegionRelevant(arg_0)).collect(Collectors.toList());
        block0: for (PlanarRegion planarRegion : regionsToCheck) {
            Point3D walkerPosition3D = new Point3D((Tuple3DReadOnly)walkerShapeWorld.getPosition());
            Plane3D plane = planarRegion.getPlane();
            Point3DBasics closestPoint = plane.orthogonalProjectionCopy((Point3DReadOnly)walkerPosition3D);
            if (!walkerShapeWorld.isPointInside((Point3DReadOnly)closestPoint)) continue;
            Ellipsoid3D walkerShapeLocal = new Ellipsoid3D(walkerShapeWorld);
            planarRegion.transformFromWorldToLocal((Transformable)walkerShapeLocal);
            walkerPosition3D.set((Tuple3DReadOnly)walkerShapeLocal.getPosition());
            Point2D walkerPosition2D = new Point2D((Tuple3DReadOnly)walkerPosition3D);
            if (planarRegion.getNumberOfConvexPolygons() == 0) {
                ArrayList concaveHullVertices = new ArrayList(planarRegion.getConcaveHull());
                double depthThreshold = 0.05;
                ArrayList convexPolygons = new ArrayList();
                ConcaveHullDecomposition.recursiveApproximateDecomposition(concaveHullVertices, (double)depthThreshold, convexPolygons);
            }
            for (int i = 0; i < planarRegion.getNumberOfConvexPolygons(); ++i) {
                ConvexPolygon2D convexPolygon = planarRegion.getConvexPolygon(i);
                Point2DBasics closestPoint2D = convexPolygon.orthogonalProjectionCopy((Point2DReadOnly)walkerPosition2D);
                if (closestPoint2D == null) {
                    if (convexPolygon.isPointInside((Point2DReadOnly)walkerPosition2D)) {
                        errorMessages = (String)errorMessages + this.fail("Body path is going through a region.");
                        continue block0;
                    }
                    throw new RuntimeException("Not sure what went wrong to here.");
                }
                closestPoint = new Point3D((Tuple2DReadOnly)closestPoint2D);
                if (!walkerShapeLocal.isPointInside((Point3DReadOnly)closestPoint)) continue;
                Point2DBasics intersectionLocal = closestPoint2D;
                Point3D intersectionWorld = new Point3D((Tuple2DReadOnly)intersectionLocal);
                planarRegion.transformFromLocalToWorld((Transformable)intersectionWorld);
                errorMessages = (String)errorMessages + this.fail("Walker is going through a region at: " + intersectionWorld);
                collisionsToPack.add(intersectionWorld);
            }
        }
        return errorMessages;
    }

    private String fail(String message) {
        return this.assertTrue(message, false);
    }

    private String assertTrue(String message, boolean condition) {
        if ((this.visualize || DEBUG) && !condition) {
            LogTools.error((String)(": " + message));
        }
        return !condition ? "\n" + message : "";
    }

    private static PlanarRegionsList simpleOccludedEnvironment(boolean includeGoalPlane) {
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.addRectangle(2.0, 4.0);
        generator.translate(1.0, -1.0, 0.5);
        generator.rotate(1.5707963267948966, Axis3D.Y);
        generator.addRectangle(0.9, 1.9);
        if (includeGoalPlane) {
            generator.identity();
            generator.translate(2.0, -1.0, 0.0);
            generator.addRectangle(1.0, 1.0);
        }
        return generator.getPlanarRegionsList();
    }

    private static PlanarRegionsList smallWallWithNoGoalGroundEnvironment() {
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.addRectangle(2.0, 4.0);
        generator.translate(2.0, 0.0, 1.0);
        generator.rotate(1.5707963267948966, Axis3D.Y);
        generator.addRectangle(0.2, 0.5);
        generator.identity();
        return generator.getPlanarRegionsList();
    }

    private static PlanarRegionsList tinyWallWithNoGoalGroundEnvironment() {
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.addRectangle(2.0, 4.0);
        generator.translate(2.0, 0.0, 1.0);
        generator.rotate(1.5707963267948966, Axis3D.Y);
        generator.addRectangle(0.05, 0.05);
        generator.identity();
        return generator.getPlanarRegionsList();
    }

    private static PlanarRegionsList largeWallWithNoGoalGroundEnvironment() {
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.addRectangle(2.0, 4.0);
        generator.translate(2.0, 0.0, 0.5);
        generator.rotate(1.5707963267948966, Axis3D.Y);
        generator.addRectangle(1.0, 0.6);
        generator.identity();
        return generator.getPlanarRegionsList();
    }

    private class TestParameters
    extends DefaultVisibilityGraphParameters {
        private TestParameters() {
        }

        public double getSearchHostRegionEpsilon() {
            return 0.0;
        }
    }
}

