/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.bodyPathPlanner;

import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.pathPlanning.bodyPathPlanner.BodyPathPlannerTools;
import us.ihmc.robotics.Assert;

public class BodyPathPlannerToolsTest {
    @Test
    public void testFindClosestPointAlongPath() {
        Point3D point0 = new Point3D(-0.007, 0.0, 0.0);
        Point3D point1 = new Point3D(0.662, 0.217, 0.0);
        Pose3D pose0 = new Pose3D((Tuple3DReadOnly)point0, (Orientation3DReadOnly)new Quaternion());
        Pose3D pose1 = new Pose3D((Tuple3DReadOnly)point1, (Orientation3DReadOnly)new Quaternion());
        ArrayList<Pose3D> path = new ArrayList<Pose3D>();
        path.add(pose0);
        path.add(pose1);
        Point3D point = new Point3D(0.619, 0.207, 0.0);
        Point3D projectedPoint = new Point3D();
        BodyPathPlannerTools.findClosestPointAlongPath(path, (Point3DReadOnly)point, (Point3DBasics)projectedPoint);
        Point3D expectedProjectedPoint = new Point3D();
        LineSegment3D segment = new LineSegment3D((Point3DReadOnly)point0, (Point3DReadOnly)point1);
        segment.orthogonalProjection((Point3DReadOnly)point, (Point3DBasics)expectedProjectedPoint);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)expectedProjectedPoint, (Point3DReadOnly)projectedPoint, (double)1.0E-8);
    }

    @Test
    public void testMoveAlongPoint() {
        ArrayList<Pose3D> bodyPath = new ArrayList<Pose3D>();
        Point3D point0 = new Point3D(0.2, 0.0, 0.0);
        Point3D point1 = new Point3D(0.5, 0.0, 0.0);
        Point3D point2 = new Point3D(10.0, 0.0, 0.0);
        Point3D point3 = new Point3D(11.0, 0.0, 0.0);
        Pose3D pose0 = new Pose3D((Tuple3DReadOnly)point0, (Orientation3DReadOnly)new Quaternion());
        Pose3D pose1 = new Pose3D((Tuple3DReadOnly)point1, (Orientation3DReadOnly)new Quaternion());
        Pose3D pose2 = new Pose3D((Tuple3DReadOnly)point2, (Orientation3DReadOnly)new Quaternion());
        Pose3D pose3 = new Pose3D((Tuple3DReadOnly)point3, (Orientation3DReadOnly)new Quaternion());
        bodyPath.add(pose0);
        bodyPath.add(pose1);
        bodyPath.add(pose2);
        bodyPath.add(pose3);
        Point3D startPoint = new Point3D(0.2, -0.5, 0.0);
        Point3D movedPoint = new Point3D(0.0, 0.0, 0.0);
        double distance = 1.0;
        int segmentStart = BodyPathPlannerTools.movePointAlongBodyPath(bodyPath, (Point3DReadOnly)startPoint, (Point3DBasics)movedPoint, (double)distance);
        Point3D expectedMovedPoint = new Point3D((Tuple3DReadOnly)startPoint);
        expectedMovedPoint.setY(0.0);
        expectedMovedPoint.addX(distance);
        Assert.assertEquals((long)1L, (long)segmentStart);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)expectedMovedPoint, (Point3DReadOnly)movedPoint, (double)1.0E-8);
        distance = 0.0;
        segmentStart = BodyPathPlannerTools.movePointAlongBodyPath(bodyPath, (Point3DReadOnly)startPoint, (Point3DBasics)movedPoint, (double)distance);
        expectedMovedPoint = new Point3D((Tuple3DReadOnly)startPoint);
        expectedMovedPoint.setY(0.0);
        expectedMovedPoint.addX(distance);
        Assert.assertEquals((long)0L, (long)segmentStart);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)expectedMovedPoint, (Point3DReadOnly)movedPoint, (double)1.0E-8);
        distance = 10.5;
        segmentStart = BodyPathPlannerTools.movePointAlongBodyPath(bodyPath, (Point3DReadOnly)startPoint, (Point3DBasics)movedPoint, (double)distance);
        expectedMovedPoint = new Point3D((Tuple3DReadOnly)startPoint);
        expectedMovedPoint.setY(0.0);
        expectedMovedPoint.addX(distance);
        Assert.assertEquals((long)2L, (long)segmentStart);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)expectedMovedPoint, (Point3DReadOnly)movedPoint, (double)1.0E-8);
        distance = 10.8;
        segmentStart = BodyPathPlannerTools.movePointAlongBodyPath(bodyPath, (Point3DReadOnly)startPoint, (Point3DBasics)movedPoint, (double)distance);
        expectedMovedPoint = new Point3D((Tuple3DReadOnly)startPoint);
        expectedMovedPoint.setY(0.0);
        expectedMovedPoint.addX(distance);
        Assert.assertEquals((long)2L, (long)segmentStart);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)expectedMovedPoint, (Point3DReadOnly)movedPoint, (double)1.0E-8);
        distance = 14.0;
        segmentStart = BodyPathPlannerTools.movePointAlongBodyPath(bodyPath, (Point3DReadOnly)startPoint, (Point3DBasics)movedPoint, (double)distance);
        expectedMovedPoint = new Point3D((Tuple3DReadOnly)point3);
        Assert.assertEquals((long)2L, (long)segmentStart);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)expectedMovedPoint, (Point3DReadOnly)movedPoint, (double)1.0E-8);
        startPoint = new Point3D(0.0, -0.5, 0.0);
        movedPoint = new Point3D(0.0, 0.0, 0.0);
        distance = 1.0;
        segmentStart = BodyPathPlannerTools.movePointAlongBodyPath(bodyPath, (Point3DReadOnly)startPoint, (Point3DBasics)movedPoint, (double)distance);
        expectedMovedPoint = new Point3D((Tuple3DReadOnly)point0);
        expectedMovedPoint.addX(distance);
        Assert.assertEquals((long)1L, (long)segmentStart);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)expectedMovedPoint, (Point3DReadOnly)movedPoint, (double)1.0E-8);
        distance = 0.0;
        segmentStart = BodyPathPlannerTools.movePointAlongBodyPath(bodyPath, (Point3DReadOnly)startPoint, (Point3DBasics)movedPoint, (double)distance);
        expectedMovedPoint = new Point3D((Tuple3DReadOnly)point0);
        expectedMovedPoint.addX(distance);
        Assert.assertEquals((long)0L, (long)segmentStart);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)expectedMovedPoint, (Point3DReadOnly)movedPoint, (double)1.0E-8);
        distance = 10.5;
        segmentStart = BodyPathPlannerTools.movePointAlongBodyPath(bodyPath, (Point3DReadOnly)startPoint, (Point3DBasics)movedPoint, (double)distance);
        expectedMovedPoint = new Point3D((Tuple3DReadOnly)point0);
        expectedMovedPoint.setY(0.0);
        expectedMovedPoint.addX(distance);
        Assert.assertEquals((long)2L, (long)segmentStart);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)expectedMovedPoint, (Point3DReadOnly)movedPoint, (double)1.0E-8);
        distance = 10.8;
        segmentStart = BodyPathPlannerTools.movePointAlongBodyPath(bodyPath, (Point3DReadOnly)startPoint, (Point3DBasics)movedPoint, (double)distance);
        expectedMovedPoint = new Point3D((Tuple3DReadOnly)point0);
        expectedMovedPoint.setY(0.0);
        expectedMovedPoint.addX(distance);
        Assert.assertEquals((long)2L, (long)segmentStart);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)expectedMovedPoint, (Point3DReadOnly)movedPoint, (double)1.0E-8);
        distance = 14.0;
        segmentStart = BodyPathPlannerTools.movePointAlongBodyPath(bodyPath, (Point3DReadOnly)startPoint, (Point3DBasics)movedPoint, (double)distance);
        expectedMovedPoint = new Point3D((Tuple3DReadOnly)point3);
        Assert.assertEquals((long)2L, (long)segmentStart);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)expectedMovedPoint, (Point3DReadOnly)movedPoint, (double)1.0E-8);
    }
}

