/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs.visualizer;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.pathPlanning.visibilityGraphs.ui.messager.UIVisibilityGraphsTopics;
import us.ihmc.pathPlanning.visibilityGraphs.ui.properties.Point3DProperty;
import us.ihmc.pathPlanning.visibilityGraphs.ui.viewers.BodyPathMeshViewer;
import us.ihmc.pathPlanning.visibilityGraphs.ui.viewers.ClusterMeshViewer;
import us.ihmc.pathPlanning.visibilityGraphs.ui.viewers.NavigableRegionViewer;
import us.ihmc.pathPlanning.visibilityGraphs.ui.viewers.PlanarRegionViewer;
import us.ihmc.pathPlanning.visibilityGraphs.ui.viewers.StartGoalPositionViewer;
import us.ihmc.pathPlanning.visibilityGraphs.ui.viewers.VisibilityMapHolderViewer;
import us.ihmc.pathPlanning.visibilityGraphs.visualizer.WalkerCollisionsViewer;

public class VisibilityGraphsTestVisualizer {
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(ThreadTools.getNamedThreadFactory((String)this.getClass().getSimpleName()));
    private final Stage primaryStage;
    private final JavaFXMessager messager;
    private final PlanarRegionViewer planarRegionViewer;
    private final PlanarRegionViewer planarRegionShadowViewer;
    private final StartGoalPositionViewer startGoalViewer;
    private final BodyPathMeshViewer bodyPathMeshViewer;
    private final ClusterMeshViewer clusterMeshViewer;
    private final NavigableRegionViewer navigableRegionMeshViewer;
    private final VisibilityMapHolderViewer interRegionConnectionsViewer;
    private final VisibilityMapHolderViewer startMapViewer;
    private final VisibilityMapHolderViewer goalMapViewer;
    private final WalkerCollisionsViewer walkerCollisionsViewer;
    @FXML
    private BorderPane mainPane;
    @FXML
    private TextField startTextField;
    @FXML
    private TextField goalTextField;
    @FXML
    private ToggleButton previousDatasetButton;
    @FXML
    private ToggleButton reloadDatasetButton;
    @FXML
    private ToggleButton nextDatasetButton;
    @FXML
    private ToggleButton stopWalkingToggleButton;
    @FXML
    private ToggleButton showBodyPathToggleButton;
    @FXML
    private ToggleButton showPlanarRegionsToggleButton;
    @FXML
    private ToggleButton showClusterRawPointsToggleButton;
    @FXML
    private ToggleButton showClusterNavigableExtrusionsToggleButton;
    @FXML
    private ToggleButton showClusterNonNavigableExtrusionsToggleButton;
    @FXML
    private ToggleButton showInnerRegionMapsToggleButton;
    @FXML
    private ToggleButton showInnerRegionHomeNodesToggleButton;
    @FXML
    private ToggleButton showInterRegionMapToggleButton;
    @FXML
    private ToggleButton showStartMapToggleButton;
    @FXML
    private ToggleButton showGoalMapToggleButton;
    @FXML
    private ListView<String> datasetsListView;

    public VisibilityGraphsTestVisualizer(Stage primaryStage, JavaFXMessager messager) throws IOException {
        this.primaryStage = primaryStage;
        this.messager = messager;
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        loader.setLocation(this.getClass().getResource(this.getClass().getSimpleName() + ".fxml"));
        Pane root = (Pane)loader.load();
        View3DFactory view3dFactory = View3DFactory.createSubscene();
        view3dFactory.addCameraController(0.05, 150.0, true);
        view3dFactory.addWorldCoordinateSystem(0.3);
        Pane subScene = view3dFactory.getSubSceneWrappedInsidePane();
        this.mainPane.setCenter((Node)subScene);
        this.bindUIControls();
        this.planarRegionViewer = new PlanarRegionViewer((Messager)messager, UIVisibilityGraphsTopics.PlanarRegionData, UIVisibilityGraphsTopics.ShowPlanarRegions);
        this.planarRegionShadowViewer = new PlanarRegionViewer((Messager)messager, UIVisibilityGraphsTopics.ShadowPlanarRegionData, UIVisibilityGraphsTopics.ShowPlanarRegions);
        this.planarRegionShadowViewer.setOpacity(0.0);
        this.startGoalViewer = new StartGoalPositionViewer((Messager)messager, UIVisibilityGraphsTopics.StartEditModeEnabled, UIVisibilityGraphsTopics.GoalEditModeEnabled, UIVisibilityGraphsTopics.StartPosition, UIVisibilityGraphsTopics.GoalPosition);
        this.bodyPathMeshViewer = new BodyPathMeshViewer((Messager)messager, this.executorService);
        this.clusterMeshViewer = new ClusterMeshViewer((Messager)messager, this.executorService);
        this.clusterMeshViewer.setTopics(UIVisibilityGraphsTopics.GlobalReset, UIVisibilityGraphsTopics.ShowClusterRawPoints, UIVisibilityGraphsTopics.ShowClusterNavigableExtrusions, UIVisibilityGraphsTopics.ShowClusterNonNavigableExtrusions, UIVisibilityGraphsTopics.NavigableRegionData);
        this.navigableRegionMeshViewer = new NavigableRegionViewer((Messager)messager, this.executorService);
        this.navigableRegionMeshViewer.setTopics(UIVisibilityGraphsTopics.GlobalReset, UIVisibilityGraphsTopics.ShowInnerRegionVisibilityMapEdges, UIVisibilityGraphsTopics.NavigableRegionVisibilityMap);
        this.walkerCollisionsViewer = new WalkerCollisionsViewer(messager);
        this.interRegionConnectionsViewer = new VisibilityMapHolderViewer((Messager)messager, this.executorService);
        this.interRegionConnectionsViewer.setCustomColor(Color.CRIMSON);
        this.interRegionConnectionsViewer.setTopics(UIVisibilityGraphsTopics.ShowInterRegionVisibilityMap, UIVisibilityGraphsTopics.InterRegionVisibilityMap);
        this.startMapViewer = new VisibilityMapHolderViewer((Messager)messager);
        this.startMapViewer.setCustomColor(Color.YELLOW);
        this.startMapViewer.setTopics(UIVisibilityGraphsTopics.ShowStartVisibilityMap, UIVisibilityGraphsTopics.StartVisibilityMap);
        this.goalMapViewer = new VisibilityMapHolderViewer((Messager)messager);
        this.goalMapViewer.setCustomColor(Color.CORNFLOWERBLUE);
        this.goalMapViewer.setTopics(UIVisibilityGraphsTopics.ShowGoalVisibilityMap, UIVisibilityGraphsTopics.GoalVisibilityMap);
        view3dFactory.addNodeToView(this.planarRegionViewer.getRoot());
        view3dFactory.addNodeToView(this.planarRegionShadowViewer.getRoot());
        view3dFactory.addNodeToView(this.startGoalViewer.getRoot());
        view3dFactory.addNodeToView(this.bodyPathMeshViewer.getRoot());
        view3dFactory.addNodeToView(this.clusterMeshViewer.getRoot());
        view3dFactory.addNodeToView(this.navigableRegionMeshViewer.getRoot());
        view3dFactory.addNodeToView(this.interRegionConnectionsViewer.getRoot());
        view3dFactory.addNodeToView(this.walkerCollisionsViewer.getRoot());
        view3dFactory.addNodeToView(this.startMapViewer.getRoot());
        view3dFactory.addNodeToView(this.goalMapViewer.getRoot());
        primaryStage.setTitle(this.getClass().getSimpleName());
        primaryStage.setMaximized(true);
        Scene mainScene = new Scene((Parent)root, 600.0, 400.0);
        primaryStage.setScene(mainScene);
        primaryStage.setOnCloseRequest(event -> this.stop());
    }

    private void bindUIControls() {
        this.messager.bindBidirectional(UIVisibilityGraphsTopics.PreviousDatasetRequest, (Property)this.previousDatasetButton.selectedProperty(), false);
        this.messager.bindBidirectional(UIVisibilityGraphsTopics.ReloadDatasetRequest, (Property)this.reloadDatasetButton.selectedProperty(), false);
        this.messager.bindBidirectional(UIVisibilityGraphsTopics.NextDatasetRequest, (Property)this.nextDatasetButton.selectedProperty(), false);
        this.previousDatasetButton.disableProperty().bind((ObservableValue)this.previousDatasetButton.selectedProperty());
        this.previousDatasetButton.disableProperty().bind((ObservableValue)this.reloadDatasetButton.selectedProperty());
        this.previousDatasetButton.disableProperty().bind((ObservableValue)this.nextDatasetButton.selectedProperty());
        this.reloadDatasetButton.disableProperty().bind((ObservableValue)this.previousDatasetButton.selectedProperty());
        this.reloadDatasetButton.disableProperty().bind((ObservableValue)this.reloadDatasetButton.selectedProperty());
        this.reloadDatasetButton.disableProperty().bind((ObservableValue)this.nextDatasetButton.selectedProperty());
        this.nextDatasetButton.disableProperty().bind((ObservableValue)this.previousDatasetButton.selectedProperty());
        this.nextDatasetButton.disableProperty().bind((ObservableValue)this.reloadDatasetButton.selectedProperty());
        this.nextDatasetButton.disableProperty().bind((ObservableValue)this.nextDatasetButton.selectedProperty());
        this.datasetsListView.disableProperty().bind((ObservableValue)this.previousDatasetButton.selectedProperty());
        this.datasetsListView.disableProperty().bind((ObservableValue)this.reloadDatasetButton.selectedProperty());
        this.datasetsListView.disableProperty().bind((ObservableValue)this.nextDatasetButton.selectedProperty());
        this.messager.bindBidirectional(UIVisibilityGraphsTopics.StopWalker, (Property)this.stopWalkingToggleButton.selectedProperty(), false);
        Point3DProperty startProperty = new Point3DProperty((Object)this, "startProperty", new Point3D(Double.NaN, Double.NaN, Double.NaN));
        Point3DProperty goalProperty = new Point3DProperty((Object)this, "goalProperty", new Point3D(Double.NaN, Double.NaN, Double.NaN));
        startProperty.addListener(InvalidationListener -> Platform.runLater(() -> this.startTextField.setText(((Point3D)startProperty.get()).toString())));
        goalProperty.addListener(InvalidationListener -> Platform.runLater(() -> this.goalTextField.setText(((Point3D)goalProperty.get()).toString())));
        this.messager.bindPropertyToTopic(UIVisibilityGraphsTopics.StartPosition, (Property)startProperty);
        this.messager.bindPropertyToTopic(UIVisibilityGraphsTopics.GoalPosition, (Property)goalProperty);
        this.messager.bindBidirectional(UIVisibilityGraphsTopics.ShowBodyPath, (Property)this.showBodyPathToggleButton.selectedProperty(), true);
        this.messager.bindBidirectional(UIVisibilityGraphsTopics.ShowPlanarRegions, (Property)this.showPlanarRegionsToggleButton.selectedProperty(), true);
        this.messager.bindBidirectional(UIVisibilityGraphsTopics.ShowClusterRawPoints, (Property)this.showClusterRawPointsToggleButton.selectedProperty(), false);
        this.messager.bindBidirectional(UIVisibilityGraphsTopics.ShowClusterNavigableExtrusions, (Property)this.showClusterNavigableExtrusionsToggleButton.selectedProperty(), false);
        this.messager.bindBidirectional(UIVisibilityGraphsTopics.ShowClusterNonNavigableExtrusions, (Property)this.showClusterNonNavigableExtrusionsToggleButton.selectedProperty(), false);
        this.messager.bindBidirectional(UIVisibilityGraphsTopics.ShowInnerRegionVisibilityMapEdges, (Property)this.showInnerRegionMapsToggleButton.selectedProperty(), false);
        this.messager.bindBidirectional(UIVisibilityGraphsTopics.ShowInnerRegionVisibilityMapHomeNodes, (Property)this.showInnerRegionHomeNodesToggleButton.selectedProperty(), false);
        this.messager.bindBidirectional(UIVisibilityGraphsTopics.ShowInterRegionVisibilityMap, (Property)this.showInterRegionMapToggleButton.selectedProperty(), false);
        this.messager.bindBidirectional(UIVisibilityGraphsTopics.ShowStartVisibilityMap, (Property)this.showStartMapToggleButton.selectedProperty(), true);
        this.messager.bindBidirectional(UIVisibilityGraphsTopics.ShowGoalVisibilityMap, (Property)this.showGoalMapToggleButton.selectedProperty(), true);
        this.messager.addFXTopicListener(UIVisibilityGraphsTopics.AllDatasetPaths, this::showDatasets);
        this.messager.addFXTopicListener(UIVisibilityGraphsTopics.CurrentDatasetPath, path -> this.datasetsListView.getSelectionModel().select(path));
        this.datasetsListView.setOnMouseClicked(this::handleDatasetSelection);
    }

    private void handleDatasetSelection(MouseEvent event) {
        if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2 && event.getTarget() instanceof Text) {
            LogTools.info((String)"Submitting new dataset request");
            this.messager.submitMessage(UIVisibilityGraphsTopics.CurrentDatasetPath, (Object)((String)this.datasetsListView.getSelectionModel().getSelectedItem()));
        }
    }

    private void showDatasets(List<String> allDatasets) {
        this.datasetsListView.getItems().clear();
        this.datasetsListView.getItems().addAll(allDatasets);
    }

    public BooleanProperty getNextDatasetRequestedProperty() {
        return this.nextDatasetButton.selectedProperty();
    }

    public void show() throws IOException {
        this.primaryStage.show();
        this.planarRegionViewer.start();
        this.planarRegionShadowViewer.start();
        this.startGoalViewer.start();
        this.bodyPathMeshViewer.start();
        this.clusterMeshViewer.start();
        this.navigableRegionMeshViewer.start();
        this.interRegionConnectionsViewer.start();
        this.walkerCollisionsViewer.start();
        this.startMapViewer.start();
        this.goalMapViewer.start();
    }

    public void stop() {
        this.planarRegionViewer.stop();
        this.planarRegionShadowViewer.stop();
        this.startGoalViewer.stop();
        this.bodyPathMeshViewer.stop();
        this.clusterMeshViewer.stop();
        this.navigableRegionMeshViewer.stop();
        this.interRegionConnectionsViewer.stop();
        this.walkerCollisionsViewer.stop();
        try {
            this.messager.closeMessager();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.startMapViewer.stop();
        this.goalMapViewer.stop();
        Platform.exit();
    }

    @FXML
    public void nextStepDynamic() {
        this.messager.submitMessage(UIVisibilityGraphsTopics.NextStepDynamic, new Object());
    }
}

