/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs.tools;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotEnvironmentAwareness.planarRegion.REAPlanarRegionTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;

public class REAPlanarRegionToolsTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    public static Point3D toWorld(Point2DReadOnly point2D, Transform transformToWorld) {
        Point3D inWorld = new Point3D((Tuple2DReadOnly)point2D);
        transformToWorld.transform((Point3DBasics)inWorld);
        return inWorld;
    }

    @Test
    public void testTruncatePlanarRegionIfIntersectingWithPlane() throws Exception {
        Point3D groundOrigin = new Point3D();
        Vector3D groundNormal = new Vector3D(0.0, 0.0, 1.0);
        Point3D squareOrigin = new Point3D(0.0, 0.0, -0.001);
        Vector3D squareNormal = new Vector3D(0.0, -1.0, 0.0);
        AxisAngle squareOrientation = EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)squareNormal);
        RigidBodyTransform squarePose = new RigidBodyTransform((Orientation3DReadOnly)squareOrientation, (Tuple3DReadOnly)squareOrigin);
        double squareSide = 4.0;
        ArrayList<Point2D> concaveHullVertices = new ArrayList<Point2D>();
        concaveHullVertices.add(new Point2D(0.0, 0.0));
        concaveHullVertices.add(new Point2D(0.0, squareSide));
        concaveHullVertices.add(new Point2D(squareSide, squareSide));
        concaveHullVertices.add(new Point2D(squareSide, 0.0));
        ArrayList<ConvexPolygon2D> convexPolygons = new ArrayList<ConvexPolygon2D>();
        convexPolygons.add(new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(concaveHullVertices)));
        PlanarRegion verticalSquare = new PlanarRegion((RigidBodyTransformReadOnly)squarePose, concaveHullVertices, convexPolygons);
        Point3D[] expectedVerticesInWorld = (Point3D[])concaveHullVertices.stream().map(p -> REAPlanarRegionToolsTest.toWorld((Point2DReadOnly)p, (Transform)squarePose)).toArray(Point3D[]::new);
        expectedVerticesInWorld[0].addZ(0.001);
        expectedVerticesInWorld[3].addZ(0.001);
        PlanarRegion truncatedSquare = REAPlanarRegionTools.truncatePlanarRegionIfIntersectingWithPlane((Point3DReadOnly)groundOrigin, (Vector3DReadOnly)groundNormal, (PlanarRegion)verticalSquare, (double)0.05, null);
        RigidBodyTransform truncatedTransform = new RigidBodyTransform();
        truncatedSquare.getTransformToWorld(truncatedTransform);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)squarePose, (EuclidGeometry)truncatedTransform, (double)1.0E-12);
        Point3D[] actualVerticesInWorld = (Point3D[])truncatedSquare.getConcaveHull().stream().map(p -> REAPlanarRegionToolsTest.toWorld((Point2DReadOnly)p, (Transform)squarePose)).toArray(Point3D[]::new);
        Assert.assertEquals((long)expectedVerticesInWorld.length, (long)actualVerticesInWorld.length);
        for (int i = 0; i < expectedVerticesInWorld.length; ++i) {
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)expectedVerticesInWorld[i], (Point3DReadOnly)actualVerticesInWorld[i], (double)1.0E-12);
        }
    }

    @Test
    public void testTruncatePlanarRegionIfIntersectingWithPlaneTwo() throws Exception {
        Point3D groundOrigin = new Point3D(4.25, 8.5, 0.0);
        Vector3D groundNormal = new Vector3D(0.0, 0.0, 1.0);
        Point3D squareOrigin = new Point3D(8.5, 8.5, 0.0);
        Vector3D squareNormal = new Vector3D(-0.1, 0.1, 0.9899);
        squareNormal.normalize();
        AxisAngle squareOrientation = EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)squareNormal);
        RigidBodyTransform squarePose = new RigidBodyTransform((Orientation3DReadOnly)squareOrientation, (Tuple3DReadOnly)squareOrigin);
        double squareSide = 4.0;
        Point2D[] concaveHullVertices = new Point2D[]{new Point2D(-squareSide / 2.0, squareSide / 2.0), new Point2D(squareSide / 2.0, squareSide / 2.0), new Point2D(squareSide / 2.0, -squareSide / 2.0), new Point2D(-squareSide / 2.0, -squareSide / 2.0)};
        ArrayList<ConvexPolygon2D> convexPolygons = new ArrayList<ConvexPolygon2D>();
        convexPolygons.add(new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])concaveHullVertices)));
        PlanarRegion rotatedSquare = new PlanarRegion((RigidBodyTransformReadOnly)squarePose, Arrays.asList(concaveHullVertices), convexPolygons);
        PlanarRegion truncatedSquare = REAPlanarRegionTools.truncatePlanarRegionIfIntersectingWithPlane((Point3DReadOnly)groundOrigin, (Vector3DReadOnly)groundNormal, (PlanarRegion)rotatedSquare, (double)0.05, null);
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(REAPlanarRegionTools.class, REAPlanarRegionToolsTest.class);
    }
}

