/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs.postProcessing;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.postProcessing.PointWiggler;
import us.ihmc.robotics.Assert;

public class PointWigglerTest {
    private static final long timeout = 3000000L;
    private static final double epsilon = 1.0E-10;
    private static final int iters = 500;

    @Test
    public void testAverageDistanceVectorCalculationEasy() {
        Point2D pointAtOrigin = new Point2D();
        Point2D topLeft = new Point2D(0.5, 0.5);
        Point2D topRight = new Point2D(0.5, -0.5);
        Point2D bottomLeft = new Point2D(-0.5, 0.5);
        Point2D bottomRight = new Point2D(-0.5, -0.5);
        ArrayList<Point2D> pointsToAvoidByDistance = new ArrayList<Point2D>();
        pointsToAvoidByDistance.add(topLeft);
        pointsToAvoidByDistance.add(topRight);
        pointsToAvoidByDistance.add(bottomLeft);
        pointsToAvoidByDistance.add(bottomRight);
        Vector2DReadOnly calculatedVector = PointWiggler.computeBestShiftVectorToAvoidPoints((Point2DReadOnly)pointAtOrigin, pointsToAvoidByDistance, (double)1.0, (double)0.0);
        Vector2D expectedVector = new Vector2D();
        EuclidCoreTestTools.assertVector2DGeometricallyEquals((Vector2DReadOnly)expectedVector, (Vector2DReadOnly)calculatedVector, (double)1.0E-10);
        pointsToAvoidByDistance.clear();
        pointsToAvoidByDistance.add(new Point2D(0.0, 0.5));
        pointsToAvoidByDistance.add(new Point2D(0.5 * Math.sin(1.0471975511965976), -0.5 * Math.cos(1.0471975511965976)));
        pointsToAvoidByDistance.add(new Point2D(-0.5 * Math.sin(1.0471975511965976), -0.5 * Math.cos(1.0471975511965976)));
        calculatedVector = PointWiggler.computeBestShiftVectorToAvoidPoints((Point2DReadOnly)pointAtOrigin, pointsToAvoidByDistance, (double)1.0, (double)0.0);
        expectedVector = new Vector2D();
        EuclidCoreTestTools.assertVector2DGeometricallyEquals((Vector2DReadOnly)expectedVector, (Vector2DReadOnly)calculatedVector, (double)1.0E-10);
    }

    @Test
    public void testAverageDistanceVectorCalculationEasy2() {
        Point2D pointToShift = new Point2D(0.33, -0.33);
        double desiredDistance = 0.5;
        Point2D topBound = new Point2D(0.53, -0.33);
        Point2D rightBound = new Point2D(0.33, -0.53);
        Point2D leftBound = new Point2D(0.33, -0.13);
        Point2D bottomBound = new Point2D(0.13, -0.33);
        ArrayList<Object> pointsToAvoidByDistance = new ArrayList<Point2DReadOnly>();
        pointsToAvoidByDistance.add(topBound);
        pointsToAvoidByDistance.add(rightBound);
        pointsToAvoidByDistance.add(leftBound);
        pointsToAvoidByDistance.add(bottomBound);
        Vector2D expectedVector = this.computeShiftVectorAssumingNoLimits(pointsToAvoidByDistance, (Point2DReadOnly)pointToShift, desiredDistance);
        Vector2DReadOnly calculatedVector = PointWiggler.computeBestShiftVectorToAvoidPoints((Point2DReadOnly)pointToShift, pointsToAvoidByDistance, (double)desiredDistance, (double)0.0);
        EuclidCoreTestTools.assertVector2DGeometricallyEquals((Vector2DReadOnly)expectedVector, (Vector2DReadOnly)calculatedVector, (double)1.0E-10);
        Point2D shiftedPointExpected = new Point2D((Tuple2DReadOnly)pointToShift);
        shiftedPointExpected.add((Tuple2DReadOnly)expectedVector);
        Point2D shiftedPoint = new Point2D((Tuple2DReadOnly)pointToShift);
        shiftedPoint.add((Tuple2DReadOnly)calculatedVector);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)shiftedPointExpected, (Point2DReadOnly)shiftedPoint, (double)1.0E-10);
        pointToShift = new Point2D(0.33, -0.33);
        topBound = new Point2D(0.43, -0.23);
        rightBound = new Point2D(0.33, -0.53);
        leftBound = new Point2D(0.38, 0.13);
        bottomBound = new Point2D(0.18, -0.28);
        pointsToAvoidByDistance = new ArrayList();
        pointsToAvoidByDistance.add((Point2DReadOnly)topBound);
        pointsToAvoidByDistance.add(rightBound);
        pointsToAvoidByDistance.add(leftBound);
        pointsToAvoidByDistance.add(bottomBound);
        expectedVector = this.computeShiftVectorAssumingNoLimits(pointsToAvoidByDistance, (Point2DReadOnly)pointToShift, desiredDistance);
        ConvexPolygon2D polygon2D = new ConvexPolygon2D();
        pointsToAvoidByDistance.forEach(arg_0 -> ((ConvexPolygon2D)polygon2D).addVertex(arg_0));
        polygon2D.update();
        Assert.assertTrue((boolean)polygon2D.isPointInside((Point2DReadOnly)pointToShift));
        calculatedVector = PointWiggler.computeBestShiftVectorToAvoidPoints((Point2DReadOnly)pointToShift, pointsToAvoidByDistance, (double)desiredDistance, (double)0.0);
        shiftedPoint.add((Tuple2DReadOnly)calculatedVector, (Tuple2DReadOnly)pointToShift);
        shiftedPointExpected.add((Tuple2DReadOnly)expectedVector, (Tuple2DReadOnly)pointToShift);
        EuclidCoreTestTools.assertVector2DGeometricallyEquals((Vector2DReadOnly)expectedVector, (Vector2DReadOnly)calculatedVector, (double)1.0E-10);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)shiftedPointExpected, (Point2DReadOnly)shiftedPoint, (double)1.0E-10);
    }

    @Test
    public void testWithinBoundsOfOneButNotTheOther() {
        Point2D pointToShift = new Point2D(0.15, 0.25);
        double desiredDistance = 0.5;
        Point2D leftBound = new Point2D(0.15, 0.3);
        Point2D rightBound = new Point2D(0.15, -0.6);
        Point2D codedPointExpected = new Point2D(0.15, -0.15);
        Vector2D codedShiftExpected = new Vector2D(0.0, -0.3);
        ArrayList<Point2DReadOnly> pointsToAvoidByDistance = new ArrayList<Point2DReadOnly>();
        pointsToAvoidByDistance.add((Point2DReadOnly)rightBound);
        pointsToAvoidByDistance.add((Point2DReadOnly)leftBound);
        Vector2D expectedVector = this.computeShiftVectorAssumingNoLimits(pointsToAvoidByDistance, (Point2DReadOnly)pointToShift, desiredDistance);
        Vector2DReadOnly calculatedVector = PointWiggler.computeBestShiftVectorToAvoidPoints((Point2DReadOnly)pointToShift, pointsToAvoidByDistance, (double)desiredDistance, (double)0.0);
        EuclidCoreTestTools.assertVector2DGeometricallyEquals((Vector2DReadOnly)expectedVector, (Vector2DReadOnly)calculatedVector, (double)1.0E-10);
        Point2D shiftedPointExpected = new Point2D((Tuple2DReadOnly)pointToShift);
        shiftedPointExpected.add((Tuple2DReadOnly)expectedVector);
        Point2D shiftedPoint = new Point2D((Tuple2DReadOnly)pointToShift);
        shiftedPoint.add((Tuple2DReadOnly)calculatedVector);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)shiftedPointExpected, (Point2DReadOnly)shiftedPoint, (double)1.0E-10);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)codedPointExpected, (Point2DReadOnly)shiftedPoint, (double)1.0E-10);
    }

    @Test
    public void testAverageDistanceVectorWithRandomlyGeneratedNearbyPoints() {
        Random random = new Random(1738L);
        for (int iter = 0; iter < 500; ++iter) {
            int numberOfPoints = RandomNumbers.nextInt((Random)random, (int)2, (int)50);
            Point2D pointToShift = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)100.0);
            double minDistanceAway = 0.5;
            double maxDistanceAway = 1.5;
            double desiredDistanceAway = 1.6;
            ArrayList<Point2D> pointsToAvoid = new ArrayList<Point2D>();
            for (int i = 0; i < numberOfPoints; ++i) {
                Point2D pointToAvoid = new Point2D((Tuple2DReadOnly)pointToShift);
                double distanceAway = RandomNumbers.nextDouble((Random)random, (double)minDistanceAway, (double)maxDistanceAway);
                Vector2D shiftVector = EuclidCoreRandomTools.nextVector2D((Random)random);
                shiftVector.normalize();
                shiftVector.scale(distanceAway);
                pointToAvoid.add((Tuple2DReadOnly)shiftVector);
                pointsToAvoid.add(pointToAvoid);
            }
            Vector2DReadOnly calculatedVector = PointWiggler.computeBestShiftVectorToAvoidPoints((Point2DReadOnly)pointToShift, pointsToAvoid, (double)desiredDistanceAway, (double)0.0);
            Vector2D expectedVector = new Vector2D();
            for (int i = 0; i < numberOfPoints; ++i) {
                Vector2D vectorToPoint = new Vector2D();
                vectorToPoint.sub((Tuple2DReadOnly)pointToShift, (Tuple2DReadOnly)pointsToAvoid.get(i));
                double distanceAway = vectorToPoint.length();
                double distanceToShift = desiredDistanceAway - distanceAway;
                vectorToPoint.normalize();
                vectorToPoint.scale(distanceToShift);
                expectedVector.add((Tuple2DReadOnly)vectorToPoint);
            }
            expectedVector.scale(1.0 / (double)numberOfPoints);
            EuclidCoreTestTools.assertVector2DGeometricallyEquals((Vector2DReadOnly)expectedVector, (Vector2DReadOnly)calculatedVector, (double)1.0E-10);
        }
    }

    @Test
    public void testFancyAverageDistanceVectorWithRandomlyGeneratedNearbyPoints() {
        Random random = new Random(1738L);
        for (int iter = 0; iter < 500; ++iter) {
            int numberOfPoints = RandomNumbers.nextInt((Random)random, (int)2, (int)50);
            Point2D pointToShift = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)100.0);
            double minDistanceAway = 0.5;
            double maxDistanceAway = 1.5;
            double desiredDistanceAway = 1.6;
            ArrayList<Point2DReadOnly> pointsToAvoid = new ArrayList<Point2DReadOnly>();
            for (int i = 0; i < numberOfPoints; ++i) {
                Point2D pointToAvoid = new Point2D((Tuple2DReadOnly)pointToShift);
                double distanceAway = RandomNumbers.nextDouble((Random)random, (double)minDistanceAway, (double)maxDistanceAway);
                Vector2D shiftVector = EuclidCoreRandomTools.nextVector2D((Random)random);
                shiftVector.normalize();
                shiftVector.scale(distanceAway);
                pointToAvoid.add((Tuple2DReadOnly)shiftVector);
                pointsToAvoid.add((Point2DReadOnly)pointToAvoid);
            }
            Vector2DReadOnly calculatedVector = PointWiggler.computeBestShiftVectorToAvoidPoints((Point2DReadOnly)pointToShift, pointsToAvoid, (double)desiredDistanceAway, (double)0.0);
            Vector2D expectedVector = this.computeShiftVectorAssumingNoLimits(pointsToAvoid, (Point2DReadOnly)pointToShift, desiredDistanceAway);
            EuclidCoreTestTools.assertVector2DGeometricallyEquals((Vector2DReadOnly)expectedVector, (Vector2DReadOnly)calculatedVector, (double)1.0E-10);
        }
    }

    private Vector2D computeShiftVectorAssumingNoLimits(List<Point2DReadOnly> pointsToAvoidByDistance, Point2DReadOnly pointToShift, double desiredDistance) {
        Vector2D expectedVector = new Vector2D();
        for (int i = 0; i < pointsToAvoidByDistance.size(); ++i) {
            Point2DReadOnly pointToAvoid = pointsToAvoidByDistance.get(i);
            Vector2D desiredShift = new Vector2D();
            desiredShift.sub((Tuple2DReadOnly)pointToShift, (Tuple2DReadOnly)pointToAvoid);
            desiredShift.scale(desiredDistance / desiredShift.length());
            expectedVector.add((Tuple2DReadOnly)pointToAvoid);
            expectedVector.add((Tuple2DReadOnly)desiredShift);
        }
        expectedVector.scale(1.0 / (double)pointsToAvoidByDistance.size());
        expectedVector.sub((Tuple2DReadOnly)pointToShift);
        return expectedVector;
    }
}

