/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.stage.Stage;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.javafx.ApplicationNoModule;
import us.ihmc.log.LogTools;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.messager.javafx.SharedMemoryJavaFXMessager;
import us.ihmc.pathPlanning.visibilityGraphs.VisibilityGraph;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityMapSolution;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityMapWithNavigableRegion;
import us.ihmc.pathPlanning.visibilityGraphs.ui.messager.UIVisibilityGraphsTopics;
import us.ihmc.pathPlanning.visibilityGraphs.visualizer.VisibilityGraphsTestVisualizer;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class VisibilityGraphsTestVisualizerApplication
extends ApplicationNoModule {
    private static final boolean showBodyPath = true;
    private static final boolean showClusterRawPoints = false;
    private static final boolean showClusterNavigableExtrusions = false;
    private static final boolean showClusterNonNavigableExtrusions = false;
    private static final boolean showRegionInnerConnections = false;
    private static final boolean showRegionInterConnections = false;
    private static VisibilityGraphsTestVisualizer ui;
    private static SharedMemoryJavaFXMessager messager;
    private static AtomicBoolean uiHasBeenConstructed;

    public void start(Stage primaryStage) throws Exception {
        messager = new SharedMemoryJavaFXMessager(UIVisibilityGraphsTopics.API);
        messager.startMessager();
        this.setDefaultUISettings((JavaFXMessager)messager);
        ui = new VisibilityGraphsTestVisualizer(primaryStage, (JavaFXMessager)messager);
        ui.show();
        uiHasBeenConstructed.set(true);
    }

    private void setDefaultUISettings(JavaFXMessager messager) {
        messager.submitMessage(UIVisibilityGraphsTopics.ShowBodyPath, (Object)true);
        messager.submitMessage(UIVisibilityGraphsTopics.ShowClusterRawPoints, (Object)false);
        messager.submitMessage(UIVisibilityGraphsTopics.ShowClusterNavigableExtrusions, (Object)false);
        messager.submitMessage(UIVisibilityGraphsTopics.ShowClusterNonNavigableExtrusions, (Object)false);
        messager.submitMessage(UIVisibilityGraphsTopics.ShowInnerRegionVisibilityMapEdges, (Object)false);
        messager.submitMessage(UIVisibilityGraphsTopics.ShowInterRegionVisibilityMap, (Object)false);
    }

    public void stop() throws Exception {
        ui.stop();
    }

    public VisibilityGraphsTestVisualizer getUI() {
        return ui;
    }

    public SharedMemoryJavaFXMessager getMessager() {
        return messager;
    }

    public void startOnAThread() {
        Thread thread = new Thread(() -> VisibilityGraphsTestVisualizerApplication.launch((String[])new String[0]));
        thread.start();
        LogTools.info((String)"Waiting for UI to be constructed.");
        while (!uiHasBeenConstructed.get()) {
            ThreadTools.sleep((long)100L);
        }
        LogTools.info((String)"UI is constructed.");
    }

    public static void main(String[] args) {
        VisibilityGraphsTestVisualizerApplication application = new VisibilityGraphsTestVisualizerApplication();
        application.startOnAThread();
        ThreadTools.sleepForever();
    }

    public void submitVisibilityGraphToVisualizer(VisibilityGraph visibilityGraph) {
        messager.submitMessage(UIVisibilityGraphsTopics.VisibilityGraph, (Object)visibilityGraph);
    }

    public void submitVisibilityGraphSolutionToVisualizer(VisibilityMapSolution visibilityMapSolution) {
        messager.submitMessage(UIVisibilityGraphsTopics.StartVisibilityMap, (Object)visibilityMapSolution.getStartMap());
        messager.submitMessage(UIVisibilityGraphsTopics.GoalVisibilityMap, (Object)visibilityMapSolution.getGoalMap());
        messager.submitMessage(UIVisibilityGraphsTopics.InterRegionVisibilityMap, (Object)visibilityMapSolution.getInterRegionVisibilityMap());
        this.submitNavigableRegionsToVisualizer(visibilityMapSolution.getVisibilityMapsWithNavigableRegions());
    }

    public void submitNavigableRegionsToVisualizer(List<VisibilityMapWithNavigableRegion> navigableRegions) {
        messager.submitMessage(UIVisibilityGraphsTopics.NavigableRegionData, navigableRegions);
        messager.submitMessage(UIVisibilityGraphsTopics.NavigableRegionVisibilityMap, navigableRegions);
    }

    public void submitStartToVisualizer(Point3D start) {
        messager.submitMessage(UIVisibilityGraphsTopics.StartPosition, (Object)start);
    }

    public void submitGoalToVisualizer(Point3D goal) {
        messager.submitMessage(UIVisibilityGraphsTopics.GoalPosition, (Object)goal);
    }

    public void submitPlanarRegionsListToVisualizer(PlanarRegionsList planarRegionsList) {
        messager.submitMessage(UIVisibilityGraphsTopics.PlanarRegionData, (Object)planarRegionsList);
    }

    public void submitShadowPlanarRegionsListToVisualizer(PlanarRegionsList planarRegionsList) {
        messager.submitMessage(UIVisibilityGraphsTopics.ShadowPlanarRegionData, (Object)planarRegionsList);
    }

    static {
        uiHasBeenConstructed = new AtomicBoolean(false);
    }
}

