/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.messager.javafx.SharedMemoryJavaFXMessager;
import us.ihmc.pathPlanning.DataSet;
import us.ihmc.pathPlanning.DataSetIOTools;
import us.ihmc.pathPlanning.PlannerInput;
import us.ihmc.pathPlanning.visibilityGraphs.NavigableRegions;
import us.ihmc.pathPlanning.visibilityGraphs.NavigableRegionsManager;
import us.ihmc.pathPlanning.visibilityGraphs.VisibilityGraphsTestVisualizerApplication;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.NavigableRegion;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityMapSolution;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.DefaultVisibilityGraphParameters;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.ui.messager.UIVisibilityGraphsTopics;
import us.ihmc.robotics.PlanarRegionFileTools;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class VisibilityGraphsPlanarRegionPairsDatasetVisualizer {
    private static final boolean fullyExpandVisibilityGraph = true;

    public static void openResourceAndVisualizePairs(String dataSetName) {
        DataSet dataSet = DataSetIOTools.loadDataSet((String)dataSetName);
        String datasetName = dataSet.getName();
        LogTools.info((String)("Loaded " + datasetName));
        Point3D start = dataSet.getPlannerInput().getStartPosition();
        Point3D goal = dataSet.getPlannerInput().getGoalPosition();
        PlanarRegionsList planarRegionsList = dataSet.getPlanarRegionsList();
        VisibilityGraphsTestVisualizerApplication visualizerApplication = new VisibilityGraphsTestVisualizerApplication();
        visualizerApplication.startOnAThread();
        SharedMemoryJavaFXMessager messager = visualizerApplication.getMessager();
        AtomicReference previousDatasetRequested = messager.createInput(UIVisibilityGraphsTopics.PreviousDatasetRequest, (Object)false);
        AtomicReference nextDatasetRequested = messager.createInput(UIVisibilityGraphsTopics.NextDatasetRequest, (Object)false);
        AtomicReference reloadDatasetRequested = messager.createInput(UIVisibilityGraphsTopics.ReloadDatasetRequest, (Object)false);
        VisibilityGraphsPlanarRegionPairsDatasetVisualizer.solveAndVisualize(start, goal, planarRegionsList, visualizerApplication);
        ThreadTools.sleep((long)3000L);
        List planarRegionsAsList = planarRegionsList.getPlanarRegionsAsList();
        int pairNumber = -1;
        int size = planarRegionsAsList.size();
        int indexOne = 0;
        int indexTwo = 1;
        boolean incrementIndices = true;
        while (true) {
            NavigableRegion region0;
            List obstacles0;
            PlanarRegion planarRegionOne = (PlanarRegion)planarRegionsAsList.get(indexOne);
            PlanarRegion planarRegionTwo = (PlanarRegion)planarRegionsAsList.get(indexTwo);
            PlanarRegionsList listToVisualize = new PlanarRegionsList();
            listToVisualize.addPlanarRegion(planarRegionOne);
            listToVisualize.addPlanarRegion(planarRegionTwo);
            DefaultVisibilityGraphParameters parameters = new DefaultVisibilityGraphParameters();
            NavigableRegions navigableRegions = new NavigableRegions((VisibilityGraphsParametersReadOnly)parameters, listToVisualize);
            navigableRegions.createNavigableRegions();
            List naviableRegionsList = navigableRegions.getNavigableRegionsList();
            if (!naviableRegionsList.isEmpty() && !(obstacles0 = (region0 = (NavigableRegion)naviableRegionsList.get(0)).getObstacleClusters()).isEmpty()) {
                pairNumber = incrementIndices ? ++pairNumber : --pairNumber;
                System.out.println("Pair number: " + pairNumber + ", indexOne = " + indexOne + ", indexTwo = " + indexTwo);
                VisibilityGraphsPlanarRegionPairsDatasetVisualizer.solveAndVisualize(start, goal, listToVisualize, visualizerApplication);
                Boolean previousRequested = (Boolean)previousDatasetRequested.get();
                Boolean nextRequested = (Boolean)nextDatasetRequested.get();
                while (!previousRequested.booleanValue() && !nextRequested.booleanValue()) {
                    if (((Boolean)reloadDatasetRequested.get()).booleanValue()) {
                        VisibilityGraphsPlanarRegionPairsDatasetVisualizer.exportPlanarRegionPairDataset(pairNumber, indexOne, indexTwo, planarRegionOne, planarRegionTwo, start, goal);
                        messager.submitMessage(UIVisibilityGraphsTopics.ReloadDatasetRequest, (Object)false);
                        ThreadTools.sleep((long)300L);
                    }
                    ThreadTools.sleep((long)100L);
                    previousRequested = (Boolean)previousDatasetRequested.get();
                    nextRequested = (Boolean)nextDatasetRequested.get();
                }
                if (previousRequested.booleanValue()) {
                    incrementIndices = false;
                }
                if (nextRequested.booleanValue()) {
                    incrementIndices = true;
                }
                messager.submitMessage(UIVisibilityGraphsTopics.PreviousDatasetRequest, (Object)false);
                messager.submitMessage(UIVisibilityGraphsTopics.NextDatasetRequest, (Object)false);
            }
            int[] newIndices = incrementIndices ? VisibilityGraphsPlanarRegionPairsDatasetVisualizer.incrementIndices(indexOne, indexTwo, size) : VisibilityGraphsPlanarRegionPairsDatasetVisualizer.decrementIndices(indexOne, indexTwo, size);
            indexOne = newIndices[0];
            indexTwo = newIndices[1];
        }
    }

    private static int[] incrementIndices(int indexOne, int indexTwo, int size) {
        if (++indexTwo >= size) {
            indexTwo = 0;
            indexOne = (indexOne + 1) % size;
        }
        if (indexOne == indexTwo) {
            return VisibilityGraphsPlanarRegionPairsDatasetVisualizer.incrementIndices(indexOne, indexTwo, size);
        }
        return new int[]{indexOne, indexTwo};
    }

    private static int[] decrementIndices(int indexOne, int indexTwo, int size) {
        if (--indexTwo < 0) {
            indexTwo = size - 1;
            if (--indexOne < 0) {
                indexOne = size - 1;
            }
        }
        if (indexOne == indexTwo) {
            return VisibilityGraphsPlanarRegionPairsDatasetVisualizer.decrementIndices(indexOne, indexTwo, size);
        }
        return new int[]{indexOne, indexTwo};
    }

    private static void solveAndVisualize(Point3D start, Point3D goal, PlanarRegionsList planarRegionsList, VisibilityGraphsTestVisualizerApplication visualizerApplication) {
        visualizerApplication.submitPlanarRegionsListToVisualizer(planarRegionsList);
        DefaultVisibilityGraphParameters parameters = new DefaultVisibilityGraphParameters();
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList());
        navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal, true);
        VisibilityMapSolution visibilityMapSolution = navigableRegionsManager.getVisibilityMapSolution();
        visualizerApplication.submitVisibilityGraphSolutionToVisualizer(visibilityMapSolution);
    }

    private static void exportPlanarRegionPairDataset(int pairIndex, int indexOne, int indexTwo, PlanarRegion planarRegionOne, PlanarRegion planarRegionTwo, Point3D start, Point3D goal) {
        PlanarRegionsList planarRegionsListToExport = new PlanarRegionsList();
        planarRegionsListToExport.addPlanarRegion(planarRegionOne);
        planarRegionsListToExport.addPlanarRegion(planarRegionTwo);
        String datasetNameToExport = PlanarRegionFileTools.getDate() + "_" + pairIndex + "_" + indexOne + "_" + indexTwo;
        DataSet dataSet = new DataSet(datasetNameToExport, planarRegionsListToExport);
        PlannerInput plannerInput = new PlannerInput();
        plannerInput.setStartPosition((Point3DReadOnly)start);
        plannerInput.setGoalPosition((Point3DReadOnly)goal);
        dataSet.setPlannerInput(plannerInput);
        DataSetIOTools.exportDataSet((DataSet)dataSet);
    }

    public static void main(String[] args) {
        LogTools.info((String)"Click on Next to cycle through the PlanarRegion pairs.");
        String resourceName = "20171215_214730_CinderBlockField";
        VisibilityGraphsPlanarRegionPairsDatasetVisualizer.openResourceAndVisualizePairs(resourceName);
    }
}

