/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.NavigableRegions;
import us.ihmc.pathPlanning.visibilityGraphs.VisibilityGraph;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.Connection;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.ConnectionPoint3D;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.InterRegionVisibilityMap;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.NavigableRegion;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityGraphEdge;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityGraphNavigableRegion;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityGraphNode;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityMap;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityMapSolution;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityMapWithNavigableRegion;
import us.ihmc.pathPlanning.visibilityGraphs.interfaces.InterRegionConnectionFilter;
import us.ihmc.pathPlanning.visibilityGraphs.interfaces.NavigableExtrusionDistanceCalculator;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.DefaultVisibilityGraphParameters;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersBasics;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersReadOnly;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionFilter;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;

public class VisibilityGraphTest {
    private static final double EPSILON = 1.0E-10;

    @Test
    public void testVisibilityGraphJustOneSquare() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        ArrayList<PlanarRegion> planarRegions = new ArrayList<PlanarRegion>();
        RigidBodyTransform transform = new RigidBodyTransform();
        Point2D pointA = new Point2D(9.99, -0.01);
        Point2D pointB = new Point2D(9.99, 1.01);
        Point2D pointC = new Point2D(11.01, 1.01);
        Point2D pointD = new Point2D(11.01, -0.01);
        transform.getTranslation().set(-10.0, 0.0, 0.0);
        ConvexPolygon2D polygon0_0 = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[]{pointA, pointB, pointC, pointD}));
        PlanarRegion planarRegion0 = new PlanarRegion((RigidBodyTransformReadOnly)transform, (Vertex2DSupplier)polygon0_0);
        planarRegion0.setRegionId(97);
        planarRegions.add(planarRegion0);
        NavigableRegions navigableRegions = new NavigableRegions((VisibilityGraphsParametersReadOnly)parameters, planarRegions);
        navigableRegions.createNavigableRegions();
        List navigableRegionsList = navigableRegions.getNavigableRegionsList();
        Assert.assertEquals((long)1L, (long)navigableRegionsList.size());
        NavigableRegion navigableRegion = (NavigableRegion)navigableRegionsList.get(0);
        Assert.assertEquals((long)97L, (long)navigableRegion.getMapId());
        final double maxDistance = 0.1;
        InterRegionConnectionFilter interRegionFilter = new InterRegionConnectionFilter(){

            public boolean isConnectionValid(ConnectionPoint3D source, ConnectionPoint3D target) {
                double distance = source.distance((Point3DReadOnly)target);
                return distance < this.getMaximumInterRegionConnectionDistance();
            }

            public double getMaximumInterRegionConnectionDistance() {
                return maxDistance;
            }
        };
        VisibilityGraph visibilityGraph = new VisibilityGraph(navigableRegions, interRegionFilter, (VisibilityGraphsParametersReadOnly)parameters);
        visibilityGraph.fullyExpandVisibilityGraph();
        ArrayList visibilityGraphNavigableRegions = visibilityGraph.getVisibilityGraphNavigableRegions();
        Assert.assertEquals((long)1L, (long)visibilityGraphNavigableRegions.size());
        VisibilityGraphNavigableRegion visibilityGraphNavigableRegion = (VisibilityGraphNavigableRegion)visibilityGraphNavigableRegions.get(0);
        HashSet navigableRegionEdges = visibilityGraphNavigableRegion.getAllEdges();
        Assert.assertEquals((long)28L, (long)navigableRegionEdges.size());
        List homeRegionNodes = visibilityGraphNavigableRegion.getHomeRegionNodes();
        Assert.assertEquals((long)8L, (long)homeRegionNodes.size());
        List crossRegionEdges = visibilityGraph.getCrossRegionEdges();
        Assert.assertEquals((long)0L, (long)crossRegionEdges.size());
        ConnectionPoint3D connectionA = new ConnectionPoint3D(0.0, 1.0, 0.0, 0);
        ConnectionPoint3D connectionAB = new ConnectionPoint3D(0.5, 1.0, 0.0, 0);
        ConnectionPoint3D connectionB = new ConnectionPoint3D(1.0, 1.0, 0.0, 0);
        ConnectionPoint3D connectionBC = new ConnectionPoint3D(1.0, 0.5, 0.0, 0);
        ConnectionPoint3D connectionC = new ConnectionPoint3D(1.0, 0.0, 0.0, 0);
        ConnectionPoint3D connectionCD = new ConnectionPoint3D(0.5, 0.0, 0.0, 0);
        ConnectionPoint3D connectionD = new ConnectionPoint3D(0.0, 0.0, 0.0, 0);
        ConnectionPoint3D connectionDA = new ConnectionPoint3D(0.0, 0.5, 0.0, 0);
        Assert.assertTrue((boolean)this.edgeListContains(navigableRegionEdges, connectionA, connectionAB));
        Assert.assertTrue((boolean)this.edgeListContains(navigableRegionEdges, connectionA, connectionDA));
        Assert.assertTrue((boolean)this.edgeListContains(navigableRegionEdges, connectionD, connectionBC));
        VisibilityMapSolution visibilityMapSolution = visibilityGraph.createVisibilityMapSolution();
        ArrayList visibilityMapsWithNavigableRegions = visibilityMapSolution.getVisibilityMapsWithNavigableRegions();
        Assert.assertEquals((long)1L, (long)visibilityMapsWithNavigableRegions.size());
        VisibilityMapWithNavigableRegion innerMapAndRegion0 = (VisibilityMapWithNavigableRegion)visibilityMapsWithNavigableRegions.get(0);
        VisibilityMap innerMap0 = innerMapAndRegion0.getVisibilityMapInWorld();
        Set vertices0 = innerMap0.getVertices();
        Set connections0 = innerMap0.getConnections();
        Assert.assertEquals((long)8L, (long)vertices0.size());
        Assert.assertTrue((boolean)vertices0.contains(connectionA));
        Assert.assertTrue((boolean)vertices0.contains(connectionAB));
        Assert.assertTrue((boolean)vertices0.contains(connectionB));
        Assert.assertTrue((boolean)vertices0.contains(connectionBC));
        Assert.assertTrue((boolean)vertices0.contains(connectionC));
        Assert.assertTrue((boolean)vertices0.contains(connectionCD));
        Assert.assertTrue((boolean)vertices0.contains(connectionD));
        Assert.assertTrue((boolean)vertices0.contains(connectionDA));
        Assert.assertEquals((long)28L, (long)connections0.size());
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionA, connectionAB));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionA, connectionB));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionA, connectionBC));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionA, connectionC));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionA, connectionCD));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionA, connectionD));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionA, connectionDA));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionAB, connectionB));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionAB, connectionBC));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionAB, connectionC));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionAB, connectionCD));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionAB, connectionD));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionAB, connectionDA));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionB, connectionBC));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionB, connectionC));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionB, connectionCD));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionB, connectionD));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionB, connectionDA));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionBC, connectionC));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionBC, connectionCD));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionBC, connectionD));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionBC, connectionDA));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionC, connectionCD));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionC, connectionD));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionC, connectionDA));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionCD, connectionD));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionCD, connectionDA));
        Assert.assertTrue((boolean)this.connectionsContain(connections0, connectionD, connectionDA));
        InterRegionVisibilityMap interRegionVisibilityMap = visibilityMapSolution.getInterRegionVisibilityMap();
        Assert.assertTrue((boolean)interRegionVisibilityMap.getVisibilityMapInWorld().isEmpty());
        double searchHostEpsilon = 0.01;
        double ceilingHeight = 2.0;
        visibilityGraph.setStart((Point3DReadOnly)new Point3D(0.4, 0.35, 0.005), searchHostEpsilon, ceilingHeight);
        VisibilityGraphNode startNode = visibilityGraph.getStartNode();
        Assert.assertEquals((long)97L, (long)startNode.getRegionId());
        HashSet startEdges = visibilityGraph.getStartEdges();
        Point2DReadOnly startInLocal = startNode.getPoint2DInLocal();
        ConnectionPoint3D startInWorld = startNode.getPointInWorld();
        Assert.assertTrue((boolean)startInLocal.epsilonEquals((EuclidGeometry)new Point2D(10.4, 0.35), 1.0E-10));
        Assert.assertTrue((boolean)startInWorld.epsilonEquals((EuclidGeometry)new Point3D(0.4, 0.35, 0.0), 1.0E-10));
        Assert.assertEquals((long)8L, (long)startEdges.size());
        visibilityGraph.setGoal((Point3DReadOnly)new Point3D(0.6, 0.55, 0.003), searchHostEpsilon, ceilingHeight);
        VisibilityGraphNode goalNode = visibilityGraph.getGoalNode();
        Assert.assertEquals((long)97L, (long)goalNode.getRegionId());
        HashSet goalEdges = visibilityGraph.getGoalEdges();
        Point2DReadOnly goalInLocal = goalNode.getPoint2DInLocal();
        ConnectionPoint3D goalInWorld = goalNode.getPointInWorld();
        Assert.assertTrue((boolean)goalInLocal.epsilonEquals((EuclidGeometry)new Point2D(10.6, 0.55), 1.0E-10));
        Assert.assertTrue((boolean)goalInWorld.epsilonEquals((EuclidGeometry)new Point3D(0.6, 0.55, 0.0), 1.0E-10));
        Assert.assertEquals((long)9L, (long)goalEdges.size());
        Assert.assertEquals((long)9L, (long)startEdges.size());
    }

    @Test
    public void testVisibilityGraphTwoSquares() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        ArrayList<PlanarRegion> planarRegions = new ArrayList<PlanarRegion>();
        Point2D pointA = new Point2D(-0.01, -0.01);
        Point2D pointB = new Point2D(-0.01, 1.01);
        Point2D pointC = new Point2D(1.01, 1.01);
        Point2D pointD = new Point2D(1.01, -0.01);
        Point2D pointE = new Point2D(6.99, 2.99);
        Point2D pointF = new Point2D(6.99, 4.01);
        Point2D pointG = new Point2D(8.01, 4.01);
        Point2D pointH = new Point2D(8.01, 2.99);
        ConvexPolygon2D polygon0_0 = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[]{pointA, pointB, pointC, pointD}));
        ConvexPolygon2D polygon1_0 = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[]{pointE, pointF, pointG, pointH}));
        RigidBodyTransform transform0 = new RigidBodyTransform();
        RigidBodyTransform transform1 = new RigidBodyTransform();
        transform1.getTranslation().set(-5.9, -3.0, 0.0);
        PlanarRegion planarRegion0 = new PlanarRegion((RigidBodyTransformReadOnly)transform0, (Vertex2DSupplier)polygon0_0);
        planarRegion0.setRegionId(77);
        PlanarRegion planarRegion1 = new PlanarRegion((RigidBodyTransformReadOnly)transform1, (Vertex2DSupplier)polygon1_0);
        planarRegion1.setRegionId(63);
        planarRegions.add(planarRegion0);
        planarRegions.add(planarRegion1);
        NavigableRegions navigableRegions = new NavigableRegions((VisibilityGraphsParametersReadOnly)parameters, planarRegions);
        navigableRegions.createNavigableRegions();
        List naviableRegionsList = navigableRegions.getNavigableRegionsList();
        Assert.assertEquals((long)2L, (long)naviableRegionsList.size());
        NavigableRegion navigableRegion0 = (NavigableRegion)naviableRegionsList.get(0);
        NavigableRegion navigableRegion1 = (NavigableRegion)naviableRegionsList.get(1);
        Assert.assertEquals((long)77L, (long)navigableRegion0.getMapId());
        Assert.assertEquals((long)63L, (long)navigableRegion1.getMapId());
        final double maxDistance = 0.58;
        InterRegionConnectionFilter filter = new InterRegionConnectionFilter(){

            public boolean isConnectionValid(ConnectionPoint3D source, ConnectionPoint3D target) {
                double distance = source.distance((Point3DReadOnly)target);
                return distance < this.getMaximumInterRegionConnectionDistance();
            }

            public double getMaximumInterRegionConnectionDistance() {
                return maxDistance;
            }
        };
        VisibilityGraph visibilityGraph = new VisibilityGraph(navigableRegions, filter, (VisibilityGraphsParametersReadOnly)parameters);
        visibilityGraph.fullyExpandVisibilityGraph();
        ArrayList visibilityGraphNavigableRegions = visibilityGraph.getVisibilityGraphNavigableRegions();
        Assert.assertEquals((long)2L, (long)visibilityGraphNavigableRegions.size());
        VisibilityGraphNavigableRegion visibilityGraphNavigableRegion0 = (VisibilityGraphNavigableRegion)visibilityGraphNavigableRegions.get(0);
        VisibilityGraphNavigableRegion visibilityGraphNavigableRegion1 = (VisibilityGraphNavigableRegion)visibilityGraphNavigableRegions.get(1);
        HashSet internalEdges0 = visibilityGraphNavigableRegion0.getAllEdges();
        HashSet internalEdges1 = visibilityGraphNavigableRegion1.getAllEdges();
        Assert.assertEquals((long)28L, (long)internalEdges0.size());
        Assert.assertEquals((long)28L, (long)internalEdges1.size());
        List nodes0 = visibilityGraphNavigableRegion0.getHomeRegionNodes();
        List nodes1 = visibilityGraphNavigableRegion1.getHomeRegionNodes();
        Assert.assertEquals((long)8L, (long)nodes0.size());
        Assert.assertEquals((long)8L, (long)nodes1.size());
        ConnectionPoint3D connectionA = new ConnectionPoint3D(0.0, 0.0, 0.0, 0);
        ConnectionPoint3D connectionAB = new ConnectionPoint3D(0.0, 0.5, 0.0, 0);
        ConnectionPoint3D connectionB = new ConnectionPoint3D(0.0, 1.0, 0.0, 0);
        ConnectionPoint3D connectionBC = new ConnectionPoint3D(0.5, 1.0, 0.0, 0);
        ConnectionPoint3D connectionC = new ConnectionPoint3D(1.0, 1.0, 0.0, 0);
        ConnectionPoint3D connectionCD = new ConnectionPoint3D(1.0, 0.5, 0.0, 0);
        ConnectionPoint3D connectionD = new ConnectionPoint3D(1.0, 0.0, 0.0, 0);
        ConnectionPoint3D connectionDA = new ConnectionPoint3D(0.5, 0.0, 0.0, 0);
        ConnectionPoint3D connectionE = new ConnectionPoint3D(1.1, 0.0, 0.0, 0);
        ConnectionPoint3D connectionEF = new ConnectionPoint3D(1.1, 0.5, 0.0, 0);
        ConnectionPoint3D connectionF = new ConnectionPoint3D(1.1, 1.0, 0.0, 0);
        ConnectionPoint3D connectionFG = new ConnectionPoint3D(1.6, 1.0, 0.0, 0);
        ConnectionPoint3D connectionG = new ConnectionPoint3D(2.1, 1.0, 0.0, 0);
        ConnectionPoint3D connectionGH = new ConnectionPoint3D(2.1, 0.5, 0.0, 0);
        ConnectionPoint3D connectionH = new ConnectionPoint3D(2.1, 0.0, 0.0, 0);
        ConnectionPoint3D connectionHE = new ConnectionPoint3D(1.6, 0.0, 0.0, 0);
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes0, connectionA));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes0, connectionAB));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes0, connectionB));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes0, connectionBC));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes0, connectionC));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes0, connectionCD));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes0, connectionD));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes0, connectionDA));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes1, connectionE));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes1, connectionEF));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes1, connectionF));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes1, connectionFG));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes1, connectionG));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes1, connectionGH));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes1, connectionH));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes1, connectionHE));
        List crossRegionEdges = visibilityGraph.getCrossRegionEdges();
        Assert.assertEquals((long)3L, (long)crossRegionEdges.size());
        Assert.assertTrue((boolean)this.edgeListContains(crossRegionEdges, connectionC, connectionF));
        Assert.assertFalse((boolean)this.edgeListContains(crossRegionEdges, connectionC, connectionEF));
        Assert.assertFalse((boolean)this.edgeListContains(crossRegionEdges, connectionCD, connectionF));
        Assert.assertTrue((boolean)this.edgeListContains(crossRegionEdges, connectionCD, connectionEF));
        Assert.assertFalse((boolean)this.edgeListContains(crossRegionEdges, connectionCD, connectionE));
        Assert.assertFalse((boolean)this.edgeListContains(crossRegionEdges, connectionD, connectionEF));
        Assert.assertTrue((boolean)this.edgeListContains(crossRegionEdges, connectionD, connectionE));
        VisibilityMapSolution visibilityMapSolution = visibilityGraph.createVisibilityMapSolution();
        ArrayList visibilityMapsWithNavigableRegions = visibilityMapSolution.getVisibilityMapsWithNavigableRegions();
        Assert.assertEquals((long)2L, (long)visibilityMapsWithNavigableRegions.size());
        VisibilityMapWithNavigableRegion innerMapAndRegion0 = (VisibilityMapWithNavigableRegion)visibilityMapsWithNavigableRegions.get(0);
        VisibilityMapWithNavigableRegion innerMapAdnRegion1 = (VisibilityMapWithNavigableRegion)visibilityMapsWithNavigableRegions.get(1);
        VisibilityMap innerMap0 = innerMapAndRegion0.getVisibilityMapInWorld();
        VisibilityMap innerMap1 = innerMapAdnRegion1.getVisibilityMapInWorld();
        Set connections0 = innerMap0.getConnections();
        Set vertices0 = innerMap0.getVertices();
        Assert.assertEquals((long)8L, (long)vertices0.size());
        Assert.assertEquals((long)28L, (long)connections0.size());
        InterRegionVisibilityMap interRegionVisibilityMap = visibilityMapSolution.getInterRegionVisibilityMap();
        VisibilityMap interRegionVisibilityMapInWorld = interRegionVisibilityMap.getVisibilityMapInWorld();
        Set interRegionConnections = interRegionVisibilityMapInWorld.getConnections();
        Set interRegionVertices = interRegionVisibilityMapInWorld.getVertices();
        Assert.assertEquals((long)0L, (long)interRegionVertices.size());
        Assert.assertEquals((long)3L, (long)crossRegionEdges.size());
        Assert.assertTrue((boolean)this.connectionsContain(interRegionConnections, connectionC, connectionF));
        Assert.assertFalse((boolean)this.connectionsContain(interRegionConnections, connectionC, connectionEF));
        Assert.assertFalse((boolean)this.connectionsContain(interRegionConnections, connectionCD, connectionF));
        Assert.assertTrue((boolean)this.connectionsContain(interRegionConnections, connectionCD, connectionEF));
        Assert.assertFalse((boolean)this.connectionsContain(interRegionConnections, connectionCD, connectionE));
        Assert.assertFalse((boolean)this.connectionsContain(interRegionConnections, connectionD, connectionEF));
        Assert.assertTrue((boolean)this.connectionsContain(interRegionConnections, connectionD, connectionE));
        double searchHostEpsilon = 0.01;
        double ceilingHeight = 2.0;
        visibilityGraph.setStart((Point3DReadOnly)new Point3D(0.4, 0.35, 0.005), ceilingHeight, searchHostEpsilon);
        VisibilityGraphNode startNode = visibilityGraph.getStartNode();
        Assert.assertEquals((long)77L, (long)startNode.getRegionId());
        HashSet startEdges = visibilityGraph.getStartEdges();
        Point2DReadOnly startInLocal = startNode.getPoint2DInLocal();
        ConnectionPoint3D startInWorld = startNode.getPointInWorld();
        Assert.assertTrue((boolean)startInLocal.epsilonEquals((EuclidGeometry)new Point2D(0.4, 0.35), 1.0E-10));
        Assert.assertTrue((boolean)startInWorld.epsilonEquals((EuclidGeometry)new Point3D(0.4, 0.35, 0.0), 1.0E-10));
        Assert.assertEquals((long)8L, (long)startEdges.size());
        visibilityGraph.setGoal((Point3DReadOnly)new Point3D(1.5, 0.55, 0.003), ceilingHeight, searchHostEpsilon);
        VisibilityGraphNode goalNode = visibilityGraph.getGoalNode();
        Assert.assertEquals((long)63L, (long)goalNode.getRegionId());
        HashSet goalEdges = visibilityGraph.getGoalEdges();
        Point2DReadOnly goalInLocal = goalNode.getPoint2DInLocal();
        ConnectionPoint3D goalInWorld = goalNode.getPointInWorld();
        Assert.assertTrue((boolean)goalInLocal.epsilonEquals((EuclidGeometry)new Point2D(7.4, 3.55), 1.0E-10));
        Assert.assertTrue((boolean)goalInWorld.epsilonEquals((EuclidGeometry)new Point3D(1.5, 0.55, 0.0), 1.0E-10));
        Assert.assertEquals((long)8L, (long)startEdges.size());
        Assert.assertEquals((long)9L, (long)goalEdges.size());
    }

    @Disabled(value="Need to double check this test and fix it.")
    @Test
    public void testVisibilityGraphTwoSquaresWithImpassableBarrier() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        ArrayList<PlanarRegion> planarRegions = new ArrayList<PlanarRegion>();
        Point2D pointA = new Point2D(-0.01, -0.01);
        Point2D pointB = new Point2D(-0.01, 1.01);
        Point2D pointC = new Point2D(1.01, 1.01);
        Point2D pointD = new Point2D(1.01, -0.01);
        Point2D pointE = new Point2D(-0.01, -0.01);
        Point2D pointF = new Point2D(-0.01, 1.01);
        Point2D pointG = new Point2D(1.01, 1.01);
        Point2D pointH = new Point2D(1.01, -0.01);
        ConvexPolygon2D polygon0_0 = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[]{pointA, pointB, pointC, pointD}));
        ConvexPolygon2D polygon1_0 = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[]{pointE, pointF, pointG, pointH}));
        RigidBodyTransform transform0 = new RigidBodyTransform();
        RigidBodyTransform transform1 = new RigidBodyTransform();
        transform1.getTranslation().set(1.25, 0.0, 0.0);
        PlanarRegion planarRegion0 = new PlanarRegion((RigidBodyTransformReadOnly)transform0, (Vertex2DSupplier)polygon0_0);
        planarRegion0.setRegionId(77);
        PlanarRegion planarRegion1 = new PlanarRegion((RigidBodyTransformReadOnly)transform1, (Vertex2DSupplier)polygon1_0);
        planarRegion1.setRegionId(63);
        planarRegions.add(planarRegion0);
        planarRegions.add(planarRegion1);
        Point2D barrierPointI = new Point2D(0.0, 0.0);
        Point2D barrierPointJ = new Point2D(0.0, 1.0);
        Point2D barrierPointK = new Point2D(1.0, 1.0);
        Point2D barrierPointL = new Point2D(1.0, 0.0);
        ConvexPolygon2D barrierPolygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[]{barrierPointI, barrierPointJ, barrierPointK, barrierPointL}));
        RigidBodyTransform barrierTransform = new RigidBodyTransform();
        barrierTransform.getRotation().setEuler(0.0, -1.5707963267948966, 0.0);
        barrierTransform.getTranslation().set(1.125, 0.0, 0.0);
        PlanarRegion barrierPlanarRegion = new PlanarRegion((RigidBodyTransformReadOnly)barrierTransform, (Vertex2DSupplier)barrierPolygon);
        barrierPlanarRegion.setRegionId(99);
        planarRegions.add(barrierPlanarRegion);
        NavigableRegions navigableRegions = new NavigableRegions((VisibilityGraphsParametersReadOnly)parameters, planarRegions);
        navigableRegions.createNavigableRegions();
        final double maxDistance = 0.58;
        InterRegionConnectionFilter filter = new InterRegionConnectionFilter(){

            public boolean isConnectionValid(ConnectionPoint3D source, ConnectionPoint3D target) {
                double distance = source.distance((Point3DReadOnly)target);
                return distance < this.getMaximumInterRegionConnectionDistance();
            }

            public double getMaximumInterRegionConnectionDistance() {
                return maxDistance;
            }
        };
        VisibilityGraph visibilityGraph = new VisibilityGraph(navigableRegions, filter, (VisibilityGraphsParametersReadOnly)parameters);
        visibilityGraph.fullyExpandVisibilityGraph();
        ArrayList visibilityGraphNavigableRegions = visibilityGraph.getVisibilityGraphNavigableRegions();
        Assert.assertEquals((long)2L, (long)visibilityGraphNavigableRegions.size());
        VisibilityGraphNavigableRegion visibilityGraphNavigableRegion0 = (VisibilityGraphNavigableRegion)visibilityGraphNavigableRegions.get(0);
        VisibilityGraphNavigableRegion visibilityGraphNavigableRegion1 = (VisibilityGraphNavigableRegion)visibilityGraphNavigableRegions.get(1);
        HashSet internalEdges0 = visibilityGraphNavigableRegion0.getAllEdges();
        HashSet internalEdges1 = visibilityGraphNavigableRegion1.getAllEdges();
        Assert.assertEquals((long)28L, (long)internalEdges0.size());
        Assert.assertEquals((long)28L, (long)internalEdges1.size());
        List nodes0 = visibilityGraphNavigableRegion0.getHomeRegionNodes();
        List nodes1 = visibilityGraphNavigableRegion1.getHomeRegionNodes();
        Assert.assertEquals((long)8L, (long)nodes0.size());
        Assert.assertEquals((long)8L, (long)nodes1.size());
        ConnectionPoint3D connectionA = new ConnectionPoint3D(0.0, 0.0, 0.0, 0);
        ConnectionPoint3D connectionAB = new ConnectionPoint3D(0.0, 0.5, 0.0, 0);
        ConnectionPoint3D connectionB = new ConnectionPoint3D(0.0, 1.0, 0.0, 0);
        ConnectionPoint3D connectionBC = new ConnectionPoint3D(0.5, 1.0, 0.0, 0);
        ConnectionPoint3D connectionC = new ConnectionPoint3D(1.0, 1.0, 0.0, 0);
        ConnectionPoint3D connectionCD = new ConnectionPoint3D(1.0, 0.5, 0.0, 0);
        ConnectionPoint3D connectionD = new ConnectionPoint3D(1.0, 0.0, 0.0, 0);
        ConnectionPoint3D connectionDA = new ConnectionPoint3D(0.5, 0.0, 0.0, 0);
        ConnectionPoint3D connectionE = new ConnectionPoint3D(1.25, 0.0, 0.0, 0);
        ConnectionPoint3D connectionEF = new ConnectionPoint3D(1.25, 0.5, 0.0, 0);
        ConnectionPoint3D connectionF = new ConnectionPoint3D(1.25, 1.0, 0.0, 0);
        ConnectionPoint3D connectionFG = new ConnectionPoint3D(1.75, 1.0, 0.0, 0);
        ConnectionPoint3D connectionG = new ConnectionPoint3D(2.25, 1.0, 0.0, 0);
        ConnectionPoint3D connectionGH = new ConnectionPoint3D(2.25, 0.5, 0.0, 0);
        ConnectionPoint3D connectionH = new ConnectionPoint3D(2.25, 0.0, 0.0, 0);
        ConnectionPoint3D connectionHE = new ConnectionPoint3D(1.75, 0.0, 0.0, 0);
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes0, connectionA));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes0, connectionAB));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes0, connectionB));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes0, connectionBC));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes0, connectionC));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes0, connectionCD));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes0, connectionD));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes0, connectionDA));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes1, connectionE));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes1, connectionEF));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes1, connectionF));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes1, connectionFG));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes1, connectionG));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes1, connectionGH));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes1, connectionH));
        Assert.assertTrue((boolean)this.nodesContainPoint(nodes1, connectionHE));
        List crossRegionEdges = visibilityGraph.getCrossRegionEdges();
        Assert.assertEquals((long)0L, (long)crossRegionEdges.size());
    }

    @Test
    public void testVisibilityGraphSquareInSquare() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        ArrayList<PlanarRegion> planarRegions = new ArrayList<PlanarRegion>();
        Point2D pointA = new Point2D(-0.01, -0.01);
        Point2D pointB = new Point2D(-0.01, 1.01);
        Point2D pointC = new Point2D(1.01, 1.01);
        Point2D pointD = new Point2D(1.01, -0.01);
        Point2D pointE = new Point2D(0.2, 0.2);
        Point2D pointF = new Point2D(0.2, 0.8);
        Point2D pointG = new Point2D(0.8, 0.8);
        Point2D pointH = new Point2D(0.8, 0.2);
        ConvexPolygon2D polygon0_0 = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[]{pointA, pointB, pointC, pointD}));
        ConvexPolygon2D polygon1_0 = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[]{pointE, pointF, pointG, pointH}));
        RigidBodyTransform transform0 = new RigidBodyTransform();
        RigidBodyTransform transform1 = new RigidBodyTransform();
        double height = 0.05;
        transform1.getTranslation().set(0.0, 0.0, height);
        PlanarRegion planarRegion0 = new PlanarRegion((RigidBodyTransformReadOnly)transform0, (Vertex2DSupplier)polygon0_0);
        planarRegion0.setRegionId(77);
        PlanarRegion planarRegion1 = new PlanarRegion((RigidBodyTransformReadOnly)transform1, (Vertex2DSupplier)polygon1_0);
        planarRegion1.setRegionId(63);
        planarRegions.add(planarRegion0);
        planarRegions.add(planarRegion1);
        NavigableRegions navigableRegions = new NavigableRegions((VisibilityGraphsParametersReadOnly)parameters, planarRegions);
        navigableRegions.createNavigableRegions();
        List navigableRegionsList = navigableRegions.getNavigableRegionsList();
        Assert.assertEquals((long)2L, (long)navigableRegionsList.size());
        NavigableRegion navigableRegion0 = (NavigableRegion)navigableRegionsList.get(0);
        NavigableRegion navigableRegion1 = (NavigableRegion)navigableRegionsList.get(1);
        Assert.assertEquals((long)77L, (long)navigableRegion0.getMapId());
        Assert.assertEquals((long)63L, (long)navigableRegion1.getMapId());
        final double maxDistance = 0.58;
        InterRegionConnectionFilter filter = new InterRegionConnectionFilter(){

            public boolean isConnectionValid(ConnectionPoint3D source, ConnectionPoint3D target) {
                double distance = source.distance((Point3DReadOnly)target);
                return distance < this.getMaximumInterRegionConnectionDistance();
            }

            public double getMaximumInterRegionConnectionDistance() {
                return maxDistance;
            }
        };
        VisibilityGraph visibilityGraph = new VisibilityGraph(navigableRegions, filter, (VisibilityGraphsParametersReadOnly)parameters);
        visibilityGraph.fullyExpandVisibilityGraph();
        ArrayList visibilityGraphNavigableRegions = visibilityGraph.getVisibilityGraphNavigableRegions();
        Assert.assertEquals((long)2L, (long)visibilityGraphNavigableRegions.size());
        VisibilityGraphNavigableRegion visibilityGraphNavigableRegion0 = (VisibilityGraphNavigableRegion)visibilityGraphNavigableRegions.get(0);
        VisibilityGraphNavigableRegion visibilityGraphNavigableRegion1 = (VisibilityGraphNavigableRegion)visibilityGraphNavigableRegions.get(1);
        HashSet internalEdges0 = visibilityGraphNavigableRegion0.getAllEdges();
        HashSet internalEdges1 = visibilityGraphNavigableRegion1.getAllEdges();
        List nodes0 = visibilityGraphNavigableRegion0.getHomeRegionNodes();
        List nodes1 = visibilityGraphNavigableRegion1.getHomeRegionNodes();
        Assert.assertEquals((long)8L, (long)nodes0.size());
        Assert.assertEquals((long)8L, (long)nodes1.size());
        ConnectionPoint3D connectionA = new ConnectionPoint3D(0.0, 0.0, 0.0, 0);
        ConnectionPoint3D connectionAB = new ConnectionPoint3D(0.0, 0.5, 0.0, 0);
        ConnectionPoint3D connectionB = new ConnectionPoint3D(0.0, 1.0, 0.0, 0);
        ConnectionPoint3D connectionBC = new ConnectionPoint3D(0.5, 1.0, 0.0, 0);
        ConnectionPoint3D connectionC = new ConnectionPoint3D(1.0, 1.0, 0.0, 0);
        ConnectionPoint3D connectionCD = new ConnectionPoint3D(1.0, 0.5, 0.0, 0);
        ConnectionPoint3D connectionD = new ConnectionPoint3D(1.0, 0.0, 0.0, 0);
        ConnectionPoint3D connectionDA = new ConnectionPoint3D(0.5, 0.0, 0.0, 0);
        Assert.assertTrue((boolean)this.arePointsAllContainedIn(nodes0, connectionA, connectionAB, connectionB, connectionBC, connectionC, connectionCD, connectionD, connectionDA));
        ConnectionPoint3D connectionE = new ConnectionPoint3D(0.21, 0.21, height, 0);
        ConnectionPoint3D connectionEF = new ConnectionPoint3D(0.21, 0.5, height, 0);
        ConnectionPoint3D connectionF = new ConnectionPoint3D(0.21, 0.79, height, 0);
        ConnectionPoint3D connectionFG = new ConnectionPoint3D(0.5, 0.79, height, 0);
        ConnectionPoint3D connectionG = new ConnectionPoint3D(0.79, 0.79, height, 0);
        ConnectionPoint3D connectionGH = new ConnectionPoint3D(0.79, 0.5, height, 0);
        ConnectionPoint3D connectionH = new ConnectionPoint3D(0.79, 0.21, height, 0);
        ConnectionPoint3D connectionHE = new ConnectionPoint3D(0.5, 0.21, height, 0);
        Assert.assertTrue((boolean)this.arePointsAllContainedIn(nodes1, connectionE, connectionEF, connectionF, connectionFG, connectionG, connectionGH, connectionH, connectionHE));
        List listOfObstacleNavigableNodes0 = visibilityGraphNavigableRegion0.getObstacleNavigableNodes();
        List listOfObstacleNavigableNodes1 = visibilityGraphNavigableRegion1.getObstacleNavigableNodes();
        Assert.assertEquals((long)1L, (long)listOfObstacleNavigableNodes0.size());
        Assert.assertEquals((long)0L, (long)listOfObstacleNavigableNodes1.size());
        List obstacleNavigableNodes0_0 = (List)listOfObstacleNavigableNodes0.get(0);
        Assert.assertEquals((long)16L, (long)obstacleNavigableNodes0_0.size());
        double sqrt2By2 = Math.sqrt(2.0) / 2.0;
        ConnectionPoint3D connectionE0 = new ConnectionPoint3D(0.2, 0.15, 0.0, 0);
        ConnectionPoint3D connectionE1 = new ConnectionPoint3D(0.2 - sqrt2By2 * 0.05, 0.2 - sqrt2By2 * 0.05, 0.0, 0);
        ConnectionPoint3D connectionE2 = new ConnectionPoint3D(0.15, 0.2, 0.0, 0);
        ConnectionPoint3D connectionEF0 = new ConnectionPoint3D(0.15, 0.5, 0.0, 0);
        ConnectionPoint3D connectionF0 = new ConnectionPoint3D(0.15, 0.8, 0.0, 0);
        ConnectionPoint3D connectionF1 = new ConnectionPoint3D(0.2 - sqrt2By2 * 0.05, 0.8 + sqrt2By2 * 0.05, 0.0, 0);
        ConnectionPoint3D connectionF2 = new ConnectionPoint3D(0.2, 0.85, 0.0, 0);
        ConnectionPoint3D connectionFG0 = new ConnectionPoint3D(0.5, 0.85, 0.0, 0);
        ConnectionPoint3D connectionG0 = new ConnectionPoint3D(0.8, 0.85, 0.0, 0);
        ConnectionPoint3D connectionG1 = new ConnectionPoint3D(0.8 + sqrt2By2 * 0.05, 0.8 + sqrt2By2 * 0.05, 0.0, 0);
        ConnectionPoint3D connectionG2 = new ConnectionPoint3D(0.85, 0.8, 0.0, 0);
        ConnectionPoint3D connectionGH0 = new ConnectionPoint3D(0.85, 0.5, 0.0, 0);
        ConnectionPoint3D connectionH0 = new ConnectionPoint3D(0.85, 0.2, 0.0, 0);
        ConnectionPoint3D connectionH1 = new ConnectionPoint3D(0.8 + sqrt2By2 * 0.05, 0.2 - sqrt2By2 * 0.05, 0.0, 0);
        ConnectionPoint3D connectionH2 = new ConnectionPoint3D(0.8, 0.15, 0.0, 0);
        ConnectionPoint3D connectionHE0 = new ConnectionPoint3D(0.5, 0.15, 0.0, 0);
        Assert.assertTrue((boolean)this.arePointsAllContainedIn(obstacleNavigableNodes0_0, connectionE0, connectionE1, connectionE2));
        Assert.assertTrue((boolean)this.arePointsAllContainedIn(obstacleNavigableNodes0_0, connectionEF0, connectionF0, connectionF1, connectionF2, connectionFG0));
        Assert.assertTrue((boolean)this.arePointsAllContainedIn(obstacleNavigableNodes0_0, connectionG0, connectionG1, connectionG2, connectionGH0));
        Assert.assertTrue((boolean)this.arePointsAllContainedIn(obstacleNavigableNodes0_0, connectionH0, connectionH1, connectionH2, connectionHE0));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionA, connectionA));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionA, connectionAB));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionA, connectionB));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionA, connectionBC));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionA, connectionC));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionA, connectionCD));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionA, connectionD));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionA, connectionDA));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionA, connectionE0));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionA, connectionE1));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionA, connectionE2));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionA, connectionEF0));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionA, connectionF0));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionA, connectionF1));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionA, connectionF2));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionA, connectionFG0));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionA, connectionG0));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionA, connectionG1));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionA, connectionG2));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionA, connectionGH0));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionA, connectionH0));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionA, connectionH1));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionA, connectionH2));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionA, connectionHE0));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionA));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionAB));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionB));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionBC));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionC));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionCD));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionD));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionDA));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionE0));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionE1));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionE2));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionEF0));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionF0));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionF1));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionF2));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionFG0));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionG0));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionG1));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionG2));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionGH0));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionH0));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionH1));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionH2));
        Assert.assertFalse((boolean)this.edgeListContains(internalEdges0, connectionCD, connectionHE0));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionE0, connectionE1));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionE1, connectionE2));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionE2, connectionEF0));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionEF0, connectionF0));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionF0, connectionF1));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionF1, connectionF2));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionF2, connectionFG0));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionFG0, connectionG0));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionG0, connectionG1));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionG1, connectionG2));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionG2, connectionGH0));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionGH0, connectionH0));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionH0, connectionH1));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionH1, connectionH2));
        Assert.assertTrue((boolean)this.edgeListContains(internalEdges0, connectionH2, connectionHE0));
        Assert.assertEquals((long)80L, (long)internalEdges0.size());
        Assert.assertEquals((long)28L, (long)internalEdges1.size());
        List crossRegionEdges = visibilityGraph.getCrossRegionEdges();
        Assert.assertEquals((long)24L, (long)crossRegionEdges.size());
        Assert.assertTrue((boolean)this.edgeListContains(crossRegionEdges, connectionA, connectionE));
        Assert.assertFalse((boolean)this.edgeListContains(crossRegionEdges, connectionA, connectionEF));
        Assert.assertFalse((boolean)this.edgeListContains(crossRegionEdges, connectionA, connectionHE));
        Assert.assertFalse((boolean)this.edgeListContains(crossRegionEdges, connectionBC, connectionF));
        Assert.assertTrue((boolean)this.edgeListContains(crossRegionEdges, connectionBC, connectionFG));
        Assert.assertFalse((boolean)this.edgeListContains(crossRegionEdges, connectionBC, connectionG));
        VisibilityMapSolution visibilityMapSolution = visibilityGraph.createVisibilityMapSolution();
        ArrayList visibilityMapsWithNavigableRegions = visibilityMapSolution.getVisibilityMapsWithNavigableRegions();
        Assert.assertEquals((long)2L, (long)visibilityMapsWithNavigableRegions.size());
        VisibilityMapWithNavigableRegion innerMapAndRegion0 = (VisibilityMapWithNavigableRegion)visibilityMapsWithNavigableRegions.get(0);
        VisibilityMapWithNavigableRegion innerMapAdnRegion1 = (VisibilityMapWithNavigableRegion)visibilityMapsWithNavigableRegions.get(1);
        VisibilityMap innerMap0 = innerMapAndRegion0.getVisibilityMapInWorld();
        Set vertices0 = innerMap0.getVertices();
        Set connections0 = innerMap0.getConnections();
        Assert.assertEquals((long)24L, (long)vertices0.size());
        Assert.assertEquals((long)80L, (long)connections0.size());
        VisibilityMap innerMap1 = innerMapAdnRegion1.getVisibilityMapInWorld();
        Set vertices1 = innerMap1.getVertices();
        Set connections1 = innerMap1.getConnections();
        Assert.assertEquals((long)8L, (long)vertices1.size());
        Assert.assertEquals((long)28L, (long)connections1.size());
        InterRegionVisibilityMap interRegionVisibilityMap = visibilityMapSolution.getInterRegionVisibilityMap();
        VisibilityMap interRegionVisibilityMapInWorld = interRegionVisibilityMap.getVisibilityMapInWorld();
        Set interRegionConnections = interRegionVisibilityMapInWorld.getConnections();
        Set interRegionVertices = interRegionVisibilityMapInWorld.getVertices();
        Assert.assertEquals((long)0L, (long)interRegionVertices.size());
        Assert.assertEquals((long)24L, (long)crossRegionEdges.size());
        Assert.assertTrue((boolean)this.edgeListContains(crossRegionEdges, connectionA, connectionE));
        Assert.assertFalse((boolean)this.edgeListContains(crossRegionEdges, connectionA, connectionEF));
        Assert.assertFalse((boolean)this.edgeListContains(crossRegionEdges, connectionA, connectionHE));
        Assert.assertFalse((boolean)this.edgeListContains(crossRegionEdges, connectionBC, connectionF));
        Assert.assertTrue((boolean)this.edgeListContains(crossRegionEdges, connectionBC, connectionFG));
        Assert.assertFalse((boolean)this.edgeListContains(crossRegionEdges, connectionBC, connectionG));
        double ceilingHeight = 2.0;
        double searchHostEpsilon = 0.01;
        visibilityGraph.setStart((Point3DReadOnly)new Point3D(0.1, 0.5, 0.005), ceilingHeight, searchHostEpsilon);
        VisibilityGraphNode startNode = visibilityGraph.getStartNode();
        Assert.assertEquals((long)77L, (long)startNode.getRegionId());
        HashSet startEdges = visibilityGraph.getStartEdges();
        Point2DReadOnly startInLocal = startNode.getPoint2DInLocal();
        ConnectionPoint3D startInWorld = startNode.getPointInWorld();
        Assert.assertTrue((boolean)startInLocal.epsilonEquals((EuclidGeometry)new Point2D(0.1, 0.5), 1.0E-10));
        Assert.assertTrue((boolean)startInWorld.epsilonEquals((EuclidGeometry)new Point3D(0.1, 0.5, 0.0), 1.0E-10));
        Assert.assertTrue((boolean)this.edgeListContains(startEdges, startInWorld, connectionA));
        Assert.assertTrue((boolean)this.edgeListContains(startEdges, startInWorld, connectionAB));
        Assert.assertTrue((boolean)this.edgeListContains(startEdges, startInWorld, connectionB));
        Assert.assertTrue((boolean)this.edgeListContains(startEdges, startInWorld, connectionE2));
        Assert.assertTrue((boolean)this.edgeListContains(startEdges, startInWorld, connectionEF0));
        Assert.assertTrue((boolean)this.edgeListContains(startEdges, startInWorld, connectionF0));
        visibilityGraph.setGoal((Point3DReadOnly)new Point3D(0.5, 0.5, 0.053), ceilingHeight, searchHostEpsilon);
        VisibilityGraphNode goalNode = visibilityGraph.getGoalNode();
        Assert.assertEquals((long)63L, (long)goalNode.getRegionId());
        HashSet goalEdges = visibilityGraph.getGoalEdges();
        Point2DReadOnly goalInLocal = goalNode.getPoint2DInLocal();
        ConnectionPoint3D goalInWorld = goalNode.getPointInWorld();
        Assert.assertTrue((boolean)goalInLocal.epsilonEquals((EuclidGeometry)new Point2D(0.5, 0.5), 1.0E-10));
        Assert.assertTrue((boolean)goalInWorld.epsilonEquals((EuclidGeometry)new Point3D(0.5, 0.5, height), 1.0E-10));
        Assert.assertEquals((long)9L, (long)goalEdges.size());
        Assert.assertEquals((long)7L, (long)startEdges.size());
    }

    private void printNodes(List<VisibilityGraphNode> nodes) {
        for (VisibilityGraphNode node : nodes) {
            System.out.println(node.getPointInWorld());
        }
        System.out.println();
    }

    private boolean arePointsAllContainedIn(List<VisibilityGraphNode> nodes, ConnectionPoint3D ... points) {
        for (ConnectionPoint3D point : points) {
            if (this.nodesContainPoint(nodes, point)) continue;
            return false;
        }
        return true;
    }

    private boolean nodesContainPoint(List<VisibilityGraphNode> nodes, ConnectionPoint3D point) {
        for (VisibilityGraphNode node : nodes) {
            if (!node.getPointInWorld().epsilonEquals((EuclidGeometry)point, 1.0E-10)) continue;
            return true;
        }
        return false;
    }

    private boolean connectionsContain(Set<Connection> connections, ConnectionPoint3D pointOne, ConnectionPoint3D pointTwo) {
        for (Connection connection : connections) {
            ConnectionPoint3D sourcePoint = connection.getSourcePoint();
            ConnectionPoint3D targetPoint = connection.getTargetPoint();
            if (sourcePoint.epsilonEquals((EuclidGeometry)pointOne, 1.0E-10) && targetPoint.epsilonEquals((EuclidGeometry)pointTwo, 1.0E-10)) {
                return true;
            }
            if (!sourcePoint.epsilonEquals((EuclidGeometry)pointTwo, 1.0E-10) || !targetPoint.epsilonEquals((EuclidGeometry)pointOne, 1.0E-10)) continue;
            return true;
        }
        return false;
    }

    private void printEdges(List<VisibilityGraphEdge> edges) {
        for (VisibilityGraphEdge edge : edges) {
            System.out.println(edge);
        }
        System.out.println();
    }

    private boolean edgeListContains(Collection<VisibilityGraphEdge> edges, ConnectionPoint3D pointOne, ConnectionPoint3D pointTwo) {
        for (VisibilityGraphEdge edge : edges) {
            ConnectionPoint3D sourcePoint = edge.getSourcePointInWorld();
            ConnectionPoint3D targetPoint = edge.getTargetPointInWorld();
            if (sourcePoint.equals(pointOne) && targetPoint.equals(pointTwo)) {
                return true;
            }
            if (!sourcePoint.equals(pointTwo) || !targetPoint.equals(pointOne)) continue;
            return true;
        }
        return false;
    }

    private void printConnections(Set<Connection> connections) {
        for (Connection connection : connections) {
            System.out.println(connection);
        }
        System.out.println();
    }

    private void printVertices(Set<ConnectionPoint3D> vertices) {
        for (ConnectionPoint3D vertex : vertices) {
            System.out.println(vertex);
        }
        System.out.println();
    }

    private VisibilityGraphsParametersBasics createVisibilityGraphParametersForTest() {
        DefaultVisibilityGraphParameters parameters = new DefaultVisibilityGraphParameters(){

            public PlanarRegionFilter getPlanarRegionFilter() {
                return new PlanarRegionFilter(){

                    public boolean isPlanarRegionRelevant(PlanarRegion region) {
                        return true;
                    }
                };
            }

            public NavigableExtrusionDistanceCalculator getNavigableExtrusionDistanceCalculator() {
                return new NavigableExtrusionDistanceCalculator(){

                    public double computeNavigableExtrusionDistance(PlanarRegion navigableRegionToBeExtruded) {
                        return 0.01;
                    }
                };
            }
        };
        parameters.setClusterResolution(0.501);
        return parameters;
    }
}

