/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.bodyPathPlanner;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.plotting.artifact.ArtifactsChangedListener;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.graphicsDescription.yoGraphics.plotting.PlotterInterface;
import us.ihmc.pathPlanning.bodyPathPlanner.BodyPathPlannerTools;
import us.ihmc.pathPlanning.bodyPathPlanner.WaypointDefinedBodyPathPlanHolder;
import us.ihmc.plotting.Plotter;
import us.ihmc.plotting.PlotterShowHideMenu;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class WaypointDefinedBodyPathPlanTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final boolean showPlotter = false;
    private static final double epsilon = 1.0E-7;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testSimpleBodyPath(TestInfo testInfo) {
        WaypointDefinedBodyPathPlanHolder plan = new WaypointDefinedBodyPathPlanHolder();
        ArrayList<Point3D> positionWaypoints = new ArrayList<Point3D>();
        positionWaypoints.add(new Point3D(0.0, 0.0, 0.0));
        positionWaypoints.add(new Point3D(0.5, 0.0, 0.0));
        positionWaypoints.add(new Point3D(1.0, 1.0, 0.0));
        double startHeading = BodyPathPlannerTools.calculateHeading((Point3DReadOnly)((Point3DReadOnly)positionWaypoints.get(0)), (Point3DReadOnly)((Point3DReadOnly)positionWaypoints.get(1)));
        double endHeading = BodyPathPlannerTools.calculateHeading((Point3DReadOnly)((Point3DReadOnly)positionWaypoints.get(1)), (Point3DReadOnly)((Point3DReadOnly)positionWaypoints.get(2)));
        ArrayList<MutableDouble> headingWaypoints = new ArrayList<MutableDouble>();
        headingWaypoints.add(new MutableDouble(startHeading));
        headingWaypoints.add(new MutableDouble(AngleTools.interpolateAngle((double)startHeading, (double)endHeading, (double)0.5)));
        headingWaypoints.add(new MutableDouble(endHeading));
        plan.setWaypoints(positionWaypoints, headingWaypoints);
        double segmentLength1 = 0.5;
        double segmentLength2 = Math.sqrt(1.25);
        double toalLength = segmentLength1 + segmentLength2;
        Assert.assertEquals((double)toalLength, (double)plan.computePathLength(0.0), (double)1.0E-7);
        Assert.assertEquals((double)(segmentLength1 / 2.0 + segmentLength2), (double)plan.computePathLength(0.5 * segmentLength1 / toalLength), (double)1.0E-7);
        Assert.assertEquals((double)segmentLength2, (double)plan.computePathLength(segmentLength1 / toalLength), (double)1.0E-7);
        Assert.assertEquals((double)(segmentLength2 / 2.0), (double)plan.computePathLength(1.0 - 0.5 * segmentLength2 / toalLength), (double)1.0E-7);
        Assert.assertEquals((double)0.0, (double)plan.computePathLength(1.0), (double)1.0E-7);
        Pose3D testPose = new Pose3D();
        plan.getPointAlongPath(0.0, (Pose3DBasics)testPose);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)((EuclidGeometry)positionWaypoints.get(0)), (EuclidGeometry)testPose.getPosition(), (double)1.0E-7);
        plan.getPointAlongPath(segmentLength1 / toalLength, (Pose3DBasics)testPose);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)((EuclidGeometry)positionWaypoints.get(1)), (EuclidGeometry)testPose.getPosition(), (double)1.0E-7);
        plan.getPointAlongPath(1.0, (Pose3DBasics)testPose);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)((EuclidGeometry)positionWaypoints.get(2)), (EuclidGeometry)testPose.getPosition(), (double)1.0E-7);
        double d1 = plan.getClosestPoint((Point2DReadOnly)new Point2D(-1.0, 0.0), (Pose3DBasics)testPose);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)((EuclidGeometry)positionWaypoints.get(0)), (EuclidGeometry)testPose.getPosition(), (double)1.0E-7);
        Assert.assertEquals((double)0.0, (double)d1, (double)1.0E-7);
        double d2 = plan.getClosestPoint((Point2DReadOnly)new Point2D(10.0, 0.0), (Pose3DBasics)testPose);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)((EuclidGeometry)positionWaypoints.get(2)), (EuclidGeometry)testPose.getPosition(), (double)1.0E-7);
        Assert.assertEquals((double)1.0, (double)d2, (double)1.0E-7);
        double d3 = plan.getClosestPoint((Point2DReadOnly)new Point2D(10.0, -10.0), (Pose3DBasics)testPose);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)((EuclidGeometry)positionWaypoints.get(1)), (EuclidGeometry)testPose.getPosition(), (double)1.0E-7);
        Assert.assertEquals((double)(segmentLength1 / toalLength), (double)d3, (double)1.0E-7);
        double d4 = plan.getClosestPoint((Point2DReadOnly)new Point2D(0.25, 0.1), (Pose3DBasics)testPose);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.25, 0.0, 0.0), (EuclidGeometry)testPose.getPosition(), (double)1.0E-7);
        Assert.assertEquals((double)(0.5 * segmentLength1 / toalLength), (double)d4, (double)1.0E-7);
        double d5 = plan.getClosestPoint((Point2DReadOnly)new Point2D(1.75, 0.0), (Pose3DBasics)testPose);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(0.75, 0.5, 0.0), (EuclidGeometry)testPose.getPosition(), (double)1.0E-7);
        Assert.assertEquals((double)(1.0 - 0.5 * segmentLength2 / toalLength), (double)d5, (double)1.0E-7);
    }

    public static void showPlotter(WaypointDefinedBodyPathPlanHolder plan, String testName) {
        int markers = 5;
        YoRegistry registry = new YoRegistry(testName);
        YoGraphicsListRegistry graphicsList = new YoGraphicsListRegistry();
        for (int i = 0; i < markers; ++i) {
            double alpha = (double)i / (double)(markers - 1);
            Pose3D pose = new Pose3D();
            plan.getPointAlongPath(alpha, (Pose3DBasics)pose);
            YoFramePoint3D yoStartPoint = new YoFramePoint3D("PointStart" + i, worldFrame, registry);
            yoStartPoint.set((Tuple3DReadOnly)pose.getPosition());
            double length = 0.1;
            YoFrameVector3D direction = new YoFrameVector3D("Direction" + i, worldFrame, registry);
            direction.set(length * Math.cos(pose.getYaw()), length * Math.sin(pose.getYaw()), 0.0);
            YoFramePoint3D yoEndPoint = new YoFramePoint3D("PointEnd" + i, worldFrame, registry);
            yoEndPoint.set((FrameTuple3DReadOnly)yoStartPoint);
            yoEndPoint.add((FrameTuple3DReadOnly)direction);
            YoGraphicPosition poseStartVis = new YoGraphicPosition("PointStart" + i, yoStartPoint, 0.01, YoAppearance.Blue());
            YoGraphicPosition poseEndVis = new YoGraphicPosition("PointEnd" + i, yoEndPoint, 0.01, YoAppearance.Red());
            graphicsList.registerArtifact(testName, (Artifact)poseStartVis.createArtifact());
            graphicsList.registerArtifact(testName, (Artifact)poseEndVis.createArtifact());
        }
        WaypointDefinedBodyPathPlanTest.showPlotter(graphicsList, testName);
    }

    public static void showPlotter(YoGraphicsListRegistry yoGraphicsListRegistry, String windowName) {
        Plotter plotter = new Plotter();
        plotter.setViewRange(2.0);
        ArrayList artifactLists = new ArrayList();
        yoGraphicsListRegistry.getRegisteredArtifactLists(artifactLists);
        for (ArtifactList artifactList : artifactLists) {
            artifactList.setVisible(true);
        }
        JFrame frame = new JFrame(windowName);
        Dimension preferredSize = new Dimension(600, 600);
        frame.setPreferredSize(preferredSize);
        JCheckBox doneBox = new JCheckBox("Done");
        PlotterShowHideMenu plotterShowHideMenu = new PlotterShowHideMenu(plotter);
        plotter.addArtifactsChangedListener((ArtifactsChangedListener)plotterShowHideMenu);
        frame.add((Component)doneBox, "South");
        frame.add((Component)plotter.getJPanel(), "Center");
        frame.setSize(preferredSize);
        frame.setVisible(true);
        yoGraphicsListRegistry.addArtifactListsToPlotter((PlotterInterface)plotter);
        while (!doneBox.isSelected()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        frame.setVisible(false);
        frame.dispose();
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(WaypointDefinedBodyPathPlanHolder.class, WaypointDefinedBodyPathPlanTest.class);
    }
}

