/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs.tools;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.tools.VisibilityGraphsGeometryTools;
import us.ihmc.robotics.Assert;

public class VisibilityGraphsGeometryToolsTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;
    private static final double LARGE_EPSILON = 1.0E-11;

    @Test
    public void testDoRay2DAndLineSegment2DIntersect() throws Exception {
        double distance;
        double alpha1;
        Point2D rayOrigin;
        Point2D rayOrigin2;
        Vector2D rayDirection;
        Point2D intersection;
        Point2D lineSegmentEnd;
        Point2D lineSegmentStart;
        Point2D lineSegmentEnd2;
        Vector2D rayDirection2;
        Point2D rayOrigin3;
        int i;
        Random random = new Random(116L);
        for (i = 0; i < 1000; ++i) {
            rayOrigin3 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            rayOrigin3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayDirection2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D pointOnRay = new Point2D();
            pointOnRay.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin3);
            Vector2D lineSegmentDirection = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Point2D lineSegmentStart2 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            double alphaStart = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double alphaEnd = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            lineSegmentStart2.scaleAdd(alphaStart, (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)pointOnRay);
            lineSegmentEnd2.scaleAdd(alphaEnd, (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)pointOnRay);
            Assert.assertTrue((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2));
            Assert.assertTrue((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2));
            alphaStart = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            alphaEnd = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            lineSegmentStart2.scaleAdd(alphaStart, (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)pointOnRay);
            lineSegmentEnd2.scaleAdd(alphaEnd, (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)pointOnRay);
            Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2));
            Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2));
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            intersection = new Point2D();
            intersection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            rayDirection = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayOrigin2 = new Point2D();
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)intersection);
            Assert.assertTrue((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            Assert.assertTrue((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart));
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)intersection);
            Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart));
        }
        for (i = 0; i < 1000; ++i) {
            rayOrigin3 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            rayOrigin3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayDirection2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D lineSegmentDirection = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Point2D lineSegmentStart3 = new Point2D();
            Point2D lineSegmentEnd3 = new Point2D();
            lineSegmentStart3.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)rayOrigin3);
            lineSegmentEnd3.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)rayOrigin3);
            Assert.assertTrue((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentStart3, (Point2DReadOnly)lineSegmentEnd3));
            Assert.assertTrue((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentEnd3, (Point2DReadOnly)lineSegmentStart3));
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            intersection = new Point2D((Tuple2DReadOnly)lineSegmentStart);
            rayDirection = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayOrigin2 = new Point2D();
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)intersection);
            Assert.assertTrue((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            Assert.assertTrue((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart));
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)intersection);
            Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd));
            Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart));
        }
        for (i = 0; i < 1000; ++i) {
            rayOrigin3 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            rayOrigin3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayDirection2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D lineSegmentStart4 = new Point2D();
            Point2D lineSegmentEnd4 = new Point2D();
            double alpha12 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart4.scaleAdd(alpha12, (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin3);
            lineSegmentEnd4.scaleAdd(alpha2, (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin3);
            Vector2D lineSegmentDirection = new Vector2D();
            lineSegmentDirection.sub((Tuple2DReadOnly)lineSegmentEnd4, (Tuple2DReadOnly)lineSegmentStart4);
            if (0.0 < alpha12 || 0.0 < alpha2 || alpha12 * alpha2 < 0.0) {
                Assert.assertTrue((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentStart4, (Point2DReadOnly)lineSegmentEnd4));
                Assert.assertTrue((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentEnd4, (Point2DReadOnly)lineSegmentStart4));
            } else {
                Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentStart4, (Point2DReadOnly)lineSegmentEnd4));
                Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentEnd4, (Point2DReadOnly)lineSegmentStart4));
            }
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin3);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            double distance2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart4.scaleAdd(distance2, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart4);
            lineSegmentEnd4.scaleAdd(distance2, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd4);
            Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentStart4, (Point2DReadOnly)lineSegmentEnd4));
            Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)lineSegmentEnd4, (Point2DReadOnly)lineSegmentStart4));
        }
        for (i = 0; i < 1000; ++i) {
            double x = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            rayOrigin = new Point2D(x, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayDirection = new Vector2D(x, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D lineSegmentStart5 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            alpha1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart5.scaleAdd(alpha1, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            lineSegmentEnd2.scaleAdd(alpha2, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            if (0.0 < alpha1 || 0.0 < alpha2 || alpha1 * alpha2 < 0.0) {
                Assert.assertTrue((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart5, (Point2DReadOnly)lineSegmentEnd2));
                Assert.assertTrue((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart5));
            } else {
                Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart5, (Point2DReadOnly)lineSegmentEnd2));
                Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart5));
            }
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart5.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart5);
            lineSegmentEnd2.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd2);
            Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart5, (Point2DReadOnly)lineSegmentEnd2));
            Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart5));
        }
        for (i = 0; i < 1000; ++i) {
            double y = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            rayOrigin = new Point2D(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), y);
            rayDirection = new Vector2D(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), y);
            Point2D lineSegmentStart6 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            alpha1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart6.scaleAdd(alpha1, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            lineSegmentEnd2.scaleAdd(alpha2, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            if (0.0 < alpha1 || 0.0 < alpha2 || alpha1 * alpha2 < 0.0) {
                Assert.assertTrue((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart6, (Point2DReadOnly)lineSegmentEnd2));
                Assert.assertTrue((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart6));
            } else {
                Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart6, (Point2DReadOnly)lineSegmentEnd2));
                Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart6));
            }
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart6.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart6);
            lineSegmentEnd2.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd2);
            Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart6, (Point2DReadOnly)lineSegmentEnd2));
            Assert.assertFalse((String)("Iteration: " + i), (boolean)VisibilityGraphsGeometryTools.doRay2DAndLineSegment2DIntersect((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart6));
        }
    }

    @Test
    public void testIntersectionBetweenRay2DAndCircle2D() throws Exception {
        int actualNumberOfIntersections;
        int expectedNumberOfIntersections;
        Vector2D rayDirection;
        Point2D rayOrigin;
        Vector2D fromCenterToCircle;
        Point2D circleCenter;
        int i;
        Random random = new Random(456467L);
        try {
            Point2D rayOrigin2 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            Vector2D rayDirection2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            Point2D circleCenter2 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            double circleRadius = -0.001;
            VisibilityGraphsGeometryTools.intersectionBetweenRay2DAndCircle2D((Point2DReadOnly)rayOrigin2, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)circleCenter2, (double)circleRadius, null, null);
            Assert.fail((String)("Should have thrown a " + IllegalArgumentException.class.getSimpleName()));
        }
        catch (IllegalArgumentException rayOrigin2) {
            // empty catch block
        }
        for (i = 0; i < 1000; ++i) {
            circleCenter = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            double circleRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            fromCenterToCircle = new Vector2D(circleRadius, 0.0);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple2DReadOnly)fromCenterToCircle, (Tuple2DBasics)fromCenterToCircle);
            Point2D pointOnCircle = new Point2D();
            pointOnCircle.add((Tuple2DReadOnly)fromCenterToCircle, (Tuple2DReadOnly)circleCenter);
            Vector2D tangent = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)fromCenterToCircle);
            if (random.nextBoolean()) {
                tangent.negate();
            }
            rayOrigin = new Point2D();
            rayDirection = new Vector2D();
            rayOrigin.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)fromCenterToCircle, (Tuple2DReadOnly)pointOnCircle);
            rayDirection.interpolate((Tuple2DReadOnly)fromCenterToCircle, (Tuple2DReadOnly)tangent, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Point2D firstIntersection = new Point2D();
            Point2D secondIntersection = new Point2D();
            expectedNumberOfIntersections = 0;
            actualNumberOfIntersections = VisibilityGraphsGeometryTools.intersectionBetweenRay2DAndCircle2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)circleCenter, (double)circleRadius, (Point2DBasics)firstIntersection, (Point2DBasics)secondIntersection);
            Assert.assertEquals((long)expectedNumberOfIntersections, (long)actualNumberOfIntersections);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)firstIntersection);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)secondIntersection);
        }
        for (i = 0; i < 1000; ++i) {
            circleCenter = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            double circleRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            fromCenterToCircle = new Vector2D(circleRadius, 0.0);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple2DReadOnly)fromCenterToCircle, (Tuple2DBasics)fromCenterToCircle);
            Point2D expectedIntersection = new Point2D();
            expectedIntersection.add((Tuple2DReadOnly)fromCenterToCircle, (Tuple2DReadOnly)circleCenter);
            Point2D rayOrigin3 = new Point2D();
            Vector2D rayDirection3 = new Vector2D();
            rayOrigin3.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0), (Tuple2DReadOnly)fromCenterToCircle, (Tuple2DReadOnly)circleCenter);
            rayDirection3.setAndScale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)fromCenterToCircle);
            Point2D actualFirstIntersection = new Point2D();
            Point2D actualSecondIntersection = new Point2D();
            int expectedNumberOfIntersections2 = 1;
            int actualNumberOfIntersections2 = VisibilityGraphsGeometryTools.intersectionBetweenRay2DAndCircle2D((Point2DReadOnly)rayOrigin3, (Vector2DReadOnly)rayDirection3, (Point2DReadOnly)circleCenter, (double)circleRadius, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
            Assert.assertEquals((long)expectedNumberOfIntersections2, (long)actualNumberOfIntersections2);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualFirstIntersection, (double)1.0E-12);
            EuclidCoreTestTools.assertTuple2DContainsOnlyNaN((Tuple2DReadOnly)actualSecondIntersection);
        }
        for (i = 0; i < 1000; ++i) {
            circleCenter = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            double circleRadius = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            fromCenterToCircle = new Vector2D(circleRadius, 0.0);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple2DReadOnly)fromCenterToCircle, (Tuple2DBasics)fromCenterToCircle);
            Point2D expectedFirstIntersection = new Point2D();
            expectedFirstIntersection.add((Tuple2DReadOnly)fromCenterToCircle, (Tuple2DReadOnly)circleCenter);
            RotationMatrixTools.applyYawRotation((double)EuclidCoreRandomTools.nextDouble((Random)random, (double)Math.PI), (Tuple2DReadOnly)fromCenterToCircle, (Tuple2DBasics)fromCenterToCircle);
            Point2D expectedSecondIntersection = new Point2D();
            expectedSecondIntersection.add((Tuple2DReadOnly)fromCenterToCircle, (Tuple2DReadOnly)circleCenter);
            rayOrigin = new Point2D();
            rayDirection = new Vector2D();
            rayOrigin.interpolate((Tuple2DReadOnly)expectedFirstIntersection, (Tuple2DReadOnly)expectedSecondIntersection, EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0));
            rayDirection.sub((Tuple2DReadOnly)expectedSecondIntersection, (Tuple2DReadOnly)expectedFirstIntersection);
            rayDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            Point2D actualFirstIntersection = new Point2D();
            Point2D actualSecondIntersection = new Point2D();
            expectedNumberOfIntersections = 2;
            actualNumberOfIntersections = VisibilityGraphsGeometryTools.intersectionBetweenRay2DAndCircle2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)circleCenter, (double)circleRadius, (Point2DBasics)actualFirstIntersection, (Point2DBasics)actualSecondIntersection);
            Assert.assertEquals((String)("Iteration: " + i), (long)expectedNumberOfIntersections, (long)actualNumberOfIntersections);
            EuclidCoreTestTools.assertTuple2DEquals((String)("Iteration: " + i), (Tuple2DReadOnly)expectedFirstIntersection, (Tuple2DReadOnly)actualFirstIntersection, (double)1.0E-11);
            EuclidCoreTestTools.assertTuple2DEquals((String)("Iteration: " + i), (Tuple2DReadOnly)expectedSecondIntersection, (Tuple2DReadOnly)actualSecondIntersection, (double)1.0E-11);
        }
    }

    @Test
    public void testIntersectionBetweenRay2DAndLineSegment2D() throws Exception {
        double distance;
        double alpha1;
        Point2D rayOrigin;
        Point2D rayOrigin2;
        Vector2D rayDirection;
        Point2D lineSegmentEnd;
        Point2D lineSegmentStart;
        Point2D lineSegmentEnd2;
        Point2D expectedIntersection;
        Vector2D rayDirection2;
        Point2D rayOrigin3;
        int i;
        Random random = new Random(3242L);
        for (i = 0; i < 1000; ++i) {
            rayOrigin3 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            rayOrigin3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayDirection2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            expectedIntersection = new Point2D();
            expectedIntersection.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin3);
            Vector2D lineSegmentDirection = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Point2D lineSegmentStart2 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            double alphaStart = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double alphaEnd = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            lineSegmentStart2.scaleAdd(alphaStart, (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)expectedIntersection);
            lineSegmentEnd2.scaleAdd(alphaEnd, (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)expectedIntersection);
            this.assertAllCombinationsOfTwoLineSegmentsIntersection(expectedIntersection, rayOrigin3, rayDirection2, lineSegmentStart2, lineSegmentEnd2);
            alphaStart = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            alphaEnd = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            lineSegmentStart2.scaleAdd(alphaStart, (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)expectedIntersection);
            lineSegmentEnd2.scaleAdd(alphaEnd, (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)expectedIntersection);
            this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin3, rayDirection2, lineSegmentStart2, lineSegmentEnd2);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expectedIntersection = new Point2D();
            expectedIntersection.interpolate((Tuple2DReadOnly)lineSegmentStart, (Tuple2DReadOnly)lineSegmentEnd, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            rayDirection = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayOrigin2 = new Point2D();
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)expectedIntersection);
            this.assertAllCombinationsOfTwoLineSegmentsIntersection(expectedIntersection, rayOrigin2, rayDirection, lineSegmentStart, lineSegmentEnd);
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)expectedIntersection);
            this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin2, rayDirection, lineSegmentStart, lineSegmentEnd);
        }
        for (i = 0; i < 1000; ++i) {
            rayOrigin3 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            rayOrigin3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayDirection2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Vector2D lineSegmentDirection = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Point2D lineSegmentStart3 = new Point2D();
            Point2D lineSegmentEnd3 = new Point2D();
            lineSegmentStart3.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)rayOrigin3);
            lineSegmentEnd3.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineSegmentDirection, (Tuple2DReadOnly)rayOrigin3);
            this.assertAllCombinationsOfTwoLineSegmentsIntersection(rayOrigin3, rayOrigin3, rayDirection2, lineSegmentStart3, lineSegmentEnd3);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd = EuclidCoreRandomTools.nextPoint2D((Random)random);
            expectedIntersection = new Point2D((Tuple2DReadOnly)lineSegmentStart);
            rayDirection = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayOrigin2 = new Point2D();
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)expectedIntersection);
            this.assertAllCombinationsOfTwoLineSegmentsIntersection(expectedIntersection, rayOrigin2, rayDirection, lineSegmentStart, lineSegmentEnd);
            rayOrigin2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.01, (double)10.0), (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)expectedIntersection);
            this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin2, rayDirection, lineSegmentStart, lineSegmentEnd);
        }
        for (i = 0; i < 1000; ++i) {
            rayOrigin3 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            rayOrigin3.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayDirection2 = EuclidCoreRandomTools.nextVector2D((Random)random);
            rayDirection2.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D lineSegmentStart4 = new Point2D();
            Point2D lineSegmentEnd4 = new Point2D();
            double alpha12 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart4.scaleAdd(alpha12, (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin3);
            lineSegmentEnd4.scaleAdd(alpha2, (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin3);
            Vector2D lineSegmentDirection = new Vector2D();
            lineSegmentDirection.sub((Tuple2DReadOnly)lineSegmentEnd4, (Tuple2DReadOnly)lineSegmentStart4);
            if (0.0 < alpha12 || 0.0 < alpha2 || alpha12 * alpha2 < 0.0) {
                this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(true, rayOrigin3, rayDirection2, lineSegmentStart4, lineSegmentEnd4);
            } else {
                this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin3, rayDirection2, lineSegmentStart4, lineSegmentEnd4);
            }
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin3);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            double distance2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart4.scaleAdd(distance2, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart4);
            lineSegmentEnd4.scaleAdd(distance2, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd4);
            this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin3, rayDirection2, lineSegmentStart4, lineSegmentEnd4);
        }
        for (i = 0; i < 1000; ++i) {
            double x = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            rayOrigin = new Point2D(x, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            rayDirection = new Vector2D(x, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            Point2D lineSegmentStart5 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            alpha1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart5.scaleAdd(alpha1, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            lineSegmentEnd2.scaleAdd(alpha2, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            if (0.0 < alpha1 || 0.0 < alpha2 || alpha1 * alpha2 < 0.0) {
                this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(true, rayOrigin, rayDirection, lineSegmentStart5, lineSegmentEnd2);
            } else {
                this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin, rayDirection, lineSegmentStart5, lineSegmentEnd2);
            }
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart5.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart5);
            lineSegmentEnd2.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd2);
            this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin, rayDirection, lineSegmentStart5, lineSegmentEnd2);
        }
        for (i = 0; i < 1000; ++i) {
            double y = EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0);
            rayOrigin = new Point2D(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), y);
            rayDirection = new Vector2D(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), y);
            Point2D lineSegmentStart6 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            alpha1 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)2.0);
            lineSegmentStart6.scaleAdd(alpha1, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            lineSegmentEnd2.scaleAdd(alpha2, (Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            if (0.0 < alpha1 || 0.0 < alpha2 || alpha1 * alpha2 < 0.0) {
                this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(true, rayOrigin, rayDirection, lineSegmentStart6, lineSegmentEnd2);
            } else {
                this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin, rayDirection, lineSegmentStart6, lineSegmentEnd2);
            }
            Vector2D orthogonal = new Vector2D();
            orthogonal.sub((Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
            orthogonal.set(-orthogonal.getY(), orthogonal.getX());
            orthogonal.normalize();
            distance = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-10, (double)10.0);
            lineSegmentStart6.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentStart6);
            lineSegmentEnd2.scaleAdd(distance, (Tuple2DReadOnly)orthogonal, (Tuple2DReadOnly)lineSegmentEnd2);
            this.assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(false, rayOrigin, rayDirection, lineSegmentStart6, lineSegmentEnd2);
        }
        for (i = 0; i < 1000; ++i) {
            Point2D rayOrigin4 = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            rayDirection2 = EuclidCoreRandomTools.nextVector2DWithFixedLength((Random)random, (double)1.0);
            Point2D front1 = new Point2D();
            Point2D front2 = new Point2D();
            Point2D back1 = new Point2D();
            Point2D back2 = new Point2D();
            front1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin4);
            front2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin4);
            back1.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin4);
            back2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)rayDirection2, (Tuple2DReadOnly)rayOrigin4);
            Point2D expectedIntersection2 = new Point2D();
            Point2D actualIntersection = new Point2D();
            expectedIntersection2.set(front1);
            boolean success = VisibilityGraphsGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin4, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)front1, (Point2DReadOnly)front2, (Point2DBasics)actualIntersection);
            Assert.assertTrue((boolean)success);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection2, (Tuple2DReadOnly)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(front2);
            success = VisibilityGraphsGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin4, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)front2, (Point2DReadOnly)front1, (Point2DBasics)actualIntersection);
            Assert.assertTrue((boolean)success);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection2, (Tuple2DReadOnly)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(front1);
            success = VisibilityGraphsGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin4, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)back1, (Point2DReadOnly)front1, (Point2DBasics)actualIntersection);
            Assert.assertTrue((boolean)success);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection2, (Tuple2DReadOnly)actualIntersection, (double)1.0E-12);
            expectedIntersection2.set(front2);
            success = VisibilityGraphsGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin4, (Vector2DReadOnly)rayDirection2, (Point2DReadOnly)front2, (Point2DReadOnly)back1, (Point2DBasics)actualIntersection);
            Assert.assertTrue((boolean)success);
            EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection2, (Tuple2DReadOnly)actualIntersection, (double)1.0E-12);
        }
    }

    private void assertOnlyExistenceOfIntersectionBetweenRay2DAndAllCombinationsOfLineSegment(boolean intersectionExist, Point2D rayOrigin, Vector2D rayDirection, Point2D lineSegmentStart, Point2D lineSegmentEnd) {
        Point2D actualIntersection = new Point2D();
        boolean success = VisibilityGraphsGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd, (Point2DBasics)new Point2D());
        Assert.assertTrue((success == intersectionExist ? 1 : 0) != 0);
        actualIntersection = VisibilityGraphsGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2D)rayDirection, (Point2DReadOnly)lineSegmentStart, (Point2DReadOnly)lineSegmentEnd);
        Assert.assertTrue((actualIntersection != null == intersectionExist ? 1 : 0) != 0);
        success = VisibilityGraphsGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart, (Point2DBasics)new Point2D());
        Assert.assertTrue((success == intersectionExist ? 1 : 0) != 0);
        actualIntersection = VisibilityGraphsGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2D)rayDirection, (Point2DReadOnly)lineSegmentEnd, (Point2DReadOnly)lineSegmentStart);
        Assert.assertTrue((actualIntersection != null == intersectionExist ? 1 : 0) != 0);
    }

    private void assertAllCombinationsOfTwoLineSegmentsIntersection(Point2D expectedIntersection, Point2D rayOrigin, Vector2D rayDirection, Point2D lineSegmentStart, Point2D lineSegmentEnd) {
        double epsilon = 1.0E-12;
        Vector2D direction1 = new Vector2D();
        direction1.sub((Tuple2DReadOnly)rayDirection, (Tuple2DReadOnly)rayOrigin);
        Vector2D direction2 = new Vector2D();
        Point2D lss2 = lineSegmentStart;
        Point2D lse2 = lineSegmentEnd;
        direction2.sub((Tuple2DReadOnly)lse2, (Tuple2DReadOnly)lss2);
        if (Math.abs(rayDirection.dot((Vector2DReadOnly)direction2)) > 0.9999) {
            epsilon = 1.0E-10;
        }
        Point2D actualIntersection = new Point2D();
        boolean success = VisibilityGraphsGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lss2, (Point2DReadOnly)lse2, (Point2DBasics)actualIntersection);
        Assert.assertTrue((boolean)success);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualIntersection, (double)epsilon);
        success = VisibilityGraphsGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lse2, (Point2DReadOnly)lss2, (Point2DBasics)actualIntersection);
        Assert.assertTrue((boolean)success);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualIntersection, (double)epsilon);
        actualIntersection = VisibilityGraphsGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2D)rayDirection, (Point2DReadOnly)lss2, (Point2DReadOnly)lse2);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualIntersection, (double)epsilon);
        actualIntersection = VisibilityGraphsGeometryTools.intersectionBetweenRay2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2D)rayDirection, (Point2DReadOnly)lse2, (Point2DReadOnly)lss2);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)expectedIntersection, (Tuple2DReadOnly)actualIntersection, (double)epsilon);
    }
}

