/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs.tools;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.tools.PointCloudTools;
import us.ihmc.robotics.Assert;

public class PointCloudToolsTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testAddClusterSelfVisibilityOneJustASquare() {
        ArrayList<Point2D> polygonPoints = new ArrayList<Point2D>();
        polygonPoints.add(new Point2D(0.0, 0.0));
        polygonPoints.add(new Point2D(1.0, 0.0));
        polygonPoints.add(new Point2D(1.0, 0.2));
        polygonPoints.add(new Point2D(0.0, 0.2));
        double brakeDownThreshold = 0.20001;
        List newPolygonPoints = PointCloudTools.addPointsAlongPolygon(polygonPoints, (double)brakeDownThreshold);
        int index = 0;
        Assert.assertEquals((long)12L, (long)newPolygonPoints.size());
        this.assertEpsilonEquals(new Point2D(0.0, 0.0), (Point2DReadOnly)newPolygonPoints.get(index++));
        this.assertEpsilonEquals(new Point2D(0.2, 0.0), (Point2DReadOnly)newPolygonPoints.get(index++));
        this.assertEpsilonEquals(new Point2D(0.4, 0.0), (Point2DReadOnly)newPolygonPoints.get(index++));
        this.assertEpsilonEquals(new Point2D(0.6, 0.0), (Point2DReadOnly)newPolygonPoints.get(index++));
        this.assertEpsilonEquals(new Point2D(0.8, 0.0), (Point2DReadOnly)newPolygonPoints.get(index++));
        this.assertEpsilonEquals(new Point2D(1.0, 0.0), (Point2DReadOnly)newPolygonPoints.get(index++));
        this.assertEpsilonEquals(new Point2D(1.0, 0.2), (Point2DReadOnly)newPolygonPoints.get(index++));
        this.assertEpsilonEquals(new Point2D(0.8, 0.2), (Point2DReadOnly)newPolygonPoints.get(index++));
        this.assertEpsilonEquals(new Point2D(0.6, 0.2), (Point2DReadOnly)newPolygonPoints.get(index++));
        this.assertEpsilonEquals(new Point2D(0.4, 0.2), (Point2DReadOnly)newPolygonPoints.get(index++));
        this.assertEpsilonEquals(new Point2D(0.2, 0.2), (Point2DReadOnly)newPolygonPoints.get(index++));
        this.assertEpsilonEquals(new Point2D(0.0, 0.2), (Point2DReadOnly)newPolygonPoints.get(index++));
    }

    private void assertEpsilonEquals(Point2D expectedPoint, Point2DReadOnly actualPoint) {
        Assert.assertTrue((boolean)expectedPoint.epsilonEquals((Tuple2DReadOnly)actualPoint, 1.0E-12));
    }

    private void printPoints(List<Point2DReadOnly> points) {
        for (Point2DReadOnly point : points) {
            System.out.println(point);
        }
    }
}

