/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.UnitVector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.clusterManagement.Cluster;
import us.ihmc.pathPlanning.visibilityGraphs.clusterManagement.ExtrusionHull;
import us.ihmc.pathPlanning.visibilityGraphs.interfaces.ObstacleExtrusionDistanceCalculator;
import us.ihmc.pathPlanning.visibilityGraphs.interfaces.ObstacleRegionFilter;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.DefaultVisibilityGraphParameters;
import us.ihmc.pathPlanning.visibilityGraphs.tools.ClusterTools;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionFilter;
import us.ihmc.robotEnvironmentAwareness.planarRegion.REAPlanarRegionTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.ConvexPolygon2dCalculator;
import us.ihmc.robotics.geometry.ConvexPolygon2dTestHelpers;
import us.ihmc.robotics.geometry.ConvexPolygonScaler;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.tools.lists.PairList;

public class ClusterToolsTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testExtrudeLine() throws Exception {
        Point2D endpoint1 = new Point2D(0.0, 0.0);
        Point2D endpoint2 = new Point2D(1.0, 0.0);
        double extrusionDistance = 0.5;
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(endpoint1);
        points.add(endpoint2);
        double[] extrusionDistances = new double[]{extrusionDistance, extrusionDistance};
        List extrusions = ClusterTools.extrudeMultiLine(points, (double[])extrusionDistances, (int)3);
        Assert.assertEquals((long)6L, (long)extrusions.size());
        int index = 0;
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.0, -0.5), (Point2DReadOnly)((Point2DReadOnly)extrusions.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.5, 0.0), (Point2DReadOnly)((Point2DReadOnly)extrusions.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.0, 0.5), (Point2DReadOnly)((Point2DReadOnly)extrusions.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, 0.5), (Point2DReadOnly)((Point2DReadOnly)extrusions.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.5, 0.0), (Point2DReadOnly)((Point2DReadOnly)extrusions.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, -0.5), (Point2DReadOnly)((Point2DReadOnly)extrusions.get(index++)), (double)1.0E-12);
    }

    @Test
    public void testFilterVerticalPolygonForMultiLineExtrusion() throws Exception {
        ArrayList<Point3D> rawPoints = new ArrayList<Point3D>();
        double expectedObstacleHeight = 1.0;
        rawPoints.add(new Point3D(0.0, 0.0, expectedObstacleHeight));
        rawPoints.add(new Point3D(expectedObstacleHeight, 0.0, expectedObstacleHeight));
        rawPoints.add(new Point3D(0.5, 0.0, 0.0));
        List filteredRawPoints = ClusterTools.filterVerticalPolygonForMultiLineExtrusion(rawPoints, (double)0.0);
        for (Point3DReadOnly filteredRawPoint : filteredRawPoints) {
            Assert.assertEquals((double)expectedObstacleHeight, (double)filteredRawPoint.getZ(), (double)1.0E-12);
        }
    }

    @Test
    public void testExtrudeCorner() {
        Point2D previous = new Point2D(1.0, 0.0);
        Point2D cornerPointToExtrude = new Point2D(1.0, 1.0);
        Point2D next = new Point2D(0.0, 1.0);
        LineSegment2D previousEdge = new LineSegment2D((Point2DReadOnly)previous, (Point2DReadOnly)cornerPointToExtrude);
        LineSegment2D nextEdge = new LineSegment2D((Point2DReadOnly)cornerPointToExtrude, (Point2DReadOnly)next);
        boolean extrudeToTheLeft = false;
        int numberOfExtrusions = 3;
        double extrusionDistance = 0.5;
        List extrusions = ClusterTools.extrudeMultiplePointsAtOutsideCorner((Point2DReadOnly)cornerPointToExtrude, (LineSegment2DReadOnly)previousEdge, (LineSegment2DReadOnly)nextEdge, (boolean)extrudeToTheLeft, (int)numberOfExtrusions, (double)extrusionDistance);
        Assert.assertEquals((long)numberOfExtrusions, (long)extrusions.size());
        Point2D extrusionExpected0 = new Point2D(1.5, 1.0);
        Point2D extrusionExpected1 = new Point2D(1.0, 1.0);
        Vector2D extrusionDirection = new Vector2D(1.0, 1.0);
        extrusionDirection.normalize();
        extrusionExpected1.scaleAdd(extrusionDistance, (Tuple2DReadOnly)extrusionDirection, (Tuple2DReadOnly)cornerPointToExtrude);
        Point2D extrusionExpected2 = new Point2D(1.0, 1.5);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)extrusionExpected0, (Point2DReadOnly)((Point2DReadOnly)extrusions.get(0)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)extrusionExpected1, (Point2DReadOnly)((Point2DReadOnly)extrusions.get(1)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)extrusionExpected2, (Point2DReadOnly)((Point2DReadOnly)extrusions.get(2)), (double)1.0E-12);
    }

    @Test
    public void testExtrudePolygon() throws Exception {
        Point2D pointA = new Point2D(0.0, 0.0);
        Point2D pointB = new Point2D(1.0, 0.0);
        Point2D pointC = new Point2D(1.0, 1.0);
        Point2D pointD = new Point2D(0.0, 1.0);
        boolean extrudeToTheLeft = true;
        ArrayList<Point2D> pointsToExtrude = new ArrayList<Point2D>();
        pointsToExtrude.add(pointA);
        pointsToExtrude.add(pointB);
        pointsToExtrude.add(pointC);
        pointsToExtrude.add(pointD);
        double[] extrusionDistances = new double[]{0.1, 0.2, 0.0, 0.3};
        List extrudedPolygon = ClusterTools.extrudePolygon((boolean)extrudeToTheLeft, pointsToExtrude, (double[])extrusionDistances);
        Assert.assertEquals((long)4L, (long)extrudedPolygon.size());
        int index = 0;
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.1, 0.1), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.8, 0.2), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.3, 0.7), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        extrudeToTheLeft = false;
        extrudedPolygon = ClusterTools.extrudePolygon((boolean)extrudeToTheLeft, pointsToExtrude, (double[])extrusionDistances);
        double sqrt2By2 = Math.sqrt(2.0) / 2.0;
        Assert.assertEquals((long)12L, (long)extrudedPolygon.size());
        index = 0;
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.1, 0.0), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.1 * sqrt2By2, -0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.0, -0.1), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, -0.2), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0 + 0.2 * sqrt2By2, -0.2 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.2, 0.0), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.0, 1.3), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.3 * sqrt2By2, 1.0 + 0.3 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.3, 1.0), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        extrudeToTheLeft = false;
        pointsToExtrude = new ArrayList();
        pointsToExtrude.add(pointD);
        pointsToExtrude.add(pointC);
        pointsToExtrude.add(pointB);
        pointsToExtrude.add(pointA);
        extrusionDistances = new double[]{0.3, 0.0, 0.2, 0.1};
        extrudedPolygon = ClusterTools.extrudePolygon((boolean)extrudeToTheLeft, pointsToExtrude, (double[])extrusionDistances);
        Assert.assertEquals((long)4L, (long)extrudedPolygon.size());
        index = 0;
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.3, 0.7), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, 1.0), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.8, 0.2), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.1, 0.1), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        pointsToExtrude = new ArrayList();
        pointsToExtrude.add(pointA);
        pointsToExtrude.add(pointB);
        extrudeToTheLeft = false;
        extrusionDistances = new double[]{0.1, 0.1};
        extrudedPolygon = ClusterTools.extrudePolygon((boolean)extrudeToTheLeft, pointsToExtrude, (double[])extrusionDistances);
        Assert.assertEquals((long)10L, (long)extrudedPolygon.size());
        index = 0;
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.0, -0.1), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.1 * sqrt2By2, -0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.1, 0.0), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.1 * sqrt2By2, 0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.0, 0.1), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, 0.1), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0 + 0.1 * sqrt2By2, 0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.1, 0.0), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0 + 0.1 * sqrt2By2, -0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, -0.1), (Point2DReadOnly)((Point2DReadOnly)extrudedPolygon.get(index++)), (double)1.0E-12);
    }

    @Test
    public void testExtrudeTwoPointMultiLine() throws Exception {
        Point2D pointA = new Point2D(0.0, 0.0);
        Point2D pointB = new Point2D(1.0, 0.0);
        ArrayList<Point2D> pointsToExtrude = new ArrayList<Point2D>();
        pointsToExtrude.add(pointA);
        pointsToExtrude.add(pointB);
        double[] extrusionDistances = new double[]{0.1, 0.1};
        int numberOfExtrusionsAtEndpoints = 5;
        List extrudedLine = ClusterTools.extrudeMultiLine(pointsToExtrude, (double[])extrusionDistances, (int)numberOfExtrusionsAtEndpoints);
        double sqrt2By2 = Math.sqrt(2.0) / 2.0;
        Assert.assertEquals((long)10L, (long)extrudedLine.size());
        int index = 0;
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.0, -0.1), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.1 * sqrt2By2, -0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.1, 0.0), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.1 * sqrt2By2, 0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.0, 0.1), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, 0.1), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0 + 0.1 * sqrt2By2, 0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.1, 0.0), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0 + 0.1 * sqrt2By2, -0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, -0.1), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
    }

    @Test
    public void testExtrudeMultiLine() throws Exception {
        Point2D pointA = new Point2D(-1.0, 1.0);
        Point2D pointB = new Point2D(0.0, 0.0);
        Point2D pointC = new Point2D(1.0, 1.0);
        ArrayList<Point2D> pointsToExtrude = new ArrayList<Point2D>();
        pointsToExtrude.add(pointA);
        pointsToExtrude.add(pointB);
        pointsToExtrude.add(pointC);
        double[] extrusionDistances = new double[]{0.1, 0.1, 0.1};
        int numberOfExtrusionsAtEndpoints = 5;
        List extrudedLine = ClusterTools.extrudeMultiLine(pointsToExtrude, (double[])extrusionDistances, (int)numberOfExtrusionsAtEndpoints);
        double sqrt2By2 = Math.sqrt(2.0) / 2.0;
        Assert.assertEquals((long)14L, (long)extrudedLine.size());
        int index = 0;
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-1.0 - 0.1 * sqrt2By2, 1.0 - 0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-1.1, 1.0), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-1.0 - 0.1 * sqrt2By2, 1.0 + 0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-1.0, 1.1), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-1.0 + 0.1 * sqrt2By2, 1.0 + 0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.0, 0.1 * Math.sqrt(2.0)), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0 - 0.1 * sqrt2By2, 1.0 + 0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0, 1.1), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0 + 0.1 * sqrt2By2, 1.0 + 0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.1, 1.0), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(1.0 + 0.1 * sqrt2By2, 1.0 - 0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.1 * sqrt2By2, -0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.0, -0.1), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-0.1 * sqrt2By2, -0.1 * sqrt2By2), (Point2DReadOnly)((Point2DReadOnly)extrudedLine.get(index++)), (double)1.0E-12);
    }

    @Test
    public void testExtrudeSinglePointAtInsideCorner() throws Exception {
        Point2D pointA = new Point2D(-1.0, 1.0);
        Point2D pointB = new Point2D(0.0, 0.0);
        Point2D pointC = new Point2D(1.0, 1.0);
        double extrusionDistance = 0.1;
        double sqrt2 = Math.sqrt(2.0);
        Point2D expectedAnswer = new Point2D(0.0, 0.1 * sqrt2);
        boolean extrudeToTheLeft = true;
        this.evaluateExtrudeSinglePointAtInsideCorner(pointA, pointB, pointC, extrusionDistance, extrudeToTheLeft, expectedAnswer);
        pointA = new Point2D(-100000.0, 1.0);
        pointB = new Point2D(10.0, 1.0);
        pointC = new Point2D(100.0, 1.0);
        extrusionDistance = 0.1;
        expectedAnswer = new Point2D(10.0, 1.1);
        this.evaluateExtrudeSinglePointAtInsideCorner(pointA, pointB, pointC, extrusionDistance, extrudeToTheLeft, expectedAnswer);
        pointA = new Point2D(-100000.0, 1.0);
        pointB = new Point2D(10.0, 1.0);
        pointC = new Point2D(100.0, 1.0);
        extrusionDistance = 0.1;
        extrudeToTheLeft = false;
        expectedAnswer = new Point2D(10.0, 0.9);
        this.evaluateExtrudeSinglePointAtInsideCorner(pointA, pointB, pointC, extrusionDistance, extrudeToTheLeft, expectedAnswer);
        pointA = new Point2D(-1.13, 0.37);
        pointB = new Point2D(0.2, 0.11);
        pointC = new Point2D(0.6, 1.0);
        extrusionDistance = 0.1;
        extrudeToTheLeft = true;
        Point2DReadOnly pointD = this.extrudeSinglePointAtInsideCorner(pointA, pointB, pointC, extrusionDistance, extrudeToTheLeft);
        Line2D lineAB = new Line2D((Point2DReadOnly)pointA, (Point2DReadOnly)pointB);
        UnitVector2DBasics vectorAB = lineAB.getDirection();
        Vector2D vectorAE = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)vectorAB);
        Line2D lineBC = new Line2D((Point2DReadOnly)pointB, (Point2DReadOnly)pointC);
        UnitVector2DBasics vectorBC = lineBC.getDirection();
        Vector2D vectorCF = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)vectorBC);
        Point2D pointE = new Point2D();
        pointE.scaleAdd(extrusionDistance, (Tuple2DReadOnly)vectorAE, (Tuple2DReadOnly)pointA);
        Point2D pointF = new Point2D();
        pointF.scaleAdd(extrusionDistance, (Tuple2DReadOnly)vectorCF, (Tuple2DReadOnly)pointC);
        Line2D lineED = new Line2D((Point2DReadOnly)pointE, pointD);
        Line2D lineDF = new Line2D(pointD, (Point2DReadOnly)pointF);
        UnitVector2DBasics vectorED = lineED.getDirection();
        UnitVector2DBasics vectorDF = lineDF.getDirection();
        Assert.assertEquals((double)1.0, (double)vectorAB.dot((Vector2DReadOnly)vectorED), (double)1.0E-12);
        Assert.assertEquals((double)1.0, (double)vectorBC.dot((Vector2DReadOnly)vectorDF), (double)1.0E-12);
    }

    private Point2DReadOnly evaluateExtrudeSinglePointAtInsideCorner(Point2D pointA, Point2D pointB, Point2D pointC, double extrusionDistance, boolean extrudeToTheLeft, Point2D expectedAnswer) {
        Point2DReadOnly extrudedPoint = this.extrudeSinglePointAtInsideCorner(pointA, pointB, pointC, extrusionDistance, extrudeToTheLeft);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)expectedAnswer, (Point2DReadOnly)extrudedPoint, (double)1.0E-12);
        return extrudedPoint;
    }

    private Point2DReadOnly extrudeSinglePointAtInsideCorner(Point2D pointA, Point2D pointB, Point2D pointC, double extrusionDistance, boolean extrudeToTheLeft) {
        LineSegment2D edgePrev = new LineSegment2D((Point2DReadOnly)pointA, (Point2DReadOnly)pointB);
        LineSegment2D edgeNext = new LineSegment2D((Point2DReadOnly)pointB, (Point2DReadOnly)pointC);
        ArrayList<Point2DReadOnly> extrudedPointList = new ArrayList<Point2DReadOnly>();
        extrudedPointList.add(ClusterTools.extrudeSinglePointAtInsideCorner((Point2DReadOnly)pointB, (LineSegment2DReadOnly)edgePrev, (LineSegment2DReadOnly)edgeNext, (boolean)extrudeToTheLeft, (double)extrusionDistance));
        Assert.assertEquals((long)1L, (long)extrudedPointList.size());
        Point2DReadOnly extrudedPoint = (Point2DReadOnly)extrudedPointList.get(0);
        return extrudedPoint;
    }

    @Test
    public void testSquareOnTopOfSquare() throws Exception {
        double tiltedPointHeight = 0.1;
        double arbitraryTranslationX = 3.0;
        double arbitraryTranslationY = -4.0;
        Point3D pointAInWorld = new Point3D(0.0, 0.0, 0.0);
        Point3D pointBInWorld = new Point3D(0.0, 1.0, 0.0);
        Point3D pointCInWorld = new Point3D(1.0, 1.0, tiltedPointHeight);
        Point3D pointDInWorld = new Point3D(1.0, 0.0, tiltedPointHeight);
        Vector3D zAxisForTransform = new Vector3D(-tiltedPointHeight, 0.0, 1.0);
        zAxisForTransform.normalize();
        RigidBodyTransform transformToWorldOops = new RigidBodyTransform();
        transformToWorldOops.getTranslation().set(arbitraryTranslationX, arbitraryTranslationY, 0.0);
        RigidBodyTransform transformToWorld0 = ClusterToolsTest.createTransformFromPointAndZAxis((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)zAxisForTransform);
        transformToWorld0.multiply((RigidBodyTransformReadOnly)transformToWorldOops);
        RigidBodyTransform transformToLocal0 = new RigidBodyTransform((RigidBodyTransformReadOnly)transformToWorld0);
        transformToLocal0.invert();
        Point3D pointAInLocal3D = this.createAndTransformPoint(pointAInWorld, transformToLocal0);
        Point3D pointBInLocal3D = this.createAndTransformPoint(pointBInWorld, transformToLocal0);
        Point3D pointCInLocal3D = this.createAndTransformPoint(pointCInWorld, transformToLocal0);
        Point3D pointDInLocal3D = this.createAndTransformPoint(pointDInWorld, transformToLocal0);
        Assert.assertEquals((double)0.0, (double)pointAInLocal3D.getZ(), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)pointBInLocal3D.getZ(), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)pointCInLocal3D.getZ(), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)pointDInLocal3D.getZ(), (double)1.0E-12);
        Point2D pointAInLocal = new Point2D((Tuple3DReadOnly)pointAInLocal3D);
        Point2D pointBInLocal = new Point2D((Tuple3DReadOnly)pointBInLocal3D);
        Point2D pointCInLocal = new Point2D((Tuple3DReadOnly)pointCInLocal3D);
        Point2D pointDInLocal = new Point2D((Tuple3DReadOnly)pointDInLocal3D);
        Vertex2DSupplier vertices0 = Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[]{pointAInLocal, pointBInLocal, pointCInLocal, pointDInLocal});
        ConvexPolygon2D convexPolygon0 = new ConvexPolygon2D(vertices0);
        PlanarRegion homeRegion = new PlanarRegion((RigidBodyTransformReadOnly)transformToWorld0, (Vertex2DSupplier)convexPolygon0);
        Point2D pointEInLocal = new Point2D(0.3, 0.3);
        Point2D pointFInLocal = new Point2D(0.3, 0.7);
        Point2D pointGInLocal = new Point2D(0.7, 0.7);
        Point2D pointHInLocal = new Point2D(0.7, 0.3);
        RigidBodyTransform transformToWorld1 = new RigidBodyTransform();
        transformToWorld1.getTranslation().set(0.0, 0.0, 0.5);
        Vertex2DSupplier vertices1 = Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[]{pointEInLocal, pointFInLocal, pointGInLocal, pointHInLocal});
        ConvexPolygon2D convexPolygon1 = new ConvexPolygon2D(vertices1);
        PlanarRegion obstacleRegion = new PlanarRegion((RigidBodyTransformReadOnly)transformToWorld1, (Vertex2DSupplier)convexPolygon1);
        ArrayList<PlanarRegion> obstacleRegions = new ArrayList<PlanarRegion>();
        obstacleRegions.add(obstacleRegion);
        double orthogonalAngle = 0.8;
        ObstacleExtrusionDistanceCalculator preferredExtrusionDistanceCalculator = new ObstacleExtrusionDistanceCalculator(){

            public double computeExtrusionDistance(Point2DReadOnly pointToExtrude, double obstacleHeight) {
                return 0.2;
            }
        };
        ObstacleExtrusionDistanceCalculator extrusionDistanceCalculator = new ObstacleExtrusionDistanceCalculator(){

            public double computeExtrusionDistance(Point2DReadOnly pointToExtrude, double obstacleHeight) {
                return 0.1;
            }
        };
        PairList obstacleClusters = ClusterTools.createObstacleClusters((PlanarRegion)homeRegion, obstacleRegions, (double)orthogonalAngle, (ObstacleExtrusionDistanceCalculator)preferredExtrusionDistanceCalculator, (ObstacleExtrusionDistanceCalculator)extrusionDistanceCalculator, (boolean)true);
        Assert.assertEquals((long)1L, (long)obstacleClusters.size());
        Cluster obstacleCluster = (Cluster)((ImmutablePair)obstacleClusters.get(0)).getLeft();
        List navigableExtrusionsInWorld = obstacleCluster.getNavigableExtrusionsInWorld();
        Assert.assertEquals((long)12L, (long)navigableExtrusionsInWorld.size());
        double sqrt2By2 = Math.sqrt(2.0) / 2.0;
        Point2D pointE0InWorld = new Point2D(0.3, 0.2);
        Point2D pointE1InWorld = new Point2D(0.3 - sqrt2By2 * 0.1, 0.3 - sqrt2By2 * 0.1);
        Point2D pointE2InWorld = new Point2D(0.2, 0.3);
        Point2D pointF0InWorld = new Point2D(0.2, 0.7);
        Point2D pointF1InWorld = new Point2D(0.3 - sqrt2By2 * 0.1, 0.7 + sqrt2By2 * 0.1);
        Point2D pointF2InWorld = new Point2D(0.3, 0.8);
        Point2D pointG0InWorld = new Point2D(0.7, 0.8);
        Point2D pointG1InWorld = new Point2D(0.7 + sqrt2By2 * 0.1, 0.7 + sqrt2By2 * 0.1);
        Point2D pointG2InWorld = new Point2D(0.8, 0.7);
        Point2D pointH0InWorld = new Point2D(0.8, 0.3);
        Point2D pointH1InWorld = new Point2D(0.7 + sqrt2By2 * 0.1, 0.3 - sqrt2By2 * 0.1);
        Point2D pointH2InWorld = new Point2D(0.7, 0.2);
        Assert.assertTrue((boolean)this.listContainsAllXYMatch(navigableExtrusionsInWorld, new Point2DReadOnly[]{pointE0InWorld, pointE1InWorld, pointE2InWorld}));
        Assert.assertTrue((boolean)this.listContainsAllXYMatch(navigableExtrusionsInWorld, new Point2DReadOnly[]{pointF0InWorld, pointF1InWorld, pointF2InWorld}));
        Assert.assertTrue((boolean)this.listContainsAllXYMatch(navigableExtrusionsInWorld, new Point2DReadOnly[]{pointG0InWorld, pointG1InWorld, pointG2InWorld}));
        Assert.assertTrue((boolean)this.listContainsAllXYMatch(navigableExtrusionsInWorld, new Point2DReadOnly[]{pointH0InWorld, pointH1InWorld, pointH2InWorld}));
        RigidBodyTransform transformToPlanarRegion = new RigidBodyTransform();
        homeRegion.getTransformToWorld(transformToPlanarRegion);
        transformToPlanarRegion.invert();
        for (Point3DReadOnly point3D : navigableExtrusionsInWorld) {
            Point3D pointToTest = new Point3D((Tuple3DReadOnly)point3D);
            transformToPlanarRegion.transform((Point3DBasics)pointToTest);
            Assert.assertEquals((double)0.0, (double)pointToTest.getZ(), (double)1.0E-12);
        }
    }

    @Test
    public void testTwoSquaresOneObstacle() throws Exception {
        Point2D[] region0_1Points = new Point2D[]{new Point2D(-3.0, 3.0), new Point2D(3.0, 3.0), new Point2D(3.0, -3.0), new Point2D(-3.0, -3.0)};
        Vector3D normal0_1 = new Vector3D(0.0, 0.0, 1.0);
        normal0_1.normalize();
        RigidBodyTransform transform0_1 = ClusterToolsTest.createTransformFromPointAndZAxis((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)normal0_1);
        PlanarRegion region0_1 = this.createPlanarRegion(transform0_1, region0_1Points);
        double distanceBetweenBottomSquares = 0.25;
        Point2D[] region1_1Points = new Point2D[]{new Point2D(3.0 + distanceBetweenBottomSquares, 3.0), new Point2D(7.0, 3.0), new Point2D(7.0, -3.0), new Point2D(3.0 + distanceBetweenBottomSquares, -3.0)};
        Vector3D normal1_1 = new Vector3D(0.0, 0.0, 1.0);
        normal1_1.normalize();
        RigidBodyTransform transform1_1 = ClusterToolsTest.createTransformFromPointAndZAxis((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)normal1_1);
        PlanarRegion region1_1 = this.createPlanarRegion(transform1_1, region1_1Points);
        Point2D[] region2_1Points = new Point2D[]{new Point2D(-0.5, 2.0), new Point2D(0.5, 2.0), new Point2D(0.5, -2.0), new Point2D(-0.5, -2.0)};
        Vector3D normal2_1 = new Vector3D(0.0, 0.0, 1.0);
        normal2_1.normalize();
        RigidBodyTransform transform2_1 = ClusterToolsTest.createTransformFromPointAndZAxis((Point3DReadOnly)new Point3D(3.0 + distanceBetweenBottomSquares / 2.0, 0.0, 1.0), (Vector3DReadOnly)normal2_1);
        PlanarRegion region2_1 = this.createPlanarRegion(transform2_1, region2_1Points);
        ArrayList<PlanarRegion> obstacleRegions = new ArrayList<PlanarRegion>();
        obstacleRegions.add(region0_1);
        obstacleRegions.add(region1_1);
        PlanarRegion homeRegion = region2_1;
        PairList<Cluster, PlanarRegion> obstacleClusters = this.createObstacleClustersForTests(obstacleRegions, homeRegion);
        Assert.assertEquals((long)0L, (long)obstacleClusters.size());
        obstacleRegions.clear();
        obstacleRegions.add(region1_1);
        homeRegion = region0_1;
        obstacleClusters = this.createObstacleClustersForTests(obstacleRegions, homeRegion);
        Assert.assertEquals((long)0L, (long)obstacleClusters.size());
        obstacleRegions.clear();
        obstacleRegions.add(region1_1);
        obstacleRegions.add(region2_1);
        homeRegion = region0_1;
        obstacleClusters = this.createObstacleClustersForTests(obstacleRegions, homeRegion);
        Assert.assertEquals((long)1L, (long)obstacleClusters.size());
        Cluster cluster = (Cluster)((ImmutablePair)obstacleClusters.get(0)).getLeft();
        ExtrusionHull nonNavigableExtrusionsInLocal = cluster.getNonNavigableExtrusionsInLocal();
        Assert.assertEquals((long)12L, (long)nonNavigableExtrusionsInLocal.size());
        obstacleRegions.clear();
        obstacleRegions.add(region0_1);
        obstacleRegions.add(region2_1);
        homeRegion = region1_1;
        obstacleClusters = this.createObstacleClustersForTests(obstacleRegions, homeRegion);
        Assert.assertEquals((long)1L, (long)obstacleClusters.size());
        cluster = (Cluster)((ImmutablePair)obstacleClusters.get(0)).getLeft();
        nonNavigableExtrusionsInLocal = cluster.getNonNavigableExtrusionsInLocal();
        Assert.assertEquals((long)12L, (long)nonNavigableExtrusionsInLocal.size());
    }

    @Test
    public void testCreateObstaclesVerticalSegmentOverRotatedBase() {
        Point2D pointA = new Point2D(0.0, -0.5);
        Point2D pointB = new Point2D(0.0, 0.5);
        Point2D pointC = new Point2D(0.5, 0.5);
        Point2D pointD = new Point2D(0.5, -0.5);
        Point2D pointE = new Point2D(-10.0, -10.0);
        Point2D pointF = new Point2D(-10.0, 10.0);
        Point2D pointG = new Point2D(10.0, 10.0);
        Point2D pointH = new Point2D(10.0, -10.0);
        ConvexPolygon2D polygon0_0 = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[]{pointA, pointB, pointC, pointD}));
        ConvexPolygon2D polygon1_0 = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[]{pointE, pointF, pointG, pointH}));
        RigidBodyTransform transform0 = new RigidBodyTransform();
        transform0.getRotation().setEuler(0.0, 1.5707963267948966, 0.0);
        transform0.getTranslation().set(0.0, 0.0, 1.0);
        PlanarRegion planarRegion0 = new PlanarRegion((RigidBodyTransformReadOnly)transform0, (Vertex2DSupplier)polygon0_0);
        ObstacleExtrusionDistanceCalculator preferredExtrusionDistanceCalculator = new ObstacleExtrusionDistanceCalculator(){

            public double computeExtrusionDistance(Point2DReadOnly pointToExtrude, double obstacleHeight) {
                return 0.02;
            }
        };
        ObstacleExtrusionDistanceCalculator extrusionDistanceCalculator = new ObstacleExtrusionDistanceCalculator(){

            public double computeExtrusionDistance(Point2DReadOnly pointToExtrude, double obstacleHeight) {
                return 0.01;
            }
        };
        double orthogonalAngle = 0.5;
        double baseRotationAngle = 0.0;
        RigidBodyTransform transform1 = new RigidBodyTransform();
        transform1.getRotation().setEuler(0.0, baseRotationAngle, 0.0);
        PlanarRegion planarRegion1 = new PlanarRegion((RigidBodyTransformReadOnly)transform1, (Vertex2DSupplier)polygon1_0);
        ArrayList<PlanarRegion> obstacleRegions = new ArrayList<PlanarRegion>();
        obstacleRegions.add(planarRegion0);
        PairList obstacleClustersOn1 = ClusterTools.createObstacleClusters((PlanarRegion)planarRegion1, obstacleRegions, (double)orthogonalAngle, (ObstacleExtrusionDistanceCalculator)preferredExtrusionDistanceCalculator, (ObstacleExtrusionDistanceCalculator)extrusionDistanceCalculator, (boolean)true);
        Assert.assertEquals((long)1L, (long)obstacleClustersOn1.size());
        Cluster obstacleCluster = (Cluster)((ImmutablePair)obstacleClustersOn1.get(0)).getLeft();
        List obstacleExtrusionsInWorld = obstacleCluster.getNavigableExtrusionsInWorld();
        Assert.assertEquals((long)10L, (long)obstacleExtrusionsInWorld.size());
        Assert.assertTrue((boolean)this.listContains(obstacleExtrusionsInWorld, new Point3D(0.0, -0.51, 0.0)));
        Assert.assertTrue((boolean)this.listContains(obstacleExtrusionsInWorld, new Point3D(0.0, 0.51, 0.0)));
        Assert.assertTrue((boolean)this.listContainsXYMatch(obstacleExtrusionsInWorld, (Point2DReadOnly)new Point2D(0.01, 0.5)));
        Assert.assertTrue((boolean)this.listContainsXYMatch(obstacleExtrusionsInWorld, (Point2DReadOnly)new Point2D(0.01, -0.5)));
        Assert.assertTrue((boolean)this.listContainsXYMatch(obstacleExtrusionsInWorld, (Point2DReadOnly)new Point2D(-0.01, 0.5)));
        Assert.assertTrue((boolean)this.listContainsXYMatch(obstacleExtrusionsInWorld, (Point2DReadOnly)new Point2D(-0.01, -0.5)));
        baseRotationAngle = 0.2;
        transform1 = new RigidBodyTransform();
        transform1.getRotation().setEuler(0.0, baseRotationAngle, 0.0);
        planarRegion1 = new PlanarRegion((RigidBodyTransformReadOnly)transform1, (Vertex2DSupplier)polygon1_0);
        obstacleRegions = new ArrayList();
        obstacleRegions.add(planarRegion0);
        obstacleClustersOn1 = ClusterTools.createObstacleClusters((PlanarRegion)planarRegion1, obstacleRegions, (double)orthogonalAngle, (ObstacleExtrusionDistanceCalculator)preferredExtrusionDistanceCalculator, (ObstacleExtrusionDistanceCalculator)extrusionDistanceCalculator, (boolean)true);
        Assert.assertEquals((long)1L, (long)obstacleClustersOn1.size());
        obstacleCluster = (Cluster)((ImmutablePair)obstacleClustersOn1.get(0)).getLeft();
        obstacleExtrusionsInWorld = obstacleCluster.getNavigableExtrusionsInWorld();
        Assert.assertEquals((long)10L, (long)obstacleExtrusionsInWorld.size());
        Assert.assertTrue((boolean)this.listContains(obstacleExtrusionsInWorld, new Point3D(0.0, -0.51, 0.0)));
        Assert.assertTrue((boolean)this.listContains(obstacleExtrusionsInWorld, new Point3D(0.0, 0.51, 0.0)));
        Assert.assertTrue((boolean)this.listContainsXYMatch(obstacleExtrusionsInWorld, (Point2DReadOnly)new Point2D(0.01, 0.5)));
        Assert.assertTrue((boolean)this.listContainsXYMatch(obstacleExtrusionsInWorld, (Point2DReadOnly)new Point2D(0.01, -0.5)));
        Assert.assertTrue((boolean)this.listContainsXYMatch(obstacleExtrusionsInWorld, (Point2DReadOnly)new Point2D(-0.01, 0.5)));
        Assert.assertTrue((boolean)this.listContainsXYMatch(obstacleExtrusionsInWorld, (Point2DReadOnly)new Point2D(-0.01, -0.5)));
    }

    @Test
    public void testFilterPointsWithSameXYCoordinatesKeepingHighest() {
        int i;
        ArrayList<Point3D> pointsToFilter = new ArrayList<Point3D>();
        double thresholdSquared = 0.010000000000000002;
        Point3D pointA = new Point3D(0.0, 0.0, 0.7);
        Point3D pointB = new Point3D(0.001, 0.0, 0.3);
        Point3D pointC = new Point3D(0.002, 0.0, -0.9);
        Point3D pointD = new Point3D(0.01, 0.0, 0.9);
        Point3D pointE = new Point3D(0.3, 0.0, 0.55);
        Point3D pointF = new Point3D(0.35, 0.0, 0.75);
        Point3D pointG = new Point3D(0.451, 0.0, 0.43);
        Point3D pointH = new Point3D(0.54, 0.0, 0.2);
        pointsToFilter.add(pointA);
        pointsToFilter.add(pointB);
        List filteredPoints = ClusterTools.filterPointsWithSameXYCoordinatesKeepingHighest(pointsToFilter, (double)thresholdSquared);
        Assert.assertEquals((long)1L, (long)filteredPoints.size());
        Assert.assertTrue((boolean)this.listContains(filteredPoints, pointA));
        pointsToFilter.clear();
        pointsToFilter.add(pointB);
        pointsToFilter.add(pointA);
        filteredPoints = ClusterTools.filterPointsWithSameXYCoordinatesKeepingHighest(pointsToFilter, (double)thresholdSquared);
        Assert.assertEquals((long)1L, (long)filteredPoints.size());
        Assert.assertTrue((boolean)this.listContains(filteredPoints, pointA));
        pointsToFilter.clear();
        pointsToFilter.add(pointB);
        pointsToFilter.add(pointC);
        pointsToFilter.add(pointA);
        filteredPoints = ClusterTools.filterPointsWithSameXYCoordinatesKeepingHighest(pointsToFilter, (double)thresholdSquared);
        Assert.assertEquals((long)1L, (long)filteredPoints.size());
        Assert.assertTrue((boolean)this.listContains(filteredPoints, pointA));
        pointsToFilter.clear();
        pointsToFilter.add(pointA);
        pointsToFilter.add(pointB);
        pointsToFilter.add(pointC);
        pointsToFilter.add(pointD);
        pointsToFilter.add(pointE);
        pointsToFilter.add(pointF);
        pointsToFilter.add(pointG);
        pointsToFilter.add(pointH);
        filteredPoints = ClusterTools.filterPointsWithSameXYCoordinatesKeepingHighest(pointsToFilter, (double)thresholdSquared);
        Assert.assertEquals((long)3L, (long)filteredPoints.size());
        Assert.assertTrue((boolean)this.listContains(filteredPoints, pointD));
        Assert.assertTrue((boolean)this.listContains(filteredPoints, pointF));
        Assert.assertTrue((boolean)this.listContains(filteredPoints, pointG));
        pointsToFilter.clear();
        for (i = 0; i < 101; ++i) {
            pointsToFilter.add(new Point3D(0.03 * (double)i, 0.0, 0.03 * (double)i));
        }
        filteredPoints = ClusterTools.filterPointsWithSameXYCoordinatesKeepingHighest(pointsToFilter, (double)thresholdSquared);
        Assert.assertEquals((long)25L, (long)filteredPoints.size());
        Assert.assertTrue((boolean)this.listContains(filteredPoints, new Point3D(3.0, 0.0, 3.0)));
        pointsToFilter.clear();
        for (i = 0; i < 101; ++i) {
            pointsToFilter.add(new Point3D(0.03 * (double)i, 0.0, 3.0 - 0.03 * (double)i));
        }
        filteredPoints = ClusterTools.filterPointsWithSameXYCoordinatesKeepingHighest(pointsToFilter, (double)thresholdSquared);
        Assert.assertEquals((long)26L, (long)filteredPoints.size());
        Assert.assertTrue((boolean)this.listContains(filteredPoints, new Point3D(0.0, 0.0, 3.0)));
    }

    @Test
    public void testVerticalObstacleOne() {
        Point2D[] region0_1Points = new Point2D[]{new Point2D(-1.0, 1.0), new Point2D(1.0, 1.0), new Point2D(1.0, -1.0), new Point2D(-1.0, -1.0)};
        Vector3D normal0_1 = new Vector3D(0.0, 0.0, 1.0);
        normal0_1.normalize();
        RigidBodyTransform transform0_1 = new RigidBodyTransform();
        PlanarRegion flatGroundRegion = this.createPlanarRegion(transform0_1, region0_1Points);
        Point2D[] region1_1Points = new Point2D[]{new Point2D(0.0, 0.0), new Point2D(0.0, 0.2), new Point2D(0.1, 0.2), new Point2D(0.1, 0.0)};
        Point2D[] region1_2Points = new Point2D[]{new Point2D(0.1, 0.0), new Point2D(0.1, 0.4), new Point2D(0.2, 0.4), new Point2D(0.2, 0.0)};
        ArrayList<Point2D> concaveHull = new ArrayList<Point2D>();
        concaveHull.add(new Point2D(0.0, 0.0));
        concaveHull.add(new Point2D(0.0, 0.2));
        concaveHull.add(new Point2D(0.1, 0.2));
        concaveHull.add(new Point2D(0.1, 0.4));
        concaveHull.add(new Point2D(0.2, 0.4));
        concaveHull.add(new Point2D(0.2, 0.0));
        Vector3D normal1_1 = new Vector3D(0.0, -1.0, 0.0);
        normal1_1.normalize();
        RigidBodyTransform transform1_1 = ClusterToolsTest.createTransformFromPointAndZAxis((Point3DReadOnly)new Point3D(0.0, 0.0, 0.014), (Vector3DReadOnly)normal1_1);
        PlanarRegion verticalObstacleRegion = this.createPlanarRegionFromSeveralPolygons(concaveHull, transform1_1, region1_1Points, region1_2Points);
        ArrayList<PlanarRegion> obstacleRegions = new ArrayList<PlanarRegion>();
        obstacleRegions.add(verticalObstacleRegion);
        PlanarRegion homeRegion = flatGroundRegion;
        DefaultVisibilityGraphParameters parameters = new DefaultVisibilityGraphParameters();
        double orthogonalAngle = parameters.getRegionOrthogonalAngle();
        ObstacleExtrusionDistanceCalculator extrusionDistanceCalculator = new ObstacleExtrusionDistanceCalculator(){

            public double computeExtrusionDistance(Point2DReadOnly pointToExtrude, double obstacleHeight) {
                if (obstacleHeight < 0.21300000000000002) {
                    return 0.0;
                }
                if (obstacleHeight < 0.41300000000000003) {
                    return 0.2;
                }
                return 0.4;
            }
        };
        PairList obstacleClusters = ClusterTools.createObstacleClusters((PlanarRegion)homeRegion, obstacleRegions, (double)orthogonalAngle, (ObstacleExtrusionDistanceCalculator)extrusionDistanceCalculator, (ObstacleExtrusionDistanceCalculator)extrusionDistanceCalculator, (boolean)true);
        Assert.assertEquals((long)1L, (long)obstacleClusters.size());
        Cluster cluster = (Cluster)((ImmutablePair)obstacleClusters.get(0)).getLeft();
        ExtrusionHull navigableExtrusionsInLocal = cluster.getNavigableExtrusionsInLocal();
        ExtrusionHull nonNavigableExtrusionsInLocal = cluster.getNonNavigableExtrusionsInLocal();
        Assert.assertEquals((long)12L, (long)navigableExtrusionsInLocal.size());
        Assert.assertEquals((long)12L, (long)nonNavigableExtrusionsInLocal.size());
        Assert.assertTrue((boolean)this.listContains(navigableExtrusionsInLocal.getPoints(), (Point2DReadOnly)new Point2D(0.0, -0.2)));
        Assert.assertTrue((boolean)this.listContains(navigableExtrusionsInLocal.getPoints(), (Point2DReadOnly)new Point2D(-0.2, 0.0)));
        Assert.assertTrue((boolean)this.listContains(navigableExtrusionsInLocal.getPoints(), (Point2DReadOnly)new Point2D(0.0, 0.2)));
        Assert.assertTrue((boolean)this.listContains(navigableExtrusionsInLocal.getPoints(), (Point2DReadOnly)new Point2D(0.1, 0.4)));
        Assert.assertTrue((boolean)this.listContains(navigableExtrusionsInLocal.getPoints(), (Point2DReadOnly)new Point2D(0.2, 0.4)));
        Assert.assertTrue((boolean)this.listContains(navigableExtrusionsInLocal.getPoints(), (Point2DReadOnly)new Point2D(0.6, 0.0)));
        Assert.assertTrue((boolean)this.listContains(navigableExtrusionsInLocal.getPoints(), (Point2DReadOnly)new Point2D(0.2, -0.4)));
        Assert.assertTrue((boolean)this.listContains(navigableExtrusionsInLocal.getPoints(), (Point2DReadOnly)new Point2D(0.1, -0.4)));
    }

    @Test
    public void testSimpleSquareConvexPolygonShrinking() {
        int i;
        ArrayList<Point2D> vertices = new ArrayList<Point2D>();
        vertices.add(new Point2D(0.0, 0.0));
        vertices.add(new Point2D(1.0, 0.0));
        vertices.add(new Point2D(1.0, 1.0));
        vertices.add(new Point2D(0.0, 1.0));
        ConvexPolygon2D polygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(vertices));
        ConvexPolygon2D shrunkenPolygon = new ConvexPolygon2D();
        double[] distances = new double[polygon.getNumberOfVertices()];
        for (i = 0; i < polygon.getNumberOfVertices(); ++i) {
            distances[i] = 0.1;
        }
        ClusterTools.extrudeConvexPolygonInward((ConvexPolygon2DReadOnly)polygon, (double[])distances, (ConvexPolygon2DBasics)shrunkenPolygon);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(0.1, 0.1), (Tuple2DReadOnly)shrunkenPolygon.getVertexCCW(0), (double)1.0E-7);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(0.9, 0.1), (Tuple2DReadOnly)shrunkenPolygon.getVertexCCW(1), (double)1.0E-7);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(0.9, 0.9), (Tuple2DReadOnly)shrunkenPolygon.getVertexCCW(2), (double)1.0E-7);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(0.1, 0.9), (Tuple2DReadOnly)shrunkenPolygon.getVertexCCW(3), (double)1.0E-7);
        polygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(vertices));
        for (i = 0; i < polygon.getNumberOfVertices(); ++i) {
            distances[i] = 1.1;
        }
        ClusterTools.extrudeConvexPolygonInward((ConvexPolygon2DReadOnly)polygon, (double[])distances, (ConvexPolygon2DBasics)shrunkenPolygon);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(0.5, 0.5), (Tuple2DReadOnly)shrunkenPolygon.getVertexCCW(0), (double)1.0E-7);
        Assert.assertEquals((long)1L, (long)shrunkenPolygon.getNumberOfVertices());
    }

    @Test
    public void testSimpleTriangleConvexPolygonShrinking() {
        int i;
        ArrayList<Point2D> vertices = new ArrayList<Point2D>();
        vertices.add(new Point2D(0.0, 0.5));
        vertices.add(new Point2D(1.0, 0.0));
        vertices.add(new Point2D(2.2, 1.0));
        ConvexPolygon2D polygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(vertices));
        ConvexPolygon2D shrunkenPolygon = new ConvexPolygon2D();
        double[] distances = new double[polygon.getNumberOfVertices()];
        for (i = 0; i < polygon.getNumberOfVertices(); ++i) {
            distances[i] = 0.1;
        }
        ClusterTools.extrudeConvexPolygonInward((ConvexPolygon2DReadOnly)polygon, (double[])distances, (ConvexPolygon2DBasics)shrunkenPolygon);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(0.986224428207409, 0.11869118477128504), (Tuple2DReadOnly)shrunkenPolygon.getVertexCCW(0), (double)1.0E-7);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(1.8160104213223893, 0.8101795123671021), (Tuple2DReadOnly)shrunkenPolygon.getVertexCCW(1), (double)1.0E-7);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(0.2947361006115917, 0.4644353485691937), (Tuple2DReadOnly)shrunkenPolygon.getVertexCCW(2), (double)1.0E-7);
        polygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(vertices));
        for (i = 0; i < polygon.getNumberOfVertices(); ++i) {
            distances[i] = 1.1;
        }
        ClusterTools.extrudeConvexPolygonInward((ConvexPolygon2DReadOnly)polygon, (double[])distances, (ConvexPolygon2DBasics)shrunkenPolygon);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(1.0666666666, 0.5), (Tuple2DReadOnly)shrunkenPolygon.getVertexCCW(0), (double)1.0E-7);
        Assert.assertEquals((long)1L, (long)shrunkenPolygon.getNumberOfVertices());
    }

    @Test
    public void testSimpleLineConvexPolygonShrinking() {
        int i;
        ArrayList<Point2D> vertices = new ArrayList<Point2D>();
        vertices.add(new Point2D(-1.0, 3.0));
        vertices.add(new Point2D(1.0, 3.0));
        ConvexPolygon2D polygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(vertices));
        ConvexPolygon2D shrunkenPolygon = new ConvexPolygon2D();
        double[] distances = new double[polygon.getNumberOfVertices()];
        for (i = 0; i < polygon.getNumberOfVertices(); ++i) {
            distances[i] = 0.1;
        }
        ClusterTools.extrudeConvexPolygonInward((ConvexPolygon2DReadOnly)polygon, (double[])distances, (ConvexPolygon2DBasics)shrunkenPolygon);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(0.9, 3.0), (Tuple2DReadOnly)shrunkenPolygon.getVertexCCW(0), (double)1.0E-7);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(-0.9, 3.0), (Tuple2DReadOnly)shrunkenPolygon.getVertexCCW(1), (double)1.0E-7);
        polygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(vertices));
        for (i = 0; i < polygon.getNumberOfVertices(); ++i) {
            distances[i] = 1.1;
        }
        ClusterTools.extrudeConvexPolygonInward((ConvexPolygon2DReadOnly)polygon, (double[])distances, (ConvexPolygon2DBasics)shrunkenPolygon);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(0.0, 3.0), (Tuple2DReadOnly)shrunkenPolygon.getVertexCCW(0), (double)1.0E-7);
        Assert.assertEquals((long)1L, (long)shrunkenPolygon.getNumberOfVertices());
    }

    @Test
    public void testSimplePointConvexPolygonShrinking() {
        ArrayList<Point2D> vertices = new ArrayList<Point2D>();
        vertices.add(new Point2D(-1.0, 3.0));
        ConvexPolygon2D polygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(vertices));
        ConvexPolygon2D shrunkenPolygon = new ConvexPolygon2D();
        double[] distances = new double[polygon.getNumberOfVertices()];
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            distances[i] = 0.1;
        }
        ClusterTools.extrudeConvexPolygonInward((ConvexPolygon2DReadOnly)polygon, (double[])distances, (ConvexPolygon2DBasics)shrunkenPolygon);
        EuclidCoreTestTools.assertTuple2DEquals((Tuple2DReadOnly)new Point2D(-1.0, 3.0), (Tuple2DReadOnly)shrunkenPolygon.getVertexCCW(0), (double)1.0E-7);
    }

    @Test
    public void testShrinkingRandomPolygonsAreCompletelyInsideOriginalPolygons() {
        Random random = new Random(1984L);
        ReferenceFrame zUpFrame = ReferenceFrame.getWorldFrame();
        double xMin = -2.0;
        double xMax = 2.0;
        double yMin = -1.0;
        double yMax = 4.0;
        double widthMax = 2.2;
        double heightMax = 1.3;
        int numberOfPoints = random.nextInt(20);
        int numberOfPolygons = 100;
        ArrayList randomPolygons = ConvexPolygon2dTestHelpers.generateRandomPolygons((Random)random, (ReferenceFrame)zUpFrame, (double)xMin, (double)xMax, (double)yMin, (double)yMax, (double)widthMax, (double)heightMax, (int)numberOfPoints, (int)numberOfPolygons);
        FrameConvexPolygon2D shrunkenPolygon = new FrameConvexPolygon2D();
        for (FrameConvexPolygon2D randomPolygon : randomPolygons) {
            double distance = RandomNumbers.nextDouble((Random)random, (double)0.001, (double)5.0);
            double[] distances = new double[randomPolygon.getNumberOfVertices()];
            for (int i = 0; i < randomPolygon.getNumberOfVertices(); ++i) {
                distances[i] = distance;
            }
            ClusterTools.extrudeConvexPolygonInward((ConvexPolygon2DReadOnly)randomPolygon, (double[])distances, (ConvexPolygon2DBasics)shrunkenPolygon);
            FrameConvexPolygon2D bigPolygon = randomPolygon;
            FrameConvexPolygon2D smallPolygon = shrunkenPolygon;
            boolean completelyInside = ConvexPolygon2dCalculator.isPolygonInside((ConvexPolygon2DReadOnly)smallPolygon, (ConvexPolygon2DReadOnly)bigPolygon);
            Assert.assertTrue((boolean)completelyInside);
        }
    }

    @Test
    public void testExtrudePolygonWithLoops() {
        ArrayList<Point3D> pointsInWorld3D = new ArrayList<Point3D>();
        pointsInWorld3D.add(new Point3D(0.2, 0.2, 0.0));
        pointsInWorld3D.add(new Point3D(0.2, 0.1, 0.0));
        pointsInWorld3D.add(new Point3D(0.2, 0.0, 0.0));
        pointsInWorld3D.add(new Point3D(0.2, -0.1, 0.0));
        pointsInWorld3D.add(new Point3D(0.2, -0.2, 0.0));
        pointsInWorld3D.add(new Point3D(0.1, -0.2, 0.0));
        pointsInWorld3D.add(new Point3D(0.0, -0.2, 0.0));
        pointsInWorld3D.add(new Point3D(-0.1, -0.2, 0.0));
        pointsInWorld3D.add(new Point3D(-0.2, -0.2, 0.0));
        pointsInWorld3D.add(new Point3D(-0.2, -0.1, 0.0));
        pointsInWorld3D.add(new Point3D(-0.2, 0.0, 0.0));
        pointsInWorld3D.add(new Point3D(-0.2, 0.1, 0.0));
        pointsInWorld3D.add(new Point3D(-0.2, 0.2, 0.0));
        pointsInWorld3D.add(new Point3D(-0.1, 0.2, 0.0));
        pointsInWorld3D.add(new Point3D(0.0, 0.2, 0.0));
        pointsInWorld3D.add(new Point3D(0.1, 0.2, 0.0));
        ArrayList<Point2D> expectedPointsInWorld3D = new ArrayList<Point2D>();
        expectedPointsInWorld3D.add(new Point2D(0.05, 0.05));
        expectedPointsInWorld3D.add(new Point2D(0.05, -0.05));
        expectedPointsInWorld3D.add(new Point2D(-0.05, -0.05));
        expectedPointsInWorld3D.add(new Point2D(-0.05, 0.05));
        ConvexPolygonScaler scaler = new ConvexPolygonScaler();
        double extrusionDistance = 0.15;
        List<Point2DReadOnly> pointsInWorld2D = pointsInWorld3D.stream().map(Point2D::new).collect(Collectors.toList());
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        ConvexPolygon2D scaledPolygon = new ConvexPolygon2D();
        pointsInWorld2D.forEach(arg_0 -> ((ConvexPolygon2D)polygon).addVertex(arg_0));
        polygon.update();
        scaler.scaleConvexPolygon((ConvexPolygon2DReadOnly)polygon, extrusionDistance, (ConvexPolygon2DBasics)scaledPolygon);
        ObstacleExtrusionDistanceCalculator calculator = (p, h) -> extrusionDistance;
        ArrayList<ConvexPolygon2D> polygons = new ArrayList<ConvexPolygon2D>();
        polygons.add(polygon);
        List extrudedPoints = ClusterTools.extrudePolygonInward(polygons, (ObstacleExtrusionDistanceCalculator)calculator);
        Assert.assertEquals((long)1L, (long)extrudedPoints.size());
        Assert.assertEquals((long)expectedPointsInWorld3D.size(), (long)((ExtrusionHull)extrudedPoints.get(0)).size());
        int i = 0;
        while (i < ((ExtrusionHull)extrudedPoints.get(0)).size()) {
            int index = i++;
            Assert.assertTrue((boolean)((ExtrusionHull)extrudedPoints.get(0)).stream().anyMatch(point -> ((Point2D)expectedPointsInWorld3D.get(index)).epsilonEquals((Tuple2DReadOnly)point, 1.0E-6)));
        }
        pointsInWorld3D = new ArrayList();
        pointsInWorld3D.add(new Point3D(0.2, 0.15, 0.0));
        pointsInWorld3D.add(new Point3D(0.2, 0.05, 0.0));
        pointsInWorld3D.add(new Point3D(0.2, -0.05, 0.0));
        pointsInWorld3D.add(new Point3D(0.2, -0.15, 0.0));
        pointsInWorld3D.add(new Point3D(0.15, -0.2, 0.0));
        pointsInWorld3D.add(new Point3D(0.05, -0.2, 0.0));
        pointsInWorld3D.add(new Point3D(-0.05, -0.2, 0.0));
        pointsInWorld3D.add(new Point3D(-0.15, -0.2, 0.0));
        pointsInWorld3D.add(new Point3D(-0.2, -0.15, 0.0));
        pointsInWorld3D.add(new Point3D(-0.2, -0.05, 0.0));
        pointsInWorld3D.add(new Point3D(-0.2, 0.05, 0.0));
        pointsInWorld3D.add(new Point3D(-0.2, 0.15, 0.0));
        pointsInWorld3D.add(new Point3D(-0.15, 0.2, 0.0));
        pointsInWorld3D.add(new Point3D(-0.05, 0.2, 0.0));
        pointsInWorld3D.add(new Point3D(0.05, 0.2, 0.0));
        pointsInWorld3D.add(new Point3D(0.15, 0.2, 0.0));
        ArrayList<Point2D> newExpectedPointsInWorld3D = new ArrayList<Point2D>();
        newExpectedPointsInWorld3D.add(new Point2D(0.05, 0.05));
        newExpectedPointsInWorld3D.add(new Point2D(0.05, -0.05));
        newExpectedPointsInWorld3D.add(new Point2D(-0.05, -0.05));
        newExpectedPointsInWorld3D.add(new Point2D(-0.05, 0.05));
        pointsInWorld2D = pointsInWorld3D.stream().map(Point2D::new).collect(Collectors.toList());
        polygon.clear();
        pointsInWorld2D.forEach(arg_0 -> ((ConvexPolygon2D)polygon).addVertex(arg_0));
        polygon.update();
        extrudedPoints = ClusterTools.extrudePolygonInward(polygons, (ObstacleExtrusionDistanceCalculator)calculator);
        Assert.assertEquals((long)1L, (long)extrudedPoints.size());
        Assert.assertEquals((long)newExpectedPointsInWorld3D.size(), (long)((ExtrusionHull)extrudedPoints.get(0)).size());
        int i2 = 0;
        while (i2 < extrudedPoints.size()) {
            int index = i2++;
            Assert.assertTrue((boolean)((ExtrusionHull)extrudedPoints.get(0)).stream().anyMatch(point -> ((Point2D)expectedPointsInWorld3D.get(index)).epsilonEquals((Tuple2DReadOnly)point, 1.0E-6)));
        }
    }

    private PairList<Cluster, PlanarRegion> createObstacleClustersForTests(List<PlanarRegion> obstacleRegions, PlanarRegion homeRegion) {
        double orthogonalAngle = 0.8;
        ObstacleExtrusionDistanceCalculator preferredExtrusionDistanceCalculator = new ObstacleExtrusionDistanceCalculator(){

            public double computeExtrusionDistance(Point2DReadOnly pointToExtrude, double obstacleHeight) {
                return 0.08;
            }
        };
        ObstacleExtrusionDistanceCalculator extrusionDistanceCalculator = new ObstacleExtrusionDistanceCalculator(){

            public double computeExtrusionDistance(Point2DReadOnly pointToExtrude, double obstacleHeight) {
                return 0.04;
            }
        };
        DefaultVisibilityGraphParameters parameters = new DefaultVisibilityGraphParameters();
        ObstacleRegionFilter obstacleRegionFilter = parameters.getObstacleRegionFilter();
        List filteredObstacleRegions = obstacleRegions.stream().filter(candidate -> obstacleRegionFilter.isRegionValidObstacle(candidate, homeRegion)).collect(Collectors.toList());
        PlanarRegionFilter planarRegionFilter = parameters.getPlanarRegionFilter();
        double DEPTH_THRESHOLD_FOR_CONVEX_DECOMPOSITION = 0.05;
        filteredObstacleRegions = REAPlanarRegionTools.filterRegionsByTruncatingVerticesBeneathHomeRegion(filteredObstacleRegions, (PlanarRegion)homeRegion, (double)DEPTH_THRESHOLD_FOR_CONVEX_DECOMPOSITION, (PlanarRegionFilter)planarRegionFilter);
        PairList obstacleClusters = ClusterTools.createObstacleClusters((PlanarRegion)homeRegion, (List)filteredObstacleRegions, (double)orthogonalAngle, (ObstacleExtrusionDistanceCalculator)preferredExtrusionDistanceCalculator, (ObstacleExtrusionDistanceCalculator)extrusionDistanceCalculator, (boolean)true);
        return obstacleClusters;
    }

    private PlanarRegion createPlanarRegion(RigidBodyTransform transform, Point2D[] points) {
        ConvexPolygon2D convexPolygon = this.createConvexPolygon(points);
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transform, (Vertex2DSupplier)convexPolygon);
        return planarRegion;
    }

    private PlanarRegion createPlanarRegionFromSeveralPolygons(List<Point2D> concaveHullVertices, RigidBodyTransform transform, Point2D[] ... listOfPoints) {
        ArrayList<ConvexPolygon2D> polygons = new ArrayList<ConvexPolygon2D>();
        for (Point2D[] points : listOfPoints) {
            polygons.add(this.createConvexPolygon(points));
        }
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transform, concaveHullVertices, polygons);
        return planarRegion;
    }

    private ConvexPolygon2D createConvexPolygon(Point2D[] points) {
        ConvexPolygon2D convexPolygon = new ConvexPolygon2D();
        for (Point2D position : points) {
            convexPolygon.addVertex((Point2DReadOnly)position);
        }
        convexPolygon.update();
        return convexPolygon;
    }

    private boolean listContainsAllXYMatch(List<Point3DReadOnly> points, Point2DReadOnly ... pointsToCheck) {
        for (Point2DReadOnly pointToCheck : pointsToCheck) {
            if (this.listContainsXYMatch(points, pointToCheck)) continue;
            return false;
        }
        return true;
    }

    private boolean listContainsXYMatch(List<Point3DReadOnly> points, Point2DReadOnly pointToCheck) {
        for (Point3DReadOnly point : points) {
            if (!pointToCheck.epsilonEquals((Tuple2DReadOnly)new Point2D((Tuple3DReadOnly)point), 1.0E-12)) continue;
            return true;
        }
        return false;
    }

    private boolean listContains(List<Point2DReadOnly> points, Point2DReadOnly pointToCheck) {
        for (Point2DReadOnly point : points) {
            if (!point.epsilonEquals((Tuple2DReadOnly)pointToCheck, 1.0E-12)) continue;
            return true;
        }
        return false;
    }

    private boolean listContains(List<? extends Point3DReadOnly> points, Point3D pointToCheck) {
        for (Point3DReadOnly point3DReadOnly : points) {
            if (!point3DReadOnly.epsilonEquals((Tuple3DReadOnly)pointToCheck, 1.0E-12)) continue;
            return true;
        }
        return false;
    }

    private Point3D createAndTransformPoint(Point3D pointToTransform, RigidBodyTransform transform) {
        Point3D transformedPoint = new Point3D((Tuple3DReadOnly)pointToTransform);
        transform.transform((Point3DBasics)transformedPoint);
        return transformedPoint;
    }

    private static RigidBodyTransform createTransformFromPointAndZAxis(Point3DReadOnly point, Vector3DReadOnly zAxis) {
        RigidBodyTransform ret = new RigidBodyTransform();
        ret.getRotation().set((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)zAxis));
        ret.getTranslation().set((Tuple3DReadOnly)point);
        return ret;
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(ClusterTools.class, ClusterToolsTest.class);
    }
}

