/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs.dataStructure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.clusterManagement.Cluster;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.NavigableRegion;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityGraphEdge;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityGraphNavigableRegion;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityGraphNode;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;

public class VisibilityGraphEdgeTest {
    private static final int iters = 1000;

    @Test
    public void testCaching() {
        HashSet<VisibilityGraphEdge> visibilityGraphEdges = new HashSet<VisibilityGraphEdge>();
        Random random = new Random(1738L);
        for (int i = 0; i < 1000; ++i) {
            Point3D pointInWorld1 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)100.0);
            Point3D pointInWorld2 = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)100.0);
            NavigableRegion navigableRegion = new NavigableRegion(new PlanarRegion(), new Cluster(Cluster.ExtrusionSide.INSIDE, Cluster.ClusterType.POLYGON), new ArrayList());
            VisibilityGraphNavigableRegion visibilityGraphNavigableRegion = new VisibilityGraphNavigableRegion(navigableRegion, false);
            VisibilityGraphNode nodeA = new VisibilityGraphNode((Point3DReadOnly)pointInWorld1, (Point2DReadOnly)new Point2D((Tuple3DReadOnly)pointInWorld1), visibilityGraphNavigableRegion, false);
            VisibilityGraphNode nodeB = new VisibilityGraphNode((Point3DReadOnly)pointInWorld1, (Point2DReadOnly)new Point2D((Tuple3DReadOnly)pointInWorld1), visibilityGraphNavigableRegion, false);
            VisibilityGraphNode nodeC = new VisibilityGraphNode((Point3DReadOnly)pointInWorld2, (Point2DReadOnly)new Point2D((Tuple3DReadOnly)pointInWorld2), visibilityGraphNavigableRegion, false);
            VisibilityGraphNode nodeD = new VisibilityGraphNode((Point3DReadOnly)pointInWorld2, (Point2DReadOnly)new Point2D((Tuple3DReadOnly)pointInWorld2), visibilityGraphNavigableRegion, false);
            VisibilityGraphEdge edge1 = new VisibilityGraphEdge(nodeA, nodeC);
            VisibilityGraphEdge edge2 = new VisibilityGraphEdge(nodeA, nodeD);
            VisibilityGraphEdge edge3 = new VisibilityGraphEdge(nodeB, nodeC);
            VisibilityGraphEdge edge4 = new VisibilityGraphEdge(nodeB, nodeD);
            Assert.assertFalse((boolean)visibilityGraphEdges.contains(edge1));
            visibilityGraphEdges.add(edge1);
            Assert.assertTrue((boolean)visibilityGraphEdges.contains(edge2));
            Assert.assertTrue((boolean)visibilityGraphEdges.contains(edge3));
            Assert.assertTrue((boolean)visibilityGraphEdges.contains(edge4));
        }
    }
}

