/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.clusterManagement.Cluster;
import us.ihmc.pathPlanning.visibilityGraphs.clusterManagement.ExtrusionHull;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.Connection;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.InterRegionVisibilityMap;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.NavigableRegion;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.SingleSourceVisibilityMap;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityMap;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityMapWithNavigableRegion;
import us.ihmc.pathPlanning.visibilityGraphs.interfaces.VisibilityMapHolder;
import us.ihmc.robotics.geometry.PlanarRegion;

public class VisibilityGraphRandomTools {
    public static Cluster getRandomCluster(Random random) {
        int i;
        int i2;
        byte typeByte = (byte)RandomNumbers.nextInt((Random)random, (int)0, (int)(Cluster.ClusterType.values.length - 1));
        byte extrusionSideByte = (byte)RandomNumbers.nextInt((Random)random, (int)0, (int)(Cluster.ExtrusionSide.values.length - 1));
        int numberOfRawPoints = RandomNumbers.nextInt((Random)random, (int)1, (int)100);
        int numberOfNavigableExtrusions = RandomNumbers.nextInt((Random)random, (int)1, (int)100);
        int numberOfNonNavigableExtrusions = RandomNumbers.nextInt((Random)random, (int)1, (int)100);
        RigidBodyTransform transformToWorld = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        ArrayList<Point3D> rawPointsInLocalExpected = new ArrayList<Point3D>();
        ArrayList<Point2D> navigableExtrusionsInLocalExpected = new ArrayList<Point2D>();
        ExtrusionHull nonNavigableExtrusionsInLocalExpected = new ExtrusionHull();
        for (i2 = 0; i2 < numberOfRawPoints; ++i2) {
            rawPointsInLocalExpected.add(EuclidCoreRandomTools.nextPoint3D((Random)random, (double)100.0));
        }
        for (i2 = 0; i2 < numberOfNavigableExtrusions; ++i2) {
            navigableExtrusionsInLocalExpected.add(EuclidCoreRandomTools.nextPoint2D((Random)random, (double)100.0));
        }
        for (i2 = 0; i2 < numberOfNonNavigableExtrusions; ++i2) {
            nonNavigableExtrusionsInLocalExpected.addPoint((Point2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random, (double)100.0));
        }
        Cluster cluster = new Cluster(Cluster.ExtrusionSide.fromByte((byte)extrusionSideByte), Cluster.ClusterType.fromByte((byte)typeByte));
        cluster.setTransformToWorld((RigidBodyTransformReadOnly)transformToWorld);
        for (i = 0; i < numberOfRawPoints; ++i) {
            cluster.addRawPointInLocal((Point3DReadOnly)rawPointsInLocalExpected.get(i));
        }
        for (i = 0; i < numberOfNavigableExtrusions; ++i) {
            cluster.addNavigableExtrusionInLocal((Point2DReadOnly)navigableExtrusionsInLocalExpected.get(i));
        }
        cluster.addNonNavigableExtrusionsInLocal(nonNavigableExtrusionsInLocalExpected);
        return cluster;
    }

    public static VisibilityMapWithNavigableRegion getRandomNavigableRegion(Random random) {
        int numberOfObstacleClusters = RandomNumbers.nextInt((Random)random, (int)1, (int)50);
        PlanarRegion homeRegion = VisibilityGraphRandomTools.nextPlanarRegion(random);
        Cluster homeCluster = VisibilityGraphRandomTools.getRandomCluster(random);
        ArrayList<Cluster> obstacleClusters = new ArrayList<Cluster>();
        for (int i = 0; i < numberOfObstacleClusters; ++i) {
            obstacleClusters.add(VisibilityGraphRandomTools.getRandomCluster(random));
        }
        NavigableRegion navigableRegion = new NavigableRegion(homeRegion, homeCluster, obstacleClusters);
        VisibilityMapWithNavigableRegion visibilityMapWithNavigableRegion = new VisibilityMapWithNavigableRegion(navigableRegion);
        visibilityMapWithNavigableRegion.setVisibilityMapInLocal(VisibilityGraphRandomTools.getRandomSingleSourceVisibilityMap(random).getVisibilityMapInLocal());
        return visibilityMapWithNavigableRegion;
    }

    public static Connection getRandomConnection(Random random) {
        int startId = RandomNumbers.nextInt((Random)random, (int)0, (int)100);
        int targetId = RandomNumbers.nextInt((Random)random, (int)0, (int)100);
        Point3D startPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)50.0);
        Point3D targetPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)50.0);
        return new Connection((Point3DReadOnly)startPoint, startId, (Point3DReadOnly)targetPoint, targetId);
    }

    public static VisibilityMapHolder getRandomSingleSourceVisibilityMap(Random random) {
        int numberOfConnections = RandomNumbers.nextInt((Random)random, (int)2, (int)50);
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (int i = 0; i < numberOfConnections; ++i) {
            connections.add(VisibilityGraphRandomTools.getRandomConnection(random));
        }
        SingleSourceVisibilityMap map = new SingleSourceVisibilityMap((Point3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)100.0), RandomNumbers.nextInt((Random)random, (int)-100, (int)100), connections);
        map.getVisibilityMapInLocal().computeVertices();
        map.getVisibilityMapInWorld().computeVertices();
        return map;
    }

    public static VisibilityMapHolder getRandomInterRegionVisibilityMap(Random random) {
        InterRegionVisibilityMap map = new InterRegionVisibilityMap();
        int numberOfConnections = RandomNumbers.nextInt((Random)random, (int)2, (int)100);
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (int i = 0; i < numberOfConnections; ++i) {
            connections.add(VisibilityGraphRandomTools.getRandomConnection(random));
        }
        map.addConnections(connections);
        map.getVisibilityMapInWorld().computeVertices();
        map.getVisibilityMapInLocal().computeVertices();
        return map;
    }

    public static VisibilityMap getRandomVisibilityMap(Random random) {
        int numberOfConnections = RandomNumbers.nextInt((Random)random, (int)2, (int)100);
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (int i = 0; i < numberOfConnections; ++i) {
            connections.add(VisibilityGraphRandomTools.getRandomConnection(random));
        }
        VisibilityMap map = new VisibilityMap(connections);
        return map;
    }

    private static PlanarRegion nextPlanarRegion(Random random) {
        RigidBodyTransform transformToWorld = VisibilityGraphRandomTools.nextRegionTransform(random);
        List<Point2D> concaveHullVertices = VisibilityGraphRandomTools.nextPoint2DList(random);
        List<ConvexPolygon2D> convexPolygons = VisibilityGraphRandomTools.nextConvexPolygon2Ds(random);
        PlanarRegion next = new PlanarRegion((RigidBodyTransformReadOnly)transformToWorld, concaveHullVertices, convexPolygons);
        next.setRegionId(random.nextInt());
        return next;
    }

    private static RigidBodyTransform nextRegionTransform(Random random) {
        Vector3D regionNormal = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
        Point3D regionOrigin = EuclidCoreRandomTools.nextPoint3D((Random)random);
        return new RigidBodyTransform((Orientation3DReadOnly)EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)regionNormal), (Tuple3DReadOnly)regionOrigin);
    }

    private static List<ConvexPolygon2D> nextConvexPolygon2Ds(Random random) {
        int size = random.nextInt(100);
        return IntStream.range(0, size).mapToObj(i -> EuclidGeometryRandomTools.nextConvexPolygon2D((Random)random, (double)10.0, (int)100)).collect(Collectors.toList());
    }

    private static List<Point2D> nextPoint2DList(Random random) {
        int size = random.nextInt(500);
        return IntStream.range(0, size).mapToObj(i -> EuclidCoreRandomTools.nextPoint2D((Random)random)).collect(Collectors.toList());
    }
}

