/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.graph.structure;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Test;
import us.ihmc.pathPlanning.graph.GridNode;
import us.ihmc.pathPlanning.graph.structure.DirectedGraph;
import us.ihmc.robotics.Assert;

public class DirectedGraphTest {
    @Test
    public void testGraph() {
        GridNode startNode = new GridNode(0, 0);
        GridNode goalNode = new GridNode(4, 0);
        DirectedGraph graph = new DirectedGraph();
        graph.initialize((Object)startNode);
        double transitionCost = 1.0;
        graph.checkAndSetEdge((Object)new GridNode(0, 0), (Object)new GridNode(1, 1), transitionCost);
        graph.checkAndSetEdge((Object)new GridNode(0, 0), (Object)new GridNode(1, 0), transitionCost);
        graph.checkAndSetEdge((Object)new GridNode(0, 0), (Object)new GridNode(1, -1), transitionCost);
        graph.checkAndSetEdge((Object)new GridNode(1, 1), (Object)new GridNode(2, 1), transitionCost);
        graph.checkAndSetEdge((Object)new GridNode(1, -1), (Object)new GridNode(2, -1), transitionCost);
        graph.checkAndSetEdge((Object)new GridNode(2, 1), (Object)new GridNode(3, 1), transitionCost);
        graph.checkAndSetEdge((Object)new GridNode(2, -1), (Object)new GridNode(3, 1), transitionCost);
        graph.checkAndSetEdge((Object)new GridNode(3, 1), (Object)goalNode, transitionCost);
        Assert.assertEquals((double)graph.getCostFromStart((Object)goalNode), (double)(4.0 * transitionCost), (double)1.0E-10);
        graph.checkAndSetEdge((Object)new GridNode(1, 0), (Object)new GridNode(3, 1), transitionCost);
        Assert.assertEquals((double)graph.getCostFromStart((Object)goalNode), (double)(3.0 * transitionCost), (double)1.0E-10);
        graph.checkAndSetEdge((Object)new GridNode(2, -1), (Object)goalNode, transitionCost);
        Assert.assertEquals((double)graph.getCostFromStart((Object)goalNode), (double)(3.0 * transitionCost), (double)1.0E-10);
        GridNode newGoalNode = new GridNode(5, 0);
        graph.checkAndSetEdge((Object)goalNode, (Object)newGoalNode, transitionCost);
        Assert.assertEquals((double)graph.getCostFromStart((Object)newGoalNode), (double)(4.0 * transitionCost), (double)1.0E-10);
        graph.checkAndSetEdge((Object)startNode, (Object)new GridNode(2, 1), -2.0);
        Assert.assertEquals((double)graph.getCostFromStart((Object)newGoalNode), (double)(1.0 * transitionCost), (double)1.0E-10);
        List pathToGoal = graph.getPathFromStart((Object)newGoalNode);
        ArrayList<GridNode> expectedPathToGoal = new ArrayList<GridNode>();
        expectedPathToGoal.add(startNode);
        expectedPathToGoal.add(new GridNode(2, 1));
        expectedPathToGoal.add(new GridNode(3, 1));
        expectedPathToGoal.add(goalNode);
        expectedPathToGoal.add(newGoalNode);
        Assert.assertEquals((long)pathToGoal.size(), (long)expectedPathToGoal.size());
        for (int i = 0; i < expectedPathToGoal.size(); ++i) {
            GridNode node = (GridNode)pathToGoal.get(i);
            GridNode expectedNode = (GridNode)expectedPathToGoal.get(i);
            Assert.assertEquals((Object)node, (Object)expectedNode);
        }
    }
}

