/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.qpOASES;

import us.ihmc.convexOptimization.qpOASES.BooleanType;
import us.ihmc.convexOptimization.qpOASES.Indexlist;
import us.ihmc.convexOptimization.qpOASES.Matrix;
import us.ihmc.convexOptimization.qpOASES.qpOASESJNI;
import us.ihmc.convexOptimization.qpOASES.returnValue;

public class SparseMatrix
extends Matrix {
    private long swigCPtr;

    protected SparseMatrix(long cPtr, boolean cMemoryOwn) {
        super(qpOASESJNI.SparseMatrix_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(SparseMatrix obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                qpOASESJNI.delete_SparseMatrix(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public SparseMatrix() {
        this(qpOASESJNI.new_SparseMatrix__SWIG_0(), true);
    }

    public SparseMatrix(int nr, int nc, int[] r, int[] c, double[] v) {
        this(qpOASESJNI.new_SparseMatrix__SWIG_1(nr, nc, r, c, v), true);
    }

    public SparseMatrix(int nr, int nc, int ld, double[] v) {
        this(qpOASESJNI.new_SparseMatrix__SWIG_2(nr, nc, ld, v), true);
    }

    @Override
    public void free() {
        qpOASESJNI.SparseMatrix_free(this.swigCPtr, this);
    }

    @Override
    public Matrix duplicate() {
        long cPtr = qpOASESJNI.SparseMatrix_duplicate(this.swigCPtr, this);
        return cPtr == 0L ? null : new Matrix(cPtr, false);
    }

    @Override
    public double diag(int i) {
        return qpOASESJNI.SparseMatrix_diag(this.swigCPtr, this, i);
    }

    @Override
    public BooleanType isDiag() {
        return BooleanType.swigToEnum(qpOASESJNI.SparseMatrix_isDiag(this.swigCPtr, this));
    }

    @Override
    public double getNorm(int type) {
        return qpOASESJNI.SparseMatrix_getNorm__SWIG_0(this.swigCPtr, this, type);
    }

    @Override
    public double getNorm() {
        return qpOASESJNI.SparseMatrix_getNorm__SWIG_1(this.swigCPtr, this);
    }

    @Override
    public double getRowNorm(int rNum, int type) {
        return qpOASESJNI.SparseMatrix_getRowNorm__SWIG_0(this.swigCPtr, this, rNum, type);
    }

    @Override
    public double getRowNorm(int rNum) {
        return qpOASESJNI.SparseMatrix_getRowNorm__SWIG_1(this.swigCPtr, this, rNum);
    }

    @Override
    public returnValue getRow(int rNum, Indexlist icols, double alpha, double[] row) {
        return returnValue.swigToEnum(qpOASESJNI.SparseMatrix_getRow(this.swigCPtr, this, rNum, Indexlist.getCPtr(icols), icols, alpha, row));
    }

    @Override
    public returnValue getCol(int cNum, Indexlist irows, double alpha, double[] col) {
        return returnValue.swigToEnum(qpOASESJNI.SparseMatrix_getCol(this.swigCPtr, this, cNum, Indexlist.getCPtr(irows), irows, alpha, col));
    }

    @Override
    public returnValue times(int xN, double alpha, double[] x, int xLD, double beta, double[] y, int yLD) {
        return returnValue.swigToEnum(qpOASESJNI.SparseMatrix_times__SWIG_0(this.swigCPtr, this, xN, alpha, x, xLD, beta, y, yLD));
    }

    @Override
    public returnValue transTimes(int xN, double alpha, double[] x, int xLD, double beta, double[] y, int yLD) {
        return returnValue.swigToEnum(qpOASESJNI.SparseMatrix_transTimes__SWIG_0(this.swigCPtr, this, xN, alpha, x, xLD, beta, y, yLD));
    }

    @Override
    public returnValue times(Indexlist irows, Indexlist icols, int xN, double alpha, double[] x, int xLD, double beta, double[] y, int yLD, BooleanType yCompr) {
        return returnValue.swigToEnum(qpOASESJNI.SparseMatrix_times__SWIG_1(this.swigCPtr, this, Indexlist.getCPtr(irows), irows, Indexlist.getCPtr(icols), icols, xN, alpha, x, xLD, beta, y, yLD, yCompr.swigValue()));
    }

    @Override
    public returnValue times(Indexlist irows, Indexlist icols, int xN, double alpha, double[] x, int xLD, double beta, double[] y, int yLD) {
        return returnValue.swigToEnum(qpOASESJNI.SparseMatrix_times__SWIG_2(this.swigCPtr, this, Indexlist.getCPtr(irows), irows, Indexlist.getCPtr(icols), icols, xN, alpha, x, xLD, beta, y, yLD));
    }

    @Override
    public returnValue transTimes(Indexlist irows, Indexlist icols, int xN, double alpha, double[] x, int xLD, double beta, double[] y, int yLD) {
        return returnValue.swigToEnum(qpOASESJNI.SparseMatrix_transTimes__SWIG_1(this.swigCPtr, this, Indexlist.getCPtr(irows), irows, Indexlist.getCPtr(icols), icols, xN, alpha, x, xLD, beta, y, yLD));
    }

    @Override
    public returnValue addToDiag(double alpha) {
        return returnValue.swigToEnum(qpOASESJNI.SparseMatrix_addToDiag(this.swigCPtr, this, alpha));
    }

    @Override
    public returnValue print(String name) {
        return returnValue.swigToEnum(qpOASESJNI.SparseMatrix_print__SWIG_0(this.swigCPtr, this, name));
    }

    @Override
    public returnValue print() {
        return returnValue.swigToEnum(qpOASESJNI.SparseMatrix_print__SWIG_1(this.swigCPtr, this));
    }
}

