/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization;

import com.sun.jna.Native;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.tools.nativelibraries.NativeLibraryLoader;

public class ReLUQPWrapper {
    private double[] objVal = new double[1];
    private int[] iters = new int[1];
    private DMatrixRMaj x = null;

    public static native void setupC(int var0, int var1, double[] var2, double[] var3, double[] var4, double[] var5, double[] var6, boolean var7, double var8, double var10, int var12, int var13);

    public static native int updateC(double[] var0, double[] var1, double[] var2);

    public static native int solveC(double[] var0, double[] var1, int[] var2);

    public void setup(DMatrixRMaj H, DMatrixRMaj g, DMatrixRMaj A, DMatrixRMaj lb, DMatrixRMaj ub, boolean verbose, double epsPrimal, double epsDual, int maxIters, int itersBetweenChecks) {
        int nx = H.getNumRows();
        int nc = A.getNumRows();
        this.x = new DMatrixRMaj(nx, 1);
        ReLUQPWrapper.setupC(nx, nc, H.getData(), g.getData(), A.getData(), lb.getData(), ub.getData(), verbose, epsPrimal, epsDual, maxIters, itersBetweenChecks);
    }

    public int update(DMatrixRMaj gNew, DMatrixRMaj lbNew, DMatrixRMaj ubNew) {
        return ReLUQPWrapper.updateC(gNew.getData(), lbNew.getData(), ubNew.getData());
    }

    public int solve() {
        if (this.x == null) {
            System.err.println("Error in ReLUQPWrapper::solve(): call setup() first");
            return -1;
        }
        return ReLUQPWrapper.solveC(this.x.getData(), this.objVal, this.iters);
    }

    public DMatrixRMaj getSolution() {
        return this.x;
    }

    public double getObjectiveValue() {
        return this.objVal[0];
    }

    public int getIters() {
        return this.iters[0];
    }

    static {
        String library = NativeLibraryLoader.extractLibrary((String)"us.ihmc.convexOptimization", (String)"ReLUQPSolver_rel");
        Native.register(ReLUQPWrapper.class, (String)library);
    }
}

